`ifndef _RAMDEFS
`define _RAMDEFS

`define OREG 1		// register data outputs
`define CENA 2		// use clock enable on registered outputs
`define CINV 4		// use inverted clock
`define TIGHT 8		// tight FIFO control
`define LOOSE 16	// loose FIFO control
`define PACKET 32	// packet size FIFO control
`define EINV 64		// use inverted enable
`define IREG 128	// register wr/addr/data inputs
`define WONLY 256	// write only port
`define RONLY 512	// read only port
`define BPAR 1024	// use block parity
`define BDMA 2048	// enable dma modes in Buffers
`define BSTREAM 4096	// enable stream modes in Buffers
`define RFIRST 8192	// READ_FIRST address conflict resolution
`define BENA 16384	// byte enable write strobes
`define DBLBUF 32768	// double buffer accounting on this fifo port
`define WFIRST	(1<<16)	// WRITE_FIRST address conflict resolution
`define NEMPTY	(1<<17)	// queue size FIFO control
`define RAHEAD	(1<<18)	// read ahead prime circuit
`define FPKT	(1<<19)	// use packetized FIFO logic
`define FLOOP 	(1<<20)	// use FIFO loopback
`define BURST16 (1<<21)	// use 16 count max burst for RAHEAD timing gain on PCIE completion packets
`define PKTSEQF (1<<22)	// use 4bit packet sequence count to fill missing packets
`define COMCLK  (1<<23)	// common clock on A/B ports of RAM 

`endif
