/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  PowerPC Processor Interface

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

  iena/oena are not one cycle early in this module

  iosize: 0=4by 1=16by 2=32by 3=64by

*/
`include "vdefs.h"
`include "mdefs.h"
`include "../lib/ramdefs.h"

`ifdef JVM_NCR
`elsif ICE_IOM
`define JVM_NCR 2
`elsif ICE_PM
`define JVM_NCR 4
`else
`define JVM_NCR 8
`endif

`ifdef JVM_NR
`elsif ICE_IOM
`define JVM_NR 2
`elsif ICE_PM
`define JVM_NR 4
`else
`define JVM_NR 32
`endif

module processor (
  cclk,crd,cwr,cpage,caddr,cdata,cdatao, cs,		// JTAG IF
  bclk,baddr, brd,brdbus,bwr,bwrbus, boot,     		// PPC BRam IF
`ifdef PRC_NOALTBUS
  srdb,swrb,
`endif
  sclkx,srst, srw,sadx, srdx,srdbus, swrx,swrbus, sack,	// System Control IOBus
`ifndef PRC_NOALTBUS
  sclks,srds,swrs,sads,					// Alternate SC rates
  sclkfs,srdfs,swrfs,sadf,				// Alternate SC rates
`endif
`ifdef PRC_TBUS
  sclkt,srdt,swrt,sadt,					// Alternate SC rates
`endif
  ioclk, ireq,iena,ibus, oreq,oena,obus, 		// IO busses
  ioaddr,iosize,iobusy,iok,ioreq,			// IO signals
  test);

  parameter IBW=32;
  parameter MODE=1;	// mode 0=mainboard 1=processor

  parameter DSMODE=1;	// mode 1=fullSpeedMem 2=halfSpeedMem
  parameter ISMODE=1;	// mode 1=fullSpeedMem 2=halfSpeedMem

  localparam DSBW=32;
  localparam ISBW=64;
  localparam NR=`JVM_NR;
  localparam NCR=`JVM_NCR;

  input cclk,crd,cwr,cs;
  input [7:0] cpage,caddr,cdata;
  output [7:0] cdatao;

  input bclk,boot;
  output brd,bwr;
  output [19:0] baddr;
  input [31:0] brdbus;
  output [31:0] bwrbus;
`ifdef PRC_NOALTBUS
  output srdb,swrb;
`endif

  input srst,sclkx;
  input [31:0] srdbus;
  output srw,srdx,swrx;
  output [31:0] swrbus,sadx;
`ifndef PRC_NOALTBUS
  input sclks;
  output srds,swrs;
  output reg [31:0] sads;
  input [1:0] sclkfs;
  output [1:0] srdfs,swrfs;
  output reg [31:0] sadf;
`endif
`ifdef PRC_TBUS
  input sclkt;
  output srdt,swrt;
  output reg [31:0] sadt;
`endif
  input [7:0] sack;

  input ioclk,iena,oena,iobusy;
  output ireq,oreq,iok;
  output [31:0] ioaddr;
  output [1:0] iosize;
  output [31:0] ioreq;

  output [IBW-1:0] obus;
  input [IBW-1:0] ibus;

`ifdef TRACE_JVM
  output [32:0] test;
`else
  output [7:0] test;
`endif

  // Power assignments
  wire H=1, L=0;

`ifdef PRC_BCLK
  wire sclky = bclk;
  wire dsclk = bclk;
  wire isclk = bclk;
`else
  wire sclky = sclkx;
  wire dsclk = (DSMODE<=1)? sclkx : bclk;
  wire isclk = (ISMODE<=1)? sclkx : bclk;
`endif

  // Debug, status and reset logic
  reg rst,iok,creset,cstart;
  always @(posedge sclky) begin
`ifdef JVM
    rst <= srst || creset;
`else
    rst <= srst;
`endif
    iok <= !rst;
  end

  // OCM - OnChip Memory Controllers 
  wire isen,dsen,dwen;
  wire [20:0] isadr;
  wire [21:0] dsadr;
  wire [ISBW-1:0] isbus;

  // Control port interface
  reg [15:0] ccnt;
  reg [13:0] caddrw;
  reg [31:0] cdataw;
  reg iswr,dswr,cinc;
  reg iswrc,iswrd;
  wire [7:0] cdatad = cdataw[31:24];
  wire cadr = cs && cwr && caddr[2];
  wire csys = cs && cwr && caddr[3];
  wire dswr_ = cs && caddr[3:2]==0 && !ccnt[14] && !ccnt[13];
  wire iswr_ = cs && caddr[3:2]==0 && !ccnt[14] &&  ccnt[13];
  wire cinc4 = caddr[4];
  wire conf  = caddr[5];
  wire cincd; delayp #(3) cdp (cclk,cinc,cincd);
  wire [1:0] ccnt4 = ccnt[1:0]+1;
  always @(posedge cclk) begin
    if (cadr) ccnt <= {cdata,cdatad}; else if (cincd) ccnt <= cinc4? {ccnt[15:2],ccnt4} : ccnt+1;
    if (cwr) cdataw <= {cdata,cdataw[31:8]};
    cinc <= cs && ((cwr && caddr[3:2]==0) || crd);
    // need to change how we do this for more data space
    dswr <= cwr && dswr_;
    iswr <= cwr && iswr_;
  end
  always @(posedge cclk or posedge srst) begin
    if (srst) cstart <= 0; else if (csys) cstart <= cdata[0];
    if (srst) creset <= 0; else if (csys) creset <= cdata[1];
  end

  // system bus
  wire [31:0] saddr;
  wire swr_en,srd_en;

`ifdef PRC_BCLK
  reg [31:0] sadx;
  reg swrx,srdx,swrx_,srdx_,srwx;
  always @(posedge sclky or posedge srwx) begin
    if (srwx) srdx_ <= 0; else srdx_ <= srd_en || srdx_;
    if (srwx) swrx_ <= 0; else swrx_ <= swr_en || swrx_;
  end
  always @(posedge sclkx) begin
    srdx <= srdx_ && !srdx;
    swrx <= swrx_ && !swrx;
    sadx <= saddr;
  end
  always @(negedge sclkx) srwx <= srdx || swrx || srst;

`else
  reg srdx,swrx;
  always @(posedge sclkx) begin
    if (srst) srdx <= 0; else srdx <= srd_en;
    if (srst) swrx <= 0; else swrx <= swr_en;
  end
  assign sadx = saddr;
`endif

`ifdef PRC_NOALTBUS
  assign srdb = srd_en;
  assign swrb = swr_en;
`else
  sysbusRetimer #(1) sbrts (sclky,srst,srd_en,swr_en, sclks,srds,swrs);
  always @(posedge sclks) if (srst) sads <= 0; else sads <= saddr;

  sysbusRetimer sbrtf (sclky,srst,srd_en,swr_en, sclkfs[0],srdfs[0],swrfs[0]);
  always @(posedge sclkfs[0]) if (srst) sadf <= 0; else sadf <= saddr;
`ifdef SYS_CLKF2
  sysbusRetimer sbrtf2 (sclky,srst,srd_en,swr_en, sclkfs[1],srdfs[1],swrfs[1]);
`endif
`endif

`ifdef PRC_TBUS
  sysbusRetimer sbrtt (sclky,srst,srd_en,swr_en, sclkt,srdt,swrt);
  always @(posedge sclkt) if (srst) sadt <= 0; else sadt <= saddr;
`endif


`ifdef JVM

  reg [3:0] cunb;
  always @(posedge cclk) begin
    if (srst) cunb  <= 0; else if (cwr) cunb <= caddr[3:0];
    if (srst) iswrc <= 0; else if (iswr|dswr) iswrc <= !iswrc;
  end

  reg clc,cl1,cl2;
  reg [11:0] code;
  always @(posedge sclky) begin
    if (srst) clc <= 0; else if (cl1) clc <= !clc;
    cl1 <= (clc^iswrc) && !cl1;
    cl2 <= cl1;
    if (cl1) code <= {cunb,cdatad};
  end
  wire cload = cl2 && iswr_;
  wire dload = cl2 && dswr_ && (ccnt[1:0]==3);

  wire [2:0] dswen;
  wire [7:0] cdataod,cdataoc;
  wire [DSBW-1:0] dsbusi,dsbuso;
  assign bwrbus = dsbuso[31:0];
  // the ccnt side addresses are good to 64Kby but conflict with ISWR above 8Kby
  // the dsadr side addresses are good to 64Kby 
`ifdef AGILEX
  wire [31:0] cdatar;
  dpram #(NR,DSBW,DSBW,`COMCLK) dsr (sclky,H, ccnt[15:2],dload, cdataw,cdatar, 
                                     dsclk,H, dsadr,dswen[0], dsbuso,dsbusi);
  muxMxN #(4,8) cdo (cdataod,cdatar,ccnt[1:0]);
`else      	
  dpram #(NR,8,DSBW) dsr (cclk,H, ccnt,dswr, cdatad,cdataod, 
                          dsclk,H, dsadr,dswen[0], dsbuso,dsbusi);
`endif
  assign bwr   = dswen[2];
  assign dsadr = baddr[15:2];
  assign cdatao = conf? cdataoc : cdataod;
  assign cdataoc = ccnt[0]? NR : NCR;

  wire brd_; assign brd = H; // now enables the DMAC ram

  jvm #(IBW,NCR) j1 (sclky, rst, cstart,cload,code,
                     sclky, srw, saddr,swr_en,swrbus,srd_en,srdbus,
                     dsclk, baddr,dswen,dsbuso,brd_,dsbusi,brdbus,
                     ioclk, ioaddr,iosize, ireq,iena,ibus, oreq,oena,obus, test);

`else
  
  // DSOCM input selector
  wire [3:0]  dswen;
  wire [DSBW-1:0] dsbusi,dsbuso,dsbus0;
  wire sel_ = dsadr[21];
  reg sel; always @(posedge dsclk) sel <= sel_;
`ifdef DTDM
  mux2xN #(16) dsbl (dsbusi[15:00],dsbus0[15:00],brdbus[15:00],sel);
  mux2xN #(16) dsbu (dsbusi[31:16],dsbus0[31:16],brdbus[31:16],sel);
`else
  mux2xN #(DSBW) dsb (dsbusi,dsbus0,brdbus,sel);
`endif

  dpram #(4,8,DSBW,0,`EINV) dsr (cclk,H, ccnt[11:0],dswr, cdatad,cdatao, 
                                 dsclk,sel_, dsadr[9:0],dwen, dsbuso,dsbus0); // uses ~sel as ENA

  // ISOCM Cache line handling
  reg ciswr,ciswrd;
  always @(posedge cclk or posedge iswrc) begin
    if (iswrc) ciswr  <= 0; else ciswr  <= cs && cwr && !caddr[2] && ccnt[14] && (ccnt[1:0]==3);
    if (iswrc) ciswrd <= 0; else ciswrd <= ciswr || ciswrd;
  end
  always @(posedge sclkx) begin
    iswrd <= ciswrd;
    iswrc <= iswrd && !iswrc;
  end

  wire [7:0] cdataod;
  dpram #(4,8,ISBW) isr (cclk,H, ccnt[11:0],iswr, cdatad,cdataod, 
                         isclk,H, isadr[8:0],L, 64'h0,isbus);

  assign bwrbus = dsbuso[31:0];
  assign baddr = {dsadr[13:0],L,L};
  assign bwr = dwen;
  assign brd = sel_;

  wire [9:0] dcr_adr;
  wire [31:0] dcr_busi,dcr_buso;
  wire dcr_rd, dcr_wr, dcr_ack;

  // this stuff sits on one side of the PPC
  proc_dcr dcr (sclkx, srw, srd_en, swr_en, saddr,swrbus,
    dcr_wr, dcr_rd, dcr_adr[1:0], dcr_ack, dcr_buso);
  assign dcr_busi = srdbus;
  assign dwen  = dswen[0];

  // PLB Data/Instruction Cache Unit
  wire ibreq, dbreq, dbrnw, dbsize, busy;
  wire [1:0] ibsize;
  wire [31:0] ibadr, dbadr;
  wire ibaack, ibrack, dbaack, dbrack, dbwack;
  wire [2:0] ibcnt, dbcnt;
  wire [63:0] plb_irbus, plb_drbus, plb_dwbus;
  wire bus64;
  generate 
  if (IBW == 32) begin:b32
    assign plb_irbus = (boot)? {cdataw,cdataw} : {ibus,ibus};
    assign plb_drbus = {ibus,ibus};
    assign obus = plb_dwbus[63:32];
    assign bus64 = L;
  end
  else begin:b64
    assign plb_irbus = (boot)? {cdataw,cdataw} : ibus;
    assign plb_drbus = {ibus[31:0],ibus[63:32]};
    assign obus = {plb_dwbus[31:0],plb_dwbus[63:32]};
    assign bus64 = H;
  end
  endgenerate

  // handle early IO signals
  reg ival; always @(posedge ioclk) ival <= iena;
  reg oval; always @(posedge ioclk) oval <= oena;

  // count/address generators
  proc_plb plb (rst, 
    ioclk, ireq, oreq, ival, oval, ioaddr, iosize, iobusy, bus64,
    ibreq, ibaack, ibrack, ibsize, ibadr, ibcnt, boot, iswrc, busy,
    dbreq, dbaack, dbrack, dbsize, dbadr, dbcnt, dbrnw, dbwack
  );

  // direct access signals
  assign ioreq[31:3] = dbadr[31:3];
  assign ioreq[2] = dbsize;
  assign ioreq[1] = dbreq &&  dbrnw && !dbaack;
  assign ioreq[0] = dbreq && !dbrnw && !dbaack;

  // resets
  reg sysrst,chiprst,corerst;
  wire sysrstreq,chiprstreq,corerstreq;
  always @(posedge sclkx) begin
    sysrst  <= rst || sysrstreq;
    chiprst <= rst || chiprstreq;
    corerst <= rst || corerstreq;
  end
  
  // Constant assignments
  `define DSARC   8'hFD	 // address [31:24]
  `define DSCNTL1 8'h81	 // DMEN 1:1
  `define DSCNTL2 8'h83	 // DMEN 2:1 
  `define DSDCRA  8'h07
  `define ISARC   8'hFF	 // address [31:24]
  `define ISCNTL1 8'h81	 // IMEN 1:1
  `define ISCNTL2 8'h83	 // IMEN 2:1
  `define ISDCRA  8'h06
  `define DCRA    5'h01

  // Unisim PPC module
`ifdef VIRTEX4
  PPC405_ADV ppc1 (
`else
  PPC405 ppc1 (
`endif
    	// Clock and Power management
	.CPMC405CLOCK (sclkx),
	.CPMC405CPUCLKEN (H),
	.CPMC405JTAGCLKEN (H),
	.CPMC405TIMERCLKEN (L),
	.MCBCPUCLKEN (L),
	.MCBJTAGEN (L),
	.MCBTIMEREN (L),

	// CPU Control Interface
	.TIEC405MMUEN (L),
	.TIEC405DISOPERANDFWD (L),
	.TIEC405DETERMINISTICMULT (L),
	.C405XXXMACHINECHECK (uhoh),

	// External Interrupts
	.EICC405CRITINPUTIRQ (L),
	.EICC405EXTINPUTIRQ (L),

	// Reset Interface
	.C405RSTSYSRESETREQ (sysrstreq),
	.C405RSTCHIPRESETREQ (chiprstreq),
	.C405RSTCORERESETREQ (corerstreq),
	.RSTC405RESETSYS  (sysrst),
	.RSTC405RESETCHIP (chiprst),
	.RSTC405RESETCORE (corerst),

	// Instruction Side Processor Local Bus
	.C405PLBICUABUS (ibadr[31:2]),
	.C405PLBICUREQUEST (ibreq),
	.C405PLBICUSIZE (ibsize),  		// 01=16by, 10=32by
	.PLBC405ICUADDRACK (ibaack),
	.PLBC405ICUBUSY (busy),
	.PLBC405ICURDDACK (ibrack),
	.PLBC405ICURDDBUS (plb_irbus),
	.PLBC405ICURDWDADDR (ibcnt),
	.PLBC405ICUSSIZE1 (!boot), 		// L=32b, H=64b

	// Data Side Processor Local Bus
	.C405PLBDCUABUS (dbadr),
	.C405PLBDCURNW (dbrnw),
	.C405PLBDCUREQUEST (dbreq),
	.C405PLBDCUWRDBUS (plb_dwbus),
	.C405PLBDCUSIZE2 (dbsize),  		// 0=4by, 1=32by
	.PLBC405DCUADDRACK (dbaack),
	.PLBC405DCUBUSY (busy),
	.PLBC405DCURDDACK (dbrack),
	.PLBC405DCURDDBUS (plb_drbus),
	.PLBC405DCURDWDADDR (dbcnt),
	.PLBC405DCUWRDACK (dbwack),
	.PLBC405DCUSSIZE1 (bus64), 		// L=32b, H=64b

	// DSOCM Interface
	.DSARCVALUE (`DSARC),
	.DSCNTLVALUE ((DSMODE==2)?`DSCNTL2:`DSCNTL1),
	.BRAMDSOCMCLK (dsclk),
	.BRAMDSOCMRDDBUS (dsbusi),
	.DSOCMBRAMABUS (dsadr),
	.DSOCMBRAMEN (dsen),
	.DSOCMBRAMBYTEWRITE (dswen),
	.DSOCMBRAMWRDBUS (dsbuso),
`ifdef VIRTEX4
	.DSOCMRWCOMPLETE (H),
`endif

	// ISOCM Interface
	.ISARCVALUE (`ISARC),
	.ISCNTLVALUE ((ISMODE==2)?`ISCNTL2:`ISCNTL1),
	.BRAMISOCMCLK (isclk),
	.BRAMISOCMRDDBUS ({isbus[31:0],isbus[63:32]}),
	.ISOCMBRAMEN (isen),
	.ISOCMBRAMRDABUS (isadr),

	// DCR Interface
`ifdef VIRTEX4
	.EXTDCRABUS (dcr_adr),
	.EXTDCRDBUSOUT (dcr_buso),
	.EXTDCRREAD (dcr_rd),
	.EXTDCRWRITE (dcr_wr),
	.EXTDCRACK (dcr_ack),
	.TIEDCRADDR (`DCRA),
	.EXTDCRDBUSIN (dcr_busi),
`else
	.C405DCRABUS (dcr_adr),
	.C405DCRDBUSOUT (dcr_buso),
	.C405DCRREAD (dcr_rd),
	.C405DCRWRITE (dcr_wr),
	.DCRC405ACK (dcr_ack),
	.TIEISOCMDCRADDR (`ISDCRA),
	.TIEDSOCMDCRADDR (`DSDCRA),
	.DCRC405DBUSIN (dcr_busi),
`endif
	// Additional FPGA Signals
	.PLBCLK (sclkx)
	);
  assign test = {dcr_rd, dcr_wr, ibreq, dbreq, isen, dsen, sclkx, rst};
`endif

//  assign test = {iok,dbwack,dbrack,dbaack,dbreq,busy,ibaack,ibreq};
//  assign test = {dcr_buso[1:0],dcr_adr[1:0], dcr_wr,dcr_rd, swr_en,rst};
//  assign test = {dcr_buso[1:0],swrbus[1:0], dcr_wr,dcr_rd, swr_en,rst};
//  assign test = {iobusy, busy,  dbreq, dbaack, dbrack, dbsize, dbrnw, dbwack};
//  assign test = 0;

endmodule

/*

  PLB Timing

	dbreq
	dbreq	dbaack
bio			iordy
bio	dbreq		iordy	oena
bio	dbreq		irdy	oena
bi	dbreq	dbaack	irdy	ioena
	dbreq	dbaack		ioena
	dbreq		odone	iena
	dbreq	dbaack		iena
	dbreq		idone
	dbreq


*/

module proc_plb (rst, 
    ioclk, ireq, oreq, iena, oena, ioaddr, iosize, iobusy, bus64,
    ibreq, ibaack, ibrack, ibsize, ibadr, ibcnt, boot, iswr, busy,
    dbreq, dbaack, dbrack, dbsize, dbadr, dbcnt, dbrnw, dbwack
  );

  input rst, ioclk, iena, oena, boot, iswr, iobusy, ibreq, dbreq, dbrnw, dbsize, bus64;
  input [31:0] ibadr, dbadr;
  input [1:0] ibsize;
  output ireq, oreq, ibaack, ibrack, dbaack, dbrack, dbwack, busy;
  output [31:0] ioaddr;
  output [2:0] ibcnt, dbcnt;
  output [1:0] iosize;

  wire H=1, L=0;
  reg ireq, oreq, ioreq, ibaack, dbaack;
  reg iside, hold, busy, ioenad, bdone;
  reg [1:0] iosize;
  reg [31:0] ioaddr;
  reg [2:0] ibcnt,dbcnt;

  assign ibrack = (iena &&  iside) || iswr;
  assign dbrack = (iena && !iside);
  assign dbwack = oena;

  wire ioena = iena || oena;
  wire idbaack = ibaack || dbaack;
  wire done = (ioenad && !(iena || oena)) || bdone;

  wire [1:0] ibinc = (bus64&!boot)? 2:1;
  wire [1:0] dbinc = (bus64)? 2:1;

  always @(posedge ioclk) begin
 
    // prefer data over instruction 
    ibaack <= ibreq && !ibaack && !hold && !iobusy; // && !dbreq;
    dbaack <= dbreq && !dbaack && !hold && !iobusy && !ibreq;

    if (idbaack) begin
      ioaddr <= (ibaack)? {8'd0,ibadr[24:2],2'd0} : dbadr;
      iosize <= (ibaack)? ibsize : {dbsize,L};
      iside  <= ibaack;
    end

    if (!ioena)      dbcnt <= 0; else dbcnt <= dbcnt+dbinc;
    if (ibaack||rst) ibcnt <= 0; else if (iswr||ioena) ibcnt <= ibcnt+ibinc;

    bdone <= iswr && ((iosize[0] && ibcnt==3) || (iosize[1] && ibcnt==7));
    ioenad <= ioena;

    if (rst) ireq <= 0; else ireq <= (dbaack &&  dbrnw) || (ibaack && !boot) || (ireq && !(iena && !ioenad));
    if (rst) oreq <= 0; else oreq <= (dbaack && !dbrnw) || (oreq && !(oena && !ioenad));
    if (rst) busy <= 0; else busy <= idbaack || (busy && !done);
    if (rst) hold <= 0; else hold <= idbaack || (hold && !ioena && !bdone);

  end

endmodule

module proc_dcr (sclkx, sread_cy, sread_en, swrite_en, saddr,swrbus,
		 dcr_wr, dcr_rd, dcr_ad, dcr_ack, dcr_buso);

  input sclkx, dcr_wr, dcr_rd;
  input [1:0] dcr_ad;
  input [31:0] dcr_buso;
  output [31:0] saddr,swrbus;
  output sread_cy, sread_en, swrite_en, dcr_ack;

  reg[31:0] saddr,swrbus;
  reg dcr_cyc,sread_cy,swrite_en,saddr_en,sdata_en,sread_en;

  always @(posedge sclkx) begin
    dcr_cyc <= (dcr_wr || dcr_rd);
    saddr_en <= dcr_wr &&  dcr_ad[0] && !dcr_cyc;
    sdata_en <= dcr_wr && !dcr_ad[0] && !dcr_cyc;
    sread_en <= dcr_rd && !dcr_ad[0] && !dcr_cyc;
    if (saddr_en) saddr <= dcr_buso;
    if (saddr_en) sread_cy <= dcr_ad[1];
    if (sdata_en) swrbus <= dcr_buso;
    swrite_en <= sdata_en;
  end
  assign dcr_ack = (dcr_wr || dcr_rd);

endmodule

/*
  Xternal processor block
  interface with TI chip
*/
module processorX (
  bclk,baddr, brd,brdbus,bwr,bwrbus, boot,     				// PPC BRam IF
  sclkx,srst, srw,saddr, srdx,srdbus, swrx,swrbus,			// System Control
  sclks,srds,swrs, sclkf,srdf,swrf, sclkt,srdt,swrt,			// Alternate SC rates
  ioclk, ireq,iena,ibus, oreq,oena,obus, 				// IO busses
  ioaddr,iosize,iobusy,iok,ioreq,					// IO signals
  test);

  parameter IBW=32;

  input bclk,brd,bwr,boot;
  input [19:0] baddr;
  output [31:0] brdbus;
  input [31:0] bwrbus;

  input srst,sclks,sclkx,sclkf,sclkt;
  input [31:0] srdbus;
  output srw, srds,swrs,srdx,swrx,srdf,swrf,srdt,swrt;
  output [31:0] swrbus,saddr;

  input ioclk,iena,oena,iobusy;
  output ireq,oreq,iok;
  output [31:0] ioaddr;
  output [1:0] iosize;
  output [31:0] ioreq;

  output [IBW-1:0] obus;
  input [IBW-1:0] ibus;

  output [7:0] test;

endmodule



/*
  Processor for IOM or mini-PM
*/
module processorLite (
  cclk,crd,cwr,cpage,caddr,cdata,cdatao, cs,		// JTAG IF
`ifdef PRC_C2SBUS
  c2s,
`endif
`ifdef PRC_BBUS
  bclk,baddr, brd,brdbus,bwr,bwrbus, 	// PPC BRam IF
`endif
  sclkx,srst, srw,saddr, srdx,srdbus, swrx,swrbus, sack,// System Control
`ifdef PRC_SBUS
  sclks,srds,swrs, 			// Alternate SC rates
`endif
`ifdef PRC_FBUS
  sclkf,srdf,swrf, 			// Alternate SC rates
`endif
`ifdef PRC_IOBUS
  ioclk, ireq,iena,ibus, oreq,oena,obus, ioaddr,iosize,	// IO busses
`endif
  test);

  parameter IBW=32;
  parameter NCR=`JVM_NCR;
  parameter NR=`JVM_NR;
  parameter FLAGS=0;

  localparam DSBW=32;

  input cclk,crd,cwr,cs;
  input [7:0] cpage,caddr,cdata;
  output [7:0] cdatao;
`ifdef PRC_C2SBUS
  input c2s;
`endif
`ifdef PRC_BBUS
  input bclk;
  output brd,bwr;
  output [19:0] baddr;
  input [31:0]  brdbus;
  output [31:0] bwrbus;
`else
  wire brd,bwr;
  wire [19:0] baddr;
  wire [31:0] brdbus;
  wire [31:0] bwrbus;
`endif
  input sclkx,srst;
  input [31:0] srdbus;
  output srw, srdx,swrx;
  output [31:0] swrbus,saddr;
  input [7:0] sack;
`ifdef PRC_SBUS
  input sclks;
  output srds,swrs;
`endif
`ifdef PRC_FBUS
  input sclkf;
  output srdf,swrf;
`endif

`ifdef PRC_IOBUS
  input ioclk,iena,oena;
  output ireq,oreq;
  output [31:0] ioaddr;
  output [1:0] iosize;
  output [IBW-1:0] obus;
  input [IBW-1:0] ibus;
`else
  wire ioclk,iena,oena;
  wire ireq,oreq;
  wire [31:0] ioaddr;
  wire [1:0] iosize;
  wire [IBW-1:0] obus;
  wire [IBW-1:0] ibus;
`endif

  output [7:0] test;

  // Power assignments
  wire H=1, L=0;

  // Debug, status and reset logic
  reg rst,iok,creset,cstart;
  always @(posedge sclkx) begin
    rst <= srst || creset;
    iok <= !rst;
  end

  // OCM - OnChip Memory Controllers 
  wire isen,dsen,dwen;
  wire [21:0] dsadr;

  // Control port interface
  reg [15:0] ccnt;
  reg [7:0] cdatad;
  reg [3:0] cunb;
  reg iswr,iswrc,dswr,cinc;
  wire cadr = cs && cwr && caddr[2];
  wire csys = cs && cwr && caddr[3];
  wire cinc4 = caddr[4];
  wire conf = caddr[5];
  wire [1:0] ccnt4 = ccnt[1:0]+1;
  always @(posedge cclk) begin
    if (cwr)  cunb <= caddr[3:0];
    if (cadr) ccnt <= {cdata,cdatad}; else if (cinc) ccnt <= cinc4? {ccnt[15:2],ccnt4} : ccnt+1;
    if (cwr) cdatad <= cdata;
    cinc <= cs && ((cwr && caddr[3:2]==0) || crd);
    dswr <= cs &&   cwr && caddr[3:2]==0 && !ccnt[13];
    iswr <= cs &&   cwr && caddr[3:2]==0 &&  ccnt[13];
  end
  always @(posedge cclk or posedge srst) begin
    if (srst) cstart <= 0; else if (csys) cstart <= cdata[0];
    if (srst) creset <= 0; else if (csys) creset <= cdata[1];
    if (srst) iswrc  <= 0; else if (iswr) iswrc <= !iswrc;
  end

  wire [2:0] dswen;
  wire [IBW-1:0] dsbusi,dsbuso;
  wire [7:0] cdataod,cdataoc;
  wire dsw = dswen[0] || dswen[1];
  assign bwrbus = dsbuso[31:0];
`ifdef AGILEX
  dpram #(NR,8,DSBW,`COMCLK) dsr0 (cclk,H, ccnt,dswr, cdatad,cdataod, 
                                   sclkx,H, dsadr,dsw, dsbuso,dsbusi);
`else      	
  dpram #(NR,8,DSBW) dsr0 (cclk,H, ccnt,dswr, cdatad,cdataod, 
                           sclkx,H, dsadr,dsw, dsbuso,dsbusi);
`endif		   
  assign bwr   = dswen[2];
  assign dsadr = baddr[15:2];
  assign cdatao = conf? cdataoc : cdataod;
  assign cdataoc = ccnt[0]? NR : NCR;

  reg clc,cl0,cl1,cl2;
  reg [11:0] code;
  always @(posedge sclkx) begin
    if (srst) clc <= 0; else if (cl1) clc <= !clc;
    cl0 <= (clc^iswrc) && !cl0 && !cl1;
    cl1 <= cl0;
    cl2 <= cl1;
    if (cl1) code <= {cunb,cdatad};
  end
  wire cload = cl2;
  wire brd_; assign brd = H; // now enables the DMAC ram

  wire swr_en,srd_en;
  wire [31:0] saddr_,swrbus_;

`ifdef VIRTEX4
  assign srw=0, saddr_=0, swr_en=0, swrbus_=0, srd_en=0;

`else
  jvm #(IBW,NCR,1,FLAGS) j1 (sclkx, rst, cstart,cload,code,
                 sclkx, srw, saddr_,swr_en,swrbus_,srd_en,srdbus,
                 sclkx, baddr,dswen,dsbuso,brd_,dsbusi,brdbus,
                 ioclk, ioaddr,iosize, ireq,iena,ibus, oreq,oena,obus, test);
`endif

  // system busses
  reg srdx,swrx;

`ifdef PRC_C2SBUS
  reg [2:0] cswr,csrd;
  reg [31:0] saddr,swrbus;
  always @(posedge sclkx) begin
    cswr <= {cswr[1:0],cwr && c2s};	// reclocking JTAG clock 
    csrd <= {csrd[1:0],crd && c2s};
    saddr <= c2s? {cpage,caddr} : saddr_;
    swrbus <= c2s? cdata : swrbus_;
    if (srst) srdx <= 0; else srdx <= srd_en || (csrd[2:1]==1);
    if (srst) swrx <= 0; else swrx <= swr_en || (cswr[2:1]==1);
  end
`else
  always @(posedge sclkx) begin
    if (srst) srdx <= 0; else srdx <= srd_en;
    if (srst) swrx <= 0; else swrx <= swr_en;
  end
  assign saddr = saddr_;
  assign swrbus = swrbus_;
`endif

`ifdef PRC_SBUS
  sysbusRetimer #(1) sbrts (sclkx,srst,srd_en,swr_en, sclks,srds,swrs);
`endif

`ifdef PRC_FBUS
  sysbusRetimer sbrtf (sclkx,srst,srd_en,swr_en, sclkf,srdf,swrf);
`endif

endmodule

module sysbusRetimer (clk,rst,rd,wr, clkf,rdf,wrf);
  parameter SYNC=0;	// if the 2 clocks are synchronous
  input clk,rst,rd,wr;
  input clkf;
  output reg rdf,wrf;

  reg cyc,cycw,cycf,cycf2,cycw2;

  wire cycf1 = (cycf^cyc) && !(rdf|wrf);
  wire cycw1 = cycw;
  wire cycf0 = SYNC? cycf1 : cycf2;
  wire cycw0 = SYNC? cycw1 : cycw2;

  always @(posedge clk) begin
    if (rst) cyc <= 0; else if (rd|wr) cyc <= !cyc;
    if (rd|wr) cycw <= wr;
  end

  always @(posedge clkf) begin
    rdf <= cycf0 && !cycw0 && !rdf;
    wrf <= cycf0 &&  cycw0 && !wrf;
    if (rst) cycf <= 0; else if (rdf|wrf) cycf <= !cycf;
    cycw2 <= cycw1;
    cycf2 <= cycf1;
  end
endmodule

module busexpander (
  sclk,  srst, sad ,srd ,swr ,swrbus,
  sclks, rsts, sads,srds,swrs,swrbuss,
  sclkf, rstf, sadf,srdf,swrf,swrbusf,
  sclkg, rstg, sadg,srdg,swrg,swrbusg);

  input sclk,srst,srd,swr;       input [31:0] sad,swrbus;

  input sclks,rsts; output reg srds,swrs; output reg [31:0] sads,swrbuss;
  input sclkf; output reg rstf,srdf,swrf; output reg [31:0] sadf,swrbusf;
  input sclkg; output reg rstg,srdg,swrg; output reg [31:0] sadg,swrbusg;

  // sclk is 2X sclks so doubling will catch the edge
  reg srdd,swrd; always @(posedge sclk) begin srdd <= srd; swrd <= swr; end	
  always @(posedge sclks) begin srds <= (srd|srdd) && !srds; swrs <= (swr|swrd) && !swrs; end
  always @(posedge sclks) begin sads<=sad; swrbuss<=swrbus; end

  wire srdf_,swrf_; sysbusRetimer sbrtf (sclk,srst,srd,swr, sclkf,srdf_,swrf_);
  always @(posedge sclkf) begin rstf<=rsts; swrf<=swrf_; srdf<=srdf_; sadf<=sad; if (swrf_) swrbusf<=swrbus; end

  wire srdg_,swrg_; sysbusRetimer sbrtg (sclk,srst,srd,swr, sclkg,srdg_,swrg_);
  always @(posedge sclkg) begin rstg<=rsts; swrg<=swrg_; srdg<=srdg_; sadg<=sad; if (swrg_) swrbusg<=swrbus; end

endmodule


/*
  DSP block for JVM - here for obfuscator
*/

module jvmdsp (clk,ena, sel, stka,stkb, stkl,stko);

  parameter DBW=32;

  input clk,ena;
  input [3:0] sel;		// operation selector
  input [DBW-1:0] stka,stkb;	// stack A/B registers
  input [DBW-1:0] stkl;		// LUT op results
  output [DBW-1:0] stko;	// output register

  wire L=0,H=1;
  wire [6:0] opmode;
  wire [3:0] alumode;
  wire [2:0] aop = sel[2:0];	// 0=tbd 1=and 2=ror 3=xor 4=neg 5=sub 6=add 7=mul
  wire [DBW-1:0] stkp;
  wire isMult = (aop==7);
  wire isNeg  = (aop==4);
  wire isCZ   = (aop==4) || (aop==7);
  wire isROR  = (aop==2);
  assign opmode[1:0] = isMult? 1 : 3;            // 0=0 1=M 2=P 3=A:B
  assign opmode[3:2] = isMult? 1 : isROR? 2 : 0; // 0=0 1=M 2=-1 3=C
  assign opmode[6:4] = isCZ?   0 : 3;            // 0=0 1=PC 2=P 3=C 
  assign alumode = (aop==1)? 12 : (aop==2)? 12 : (aop==3)? 7 : (aop==4)? 3 : (aop==5)? 3 : 0;

  wire [24:0] stkba = isMult? stkb : stka[31:18]; // put stka in portB and stkb in portA for subtract needs

`ifndef verilator
`ifdef SPARTAN6
// warning - this DSP has no ALU for the bit compare functions
  DSP48A1 dsp (.CLK(clk),.OPMODE(opmode), .A(stkba),.B(stka),.C(stkb),.P(stkp),
		.CEP(ena), .CEA(L),.CEB(L),.CEC(L),.CED(L),.CECARRYIN(L),.CEOPMODE(L));
  defparam dsp.A0REG=0;
  defparam dsp.B0REG=0;
  defparam dsp.CREG=0, dsp.MREG=0, dsp.PREG=1;
//  defparam dsp.OPMODEREG=0, dsp.ALUMODEREG=0;
`else
  DSP48E dsp (.CLK(clk),.OPMODE(opmode),.ALUMODE(alumode), .A(stkba),.B(stka),.C(stkb),.P(stkp),
		.CEP(ena), .CEC(L),.CEM(L),.CEA1(L),.CEA2(L),.CEB1(L),.CEB2(L));
  defparam dsp.AREG=0, dsp.ACASCREG=0;
  defparam dsp.BREG=0, dsp.BCASCREG=0;
  defparam dsp.CREG=0, dsp.MREG=0, dsp.PREG=1;
  defparam dsp.OPMODEREG=0, dsp.ALUMODEREG=0;
`endif
`ifdef VIRTEX5
  defparam dsp.USE_MULT="MULT";
`endif
`endif

  reg stksel; always @(posedge clk) if (ena) stksel <= sel[3];
  assign stko = stksel? stkp : stkl;

endmodule

module muladd (clk,ena, a,b,c, p);
  parameter AW=18;
  parameter BW=18;
  parameter CW=35;
  parameter PW=36;
  parameter POFF=0;
  input clk,ena;
  input signed [AW-1:0] a;
  input signed [BW-1:0] b;
  input signed [CW-1:0] c;
  output signed [PW-1:0] p;
  wire L=0,H=1;
  wire signed [CW+POFF-1:0] cin = (POFF==0)? c : $signed({c,{POFF{L}}});
`ifdef verilator
  reg signed [48:0] pout;
  wire signed [AW+BW-1:0] mout = a * b;
  always @(posedge clk) pout <= mout + cin;
`else
  wire [6:0] opmode = 8'h35;
  wire [3:0] alumode = 4'h0;
  wire signed [48:0] pout;
  DSP48E dsp (.CLK(clk),.OPMODE(opmode),.ALUMODE(alumode), .A(a),.B(b),.C(cin),.P(pout),
	      .CEP(L),.CEC(ena),.CEM(ena),.CEA1(L),.CEA2(L),.CEB1(L),.CEB2(L));
  defparam dsp.AREG=0, dsp.ACASCREG=0;
  defparam dsp.BREG=0, dsp.BCASCREG=0;
  defparam dsp.CREG=1, dsp.MREG=1, dsp.PREG=0;
  defparam dsp.OPMODEREG=0, dsp.ALUMODEREG=0;
`endif
  assign p = $signed(pout[PW+POFF-1:POFF]);
endmodule
  
