/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  User Core Template

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003
*/
/* verilator lint_off MULTITOP */

// this function wraps outadder function for DUC2 spice testing
module duc2mc (clk,reset, ten,tbus, vstat,vena,vbus, wstat,wena,wbus);
  input clk,reset,ten;
  input [31:0] tbus;
  input vstat,wstat;
  output vena,wena;
  input [31:0] vbus;
  output [63:0] wbus;

  localparam BWC=20;
  localparam UPS=2;
  localparam NC=2;

  reg vena,vval,wena,wval,phase;
  reg [31:0] xbus;
  always @(posedge clk) begin
    vena <= vstat && wstat;
    vval <= vena;
    if (vval) xbus <= vbus;
    if (reset) phase <= 0; else if (vval) phase <= !phase;
  end

  wire ups=1;

`ifdef INNERUPS
  wire [1:0] fcy=0;
  wire [3:0] cab[NC];
  wire signed [BWC-1:0] cax[NC],cay[NC];
  wire signed [BWC-1:0] cbx[UPS],cby[UPS];
  assign cab[0] = 2;
  assign cab[1] = 0;
  assign cax[0] = $signed(vbus[15:0]);
  assign cay[0] = $signed(vbus[31:16]);
  assign wbus = {cby[1][15:0],cbx[1][15:0],cby[0][15:0],cbx[0][15:0]};
  adderups #(BWC,NC,UPS,2) duc (clk,reset, ups,fcy, clk,ten,tbus, vval,cab,cax,cay, wena,cbx,cby);
`else
  wire ena = !reset;
  wire [NC-1:0] enas = 2'b01;
  wire [15:0] scale = 16'h0100;
  wire [15:0] nfscl = 16'h0000;
  mcaddups #(2,32,UPS) duc (clk,ena,enas, ups,scale,nfscl, clk,ten,tbus, vval,8'h12,{vbus,vbus}, wena,wbus);
`endif

endmodule

/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  User Core Template

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003
*/

module mcaddups (clk,ena,enas, ups,scale,nfscl, tclk,ten,tbus, wen,wchn,wbus, wenx,wbusx);
  parameter NC=8;
  parameter IBW=32;		// complex input - scalars per atom
  parameter UPS=1;		// upsample ratio
  parameter OBW=IBW*UPS;
  localparam IBWP=IBW/8;
  input clk,ena;
  input [NC-1:0] enas;
  input ups;
  input [15:0] scale,nfscl;
  input tclk,ten;
  input [31:0] tbus;
  input wen;
  input [NC*IBWP-1:0] wchn;
  input [NC*IBW-1:0] wbus;
  output wenx;
  output reg [OBW-1:0] wbusx;
 
  localparam BW=IBW/2;
  localparam NCO=(NC>16)?5:(NC>8)?4:(NC>4)?3:(NC>2)?2:1;
  localparam NUPS=(UPS>1)?3:1;	// number of UPS bands
  localparam BWC=18;		// max size of multiplier A port - hopefully BW+NCO;

  function [25:0] LRS (input [25:0] lrs);
    LRS = {lrs[24:0],lrs[0:0]^lrs[1:1]^lrs[5:5]^lrs[25:25]};
  endfunction

  wire T=1, F=0, H=1, L=0;
  wire wenc,wval,wvaly;
  wire [NUPS-1:0] dens;
  wire wend = dens[0];

  delayp #(1) dpc (clk,wen,wenc);
  delayp #(3) dpy (clk,wend,wvaly);
  delayp #(4) dpx (clk,wend,wenx);

  // wen wbus
  // wenc cx
  //
  // wend dx
  // wval fx
  // wvaly dout nout
  // wenx wbusx

  // implement noise floor generators
  reg[25:0] lrsr,lrsi;
  wire[25:0] lrsrx = LRS(lrsr);
  wire[25:0] lrsix = LRS(lrsi);
  reg signed [15:0] nfsc;
  reg nfrst,nfcy;
  wire nups = (UPS>1);
  always @(posedge clk) begin
    nfrst <= !ena;
    if (nfrst) nfcy <= 0;       else if (wvaly) nfcy <= nups? F : ~nfcy;		// negate every other
    if (nfrst) nfsc <= 0;       else if (wvaly) nfsc <= nfcy? -nfscl : nfscl;
    if (nfrst) lrsr <= ~123456; else if (wvaly) lrsr <= nups? LRS(lrsrx) : lrsrx;	// by 2 or 1 only
    if (nfrst) lrsi <= ~654321; else if (wvaly) lrsi <= nups? LRS(lrsix) : lrsix;	// by 2 or 1 only
  end
  wire signed [BW-1:0] nout[4], dout[4], dnout[4];
  srmul #(16,16,BW,1,15) nrm  ( lrsr, nfsc,nout[0],clk,wvaly); 
  srmul #(16,16,BW,1,15) nim  ( lrsi, nfsc,nout[1],clk,wvaly); 
  srmul #(16,16,BW,1,15) nrmx (~lrsrx,nfsc,nout[2],clk,wvaly); 		// negate upper sample
  srmul #(16,16,BW,1,15) nimx (~lrsix,nfsc,nout[3],clk,wvaly); 

  // implement adder trees
  reg         [3:0]     cc[NC];
  reg  signed [BWC-1:0] cx[NC],cy[NC];
  wire signed [BWC-1:0] dx[NUPS][2],dy[NUPS][2];
  wire signed [BWC-1:0] ex[UPS],ey[UPS];
  genvar i,j;
  generate
  for (i=0; i<NC; i=i+1) begin	// actual channels
    always @(posedge clk) cx[i] <= $signed(wbus[BW-1+0*BW+i*IBW:0*BW+i*IBW]);
    always @(posedge clk) cy[i] <= $signed(wbus[BW-1+1*BW+i*IBW:1*BW+i*IBW]);
    always @(posedge clk) cc[i] <= enas[i]? wchn[IBWP-1+i*IBWP:i*IBWP] : 0;
  end
  for (j=0; j<NUPS; j=j+1) begin	
    wire [1:0] fcy = j-1;	// bands 1=low 2=mid 3=high
    adderups #(BWC,NC,UPS,j+1) qax (clk,!ena, ups,fcy, tclk,ten,tbus, wenc,cc,cx,cy, dens[j],dx[j],dy[j]);
  end
  for (i=0; i<UPS; i=i+1) begin	
    if (NUPS==3) assign ex[i]=dx[0][i]+dx[1][i]+dx[2][i],	ey[i]=dy[0][i]+dy[1][i]+dy[2][i]; 
    if (NUPS==2) assign ex[i]=dx[0][i]+dx[1][i],		ey[i]=dy[0][i]+dy[1][i];
    if (NUPS==1) assign ex[i]=dx[0][i],				ey[i]=dy[0][i];
    // params - 2 is PIPEd, scale=1 is 0x100 so we want lower 8 bits of multiply : 3 is RnClip
    srmul #(BWC,16,BW,2,8,3) cxm (ex[i],scale,dout[i*2+0],clk,ena); 
    srmul #(BWC,16,BW,2,8,3) cym (ey[i],scale,dout[i*2+1],clk,ena); 
  end
  for (i=0; i<UPS*2; i=i+1) begin
    assign dnout[i] = dout[i] + nout[i];
  end
  always @(posedge clk) wbusx <= (UPS==1)? {dnout[1],dnout[0]} : {dnout[3],dnout[2],dnout[1],dnout[0]};
  endgenerate

endmodule

// ena ca
// enad cc#
// enc cc
// 
// enx
// eny
// enb

module adderups (clk,rst, ups,fcy, tclk,ten,taps, ena,cab,cax,cay, enb,cbx,cby);

  parameter BWC=16;
  parameter NC=4;
  parameter UPS=1;
  parameter BID=1;		// UPS band ID
  parameter NT=16;		// number taps

  localparam SHF=8;		// unity gain tap shift
  localparam TW=17+SHF;		// tap bit width
  localparam BX=SHF;		// rounder bits
  localparam BTX=TW-SHF-2;	// rounder bits
  localparam BWCX=BWC+BX;
  localparam BWCT=BWC+TW-1;
  localparam RADD=(1<<BX)/2;	// rounder add amount .5 of rounder bits
  localparam NP=(NT>32)?6:(NT>16)?5:(NT>8)?4:(NT>4)?3:(NT>2)?2:(NT>1)?1:0;

  input clk,rst,ups;
  input [1:0] fcy;
  input tclk,ten;
  input [31:0] taps;
  input ena;
  input [3:0] cab[NC];
  input signed [BWC-1:0] cax[NC],cay[NC];

  output reg enb;
  output reg signed [BWC-1:0] cbx[2],cby[2];

  wire enc,enc_;
  wire enaz [NC];
  wire signed [BWC-1:0] ccx,ccy;
  vsum #(BWC,NC) vsx (clk,enaz, ena,cax, enc ,ccx);
  vsum #(BWC,NC) vsy (clk,enaz, ena,cay, enc_,ccy);
  wire enx; delayp #(NP+3) dpx (clk,enc,enx);
  wire eny; delayp #(NP+4) dpy (clk,enc,eny);
  wire enz = (UPS==2 && ups)? eny : enc;

 generate
 genvar i,n;

  for (i=0; i<NC; i=i+1) begin
    assign enaz[i] = (UPS==1) || (cab[i]==BID);
  end

 if (UPS==1) begin:ups1

  always @(posedge clk) begin
    enb <= enz;
    if (enz) begin cbx[0] <= ccx;  cbx[1] <= ccx; end
    if (enz) begin cby[0] <= ccy;  cby[1] <= ccy; end
  end

 end
 if (UPS==2) begin:ups2

  reg signed [TW-1:0]   t0[NT],t1[NT];
  reg signed [BWC-1:0]  ax[NT],ay[NT];
  reg signed [BWCT-1:0] t0ax[NT],t0ay[NT], t1ax[NT],t1ay[NT];

  reg signed [BWCX-1:0] c0x[2*NT],c0y[2*NT],c1x[2*NT],c1y[2*NT];

  reg tend;  always @(posedge tclk) tend <= ten;

  for (i=0; i<NT; i=i+1) begin
    always @(posedge tclk) begin
      if (ten) t0[i] <= (i==0)? taps : t1[i-1];
      if (ten) t1[i] <= t0[i];
    end
    always @(posedge clk) begin
      if (!ups) ax[i] <= 0; else if (enc) ax[i] <= (i==0)? ccx : ax[i-1];
      if (!ups) ay[i] <= 0; else if (enc) ay[i] <= (i==0)? ccy : ay[i-1];
      t0ax[i] <= t0[i] * ax[i];
      t0ay[i] <= t0[i] * ay[i];
      t1ax[i] <= t1[i] * ax[i];
      t1ay[i] <= t1[i] * ay[i];
    end
  end
  for (n=0; n<=NP; n=n+1) begin
    localparam j = NT>>n;
    localparam k = j*2;
    for (i=0; i<j; i=i+1) begin
      always @(posedge clk) begin
	c0x[j+i] <= (n==0)? (t0ax[i]>>BTX) : c0x[k+i] + c0x[k+j+i];
	c0y[j+i] <= (n==0)? (t0ay[i]>>BTX) : c0y[k+i] + c0y[k+j+i];
	c1x[j+i] <= (n==0)? (t1ax[i]>>BTX) : c1x[k+i] + c1x[k+j+i];
	c1y[j+i] <= (n==0)? (t1ay[i]>>BTX) : c1y[k+i] + c1y[k+j+i];
      end
    end
  end

  reg [1:0] quad;
  wire [1:0] quax = quad+fcy;
  always @(posedge clk) begin
    if (rst) quad <= 0; else if (enx) quad <= quax+fcy;
    c0x[0] <= (quad==0)?  c0x[1] : (quad==1)? -c0y[1] : (quad==2)? -c0x[1] :  c0y[1];
    c0y[0] <= (quad==0)?  c0y[1] : (quad==1)?  c0x[1] : (quad==2)? -c0y[1] : -c0x[1];
    c1x[0] <= (quax==0)?  c1x[1] : (quax==1)? -c1y[1] : (quax==2)? -c1x[1] :  c1y[1];
    c1y[0] <= (quax==0)?  c1y[1] : (quax==1)?  c1x[1] : (quax==2)? -c1y[1] : -c1x[1];
  end
  wire signed [BWC-1:0] d0x = (c0x[0]+RADD)>>BX, d0y = (c0y[0]+RADD)>>BX;	// rounding
  wire signed [BWC-1:0] d1x = (c1x[0]+RADD)>>BX, d1y = (c1y[0]+RADD)>>BX;	

  reg [1:0] ocnt;
  wire enb_ = enz && (ups|ocnt[0]);
  always @(posedge clk) begin
    if (rst) ocnt <= 0; else if (enz) ocnt <= ocnt+1;
    enb <= enz && (ups|ocnt[0]);
    if (enz) begin cbx[0] <= ups?d0x:cbx[1];  cbx[1] <= ups?d1x:ccx; end
    if (enz) begin cby[0] <= ups?d0y:cby[1];  cby[1] <= ups?d1y:ccy; end
  end

 end
 endgenerate

endmodule

module vsum (clk,enz, ival,ibus, oval,obus);
  parameter BW=32;      // Bus width
  parameter NT=1;       // Number Taps
  input clk,ival;
  input enz [NT];
  input signed [BW-1:0] ibus [NT];
  output oval;
  output signed [BW-1:0] obus;

  localparam NP=(NT>32)?6:(NT>16)?5:(NT>8)?4:(NT>4)?3:(NT>2)?2:(NT>1)?1:0;
  localparam NPT=(1<<NP);
  reg signed [BW-1:0] c[2*NPT];

  genvar i,j,k,n;
  generate
  for (n=0; n<=NP; n=n+1) begin
    localparam j = NPT>>n;
    localparam k = j*2;
    for (i=0; i<j; i=i+1) begin
      always @(posedge clk) c[j+i] <= (n>0)? c[k+i] + c[k+j+i] : (i>=NT||!enz[i])? 0 : ibus[i];
    end
  end
  endgenerate
  assign obus = c[1];
  delayp #(NP+1) dp (clk,ival,oval);
endmodule

/* verilator lint_on MULTITOP */
