

module jtag_sm(clk, tms, cir, sir, uir, cdr, sdr, udr);

input clk,tms;
output cir,sir,uir;
output cdr,sdr,udr;

reg [3:0] state;
always@(posedge clk) begin
  case (state)
    0: begin //Test Logic/Reset
      if(tms == 0) state <= 1;
    end
    1: begin //Run Test/Idle
      if(tms == 1) state <= 2;
    end
    2: begin //Select DR Scan
      if(tms == 0) state <= 3;
      else state <= 9;
    end
    3: begin //Capture DR
      if(tms == 0) state <= 4;
      else state <= 5;
    end
    4: begin //Shift DR
      if(tms == 1) state <= 5;
    end
    5: begin //Exit1 DR
      if(tms == 0) state <= 6;
      else state <= 8;
    end
    6: begin //Pause DR
      if(tms == 1) state <= 7;
    end
    7: begin //Exit2 DR
      if(tms == 0) state <= 4;
      else state <= 8;
    end
    8: begin //Update DR
      if(tms == 0) state <= 1;
      else state <= 2;
    end
    9: begin //Select IR Scan
      if(tms == 0) state <= 10;
      else state <= 0;
    end
    10: begin //Capture IR
      if(tms == 0) state <= 11;
      else state <= 12;
    end
    11: begin //Shift IR
      if(tms == 1) state <= 12;
    end
    12: begin //Exit1 IR
      if(tms == 0) state <= 13;
      else state <= 15;
    end
    13: begin //Pause IR
      if(tms == 1) state <= 14;
    end
    14: begin //Exit2 IR
      if(tms == 0) state <= 11;
      else state <= 15;
    end
    15: begin //Update IR
      if(tms == 0) state <= 1;
      else state <= 2;
    end
  endcase
end

assign cir = (state==10);
assign sir = (state==11);
assign uir = (state==15);

assign cdr = (state==3);
assign sdr = (state==4);
assign udr = (state==8);

endmodule

