/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  ICE DMA Controller Defines

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

*/
`ifndef _DMADEFS
`define _DMADEFS
// special constants
`define CW0 32'h00000000
`define C0F 8'h0F

// module IDs
`define DMAC 0
`define PROC 0
`define HOST 1

`define PR   0
`define HP   1
`define HA   2
`define HB   3
`define CA   4
`define CB   5
`define TA   6
`define TB   7

`define RIO  8
`define NIO  8
`define DIO  9

`define HA1  10
`define HB1  11

`define TA1  12
`define TA2  13
`define TB1  14
`define TB2  15

`define E1   12
`define E2   13

`define NV   12
`define HC   13

// specialty PM IDs
`define TC   1
`define TCTL 7

// flags
`define TMUXA 0
`define TMUXB 1
`define TMUXC 2
`define TMUXD 3
`define TXOUT 3
`define HPFDP 4
`define HXFDP 5
`define CXFDP 6
`define TXFDP 7

`define CA2CB 8
`define CB2CA 9
`define TA2TB 10
`define TB2TA 11
`define TX2HX 12
`define CX2HX 13
`define TX2CX 14
`define CXAOB 15

`define HXAOB 16
`define TXAOB 17
`define TA2HX 18
`define TB2HX 19
`define DIO2P 20
`define P2DIO 21
`define CXMIX 22
`define TXTAG 23

`define NIO2M 24
`define M2NIO 25
`define NV2M  26
`define M2NV  27
`define NIO2HX 28
`define HX2NIO 29
`define NV2HX 30
`define HX2NV 31

// direct routes
`define CA2HA 0
`define CB2HA 1
`define CA2HB 2
`define CB2HB 3

`define HA2CA 4
`define HB2CA 5
`define HA2CB 6
`define HB2CB 7

`define TA2HA 8
`define CA2TA 9
`define CB2TB 10
`define TB2HB 11

`define HA2TA 12
`define HB2TA 13
`define HA2TB 14
`define HB2TB 15

// DRAM routes
`define PR2R  16
`define HP2R  17
`define HA2R  18
`define HB2R  19
`define CA2R  20
`define CB2R  21
`define TA2R  22
`define TB2R  23

`define R2PR  24
`define R2HP  25
`define R2HA  26
`define R2HB  27
`define R2CA  28
`define R2CB  29
`define R2TA  30
`define R2TB  31

// specialty PM routes
`define R2TC   25
`define TA2CA  1
`define TB2CB  2

// specialty MB routes
`define CA2TB 8
`define CB2TA 11

`endif
