/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  Bypass Core 

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

*/
module bypengine (sclk,srst, scs,saddr, swr,swrbus, srd,srdbus, sack,
		   ioclk, istat,iena,isel,ibus, ostat,oena,osel,obus, test);

  parameter PORT=1;	// engine index
  parameter IBW=64;	// I/O bus input width 
  parameter OBW=IBW;	// I/O bus output width 

  localparam SBW=32;	// System bus width - always 32
  localparam DBW=32;	// Data bus width (internal core use)
  localparam NR=2;	// Number of 16kb RAMS in fifos

  input sclk;		// system clock
  input srst;		// system reset
  input scs;		// system select (qualifies swr and srd for this core)
  input swr;		// register write
  input srd;		// register read
  input [31:0] saddr;	// register address
  input [31:0] swrbus;	// register data
  output [31:0] srdbus;	// register data
  output sack;          // acknowledge

  input ioclk;          // I/O data bus clock
  output istat;         // istat - ready to accept 64 by burst
  input iena;           // input enable (one cycle early) (continuous 64 byte burst)
  input [7:0] isel;     // input channel selection
  input [IBW-1:0] ibus; // input data bus
  output ostat;         // ostat - ready to provide 64 byte burst
  input oena;           // output enable (one cycle early) (continuous 64 byte burst)
  output [7:0] osel;    // output channel selection
  output [OBW-1:0] obus;// output data bus

  output [7:0] test;	// 8 test signals for scope probes
  
  wire L=0, H=1;
  assign sack=H;
  assign osel=0;	// single channel core

  // system status ram with parameterized ID 
  swrstat #("BYP",32'h1CE) ss (sclk,scs,swr, saddr, swrbus,srdbus);

  // system register address resolution - with pipeline
  wire [7:0] sb; swrbank #(0,8) swb (sclk,scs,swr,saddr,sb);
  wire swrsys  = sb[0]; // system register (required)
  wire swrflag = sb[7]; // flag register (optional)

  // system registers - written to by pic_cport() host control software
  reg [31:0] system,flag;	
  always @(posedge sclk) begin
    if (srst) system <= 0; else if (swrsys) system <= swrbus;
    if (srst) flag   <= 0; else if (swrflag) flag  <= swrbus;
  end
  wire enable     = system[0];		// core enable
  wire dir        = system[1];		// direction ? output:input

  wire reset = !enable;		// core reset (at boot or disabled)

  reg ival; always @(posedge ioclk) ival <= iena; // handle iena early

  // this reformats any input type to output format 4'h8 = complex 16b
  fifoNxM #(IBW,OBW,NR) fi (ioclk,reset, istat,ival,ibus, ioclk,reset, ostat,oena,obus);

  assign test = {oena,ostat,iena,istat,system[3:0]};	// example test probe

endmodule

