/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  Xilinx RocketIO 4x10GE Controller

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

*/
module niocontroller (
  bsclk,bscs,bsrd,bswr,bspage,bsaddr,bsdata,bsdatao, // Boundary Scan Interface
  sclk,srst, scs,saddr, swr,swrbus, srd,srdbus,
  cclk,crd,cwr,cpage,caddr,cdata,cdatao, cs,
  pxclkx, pxrxp,pxrxn, pxtxp,pxtxn, pxctl,
  ioclk,iorst,ena, irdy,iena,isel,ibus, ordy,oena,osel,obus,
  test);			

  parameter PORTS=4;
  parameter IBW=32;

  localparam MPORTS=16;
  localparam DBW=IBW;

  // BSCAN ports
  input bsclk,bscs,bsrd,bswr;
  input [7:0] bspage,bsaddr,bsdata;
  output [7:0] bsdatao;

  // system bus
  input sclk,srst,scs,swr,srd;
  input [31:0] saddr,swrbus;
  output [31:0] srdbus;

  // JVM control IF
  input cclk,crd,cwr,cs;
  input [7:0] cpage,caddr,cdata;
  output [7:0] cdatao;
        
  // MGT ports
  inout [3:0] pxclkx;
  input [PORTS-1:0] pxrxp,pxrxn;
  output [PORTS-1:0] pxtxp,pxtxn;
  inout [MPORTS-1:0] pxctl;

  // IO port busses
  input ioclk,iorst;
  input [1:0] ena;
  input iena,oena;
  output irdy,ordy;
  input [7:0] isel;
  output [7:0] osel;
  input [IBW-1:0] ibus;
  output [IBW-1:0] obus;

  // test port
  output [7:0] test;

  // global signals 
  wire F=0, T=1;

  // boundary scan to DRP monitor
  wire        drp_en;
  wire [15:0] drp_di,drp_addr;
  wire [PORTS-1:0] drp_wex,drp_rdyx;
  wire [PORTS*16-1:0] drp_dox;
  wire [PORTS*17-1:0] dmon_dox;
  wire drp_clk = sclk;
  bs2drp #(PORTS,0,4) (bsclk,bscs,bsrd,bswr,bspage,bsaddr,bsdata,bsdatao,
                   drp_clk,drp_en,drp_wex,drp_addr,drp_di,drp_rdyx,drp_dox,dmon_dox);

  // system register
  reg [7:0] sysreg; always @(posedge sclk) if (scs && swr && saddr[16]) sysreg <= swrbus;
  reg rstx; always @(posedge ioclk) rstx <= (ena==0) || iorst || srst;
  wire [4*38:0] streams;
  wire [7:0] dbgsys=sysreg;
  wire [32:0] dbgout;
  wire scsx = scs && !saddr[16];

  ice_tg_phy #(4,DBW) bnk (
	ioclk,rstx, irdy,iena,isel,ibus, ordy,oena,osel,obus,
	sclk,srst, scsx,saddr, swr,swrbus, srd,srdbus,
        cclk,crd,cwr,cpage,caddr,cdata,cdatao, cs,
	drp_clk,F,drp_en,drp_addr,drp_wex,drp_di,drp_rdyx,drp_dox,dmon_dox,
	pxclkx, pxtxp,pxtxn, pxrxp,pxrxn, streams,test,dbgsys,dbgout);

endmodule
