/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  ICE PIC8 Module System Clock / Reset Generators, etc.

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2014

*/
`ifndef SYS_CLKF
`define SYS_CLKF 166
`endif
`ifndef SYS_CLKF2
`define SYS_CLKF2 400
`endif
`ifndef SYS_CLKM
`define SYS_CLKM 250
`endif
`ifndef SYS_CLKX
`define SYS_CLKX 240
`endif
`ifndef SYS_CLKV
`define SYS_CLKV 400
`endif

module sysclocks (x1p,x1n,x2p,x2n,x3p,x3n,x4p,x4n,x5p,x5n,x6p,x6n, gclkc,mclk,trsp,
	crst,addr, sset,swrbus,srdbus, rprc,rdmac,pset,rset,
	rscs,rhyp,rmem,rio,rsts,rmod,boot,
	gclks,gclkx,gclky,gclkms,gclkf,gclkv,
	lclktp,lclktq,lclktr,lclkts,pclk, test);

  localparam CLKF=`SYS_CLKF;
  localparam CLKF2=`SYS_CLKF2;
  localparam CLKM=`SYS_CLKM;

  localparam CLKF_MUL  = (CLKF2==256.25)? 10.25 : 10;
  localparam CLKF_DIV  = 100.0*CLKF_MUL/`SYS_CLKF;
  localparam CLKF_DIV2 = 100*CLKF_MUL/`SYS_CLKF2;

  localparam CLKS_MUL  = 12;
  localparam CLKS_DIV  = 12;
  localparam CLKX_DIV  = 1200.0/`SYS_CLKX;
  localparam CLKY_DIV  = 6;
  localparam CLKZ_DIV  = 4;
  localparam CLKV_DIV  = 1200/`SYS_CLKV;

  input x1p,x1n,x2p,x2n,x3p,x3n,x4p,x4n,x5p,x5n,x6p,x6n;
  input [2:0] trsp;
  input crst,sset,rdmac,pset,rset;
  input [7:0] addr;
  input [31:0] swrbus;
  output [31:0] srdbus;
  output reg rscs,rhyp,rmem,rio,rsts,rprc,rmod,boot;
  output gclks,gclkx,gclky,gclkv,gclkc,mclk,pclk;
  output [1:0] gclkf;
  output [39:0] gclkms;
  output [1:0] lclktp,lclktq,lclktr,lclkts;
  output [7:0] test;

  wire H=1, L=0; 
(* dont_touch = "yes" *)  wire lclkc,lclks,lclkm,lclkf,lclkf2,lclkx,lclky,lclkz,lclkv,lclkmf,lclkp;
  wire lock,gclkz,gclkmf,gclkn;

  // System resets
  always @(posedge gclks) boot <= (crst || boot);
  always @(posedge gclks) rscs <= (crst && addr[0]); 
  always @(posedge gclks) rhyp <= (crst && addr[4]) || rdmac;
  always @(posedge gclks) rsts <= (crst && addr[6]) || rdmac;
  always @(posedge gclks) rmod <= rprc;
  reg booted;
  always @(posedge gclkx) begin
    booted <= crst || booted;
    rprc   <= !booted || rscs || (crst && addr[2] && !addr[7])
              || (rprc && !(crst && addr[2] && addr[7]));
    rio  <= (crst && addr[6]) || rdmac;
  end

  // Clock recovery
  assign mclk = L;
  reg [31:0] prate;
  reg [23:0] srcfg;
  assign srdbus = {trsp,srcfg};

  // Clock adjusts
  reg rscp,ascp,rupdn,rupdnp,rscq,ascq,rmems,rmemx,rmemy,rmemc,wmce;
  always @(posedge gclks) begin
    if (sset) rmems <= swrbus[4];
    if (sset) rmemx <= swrbus[24];
    if (sset) rmemy <= swrbus[25];
    if (pset) prate <= swrbus;
    if (rset) srcfg <= swrbus;
  end

  // Global Clocks
  BUFG_GT _clkp  (.O(gclkc),.I(lclktq[1]));	// 100MHz Crystal

  // MGT Clocks
`ifdef K8P
  IBUFDS_GTE4 mgtp (.O(lclktp[0]),.ODIV2(lclktp[1]),.I(x3p),.IB(x3n));	// 100MHz PCI Express
  IBUFDS_GTE4 mgtq (.O(lclktq[0]),.ODIV2(lclktq[1]),.I(x4p),.IB(x4n));	// 100MHz crystal
  IBUFDS_GTE4 mgtr (.O(lclktr[0]),.ODIV2(lclktr[1]),.I(x5p),.IB(x5n));	// 156MHz crystal
  IBUFDS_GTE4 mgts (.O(lclkts[0]),.ODIV2(lclkts[1]),.I(x6p),.IB(x6n));	// 156MHz crystal
`else
  IBUFDS_GTE3 mgtp (.O(lclktp[0]),.ODIV2(lclktp[1]),.I(x3p),.IB(x3n));	// 100MHz PCI Express
  IBUFDS_GTE3 mgtq (.O(lclktq[0]),.ODIV2(lclktq[1]),.I(x4p),.IB(x4n));	// 100MHz crystal
  IBUFDS_GTE3 mgtr (.O(lclktr[0]),.ODIV2(lclktr[1]),.I(x5p),.IB(x5n));	// 156MHz crystal
  IBUFDS_GTE3 mgts (.O(lclkts[0]),.ODIV2(lclkts[1]),.I(x6p),.IB(x6n));	// 156MHz crystal
`endif

  // Derived Clocks
  BUFG    _clkf  (gclkf[0],lclkf);	// 1xxMHz for function clock
  BUFG    _clkf2 (gclkf[1],lclkf2);	// 3xxMHz for secondary function clock
  BUFG    _clkx  (gclkx,lclkx);		// 2xxMHz for ioclk 
  BUFG    _clkm  (gclkn,lclks);		// 100MHz System clock 
  BUFG    _clkz  (gclkz,lclkz);		// 300MHz for IDELAYCNTRL
  BUFG    _clkv  (gclkv,lclkv);		// PM RIO

  BUFGCE_DIV #(.BUFGCE_DIVIDE("2")) _clks (.O(gclks),.I(lclky));	// 100MHz System clock 
  BUFGCE_DIV #(.BUFGCE_DIVIDE("1")) _clky (.O(gclky),.I(lclky));	// 200MHz System clock 

  // the Memory clocks
  assign gclkms = { srcfg, 4'h0, 4'h0, 4'h0, gclkn,rmemx,x1n,x1p};

  // 100/200/300MHz synchronized System clocks + function clock
  wire rena,o_fb; delaypipe #(64) rsys (gclkc,H,rena);
  MMCM_ADV o_dcm (.PSCLK(L),.PSEN(L),.PSINCDEC(L),.RST(!rena),.PWRDWN(L),
        .CLKIN1(gclkc),.CLKFBIN(o_fb),.CLKFBOUT(o_fb),.CLKOUT0(lclkx),.CLKOUT2(lclks),.CLKOUT3(lclky),.CLKOUT4(lclkz),.CLKOUT5(lclkv)); 
  defparam o_dcm.CLKIN1_PERIOD = 10;
  defparam o_dcm.DIVCLK_DIVIDE = 1;
  defparam o_dcm.CLKFBOUT_MULT_F = CLKS_MUL;
  defparam o_dcm.CLKFBOUT_PHASE = 0;
  defparam o_dcm.CLKOUT0_DIVIDE_F = $rtoi(8*CLKX_DIV)/8.0;
  defparam o_dcm.CLKOUT2_DIVIDE = CLKS_DIV;
  defparam o_dcm.CLKOUT3_DIVIDE = CLKY_DIV;
  defparam o_dcm.CLKOUT4_DIVIDE = CLKZ_DIV;
  defparam o_dcm.CLKOUT5_DIVIDE = CLKV_DIV; 

  // the 125=5/4, 133=4/3, or 150=3/2 MHz System clock 
  wire f_fb;
  MMCM_ADV f_dcm (.PSCLK(L),.PSEN(L),.PSINCDEC(L),.RST(rscs),.PWRDWN(L),
        .CLKIN1(gclkc),.CLKFBIN(f_fb),.CLKFBOUT(f_fb),.CLKOUT0(lclkf),.CLKOUT1(lclkf2)); 
  defparam f_dcm.CLKIN1_PERIOD = 10;
  defparam f_dcm.DIVCLK_DIVIDE = 1;
  defparam f_dcm.CLKFBOUT_MULT_F = CLKF_MUL;
  defparam f_dcm.CLKOUT0_DIVIDE_F = $rtoi(8*CLKF_DIV)/8.0;
  defparam f_dcm.CLKOUT1_DIVIDE = CLKF_DIV2; 

  // the programmable clock
  reg [7:0] fcnt;
  wire rcnt = (fcnt==8'hC7);	// 200 in MHz 
  reg pgo,pclkp,pclkn;
  always @(posedge gclky) begin
    if (rcnt) fcnt <= 0; else fcnt <= fcnt+1;
    pgo <= fcnt < prate[27:20];
    if (pgo) pclkp <= !pclkp;
  end
  always @(negedge gclky) begin
    pclkn <= pclkp;
  end
  assign pclk = (pclkp^pclkn);

  wire idcrdy;
  reg rmemz; always @(posedge gclkz) rmemz <= rmemy;
  IDELAYCTRL #(.SIM_DEVICE("ULTRASCALE")) dlycx (.REFCLK(gclkz),.RST(rmemz),.RDY(idcrdy) );

  //assign test = 0;
  reg sff; always @(posedge gclks) sff <= !sff;
  reg zff; always @(posedge gclkz) zff <= !zff;
  reg f0f; always @(posedge gclkf[0]) f0f <= !f0f;
  reg f1f; always @(posedge gclkf[1]) f1f <= !f1f;
  assign test = crst? 8'hFF : {rmemx,rmemy,rmemz,rmems,lock,zff,f1f,f0f,sff};

endmodule
