`include "../lib/firdefs.h"
`ifndef TFDD_ORDER
`define TFDD_ORDER 1
`endif
`ifndef TFDD_MDW
`define TFDD_MDW 12
`endif
`define Z1 `XCOEF
`ifdef TFDD_XTAPS
`define Z2 `XCOEF|`C2ROUT|`XTAPS
`else
`define Z2 `XCOEF|`C2ROUT
`endif
`ifndef TFDD_RTAPS
`define TFDD_RTAPS 8
`endif
`ifdef VIVADO
module
tfdengine
#
(
PORT
=
1
,
IBW
=
64
,
OBW
=
IBW
)
(
input
[
1
:
0
]
sclks
,
input
srst
,
input
scs
,
input
[
31
:
0
]
saddr
,
input
swrs
,
input
[
31
:
0
]
swrbus
,
input
srds
,
output
[
31
:
0
]
srdbus
,
output
sack
,
input
ioclk
,
output
istat
,
input
iena
,
input
[
7
:
0
]
isel
,
input
[
IBW
-
1
:
0
]
ibus
,
output
ostat
,
input
oena
,
output
[
7
:
0
]
osel
,
output
[
IBW
-
1
:
0
]
obus
,
output
[
7
:
0
]
test
);
tfddengine
#
(
PORT
,
IBW
,
OBW
,
12
,
1
,
8
)
inst
(
sclks
,
srst
,
scs
,
saddr
,
swrs
,
swrbus
,
srds
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
endmodule
`endif
`ifdef verilator
module
TFDD_core
#
(
PORT
=
1
,
IBW
=
64
,
OBW
=
IBW
)
(
input
[
1
:
0
]
sclks
,
input
srst
,
input
scs
,
input
[
31
:
0
]
saddr
,
input
swrs
,
input
[
31
:
0
]
swrbus
,
input
srds
,
output
[
31
:
0
]
srdbus
,
output
sack
,
input
ioclk
,
output
istat
,
input
iena
,
input
[
7
:
0
]
isel
,
input
[
IBW
-
1
:
0
]
ibus
,
output
ostat
,
input
oena
,
output
[
7
:
0
]
osel
,
output
[
IBW
-
1
:
0
]
obus
,
output
[
7
:
0
]
test
);
tfddengine
#
(
PORT
,
IBW
,
OBW
)
inst
(
sclks
,
srst
,
scs
,
saddr
,
swrs
,
swrbus
,
srds
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
endmodule
`endif
module
tfddengine
(
sclks
,
srst
,
scs
,
saddr
,
swrs
,
swrbus
,
srds
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
OBW
=
IBW
;
parameter
IKR
=
0
;
parameter
OKR
=
0
;
parameter
IOCLKS
=
1
;
localparam
MDW
=`TFDD_MDW
;
localparam
ORDER
=`TFDD_ORDER
;
localparam
RTAPS
=`TFDD_RTAPS
;
localparam
MSW
=(
MDW
>
15
)?
8
:
(
MDW
>
12
)?
7
:
(
MDW
>
6
)?
6
:
(
MDW
>
3
)?
5
:
4
;
`ifdef TFDD_NPS
localparam
NPS
=`TFDD_NPS
;
`else
localparam
NPS
=
0
;
`endif
`ifdef PIC8
localparam
NR
=
4
;
localparam
NS
=
4
;
`else
localparam
NR
=
0
;
localparam
NS
=
3
;
`endif
`ifdef SYS_CLKF2_MASK
localparam
CLKF2
=(`SYS_CLKF2_MASK
>>
(
PORT
-
1
))
&
1
;
localparam
MFCLK
=(
CLKF2
>
0
)?
`SYS_CLKF2
:`SYS_CLKF
;
`else
localparam
CLKF2
=
0
;
localparam
MFCLK
=`SYS_CLKF
;
`endif
localparam
FCLK
=
MFCLK
*
1000000
;
localparam
NCX
=
2
;
`ifdef TFDD_CFXO
localparam
CFXO
=`TFDD_CFXO
;
`else
localparam
CFXO
=
0
;
`endif
input
[
1
:
0
]
sclks
;
input
srst
;
input
scs
;
input
[
1
:
0
]
swrs
;
input
[
1
:
0
]
srds
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
OBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z3
=
0
,
z4
=
1
;
assign
sack
=
z4
;
assign
osel
=
0
;
wire
z5
=
sclks
[
CLKF2
];
wire
z6
=
swrs
[
CLKF2
];
wire
z7
=
srds
[
CLKF2
];
wire
[
31
:
0
]
z8
=
FCLK
;
wire
z9
,
z10
,
z11
,
z12
,
z13
;
reg
z14
,
z15
,
z16
,
z17
,
z18
,
z19
;
always
@(
posedge
ioclk
)
z18
<=
iena
;
statusblk
#
(
"TFDD"
,
ORDER
,
MDW
,
RTAPS
,
NPS
,
CFXO
,
0
,
MFCLK
)
ss
(
z5
,
scs
,
saddr
,
z6
,
swrbus
,
z7
,
srdbus
);
wire
[
15
:
0
]
z20
;
swrbank
#
(
0
,
16
)
swb
(
z5
,
scs
,
z6
,
saddr
,
z20
);
wire
z21
=
z20
[
0
],
z22
=
z20
[
1
],
z23
=
z20
[
2
],
z24
=
z20
[
3
],
z25
=
z20
[
4
],
z26
=
z20
[
5
],
z27
=
z20
[
6
],
z28
=
z20
[
7
];
wire
z29
=
z20
[
8
],
z30
=
z20
[
9
],
z31
=
z20
[
10
],
z32
=
z20
[
11
],
z33
=
z20
[
12
],
z34
=
z20
[
13
],
z35
=
z20
[
14
],
z36
=
z20
[
15
];
reg
[
31
:
0
]
z37
;
reg
[
MDW
-
1
:
0
]
z38
;
reg
[
7
:
0
]
z39
,
z40
;
reg
[
11
:
0
]
z41
;
reg
[
31
:
0
]
z42
;
reg
z43
;
always
@(
posedge
z5
)
begin
z43
<=
srst
;
if
(
z43
)
z37
<=
0
;
else
if
(
z21
)
z37
<=
swrbus
;
if
(
z43
)
z38
<=
0
;
else
if
(
z22
)
z38
<=
swrbus
;
if
(
z43
)
z39
<=
0
;
else
if
(
z26
)
z39
<=
swrbus
;
if
(
z43
)
z41
<=
0
;
else
if
(
z30
)
z41
<=
swrbus
;
if
(
z43
)
z42
<=
0
;
else
if
(
z24
)
z42
<=
swrbus
;
if
(
z43
)
z40
<=
0
;
else
if
(
z28
)
z40
<=
swrbus
;
end
wire
z44
=
!
z37
[
0
];
wire
z45
=
z37
[
0
];
wire
z46
=
z37
[
1
];
wire
z47
=
z37
[
2
];
wire
z48
=
z37
[
3
];
wire
z49
=
z37
[
4
];
wire
z50
=
z37
[
5
];
wire
z51
=
z37
[
6
];
wire
[
3
:
0
]
z52
=
z37
[
11
:
8
];
wire
[
3
:
0
]
z53
=
z37
[
15
:
12
];
wire
[
2
:
0
]
z54
=
z37
[
18
:
16
];
wire
[
3
:
0
]
z55
=
z37
[
23
:
20
];
wire
[
1
:
0
]
z56
=
saddr
[
1
:
0
];
wire
z57
=
z4
;
wire
z58
=
!
z53
[
3
];
wire
z59
=
z53
[
0
];
wire
z60
=
z53
[
2
];
wire
z61
=
z5
;
wire
z62
=
!
z51
;
wire
z63
=
z49
?
z47
:
z40
[
0
];
reg
z64
,
z65
;
reg
[
4
:
0
]
z66
;
wire
z67
=
(
z14
||
z64
);
wire
z68
=
(
z66
<=
1
);
wire
z69
=
z44
||
z68
;
always
@(
posedge
z61
)
begin
if
(
z44
)
z14
<=
0
;
else
z14
<=
z9
&&
z10
&&
z11
&&
z13
&&
(!
z67
||
z68
||
!
z49
)
&&
!
z19
;
if
(
z44
)
z64
<=
0
;
else
z64
<=
z67
&&
!
z68
&&
z49
;
if
(
z69
)
z66
<=
z39
;
else
if
(
z67
)
z66
<=
z66
-
1
;
z15
<=
z50
?
z14
:
(
z14
||
z64
);
end
`ifdef TFDD_NPS
wire
[
3
:
0
]
z70
=
{
z27
&(
z56
==
3
),
z27
&(
z56
==
2
),
z27
&(
z56
==
1
),
z27
&(
z56
==
0
)};
wire
[
3
:
0
]
z71
=
{
z28
&(
z56
==
3
),
z28
&(
z56
==
2
),
z28
&(
z56
==
1
),
z28
&(
z56
==
0
)};
wire
[
NPS
*
2
*
16
-
1
:
0
]
z72
,
z73
;
fifoNxM
#
(
IBW
,
NPS
*
2
*
16
)
fin
(
ioclk
,
z44
,
istat
,
z18
,
ibus
,
z61
,
z44
,
z9
,
z14
,
z72
);
always
@(
posedge
z61
)
begin
z19
<=
z3
;
end
wire
z74
;
wire
[
NPS
*
2
*
18
-
1
:
0
]
z75
;
cxtuner
#
(
16
,
16
,
18
,
1
,
NPS
,
1
)
cxt
(
z61
,
z44
,
z70
,
z71
,
swrbus
,
z15
,
z72
,
z74
,
z75
);
wire
z76
,
z77
;
wire
[
23
:
0
]
z78
,
z79
;
firfilter
#
(
ORDER
+
CFXO
,
18
,
18
,
24
,
3
,
8
,`XCOEF
,
NCX
,
NPS
)
cfir
(
z61
,
z44
,
z31
,
z32
,
swrbus
,
z76
,
z74
,
z75
,
z77
,{
z79
,
z78
},
z3
);
assign
z10
=
z49
?
z76
:
z4
;
wire
z80
,
z81
;
wire
signed
[
16
:
0
]
z82
,
z83
;
cicfilter
#
(
5
,
24
,
17
,
MDW
,
MSW
,
16
,
1
)
cicr
(
z61
,
z44
,
z38
,
z23
,
swrbus
,
z77
,
z78
,
z80
,
z82
);
cicfilter
#
(
5
,
24
,
17
,
MDW
,
MSW
,
16
,
1
)
cici
(
z61
,
z44
,
z38
,
z23
,
swrbus
,
z77
,
z79
,
z81
,
z83
);
wire
z84
,
z85
;
wire
[
16
:
0
]
z86
,
z87
;
resfilter
#
(
RTAPS
,
17
,
18
,
17
,
3
,
8
,
NCX
,
6
)
resx
(
z61
,
z44
,
z62
,
z25
,
z24
,
z35
,
z36
,
swrbus
,
z84
,
z80
,{
z83
,
z82
},
z12
,
z85
,{
z87
,
z86
});
wire
[
31
:
0
]
z88
=
{
z87
[
16
:
1
],
z86
[
16
:
1
]};
assign
z11
=
z49
?
z84
:
z4
;
wire
z89
,
z90
;
wire
[
31
:
0
]
z91
;
firfilter
#
(
ORDER
,
17
,
18
,
16
,
4
,
10
,`XCOEF
,
NCX
)
pfir
(
z61
,
z44
,
z33
,
z34
,
swrbus
,
z89
,
z85
,{
z87
,
z86
},
z90
,
z91
,
z58
);
assign
z12
=
z89
;
fifoNxMfmti
#
(
OBW
,
32
)
fout
(
ioclk
,
z44
,
z53
,
ostat
,
oena
,
obus
,
z5
,
z44
,
4'h8
,
z13
,
z49
?
z90
:
z15
,
z49
?
z91
:
z73
);
`else
wire
[
31
:
0
]
z72
;
fifoNxMfmt
#
(
IBW
,
32
)
fin
(
ioclk
,
z44
,
z52
,
istat
,
z18
,
ibus
,
z61
,
z44
,
4'h8
,
z9
,
z14
,
z72
);
reg
signed
[
15
:
0
]
z92
,
z93
;
wire
z94
=
(
z72
[
15
:
01
]
==
15'b100000000000000
);
wire
z95
=
(
z72
[
31
:
17
]
==
15'b100000000000000
);
always
@(
posedge
z61
)
begin
z65
<=
!
z14
;
z16
<=
z15
&&
z49
;
z17
<=
z16
;
if
(
z65
)
z92
<=
0
;
else
z92
<=
{
z72
[
15
:
01
],
z72
[
00
]|
z94
};
if
(
z65
)
z93
<=
0
;
else
z93
<=
{
z72
[
31
:
17
],
z72
[
16
]|
z95
};
end
reg
z96
,
z97
,
z98
,
z99
,
z100
;
reg
[
3
:
0
]
z101
;
reg
[
6
:
0
]
z102
;
wire
z103
=
z98
&&
(
z101
>
0
);
always
@(
posedge
z61
)
begin
z96
<=
z14
;
z97
<=
z96
;
z98
<=
z97
;
z99
<=
z98
;
z102
<=
z72
[
15
]?
~
z72
[
14
:
8
]
:
z72
[
14
:
8
];
z100
<=
z97
&&
(
z102
>
z41
[
6
:
0
]);
if
(
z100
)
z101
<=
z41
[
11
:
8
];
else
if
(
z103
)
z101
<=
z101
-
1
;
end
wire
signed
[
15
:
0
]
z104
,
z105
;
dds
fdds
(
z61
,
z44
,
z27
,
z28
,
swrbus
,
z15
,
z104
,
z105
);
reg
z106
,
z107
,
z74
;
wire
signed
[
23
:
0
]
z108
,
z109
;
reg
signed
[
31
:
0
]
z110
,
z111
,
z112
,
z113
;
reg
signed
[
31
:
0
]
z114
,
z115
;
always
@(
posedge
z61
)
begin
z110
<=
(
z92
*
z105
);
z111
<=
(
z92
*
z104
);
z112
<=
(
z93
*
z105
);
z113
<=
(
z93
*
z104
);
if
(
z103
)
z114
<=
0
;
else
z114
<=
(
z110
-
z113
);
if
(
z103
)
z115
<=
0
;
else
z115
<=
(
z111
+
z112
);
z106
<=
z17
;
z107
<=
z17
;
z74
<=
z17
;
end
assign
z109
=
z114
[
31
:
8
];
assign
z108
=
z115
[
31
:
8
];
wire
z80
,
z81
;
wire
signed
[
16
:
0
]
z82
,
z83
;
cicfilter
#
(
5
,
24
,
17
,
MDW
,
MSW
,
16
)
cicr
(
z61
,
z44
,
z38
,
z23
,
swrbus
,
z74
,
z109
,
z80
,
z82
);
cicfilter
#
(
5
,
24
,
17
,
MDW
,
MSW
,
16
)
cici
(
z61
,
z44
,
z38
,
z23
,
swrbus
,
z74
,
z108
,
z81
,
z83
);
wire
z76
,
z77
;
wire
[
16
:
0
]
z78
,
z79
;
firfilter
#
(
ORDER
,
17
,
16
,
17
,
3
,
8
,`Z1
,
NCX
)
cfir
(
z61
,
z44
,
z31
,
z32
,
swrbus
,
z76
,
z80
,{
z83
,
z82
},
z77
,{
z79
,
z78
},
z3
);
assign
z10
=
z4
;
wire
z84
,
z85
;
wire
[
16
:
0
]
z86
,
z87
;
resfilter
#
(
RTAPS
,
17
,
18
,
17
,
3
,
8
,
NCX
)
resx
(
z61
,
z44
,
z62
,
z25
,
z24
,
z35
,
z36
,
swrbus
,
z84
,
z77
,{
z79
,
z78
},
z12
,
z85
,{
z87
,
z86
});
wire
[
31
:
0
]
z88
=
{
z87
[
16
:
1
],
z86
[
16
:
1
]};
assign
z11
=
z84
;
wire
z89
,
z90
;
wire
[
31
:
0
]
z91
;
firfilter
#
(
ORDER
,
17
,
16
,
18
,
4
,
10
,`Z2
,
NCX
)
pfir
(
z61
,
z44
,
z33
,
z34
,
swrbus
,
z89
,
z85
,{
z87
,
z86
},
z90
,
z91
,
z58
);
assign
z12
=
z89
;
wire
signed
[
24
:
0
]
z116
,
z117
,
z118
;
wire
z119
,
z120
;
wire
z121
=
z57
&&
!
z60
;
wire
z122
=
z57
&&
z59
;
assign
z116
=
$signed
(
z91
[
27
:
3
]);
roundN2Mc
#
(
25
,
16
,
1
)
cvto
(
z116
,
z117
,
z121
,
z4
,
z61
,
z119
);
roundN2Mc
#
(
25
,
8
,
1
)
cvtob
(
z117
,
z118
,
z122
,
z4
,
z61
,
z120
);
reg
[
6
:
0
]
z123
;
reg
z124
,
z125
,
z126
;
always
@(
posedge
z61
)
begin
if
(
z44
)
z123
<=
0
;
else
if
(
z90
)
z123
<=
z123
+
1
;
if
(
z44
)
z124
<=
0
;
else
z124
<=
!
z48
||
z123
[
6
]
||
z124
;
z125
<=
z90
&&
z124
;
z126
<=
z125
;
end
`ifdef BLNK_DEBUG
wire
z127
=
z99
;
wire
[
31
:
0
]
z128
=
{
z115
[
30
:
15
],
z114
[
30
:
15
]};
`else
wire
z127
=
z15
;
wire
[
31
:
0
]
z128
=
z72
;
`endif
reg
[
7
:
0
]
z129
;
reg
[
9
:
0
]
z130
;
wire
z131
=
z127
&&
(
z130
==
0
);
wire
z132
=
(
z129
==
z8
[
27
:
20
]);
always
@(
posedge
z61
)
begin
if
(
z44
)
z130
<=
0
;
else
if
(
z131
)
z130
<=
z38
;
else
if
(
z127
)
z130
<=
z130
-
1
;
if
(!
z63
)
z19
<=
z3
;
else
z19
<=
(
z129
>
z42
[
27
:
20
]);
if
(
z132
)
z129
<=
1
;
else
z129
<=
z129
+
1
;
end
reg
z133
;
reg
[
3
:
0
]
z134
;
reg
[
31
:
0
]
z135
;
always
@(
posedge
z61
)
begin
z135
<=
z49
?
{
8'b0
,
z118
[
23
:
8
]}
:
z128
;
z133
<=
z49
?
z126
:
z131
;
z134
<=
z49
?
{
z3
,
z53
[
2
:
0
]}
:
z53
;
end
`ifdef TFDD_RTEST
fifoNxMfmti
#
(
OBW
,
32
)
fout
(
ioclk
,
z44
,
4'h8
,
ostat
,
oena
,
obus
,
z5
,
z44
,
4'h8
,
z13
,
z85
,
z88
);
`else
fifoNxMfmti
#
(
OBW
,
32
)
fout
(
ioclk
,
z44
,
z134
,
ostat
,
oena
,
obus
,
z5
,
z44
,
4'h8
,
z13
,
z133
,
z135
);
`endif
`endif
assign
test
=
{
z85
,
z77
,
z14
,
z9
,
istat
,
z9
,
z13
,
ostat
};
endmodule
