module
emtengine
(
sclk
,
srst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
OBW
=
IBW
;
localparam
DBW
=
32
;
input
sclk
;
input
srst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
assign
sack
=
z2
;
wire
[
DBW
-
1
:
0
]
z3
;
wire
[
DBW
-
1
:
0
]
z4
;
reg
z5
,
z6
,
z7
;
reg
[
31
:
0
]
z8
;
reg
[
11
:
0
]
z9
;
reg
[
3
:
0
]
z10
;
wire
z11
,
z12
,
z13
;
statusblk
#
(
"EMT"
,
0
)
ss
(
sclk
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
);
wire
[
7
:
0
]
z14
;
swrbank
#
(
0
,
8
)
swb
(
sclk
,
scs
,
swr
,
saddr
,
z14
);
wire
z15
=
z14
[
0
];
wire
z16
=
z14
[
1
];
wire
z17
=
z14
[
3
];
always
@(
posedge
sclk
)
begin
if
(
z15
)
z8
<=
swrbus
;
if
(
z16
)
z9
<=
swrbus
;
if
(
z17
)
z10
<=
swrbus
[
19
:
16
];
end
wire
z18
=
!
z8
[
0
];
wire
[
3
:
0
]
z19
=
z8
[
11
:
8
];
wire
[
3
:
0
]
z20
=
z8
[
15
:
12
];
always
@(
posedge
ioclk
)
z5
<=
iena
;
always
@(
posedge
sclk
)
z6
<=
z11
&&
z12
;
always
@(
posedge
sclk
)
z7
<=
z6
;
fifoNxMfmt
#
(
IBW
,
DBW
)
fi
(
ioclk
,
z18
,
z19
,
istat
,
z5
,
ibus
,
sclk
,
z18
,
4'h8
,
z11
,
z6
,
z3
);
emtfilter
emt
(
sclk
,
z18
,
z9
,
z10
,
z7
,{
z3
[
31
:
24
],
z3
[
15
:
8
]},
z13
,
z4
[
15
:
8
]);
fifoNxMfmti
#
(
IBW
,
DBW
)
fo
(
ioclk
,
z18
,
z20
,
ostat
,
oena
,
obus
,
sclk
,
z18
,
4'h8
,
z12
,
z13
,
z4
);
assign
test
=
0
;
endmodule
module
emtfilter
(
clk
,
rst
,
z9
,
z10
,
vin
,
din
,
vout
,
dout
);
input
clk
,
rst
;
input
[
11
:
0
]
z9
;
input
[
3
:
0
]
z10
;
input
vin
;
input
[
15
:
0
]
din
;
output
vout
;
output
[
7
:
0
]
dout
;
wire
z1
=
0
,
z2
=
1
;
reg
z21
,
z22
,
z23
,
z24
,
z25
,
z26
;
reg
[
11
:
0
]
z27
;
reg
[
7
:
0
]
z28
,
z29
,
z30
,
z31
;
reg
[
15
:
0
]
z32
;
wire
[
15
:
0
]
z33
=
{
z31
,
8'd0
};
wire
[
7
:
0
]
z34
=
din
[
7
:
0
];
wire
[
7
:
0
]
z35
=
din
[
15
:
8
];
reg
signed
[
23
:
0
]
z36
,
z37
;
wire
z38
=
(
z27
==
z9
);
wire
z39
=
(
z27
==
0
);
wire
z40
=
z22
&&
(
z39
||
(
z30
>
z31
));
wire
[
3
:
0
]
z41
=
{
z10
[
3
:
1
],
z1
};
always
@(
posedge
clk
)
begin
if
(
rst
|(
z38
&
z22
))
z27
<=
0
;
else
if
(
z22
)
z27
<=
z27
+
1
;
z21
<=
vin
;
z22
<=
z21
;
z23
<=
z22
&&
z38
;
z24
<=
z23
;
z25
<=
z24
;
z26
<=
z25
;
z28
<=
z34
[
7
]?
~
z34
:
z34
;
z29
<=
z35
[
7
]?
~
z35
:
z35
;
z30
<=
(
z28
>
z29
)?
z28
:
z29
;
if
(
z40
)
z31
<=
z30
;
if
(
z23
)
z36
<=
z33
-
z32
;
if
(
z24
)
z37
<=
z36
>>>
z41
;
if
(
z25
)
z32
<=
z32
+
z37
;
end
assign
vout
=
z26
;
assign
dout
=
z32
[
15
:
8
];
endmodule
