`include "mdefs.h"
module
ddsengine
(
sclk
,
srst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
OBW
=
IBW
;
localparam
SBW
=
32
;
localparam
DBW
=
32
;
localparam
CBW
=
16
;
input
sclk
;
input
srst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
assign
sack
=
1
;
statusblk
#
(
"DDS"
)
rs
(
sclk
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
);
wire
[
11
:
0
]
z1
;
swrbank
#
(
0
,
12
)
swb
(
sclk
,
scs
,
swr
,
saddr
,
z1
);
wire
z2
=
z1
[
0
];
wire
z3
=
z1
[
6
];
wire
z4
=
z1
[
8
];
reg
[
31
:
0
]
z5
;
always
@(
posedge
sclk
)
begin
if
(
z2
)
z5
<=
swrbus
;
end
wire
z6
=
srst
||
!
z5
[
0
];
wire
[
3
:
0
]
z7
=
z5
[
11
:
8
];
wire
[
3
:
0
]
z8
=
z5
[
15
:
12
];
reg
z9
,
z10
,
z11
;
wire
z12
,
z13
,
z14
;
wire
[
DBW
-
1
:
0
]
z15
,
z16
;
always
@(
posedge
ioclk
)
z9
<=
iena
;
always
@(
posedge
sclk
)
z10
<=
z12
&&
z13
;
always
@(
posedge
sclk
)
z11
<=
z10
;
fifoNxMfmt
#
(
IBW
,
DBW
)
fi
(
ioclk
,
z6
,
z7
,
istat
,
z9
,
ibus
,
sclk
,
z6
,
4'h8
,
z12
,
z10
,
z15
);
cxtuner
#
(
DBW
/
2
,
CBW
,
DBW
/
2
)
cxt
(
sclk
,
z6
,
z3
,
z4
,
swrbus
,
z11
,
z15
,
z14
,
z16
);
fifoNxMfmti
#
(
IBW
,
DBW
)
fo
(
ioclk
,
z6
,
z8
,
ostat
,
oena
,
obus
,
sclk
,
z6
,
4'h8
,
z13
,
z14
,
z16
);
assign
test
=
{
oena
,
ostat
,
iena
,
istat
,
z5
[
3
:
0
]};
endmodule
module
cxtuner
(
clk
,
rst
,
wfreq
,
wphase
,
sbus
,
vinc
,
din
,
vout
,
dout
);
parameter
IBW
=
16
;
parameter
CBW
=
16
;
parameter
OBW
=
16
;
parameter
NIC
=
1
;
parameter
NPC
=
1
;
parameter
GBW
=
0
;
localparam
RBW
=
6
;
localparam
PBW
=
IBW
+
CBW
;
localparam
UBW
=
PBW
-
OBW
-
1
;
localparam
ARBW
=(
UBW
>
RBW
)?
RBW
:
UBW
;
input
clk
,
rst
;
input
[
NPC
-
1
:
0
]
wfreq
,
wphase
;
input
[
31
:
0
]
sbus
;
input
[
1
:
0
]
vinc
;
input
[
NPC
*
2
*
IBW
-
1
:
0
]
din
;
output
vout
;
output
[
NPC
*
2
*
OBW
-
1
:
0
]
dout
;
wire
z17
=
0
,
z18
=
1
;
wire
z19
=
vinc
[
0
];
wire
z20
=
vinc
[
1
];
wire
z21
=
(
NPC
>
1
&&
!
z20
);
delaypipe
#
(
4
)
ogos
(
clk
,
z19
,
vout
);
wire
z22
;
ff
#
(
1
)
dr
(
z22
,
rst
||
(
z21
&&
wphase
[
NPC
-
1
]),
clk
);
genvar
n
;
generate
for
(
n
=
0
;
n
<
NPC
;
n
=
n
+
1
)
begin
:
chx
wire
signed
[
CBW
-
1
:
0
]
z23
,
z24
;
dds
#
(
CBW
,
NIC
)
fdds
(
clk
,
z22
,
wfreq
[
n
],
wphase
[
n
],
sbus
,
vinc
,
z24
,
z23
);
reg
signed
[
IBW
-
1
:
0
]
z25
,
z26
;
reg
signed
[
PBW
-
1
:
0
]
z27
,
z28
,
z29
,
z30
,
z31
,
z32
;
always
@(
posedge
clk
)
begin
z25
<=
din
[(
1
+
n
*
2
)*
IBW
-
1
:(
0
+
n
*
2
)*
IBW
];
z26
<=
din
[(
2
+
n
*
2
)*
IBW
-
1
:(
1
+
n
*
2
)*
IBW
];
z27
<=
(
z25
*
z23
);
z28
<=
(
z25
*
z24
);
z29
<=
(
z26
*
z23
);
z30
<=
(
z26
*
z24
);
z31
<=
(
z27
-
z30
);
z32
<=
(
z28
+
z29
);
end
roundN2M
#
(
OBW
+
ARBW
,
OBW
)
rndr
(
z31
[
PBW
-
2
+
GBW
:
PBW
-
OBW
-
1
-
ARBW
+
GBW
],
dout
[(
1
+
n
*
2
)*
OBW
-
1
:(
0
+
n
*
2
)*
OBW
],
clk
);
roundN2M
#
(
OBW
+
ARBW
,
OBW
)
rndi
(
z32
[
PBW
-
2
+
GBW
:
PBW
-
OBW
-
1
-
ARBW
+
GBW
],
dout
[(
2
+
n
*
2
)*
OBW
-
1
:(
1
+
n
*
2
)*
OBW
],
clk
);
end
endgenerate
endmodule
module
dds
(
clk
,
sclr
,
wef
,
wep
,
data
,
cec
,
sine
,
cosine
);
parameter
CW
=
16
;
parameter
NIC
=
1
;
parameter
LRS
=
1
;
`ifdef DDS_HIRES
parameter
LW
=
20
;
`else
parameter
LW
=
14
;
`endif
localparam
LLW
=
14
;
localparam
DW
=
32
;
localparam
RW
=
DW
-
LW
;
localparam
LRSW
=
26
;
localparam
PIPE
=
(
LW
>
LLW
)?
5
:
4
;
input
clk
,
sclr
,
wef
,
wep
;
input
[
DW
-
1
:
0
]
data
;
input
[
1
:
0
]
cec
;
output
signed
[
CW
-
1
:
0
]
sine
,
cosine
;
wire
z33
=
cec
[
0
];
wire
z20
=
(
NIC
>
1
)
&&
cec
[
1
];
reg
signed
[
CW
-
1
:
0
]
z34
,
z35
;
reg
[
DW
-
1
:
0
]
z36
,
z37
,
z38
;
reg
[
DW
-
1
:
0
]
z39
,
z40
;
reg
[
DW
-
1
:
0
]
z41
;
wire
z42
=
wef
;
wire
z43
=
wep
;
reg
[
LRSW
-
1
:
0
]
z44
;
reg
[
2
:
0
]
z45
;
reg
[
1
:
0
]
z46
,
z47
,
z48
;
reg
z49
,
z50
,
z51
,
z52
;
wire
z53
=
z52
&&
(
NIC
==
1
||
!
z51
);
wire
z54
=
z52
&&
(
NIC
>
1
&&
z51
);
wire
[
DW
-
1
:
0
]
z55
=
(
NIC
>
1
&&
z51
)?
z39
:
z36
;
always
@(
posedge
clk
)
begin
z49
<=
sclr
;
z50
<=
sclr
&&
(
z43
||
z42
||
!
z49
);
z52
<=
(
z33
&&
!
sclr
)
||
(
z45
!=
0
&&
!
z50
);
if
(
z43
)
z41
<=
data
;
if
(
z42
)
z37
<=
data
;
if
(
z42
)
z40
<=
z37
;
if
(
z50
)
z45
<=
PIPE
;
else
if
(
z45
!=
0
)
z45
<=
z45
-
1
;
if
(
z50
)
z36
<=
0
;
else
if
(
z53
)
z36
<=
z36
+
z37
;
if
(
z50
)
z39
<=
0
;
else
if
(
z54
)
z39
<=
z39
+
z40
;
if
(
z50
)
z44
<=
1
;
else
if
(
z52
)
z44
<=
{
z44
[
24
:
0
],
z44
[
0
]^
z44
[
1
]^
z44
[
5
]^
z44
[
25
]};
if
(
z50
)
z51
<=
0
;
else
if
(
z52
)
z51
<=
z20
^
z51
;
if
(
z52
)
z38
<=
z55
+
{
z41
[
DW
-
1
:
RW
],
LRS
?
z44
[
LRSW
-
1
:
LRSW
-
RW
]
:
z41
[
RW
-
1
:
0
]};
if
(
z52
)
z46
<=
z38
[
DW
-
1
:
DW
-
2
];
if
(
z52
)
z47
<=
z46
;
if
(
z52
)
z48
<=
z47
;
end
wire
[
LLW
-
3
:
0
]
z56
=
z38
[
DW
-
3
:
DW
-
LLW
];
wire
[
LLW
-
3
:
0
]
z57
=
~
z56
;
wire
signed
[
CW
-
1
:
0
]
z58
,
z59
;
sinlut
#
(
LLW
-
2
,
CW
)
slt
(
clk
,
z52
,
z56
,
z58
,
z57
,
z59
);
wire
signed
[
CW
-
1
:
0
]
z60
,
z61
;
generate
if
(
LW
>
LLW
)
begin
assign
z60
=
z58
;
assign
z61
=
z59
;
end
if
(
LW
<=
LLW
)
begin
assign
z60
=
z58
;
assign
z61
=
z59
;
end
endgenerate
wire
[
1
:
0
]
z62
=
(
PIPE
==
5
)?
z48
:
(
PIPE
==
4
)?
z47
:
z46
;
always
@(
posedge
clk
)
begin
if
(
z52
)
case
(
z62
)
0
:
z34
<=
z60
;
1
:
z34
<=
z61
;
2
:
z34
<=
-
z60
;
3
:
z34
<=
-
z61
;
endcase
if
(
z52
)
case
(
z62
)
0
:
z35
<=
z61
;
1
:
z35
<=
-
z60
;
2
:
z35
<=
-
z61
;
3
:
z35
<=
z60
;
endcase
end
endmodule
module
sinlut
(
clk
,
z33
,
addra
,
sinea
,
addrb
,
sineb
);
parameter
AW
=
12
;
parameter
CW
=
16
;
parameter
RW
=
(
2
**
AW
);
input
clk
,
z33
;
input
[
AW
-
1
:
0
]
addra
,
addrb
;
output
[
CW
-
1
:
0
]
sinea
,
sineb
;
`ifdef verilator
reg
[
CW
-
1
:
0
]
z58
,
z59
;
wire
[
CW
-
1
:
0
]
z63
[
RW
-
1
:
0
];
`include "../lib/sinlut.hv"
always
@(
posedge
clk
)
begin
if
(
z33
)
z58
<=
z63
[
addra
];
if
(
z33
)
z59
<=
z63
[
addrb
];
end
`else
wire
[
CW
-
1
:
0
]
z58
,
z59
;
dpram_4096x16x16
sinlut
(
clk
,
z33
,
addra
,
1'b0
,
16'b0
,
z58
,
clk
,
z33
,
addrb
,
1'b0
,
16'b0
,
z59
);
`endif
reg
[
CW
-
1
:
0
]
z64
,
z65
;
always
@(
posedge
clk
)
begin
if
(
z33
)
z64
<=
z58
;
if
(
z33
)
z65
<=
z59
;
end
endmodule
module
sinlutx
(
clk
,
z33
,
addra
,
z64
,
addrb
,
z65
);
parameter
AW
=
20
;
parameter
CW
=
16
;
parameter
LW
=
10
;
parameter
DW
=
AW
-
LW
;
parameter
RW
=
(
2
**
LW
);
parameter
EW
=
CW
+
DW
;
input
clk
,
z33
;
input
[
AW
-
1
:
0
]
addra
,
addrb
;
output
[
CW
-
1
:
0
]
z64
,
z65
;
wire
[
LW
-
1
:
0
]
z66
=
addra
[
AW
-
1
:
DW
];
wire
[
LW
-
1
:
0
]
z67
=
addrb
[
AW
-
1
:
DW
];
`ifdef verilator
reg
[
CW
-
1
:
0
]
z60
,
z61
;
reg
[
CW
-
1
:
0
]
z68
,
z69
;
wire
[
CW
-
1
:
0
]
z70
[
RW
-
1
:
0
];
`include "../lib/sinlutx.hv"
wire
[
CW
-
1
:
0
]
z71
[
RW
-
1
:
0
];
`include "../lib/sinluty.hv"
always
@(
posedge
clk
)
begin
if
(
z33
)
z60
<=
z70
[
z66
];
if
(
z33
)
z61
<=
z70
[
z67
];
if
(
z33
)
z68
<=
z71
[
z66
];
if
(
z33
)
z69
<=
z71
[
z67
];
end
`else
wire
[
CW
-
1
:
0
]
z60
,
z61
;
dpram
#
(
1
,
16
,
16
)
sinlutx
(
clk
,
z33
,
z66
,
1'b0
,
16'b0
,
z60
,
clk
,
z33
,
z67
,
1'b0
,
16'b0
,
z61
);
`include "../lib/sinlutx.hx"
wire
[
CW
-
1
:
0
]
z68
,
z69
;
dpram
#
(
1
,
16
,
16
)
sinluty
(
clk
,
z33
,
z66
,
1'b0
,
16'b0
,
z68
,
clk
,
z33
,
z67
,
1'b0
,
16'b0
,
z69
);
`include "../lib/sinluty.hx"
`endif
reg
[
CW
-
1
:
0
]
z72
,
z73
;
reg
[
CW
-
1
:
0
]
z74
,
z75
;
reg
[
DW
-
1
:
0
]
z76
,
z77
;
wire
[
EW
-
1
:
0
]
z78
=
z68
*
z76
;
wire
[
EW
-
1
:
0
]
z79
=
z69
*
z77
;
always
@(
posedge
clk
)
begin
if
(
z33
)
z76
<=
addra
[
DW
-
1
:
0
];
if
(
z33
)
z77
<=
addrb
[
DW
-
1
:
0
];
if
(
z33
)
z74
<=
z78
[
EW
-
1
:
EW
-
CW
];
if
(
z33
)
z75
<=
z79
[
EW
-
1
:
EW
-
CW
];
if
(
z33
)
z72
<=
z60
;
if
(
z33
)
z73
<=
z61
;
end
assign
z64
=
z72
+
z74
;
assign
z65
=
z73
+
z75
;
endmodule
