`ifdef verilator
`include "../lib/coretypes.h"
`else
`endif
`include "../lib/ramdefs.h"
module
component
();
endmodule
module
setLine
#
(
parameter
TOP
=
0
,
parameter
PIPE
=
0
,
parameter
PIPEB
=
0
,
parameter
IFUNC
=
0
)
(
/* verilator lint_off UNOPTFLAT */
output
Line
ln
,
input
func
,
input
istat
,
input
jstat
);
/* verilator lint_on UNOPTFLAT */
assign
ln.istat
=
istat
;
assign
ln.jstat
=
jstat
;
assign
ln.cpp
=
0
;
endmodule
module
setLinx
#
(
parameter
TOP
=
0
,
parameter
PIPE
=
0
,
parameter
PIPEB
=
0
,
parameter
IFUNC
=
0
)
(
/* verilator lint_off UNOPTFLAT */
output Line ln,input func, input istat, input jstat,/* verilator lint_on UNOPTFLAT */
input
[
3
:
0
]
cpp
);
assign
ln.istat
=
istat
;
assign
ln.jstat
=
jstat
;
assign
ln.cpp
=
cpp
;
endmodule
module
doSeq
#
(
parameter
FUNC
=
0
,
parameter
TOP
=
0
,
parameter
PIPE
=
0
,
parameter
PIPEB
=
0
)
(
input clk, input rst,/* verilator lint_off UNOPTFLAT */
input ien, output oen, output xen,input istat, input jstat,/* verilator lint_on UNOPTFLAT */
input
[
3
:
0
]
cpp
);
localparam
DP
=
(
PIPE
==
0
)?
0
:
PIPE
-
1
;
localparam
START
=
11
,
CONTINUE
=
12
,
BREAK
=
13
,
RETURN
=
14
,
END
=
15
,
SETVAR
=
21
,
SETVARI
=
22
,
SETACC
=
23
,
PRINT
=
24
,
IF
=
31
,
ENDIF
=
32
,
IFELSE
=
33
,
ELSEIF
=
34
,
ENDIFE
=
35
,
WHILE
=
41
,
ENDWHILE
=
42
,
DOWHILE
=
43
,
ENDDOWHILE
=
44
,
FOR
=
45
,
ENDFOR
=
46
,
FORI
=
47
,
ENDFORI
=
48
,
DMA_B2B
=
51
,
DMA_B2R
=
52
,
DMA_R2B
=
53
,
DMA_R2R
=
54
,
DMA_SYNC
=
55
,
DMA_B2S
=
56
,
DMA_S2B
=
57
,
GENFOR
=
61
,
GENFORP
=
62
,
NONE
=
0
,
OTHER
=
99
;
wire
z1
=
1
,
z2
=
0
;
generate
if
(
FUNC
==
NONE
)
begin
:
None
assign
oen
=
z2
;
assign
xen
=
z2
;
end
else
if
(
FUNC
==
START
)
begin
:
Start
assign
oen
=
istat
;
assign
xen
=
jstat
;
end
else
if
(
FUNC
==
CONTINUE
||
FUNC
==
BREAK
)
begin
:
exitFlow
ffr
#
(
1
,
PIPE
)
fx
(
xen
,
ien
,
clk
,
rst
);
assign
oen
=
0
;
end
else
if
(
FUNC
==
RETURN
)
begin
:
retFlow
ffr
#
(
1
,
PIPE
)
fx
(
xen
,
ien
,
clk
,
rst
);
assign
oen
=
0
;
end
else
if
(
FUNC
==
SETVAR
)
begin
:
setVar
ffr
#
(
1
,
PIPE
)
fo
(
oen
,
ien
,
clk
,
rst
);
ffr
#
(
1
,
PIPEB
)
fx
(
xen
,
oen
,
clk
,
rst
);
end
else
if
(
FUNC
==
SETVARI
)
begin
:
setVarI
ffr
#
(
1
,
PIPE
)
fo
(
oen
,
ien
,
clk
,
rst
);
ffr
#
(
1
,
PIPEB
)
fx
(
xen
,
oen
|
rst
,
clk
,
z2
);
end
else
if
(
FUNC
==
SETACC
)
begin
:
setAcc
assign
oen
=
istat
;
ffr
#
(
1
,
PIPE
)
fx
(
xen
,
ien
,
clk
,
rst
);
end
else
if
(
FUNC
==
PRINT
)
begin
:
print
ffr
#
(
1
,
PIPE
)
fo
(
oen
,
ien
,
clk
,
rst
);
assign
xen
=
oen
&
istat
;
end
else
if
(
FUNC
==
IF
||
FUNC
==
IFELSE
)
begin
:
If
wire
z3
;
ffr
#
(
1
,
PIPE
)
fd
(
z3
,
ien
,
clk
,
rst
);
assign
oen
=
z3
&&
istat
;
assign
xen
=
z3
&&
!
istat
;
end
else
if
(
FUNC
==
ENDIF
)
begin
:
endIf
wire
z3
;
ffr
#
(
1
,
PIPE
)
fd
(
z3
,
ien
,
clk
,
rst
);
wire
z4
;
ffr
#
(
1
,
PIPEB
)
fi
(
z4
,
istat
,
clk
,
rst
);
wire
z5
;
ffr
#
(
1
,
PIPEB
)
fj
(
z5
,
jstat
,
clk
,
rst
);
assign
oen
=
z3
||
z5
||
z4
;
assign
xen
=
0
;
end
else
if
(
FUNC
==
ELSEIF
)
begin
:
ElseIf
assign
oen
=
(
jstat
&&
istat
);
assign
xen
=
(
jstat
&&
!
istat
);
end
else
if
(
FUNC
==
ENDIFE
)
begin
:
endIfE
wire
z3
;
ffr
#
(
1
,
PIPE
)
fd
(
z3
,
ien
,
clk
,
rst
);
assign
oen
=
z3
;
assign
xen
=
0
;
end
else
if
(
FUNC
==
WHILE
&&
PIPEB
>
1
)
begin
:
WhileN
wire
z3
;
ffr
#
(
1
,
DP
)
fd
(
z3
,
ien
,
clk
,
rst
);
wire
z6
;
ffr
#
(
1
,
1
)
fl
(
z6
,
z3
||
(
z6
&&
istat
),
clk
,
rst
);
wire
[
3
:
0
]
z7
=
cpp
-
1
;
reg
[
3
:
0
]
z8
;
always
@(
posedge
clk
)
if
(
z8
==
0
)
z8
<=
z7
;
else
z8
<=
z8
-
1
;
reg
z9
;
always
@(
posedge
clk
)
z9
<=
(
z8
==
0
);
assign
oen
=
z6
&&
istat
&&
z9
;
assign
xen
=
z6
&&
!
istat
;
end
else
if
(
FUNC
==
WHILE
)
begin
:
While
wire
z3
;
ffr
#
(
1
,
DP
)
fd
(
z3
,
ien
,
clk
,
rst
);
wire
z6
;
ffr
#
(
1
,
1
)
fl
(
z6
,
z3
||
(
PIPEB
?
z6
&&
istat
:
jstat
),
clk
,
rst
);
assign
oen
=
z6
&&
istat
;
assign
xen
=
z6
&&
!
istat
;
end
else
if
(
FUNC
==
ENDWHILE
)
begin
:
endWhile
ffr
#
(
1
,
DP
)
fd
(
xen
,
ien
,
clk
,
rst
);
ffr
#
(
1
,
PIPE
)
fo
(
oen
,
istat
,
clk
,
rst
);
end
else
if
(
FUNC
==
DOWHILE
)
begin
:
DoWhile
wire
z3
;
ffr
#
(
1
,
PIPE
)
fd
(
z3
,
ien
,
clk
,
rst
);
assign
oen
=
z3
||
istat
;
assign
xen
=
0
;
end
else
if
(
FUNC
==
ENDDOWHILE
)
begin
:
endDoWhile
wire
z3
;
ffr
#
(
1
,
PIPE
)
fd
(
z3
,
ien
,
clk
,
rst
);
ffr
#
(
1
,
1
)
fo
(
oen
,
z3
&&
!
istat
,
clk
,
rst
);
ffr
#
(
1
,
1
)
fx
(
xen
,
z3
&&
istat
,
clk
,
rst
);
end
else
if
(
FUNC
==
FOR
||
FUNC
==
GENFORP
)
begin
:
For
wire
z3
;
ffr
#
(
1
,
PIPE
)
fd
(
z3
,
ien
,
clk
,
rst
);
wire
z6
;
ffr
#
(
1
,
1
)
fo
(
z6
,(
z3
|
z6
)&
istat
,
clk
,
rst
);
assign
oen
=
(
z3
||
z6
);
assign
xen
=
(
z3
||
z6
)
&&
!
istat
;
end
else
if
(
FUNC
==
GENFOR
)
begin
:
GenFor
ffr
#
(
1
,
PIPE
)
fo
(
oen
,
ien
,
clk
,
rst
);
assign
xen
=
0
;
end
else
if
(
FUNC
==
FORI
)
begin
:
ForI
wire
z3
;
ffr
#
(
1
,
PIPE
)
fd
(
z3
,
ien
,
clk
,
rst
);
wire
z6
;
ffr
#
(
1
,
1
)
fo
(
z6
,(
z3
|
z6
)&
jstat
,
clk
,
rst
);
assign
oen
=
(
z3
||
z6
)
&&
istat
;
assign
xen
=
(
z3
||
z6
)
&&
!
istat
;
end
else
if
(
FUNC
==
ENDFOR
||
FUNC
==
ENDFORI
)
begin
:
endFor
wire
z3
;
ffr
#
(
1
,
1
)
fd
(
z3
,
ien
,
clk
,
rst
);
assign
oen
=
z3
&&
!
ien
;
assign
xen
=
0
;
end
else
if
(
FUNC
==
DMA_B2R
||
FUNC
==
DMA_B2B
||
FUNC
==
DMA_R2R
||
FUNC
==
DMA_R2B
||
FUNC
==
DMA_B2S
||
FUNC
==
DMA_S2B
)
begin
:
dmaStart
ffr
#
(
1
,
PIPE
)
fo
(
oen
,
ien
,
clk
,
rst
);
wire
z6
;
ffr
#
(
1
,
1
)
fl
(
z6
,
oen
,
clk
,
rst
);
wire
z10
;
ffr
#
(
1
,
1
)
fa
(
z10
,
oen
||
z6
||(
z10
&&
istat
),
clk
,
rst
);
assign
xen
=
oen
||
z10
;
end
else
if
(
FUNC
==
DMA_SYNC
)
begin
:
dmaSync
wire
z3
;
ffr
#
(
1
,
PIPE
)
fd
(
z3
,
ien
,
clk
,
rst
);
wire
z11
;
ffr
#
(
1
,
1
)
fdd
(
z11
,
z3
||(
z11
&&
istat
),
clk
,
rst
);
assign
oen
=
z11
&&
!
istat
;
assign
xen
=
0
;
end
else
begin
:
other
ffr
#
(
1
,
PIPE
)
fo
(
oen
,
ien
,
clk
,
rst
);
ffr
#
(
1
,
PIPEB
)
fx
(
xen
,
oen
|
rst
,
clk
,
z2
);
end
endgenerate
endmodule
module
sequencer
#
(
parameter
N
=
1
,
parameter
int
ARGS
[
N
*
4
])
(
input clk, input rst,/* verilator lint_off UNOPTFLAT */
input
Line
ln
[
N
],
output
en
[
N
],
output
xn
[
N
]);
/* verilator lint_on UNOPTFLAT */
genvar
i
;
generate
for
(
i
=
0
;
i
<
N
;
i
=
i
+
1
)
begin
localparam
FUNC
=
ARGS
[
i
*
4
+
0
],
TOP
=
ARGS
[
i
*
4
+
1
],
PIPE
=
ARGS
[
i
*
4
+
2
],
PIPEB
=
ARGS
[
i
*
4
+
3
];
doSeq
#
(
FUNC
,
TOP
,
PIPE
,
PIPEB
)
inst
(
clk
,
rst
,
en
[
TOP
],
en
[
i
],
xn
[
i
],
ln
[
i
]
.istat
,
ln
[
i
]
.jstat
,
ln
[
i
]
.cpp
);
end
endgenerate
endmodule
module
setter
#
(
parameter
N
=
16
,
parameter
ROOT
=
0
)
(
input
clk
,
input
rst
,
input
wr
,
input
[
31
:
0
]
addr
,
input
[
31
:
0
]
data
,
output
[
31
:
0
]
sub
,
output
[
15
:
0
]
ind
,
output
[
N
-
1
:
0
]
set
,
output
[
63
:
0
]
val
);
localparam
W
=(
N
<=
4
)?
2
:(
N
<=
8
)?
3
:(
N
<=
16
)?
4
:(
N
<=
32
)?
5
:
6
;
wire
[
7
:
0
]
z12
,
z13
;
reg
[
W
-
1
:
0
]
z14
;
reg
[
4
:
0
]
z15
;
wire
z16
;
wire
[
31
:
0
]
z17
;
reg
z18
,
z19
;
generate
if
(
ROOT
==
1
)
begin
reg
[
7
:
0
]
z20
,
z21
;
reg
[
15
:
0
]
z22
;
reg
[
1
:
0
]
z23
;
reg
[
31
:
0
]
z24
;
wire
z25
=
wr
&&
(
addr
[
1
:
0
]==
1
);
wire
z26
=
wr
&&
(
addr
[
1
:
0
]==
2
);
wire
z27
=
wr
&&
(
addr
[
1
:
0
]==
3
);
wire
z28
=
wr
&&
(
addr
[
1
:
0
]!=
3
);
always
@(
posedge
clk
)
begin
z18
<=
(
z23
!=
0
)?
z16
:
z15
[
1
];
z19
<=
(
z23
!=
0
)
&&
(
z15
[
3
:
0
]!=
0
);
if
(
wr
)
z24
<=
data
;
else
if
(
z19
)
z24
<=
z24
>>
8
;
if
(
rst
)
z20
<=
0
;
else
if
(
z25
)
z20
<=
addr
[
15
:
10
];
if
(
z26
)
z22
<=
0
;
else
if
(
z25
)
z22
<=
data
[
15
:
00
];
else
if
(
z18
)
z22
<=
z22
+
1
;
if
(
z26
)
z23
<=
0
;
else
if
(
z25
)
z23
<=
data
[
19
:
18
];
z21
<=
addr
[
7
:
0
];
z15
<=
{
z15
,
wr
&&
addr
[
1
]};
end
assign
z16
=
(
z23
==
3
)?
(
z15
[
3
]|
z15
[
2
]|
z15
[
1
]|
z15
[
0
])
:
(
z23
==
1
)?
(
z15
[
2
]|
z15
[
0
])
:
z15
[
0
];
assign
z12
=
z20
;
assign
ind
=
z22
;
assign
z13
=
z21
;
assign
z17
=
z24
;
end
if
(
ROOT
==
0
)
begin
assign
z16
=
wr
;
assign
z12
=
addr
[
31
:
24
];
assign
ind
=
addr
[
23
:
8
];
assign
z13
=
addr
[
7
:
0
];
assign
z17
=
data
;
end
endgenerate
wire
z29
=
z12
[
0
];
reg
[
31
:
0
]
z30
;
reg
z31
;
always
@(
posedge
clk
)
begin
z31
<=
z16
;
if
(
z31
)
z30
<=
data
;
if
(!
z29
)
z14
<=
addr
[
7
:
2
];
end
genvar
i
;
generate
for
(
i
=
0
;
i
<
N
;
i
=
i
+
1
)
begin
:
blk
reg
z32
;
if
(
ROOT
==
1
)
begin
always
@(
posedge
clk
)
if
(!
z16
)
z32
<=
0
;
else
z32
<=
(
z14
==
i
);
assign
set
[
i
]
=
z32
;
end
if
(
ROOT
==
0
)
begin
always
@(
posedge
clk
)
z32
<=
(
z14
==
i
);
assign
set
[
i
]
=
z16
&&
z32
;
end
end
endgenerate
assign
sub
=
{
1'b0
,
z12
[
7
:
1
],
ind
[
15
:
0
],
z13
[
7
:
0
]};
assign
val
=
{
z30
,
z17
};
endmodule
module
flowcontrol
(
input
clk
,
input
rst
,
input
s_opt
,
input
[
15
:
0
]
c_cnt
,
output
c_ok
);
`ifdef verilator
reg
[
25
:
0
]
z33
;
always
@(
posedge
clk
)
if
(
rst
)
z33
<=
1
;
else
z33
<=
{
z33
[
24
:
0
],
z33
[
0
]^
z33
[
1
]^
z33
[
5
]^
z33
[
25
]};
assign
c_ok
=
rst
?
0
:
s_opt
?
z33
[
5
:
0
]!=
0
:
!
c_cnt
[
10
];
`else
assign
c_ok
=
rst
?
0
:
s_opt
?
!
c_cnt
[
9
]
:
!
c_cnt
[
13
];
`endif
endmodule
module
Value
#
(
parameter
FORM
=
"CF"
,
parameter
SIZE
=
1
,
parameter
BW
=(
FORM
==
"CF"
)?
64
:
32
,
parameter
AW
=(
SIZE
>
1
)?
4
:
1
)
(
input
clk
,
input
rst
,
input
wen
,
input
[
AW
-
1
:
0
]
wadr
,
input
[
BW
-
1
:
0
]
wbus
,
input
ren
,
input
[
AW
-
1
:
0
]
radr
,
output
[
BW
-
1
:
0
]
rbus
);
localparam
BPE
=
(
FORM
==
"CF"
)?
64
:
32
;
generate
if
(
SIZE
<=
1
||
BW
>
BPE
)
begin
reg
[
BW
-
1
:
0
]
z34
;
always
@(
posedge
clk
)
if
(
wen
)
z34
<=
wbus
;
assign
rbus
=
z34
;
end
if
(
SIZE
>
1
)
begin
cram16xNsd
#
(
BW
)
z34
(
wbus
,
wadr
,
clk
,
wen
,
radr
,
rbus
);
end
endgenerate
endmodule
module
Stream
#
(
parameter
SZ
=
64
,
parameter
IBW
=
64
,
parameter
OBW
=
IBW
,
parameter
IBWP
=
IBW
/
8
,
parameter
OBWP
=
OBW
/
8
)
(
input
clk
,
input
rst
,
input
[
3
:
0
]
swaps
,
output
irdy
,
input
ien
,
input
[
IBWP
-
1
:
0
]
isel
,
input
[
IBW
-
1
:
0
]
ibus
,
output
ordy
,
input
oen
,
output
[
OBWP
-
1
:
0
]
osel
,
output
[
OBW
-
1
:
0
]
obus
);
localparam
NR
=
SZ
/
2048
;
fifoNxM
#
(
IBW
+
IBWP
,
OBW
+
OBWP
,
NR
,
3
,`BPAR
,`BPAR
)
fifo
(
clk
,
rst
,
irdy
,
ien
,{
isel
,
ibus
},
clk
,
rst
,
ordy
,
oen
,{
osel
,
obus
});
endmodule
module
Queue
#
(
parameter
SZ
=
64
,
parameter
BW
=
64
,
parameter
AFULL
=
SZ
-
4
,
parameter
AEMPTY
=
4
)
(
input
clk
,
input
rst
,
output
irdy
,
input
ien
,
input
[
BW
-
1
:
0
]
ibus
,
output
ordy
,
input
oen
,
output
[
BW
-
1
:
0
]
obus
);
localparam
M
=
(
SZ
>=
64
)?
6
:
(
SZ
>=
32
)?
5
:
4
;
wire
z35
,
z36
;
queMxNafae
#
(
M
,
BW
,
AFULL
,
AEMPTY
)
que
(
clk
,
rst
,
ien
,
oen
,
ibus
,
obus
,
z35
,
z36
);
assign
irdy
=
!
z35
;
assign
ordy
=
!
z36
;
endmodule
module
Ram
#
(
parameter
AW
=
12
,
parameter
BWR
=
8
,
parameter
BWW
=
8
)
(
input
clk
,
input
rst
,
input
wen
,
input
[
31
:
0
]
wdma
,
input
[
AW
-
1
:
0
]
wadr
,
input
[
BWW
-
1
:
0
]
wbus
,
input
ren
,
input
[
31
:
0
]
rdma
,
input
[
AW
-
1
:
0
]
radr
,
output
[
BWR
-
1
:
0
]
rbus
,
output
[
7
:
0
]
rbusb
);
localparam
TW
=
AW
;
localparam
NKR
=
1
<<(
TW
-
10
);
localparam
BOR
=(
BWR
>
64
)?
4
:(
BWR
>
32
)?
3
:(
BWR
>
16
)?
2
:(
BWR
>
8
)?
1
:
0
;
localparam
BOW
=(
BWW
>
64
)?
4
:(
BWW
>
32
)?
3
:(
BWW
>
16
)?
2
:(
BWW
>
8
)?
1
:
0
;
localparam
BBR
=(
1
<<
BOR
);
localparam
BBW
=(
1
<<
BOW
);
wire
z1
=
1
,
z2
=
0
;
wire
[
BBW
-
1
:
0
]
z37
=
wen
?
~
0
:
wdma
[
32
-
1
:
32
-
BBW
];
wire
[
TW
-
1
:
0
]
z21
=
{
ren
?
radr
:
rdma
[
AW
-
1
:
0
]};
wire
[
TW
-
1
:
0
]
z38
=
{
wen
?
wadr
:
wdma
[
AW
-
1
:
0
]};
wire
[
BWR
-
1
:
0
]
z39
;
wire
[
BWW
-
1
:
0
]
z40
;
dpram
#
(
NKR
,
BWW
,
BWR
,`BENA
,
0
)
ram
(
clk
,
z1
,
z38
[
TW
-
1
:
BOW
],
z37
,
wbus
,
z40
,
clk
,
z1
,
z21
[
TW
-
1
:
BOR
],
z2
,
z39
,
rbus
);
generate
if
(
BOR
==
0
)
begin
assign
rbusb
=
rbus
;
end
else
begin
reg
[
BOR
-
1
:
0
]
z41
;
always
@(
posedge
clk
)
z41
<=
radr
;
assign
rbusb
=
rbus
>>{
z41
,
3'h0
};
end
endgenerate
endmodule
module
RamRWC
#
(
parameter
AW
=
12
,
parameter
BWR
=
8
,
parameter
BWW
=
8
,
parameter
CW
=
0
)
(
input
clk
,
input
rst
,
input
wen
,
input
[
31
:
0
]
wdma
,
input
[
CW
:
0
]
wchn
,
input
[
AW
-
1
:
0
]
wadr
,
input
[
BWW
-
1
:
0
]
wbus
,
input
ren
,
input
[
31
:
0
]
rdma
,
input
[
CW
:
0
]
rchn
,
input
[
AW
-
1
:
0
]
radr
,
output
[
BWR
-
1
:
0
]
rbus
,
output
[
7
:
0
]
rbusb
);
localparam
TW
=
CW
+
AW
;
localparam
NKR
=
1
<<(
TW
-
10
);
localparam
BOR
=(
BWR
>
64
)?
4
:(
BWR
>
32
)?
3
:(
BWR
>
16
)?
2
:(
BWR
>
8
)?
1
:
0
;
localparam
BOW
=(
BWW
>
64
)?
4
:(
BWW
>
32
)?
3
:(
BWW
>
16
)?
2
:(
BWW
>
8
)?
1
:
0
;
localparam
BBR
=(
1
<<
BOR
);
localparam
BBW
=(
1
<<
BOW
);
wire
z1
=
1
,
z2
=
0
;
wire
[
BBW
-
1
:
0
]
z37
=
wen
?
~
0
:
wdma
[
32
-
1
:
32
-
BBW
];
wire
[
TW
-
1
:
0
]
z21
=
{
rchn
,
ren
?
radr
:
rdma
[
AW
-
1
:
0
]};
wire
[
TW
-
1
:
0
]
z38
=
{
wchn
,
wen
?
wadr
:
wdma
[
AW
-
1
:
0
]};
wire
[
BWR
-
1
:
0
]
z39
;
wire
[
BWW
-
1
:
0
]
z40
;
dpram
#
(
NKR
,
BWW
,
BWR
,`BENA
,
0
)
ram
(
clk
,
z1
,
z38
[
TW
-
1
:
BOW
],
z37
,
wbus
,
z40
,
clk
,
z1
,
z21
[
TW
-
1
:
BOR
],
z2
,
z39
,
rbus
);
generate
if
(
BOR
==
0
)
begin
assign
rbusb
=
rbus
;
end
else
begin
reg
[
BOR
-
1
:
0
]
z41
;
always
@(
posedge
clk
)
z41
<=
radr
;
assign
rbusb
=
rbus
>>{
z41
,
3'h0
};
end
endgenerate
endmodule
module
RomF
#
(
parameter
OM
=
4
,
parameter
RP
=
1
,
parameter
ONP
=
1
)
(
input
clk
,
input
rst
,
input
sset
,
input
[
31
:
0
]
sadr
,
input
[
31
:
0
]
sbus
,
input
ren
,
input
[
OM
-
1
:
0
]
rM
[
RP
],
output
fptx
rbus
[
RP
]);
localparam
M
=(
1
<<
OM
);
localparam
OP
=(
RP
>
64
)?
7
:(
RP
>
32
)?
6
:(
RP
>
16
)?
5
:(
RP
>
8
)?
4
:(
RP
>
4
)?
3
:(
RP
>
2
)?
2
:(
RP
>
1
)?
1
:
0
;
localparam
P
=(
1
<<
OP
);
localparam
BW
=
32
;
localparam
OX
=
OM
-
OP
;
wire
z1
=
1
,
z2
=
0
;
wire
[
OP
-
1
:
0
]
z42
=
sadr
[
OP
+
7
:
0
+
8
];
wire
[
OX
-
1
:
0
]
z43
=
sadr
[
OM
+
7
:
OP
+
8
];
wire
z44
=
sset
&&
(
sadr
[
7
:
2
]==
2
);
genvar
i
;
generate
for
(
i
=
0
;
i
<
P
;
i
=
i
+
1
)
begin
:
srli
wire
[
OM
-
1
:
0
]
z45
=
rM
[
i
];
wire
[
OX
-
1
:
0
]
z46
=
z45
[
OM
-
1
:
OP
];
wire
z47
=
z44
&&
(
z42
==
i
);
cram16xNsd
#
(
32
)
srl
(
sbus
,
z43
,
clk
,
z47
,
z46
,
rbus
[
i
]);
end
endgenerate
endmodule
module
RomF2D
#
(
parameter
ON
=
10
,
parameter
OM
=
4
,
parameter
RW
=
1
,
parameter
ONP
=
1
)
(
input
clk
,
input
rst
,
input
sset
,
input
[
31
:
0
]
sadr
,
input
[
31
:
0
]
sbus
,
input
ren
,
input
[
ON
-
1
:
0
]
rN
,
input
[
OM
-
1
:
0
]
rM
[
RW
],
output
fptx
rbus
[
RW
]);
localparam
N
=(
1
<<
ON
);
localparam
M
=(
1
<<
OM
);
localparam
ONM
=
ON
+
OM
;
localparam
NPER
=
M
/
RW
;
localparam
BW
=
32
;
localparam
NKR
=(
N
*
NPER
*
BW
/
8
)/
1024
;
wire
z1
=
1
,
z2
=
0
;
wire
[
OM
-
1
:
0
]
z42
=
sadr
[
ONM
+
7
:
ON
+
8
];
wire
[
ON
-
1
:
0
]
z43
=
sadr
[
ON
+
7
:
8
];
wire
z44
=
sset
&&
(
sadr
[
7
:
2
]==
2
);
genvar
i
;
generate
for
(
i
=
0
;
i
<
RW
;
i
=
i
+
1
)
begin
:
rami
fptx
z48
;
wire
z49
=
z44
&&
(
z42
==
i
);
dpram
#
(
NKR
,
BW
,
BW
)
ram
(
clk
,
z1
,
z43
,
z49
,
sbus
,
z48
,
clk
,
z1
,
rN
,
z2
,
32'b0
,
rbus
[
i
]);
end
endgenerate
endmodule
module
RomF2Di
#
(
parameter
ON
=
10
,
parameter
OM
=
4
,
parameter
RW
=
1
,
parameter
ONP
=
0
)
(
input
clk
,
input
rst
,
input
sset
,
input
[
31
:
0
]
sadr
,
input
[
31
:
0
]
sbus
,
input
renr
,
input
fptx
rNr
,
input
[
ON
-
1
:
0
]
rN
,
input
[
OM
-
1
:
0
]
rM
[
RW
],
output
fptx
rbus
[
RW
]);
localparam
N
=(
1
<<
ON
);
localparam
M
=(
1
<<
OM
);
localparam
ONM
=
ON
+
OM
;
localparam
NPER
=
M
/
RW
;
localparam
CW
=
21
;
localparam
DW
=
15
;
localparam
CDW
=
CW
+
DW
;
localparam
BW
=
32
;
localparam
NPM
=(
ONP
>
0
)?
1
<<
ONP
:
1
;
localparam
NKR
=(
NPM
*
N
*
NPER
*
BW
/
8
)/
1024
;
localparam
OD
=
16
-
ON
;
localparam
OR
=
(
RW
>
16
)?
5
:
(
RW
>
8
)?
4
:
(
RW
>
4
)?
3
:
(
RW
>
2
)?
2
:
(
RW
>
1
)?
1
:
0
;
wire
z1
=
1
,
z2
=
0
;
wire
z50
=
sset
&&
(
sadr
[
7
:
2
]==
0
);
wire
z51
=
sset
&&
(
sadr
[
7
:
2
]==
1
);
wire
z44
=
sset
&&
(
sadr
[
7
:
2
]==
2
);
reg
z52
;
fptx
z53
,
z54
,
z55
;
assign
z53
=
sbus
;
reg
[
OM
-
1
:
0
]
z42
;
reg
[
ON
-
1
:
0
]
z43
;
always
@(
posedge
clk
)
begin
z52
<=
z44
;
if
(
z52
)
z55
<=
z53
;
if
(
z52
)
{
z42
,
z43
}
<=
sadr
[
ONM
+
7
:
8
];
if
(
z44
)
z54
<=
z53
-
z55
;
end
wire
[
ON
-
1
:
0
]
z56
=
rNr
[
16
-
1
:
16
-
ON
];
reg
signed
[
OD
:
0
]
z57
;
always
@(
posedge
clk
)
if
(
renr
)
z57
<=
{
z2
,
rNr
[
OD
-
1
:
0
]};
wire
[
OM
-
1
:
0
]
z58
=
rM
[
0
];
genvar
i
;
generate
for
(
i
=
0
;
i
<
RW
;
i
=
i
+
1
)
begin
:
rwi
fptx
z59
;
wire
[
OM
-
1
:
0
]
z60
,
z61
,
z62
;
assign
z60
=
(
ONP
>
0
)?
(
z42
-
i
)
:
(
z42
>>
OR
);
assign
z62
=
(
ONP
>
0
)?
rNr
[
ONP
+
16
:
16
]
:
(
z58
>>
OR
);
wire
signed
[
CW
-
1
:
0
]
z48
;
wire
signed
[
DW
-
1
:
0
]
z63
;
reg
z49
;
always
@(
posedge
clk
)
z49
<=
z44
&&
(
(
ONP
>
0
)?
(
z60
<
NPM
)
:
(
z42
[
OR
-
1
:
0
]==
i
)
);
sdpram
#
(
NKR
,
CDW
,
CDW
)
ram
(
clk
,
z1
,{
z60
,
z43
},
z49
,{
z54
[
DW
-
1
:
0
],
z55
[
CW
-
1
:
0
]},
clk
,
z1
,{
z62
,
z56
},{
z63
,
z48
});
muladd
#
(
DW
,
OD
+
1
,
CW
,
BW
,
OD
)
ma
(
clk
,
z1
,
z63
,
z57
,
z48
,
z59
);
assign
rbus
[
i
]
=
z59
;
end
endgenerate
endmodule
module
RomF2Di_NP
#
(
parameter
ON
=
10
,
OM
=
4
,
RW
=
1
,
NP
=
1
,
LA
=
NP
)
(
input
clk
,
input
rst
,
input
sset
,
input
[
31
:
0
]
sadr
,
input
[
31
:
0
]
sbus
,
input
renr
,
input
fptx
rNr
[
NP
],
input
[
ON
-
1
:
0
]
rN
,
input
[
OM
-
1
:
0
]
rM
[
RW
],
output
fptx
rbus
[
NP
][
RW
]);
localparam
OLA
=(
LA
==
0
)?
0
:
(
LA
<=
1
)?
1
:
(
LA
<=
2
)?
2
:
(
LA
<=
4
)?
3
:
(
LA
<=
8
)?
4
:
(
LA
<=
16
)?
5
:
6
;
genvar
n
;
generate
for
(
n
=
0
;
n
<
NP
;
n
=
n
+
1
)
begin
:
nr
RomF2Di
#
(
ON
,
OM
,
RW
,
OLA
)
inst
(
clk
,
rst
,
sset
,
sadr
,
sbus
,
renr
,
rNr
[
n
],
rN
,
rM
,
rbus
[
n
]);
end
endgenerate
endmodule
module
RomF2Di_CX
#
(
parameter
ON
=
10
,
parameter
OM
=
4
,
parameter
RW
=
1
)
(
input
clk
,
input
rst
,
input
sset
,
input
[
31
:
0
]
sadr
,
input
[
31
:
0
]
sbus
,
input
renr
,
input
fptx
rNr
,
input
[
ON
-
1
:
0
]
rN
,
input
[
OM
-
1
:
0
]
rM
[
RW
],
input
cx
,
output
CxFptx
rbus
[
RW
]);
localparam
MC
=
RW
/
2
;
fptx
z63
[
RW
],
z48
[
RW
];
RomF2Di
#
(
ON
,
OM
,
RW
,
0
)
inst
(
clk
,
rst
,
sset
,
sadr
,
sbus
,
renr
,
rNr
,
rN
,
rM
,
z63
);
genvar
i
;
generate
for
(
i
=
0
;
i
<
RW
;
i
=
i
+
1
)
begin
:
irc
reg
z64
;
always
@(
posedge
clk
)
z64
<=
!
cx
;
always
@(
posedge
clk
)
z48
[
i
]
<=
z63
[
i
];
assign
rbus
[
i
]
.x
=
z64
?
z48
[
i
]
:
(
i
<
MC
)?
z48
[
i
]
:
0
;
assign
rbus
[
i
]
.y
=
z64
?
z48
[
i
]
:
(
i
<
MC
)?
z48
[
i
+
MC
]
:
0
;
end
endgenerate
endmodule
module
RamDPN
#
(
parameter
AW
=
12
,
parameter
BWA
=
8
,
parameter
BWB
=
8
)
(
input
clkA
,
input
adrA
,
input
wrA
,
input
[
BWA
-
1
:
0
]
wbusA
,
input
rdA
,
output
[
BWA
-
1
:
0
]
z63
,
input
clkB
,
input
adrB
,
input
wrB
,
input
[
BWB
-
1
:
0
]
wbusB
,
input
rdB
,
output
[
BWB
-
1
:
0
]
z48
);
endmodule
module
RamSPN
#
(
parameter
AW
=
12
,
parameter
BW
=
8
)
(
input
clk
,
input
[
AW
-
1
:
0
]
adr
,
input
wr
,
input
[
BW
-
1
:
0
]
wrbus
,
input
rd
,
output
[
BW
-
1
:
0
]
rdbus
,
input
z16
,
input
[
BW
-
1
:
0
]
swrbus
,
input
srd
,
output
[
BW
-
1
:
0
]
srdbus
);
wire
[
BW
-
1
:
0
]
z65
;
RamDPN
#
(
AW
,
BW
,
BW
)
inst
(
clk
,
adr
,
wr
,
wrbus
,
rd
,
rdbus
,
clk
,
0
,
0
,
0
,
0
,
z65
);
endmodule
module
Dma
#
(
parameter
AW
=
12
,
parameter
BW
=
8
,
parameter
ID
=
0
)
(
input
clk
,
input
rst
,
input
start
,
input
[
AW
-
1
:
0
]
count
,
input
[
7
:
0
]
flags
,
input
shrd
,
output
busy
,
input
rok
,
input
[
AW
-
1
:
0
]
z43
,
input
[
BW
-
1
:
0
]
rbus
,
output
[
31
:
0
]
rdma
,
input
wok
,
input
[
AW
-
1
:
0
]
wadr
,
output
[
BW
-
1
:
0
]
wbus
,
output
[
31
:
0
]
wdma
);
localparam
BO
=(
BW
>
64
)?
4
:(
BW
>
32
)?
3
:(
BW
>
16
)?
2
:(
BW
>
8
)?
1
:
0
;
localparam
BWB
=(
1
<<
BO
);
localparam
BWA
=(
BO
==
0
)?
1
:
BO
;
function
[
31
:
0
]
bswap4
(
input
[
31
:
0
]
d
);
bswap4
=
{
d
[
7
:
0
],
d
[
15
:
8
],
d
[
23
:
16
],
d
[
31
:
24
]};
endfunction
function
[
31
:
0
]
bswap2
(
input
[
31
:
0
]
d
);
bswap2
=
{
d
[
23
:
16
],
d
[
31
:
24
],
d
[
7
:
0
],
d
[
15
:
8
]};
endfunction
function
[
15
:
0
]
sbswap2
(
input
[
15
:
0
]
d
);
sbswap2
=
{
d
[
7
:
0
],
d
[
15
:
8
]};
endfunction
wire
z1
=
1
,
z2
=
0
;
wire
z66
=
flags
[
0
];
wire
z67
=
flags
[
1
];
wire
z68
=
flags
[
2
];
wire
z69
=
flags
[
3
];
reg
z70
,
z71
,
z72
,
z73
,
z74
,
z75
,
z76
,
z77
,
z78
,
z79
,
z80
;
reg
[
AW
-
1
:
0
]
z8
,
z81
,
z82
;
reg
[
BWA
-
1
:
0
]
z83
,
z84
;
reg
[
BWA
-
1
:
0
]
z85
;
reg
[
BW
-
1
:
0
]
z86
;
reg
[
BW
*
2
-
1
:
0
]
z87
;
reg
[
BWB
-
1
:
0
]
z88
;
wire
[
BWB
-
1
:
0
]
z89
=
~
0
;
wire
[
AW
-
1
:
0
]
z90
=
count
+
wadr
[
BWA
-
1
:
0
];
wire
z91
=
wadr
[
BWA
-
1
:
0
]>
z43
[
BWA
-
1
:
0
];
reg
[
11
:
0
]
z92
;
wire
z93
=
z92
[
11
];
wire
z94
=
(
rok
&&
wok
);
wire
z95
=
z70
&&
!
z94
;
wire
z96
=
z70
&&
!
shrd
&&
(
z94
||
z93
);
wire
z97
=
z96
&&
(
z8
<=
BWB
);
wire
z98
;
srl16xN
f1
(
clk
,
z1
,
z77
?
4'h2
:
4'h3
,
start
,
z98
);
wire
z99
;
srl16xN
f2
(
clk
,
z1
,
z77
?
4'h1
:
4'h2
,
z97
,
z99
);
wire
z100
;
srl16xN
f3
(
clk
,
z1
,
z77
?
4'h1
:
4'h2
,
z97
,
z100
);
wire
z101
=
z72
||
z100
;
always
@(
posedge
clk
)
begin
if
(
start
)
z92
<=
0
;
else
if
(
z95
)
z92
<=
z92
+
1
;
if
(
start
)
z8
<=
z90
;
else
if
(
z96
)
z8
<=
z8
-
BWB
;
if
(
start
)
z81
<=
z43
;
else
if
(
z96
)
z81
<=
z81
+
BWB
;
if
(
start
)
z82
<=
wadr
;
else
if
(
z74
)
z82
<=
z82
+
BWB
;
if
(
start
)
z77
<=
z91
;
if
(
start
)
z84
<=
count
[
BWA
-
1
:
0
]+
wadr
[
BWA
-
1
:
0
];
if
(
start
)
z78
<=
z91
;
else
z78
<=
z78
||
z72
;
if
(
z98
)
z83
<=
z81
[
BWA
-
1
:
0
]-
z82
[
BWA
-
1
:
0
];
z70
<=
start
||
(
z70
&&
!
z97
);
z71
<=
z96
;
z72
<=
z71
;
z73
<=
z78
&&
z101
;
z74
<=
z73
;
z75
<=
z74
;
z76
<=
z75
;
if
(
z98
)
z85
<=
z82
[
BWA
-
1
:
0
];
else
if
(
z99
)
z85
<=
BWB
-
z84
;
else
z85
<=
0
;
z79
<=
z98
;
if
(
z101
)
z87
[
BW
*
2
-
1
:
BW
]
<=
rbus
;
if
(
z101
)
z87
[
BW
-
1
:
0
]
<=
z87
[
BW
*
2
-
1
:
BW
];
if
(!
z73
)
z88
<=
0
;
else
z88
<=
z79
?
z89
<<
z85
:
z89
>>
z85
;
z80
<=
start
||
z70
||
z71
||
z72
||
z73
;
`ifdef DEBUG
if
(
busy
&&
shrd
)
$write
(
"Shared read at cnt=%d\n"
,
z8
);
if
(
start
&&
ID
==
1
)
$write
(
"start pcnt=%d dcnt=%x cnt=%x radr=%x wadr=%x\n"
,
pcnt
[
4
:
0
],
dcnt
,
count
,
z43
,
wadr
);
if
(
debug
&&
ID
==
1
)
$write
(
"data  pcnt=%d dcnt=%x cnt=%x rdma=%x rbus=%x wdma=%x wbus=%x\n"
,
pcnt
[
4
:
0
],
dcnt
,
z8
,
rdma
,
rbus
,
wdma
,
z86
);
`endif
z86
<=
z87
>>{
z83
,
3'h0
};
end
assign
busy
=
start
||
z80
;
assign
rdma
[
AW
-
1
:
0
]
=
z81
;
assign
wdma
[
AW
-
1
:
0
]
=
z82
;
assign
wdma
[
32
-
1
:
32
-
BWB
]
=
z88
;
generate
if
(
BW
==
64
)
begin
assign
wbus
=
z66
?
{
bswap2
(
z86
[
63
:
32
]),
bswap2
(
z86
[
31
:
0
])}
:
z67
?
{
bswap4
(
z86
[
63
:
32
]),
bswap4
(
z86
[
31
:
0
])}
:
z86
;
end
else
if
(
BW
==
32
)
begin
assign
wbus
=
z66
?
bswap2
(
z86
)
:
z67
?
bswap4
(
z86
)
:
z86
;
end
else
if
(
BW
==
16
)
begin
assign
wbus
=
z66
?
sbswap2
(
z86
)
:
z67
?
sbswap2
(
z86
)
:
z86
;
end
else
begin
assign
wbus
=
z86
;
end
endgenerate
endmodule
module
TapBuf
#
(
M
=
4
,
IW
=
1
,
OW
=
1
,
DLY
=-
1
)
(
input
clk
,
input
rst
,
input
z47
,
input
fptx
wbus
,
input
ren
[
OW
],
input
[
M
-
1
:
0
]
z43
[
OW
],
output
fptx
rbus
[
OW
]);
fptx
z102
[
1
];
assign
z102
[
0
]=
wbus
;
TapBuf_NP
#
(
M
,
IW
,
OW
,
DLY
,
1
)
inst
(
clk
,
rst
,
z47
,
z102
,
ren
,
z43
,
rbus
);
endmodule
module
TapBuf_NP
#
(
M
=
4
,
IW
=
1
,
OW
=
1
,
DLY
=-
1
,
NP
=
1
)
(
input
clk
,
input
rst
,
input
z47
,
input
fptx
wbus
[
NP
],
input
ren
[
OW
],
input
[
M
-
1
:
0
]
z43
[
OW
],
output
fptx
rbus
[
OW
]);
localparam
IWO
=
(
IW
>
16
)?
5
:
(
IW
>
8
)?
4
:
(
IW
>
4
)?
3
:
(
IW
>
2
)?
2
:
(
IW
>
1
)?
1
:
0
;
localparam
OWO
=
(
OW
>
16
)?
5
:
(
OW
>
8
)?
4
:
(
OW
>
4
)?
3
:
(
OW
>
2
)?
2
:
(
OW
>
1
)?
1
:
0
;
localparam
MX
=
(
DLY
<
0
)?
M
+
1
:
M
;
wire
[
IWO
:
0
]
z103
=
(
ren
[
0
]
&&
(
OW
==
1
||
z43
[
0
]==
0
))?
IW
:
0
;
reg
[
M
:
0
]
z104
;
wire
[
M
:
0
]
z105
=
z104
-
z103
;
always
@(
posedge
clk
)
begin
if
(
rst
)
z104
<=
0
;
else
z104
<=
z105
+
z47
;
end
genvar
i
;
generate
for
(
i
=
0
;
i
<
OW
;
i
=
i
+
1
)
begin
wire
[
M
:
0
]
z46
=
(
DLY
==
0
)?
z43
[
i
]
:
z43
[
i
]
+
z105
;
srlMxN
#
(
MX
,
32
,
0
)
srl
(
clk
,
rst
|
z47
,
z46
,
rst
?
0
:
wbus
[
0
],
rbus
[
i
]);
end
endgenerate
endmodule
module
CxTapBuf
#
(
M
=
4
,
IW
=
1
,
OW
=
1
,
DLY
=
0
)
(
input
clk
,
input
rst
,
input
[
3
:
0
]
stride
,
input
split
,
input
z47
,
input
CxFptx
wbus
,
input
ren
[
OW
],
input
[
M
-
1
:
0
]
z43
[
OW
],
output
CxFptx
rbus
[
OW
]);
CxFptx
z102
[
1
];
assign
z102
[
0
]=
wbus
;
CxTapBuf_NP
#
(
M
,
IW
,
OW
,
DLY
,
1
)
inst
(
clk
,
rst
,
stride
,
split
,
z47
,
z102
,
ren
,
z43
,
rbus
);
endmodule
module
CxTapBuf_NP
#
(
M
=
4
,
IW
=
1
,
OW
=
1
,
DLY
=
0
,
NP
=
1
)
(
input
clk
,
input
rst
,
input
[
3
:
0
]
stride
,
input
split
,
input
z47
,
input
CxFptx
wbus
[
NP
],
input
ren
[
OW
],
input
[
M
-
1
:
0
]
z43
[
OW
],
output
CxFptx
rbus
[
OW
]);
localparam
TW
=
(
1
<<
M
);
localparam
HW
=
TW
/
2
;
localparam
IWO
=
(
IW
>
16
)?
5
:
(
IW
>
8
)?
4
:
(
IW
>
4
)?
3
:
(
IW
>
2
)?
2
:
(
IW
>
1
)?
1
:
0
;
localparam
OWO
=
(
OW
>
16
)?
5
:
(
OW
>
8
)?
4
:
(
OW
>
4
)?
3
:
(
OW
>
2
)?
2
:
(
OW
>
1
)?
1
:
0
;
localparam
USEREG
=
(
IW
==
NP
&&
DLY
<
0
&&
OW
>=
HW
)
?
1
:
0
;
localparam
MX
=
(
DLY
>
0
)?
M
+
DLY
:
(
DLY
<
0
)?
M
-
DLY
:
M
;
wire
[
M
-
1
:
0
]
z106
=
z43
[
0
];
wire
z103
=
ren
[
0
]
&&
(
OW
==
1
||
NP
>
1
||
z106
==
0
);
reg
[
MX
:
0
]
z104
;
wire
[
MX
:
0
]
z105
=
z103
?
z104
-
stride
:
z104
;
always
@(
posedge
clk
)
if
(
rst
)
z104
<=
0
;
else
z104
<=
z105
+
(
z47
?
IW
:
0
);
genvar
i
;
generate
if
(
USEREG
)
begin
:
usereg
CxFptx
z107
[
TW
];
for
(
i
=
0
;
i
<
TW
;
i
=
i
+
1
)
begin
always
@(
posedge
clk
)
if
(
rst
)
z107
[
i
]
<=
0
;
else
if
(
z47
)
z107
[
i
]
<=
(
i
<
NP
)?
wbus
[
NP
-
1
-
i
]
:
z107
[
i
-
NP
];
end
for
(
i
=
0
;
i
<
OW
;
i
=
i
+
1
)
begin
assign
rbus
[
i
]
=
(
OW
>
HW
)?
z107
[
i
]
:
z106
[
OWO
]?
z107
[
i
+
HW
]
:
z107
[
i
];
end
end
if
(!
USEREG
)
begin
:
usesrl
for
(
i
=
0
;
i
<
OW
;
i
=
i
+
1
)
begin
wire
[
MX
:
0
]
z46
=
(
DLY
==
0
)?
z43
[
i
]
:
z43
[
i
]+
z105
;
srlMxN
#
(
MX
,
64
,
0
)
srl
(
clk
,
rst
|
z47
,
z46
>>
IWO
,
rst
?
0
:
wbus
[
i
%
IW
],
rbus
[
i
]);
end
end
endgenerate
endmodule
module
CxTapBuf_NPO
#
(
M
=
4
,
IW
=
1
,
OW
=
1
,
DLY
=
0
,
NP
=
1
)
(
input
clk
,
input
rst
,
input
z47
,
input
CxFptx
wbus
,
input
fptx
fps
[
NP
],
input
ren
[
NP
][
OW
],
input
[
M
-
1
:
0
]
z43
[
NP
][
OW
],
output
CxFptx
rbus
[
NP
][
OW
]);
genvar
i
,
j
;
generate
for
(
j
=
0
;
j
<
NP
;
j
=
j
+
1
)
begin
fptx
z108
;
assign
z108
=
fps
[
j
];
for
(
i
=
0
;
i
<
OW
;
i
=
i
+
1
)
begin
wire
[
M
-
1
:
0
]
z46
=
z43
[
j
][
i
];
wire
z104
=
(
z46
>
0
)?
z108
[
16
:
16
]
:
0
;
wire
[
M
-
1
:
0
]
z109
=
z46
-
z104
;
srlMxN
#
(
M
,
64
,
0
)
srl
(
clk
,
rst
|
z47
,
z109
,
rst
?
0
:
wbus
,
rbus
[
j
][
i
]);
end
end
endgenerate
endmodule
module
CxTapBuf_NP2
#
(
M
=
4
,
IW
=
1
,
OW
=
1
,
DLY
=
0
,
NP
=
1
)
(
input
clk
,
input
rst
,
input
[
3
:
0
]
stride
,
input
z47
,
input
CxFptx
wbus
[
NP
],
input
ren
[
OW
],
input
[
M
-
1
:
0
]
z43
[
OW
],
output
CxFptx
rbus
[
OW
],
output
CxFptx
rbus2
[
OW
]);
localparam
TW
=
(
1
<<
M
);
localparam
HW
=
TW
/
2
;
localparam
IWO
=
(
IW
>
16
)?
5
:
(
IW
>
8
)?
4
:
(
IW
>
4
)?
3
:
(
IW
>
2
)?
2
:
(
IW
>
1
)?
1
:
0
;
localparam
OWO
=
(
OW
>
16
)?
5
:
(
OW
>
8
)?
4
:
(
OW
>
4
)?
3
:
(
OW
>
2
)?
2
:
(
OW
>
1
)?
1
:
0
;
localparam
USEREG
=
(
IW
==
NP
&&
DLY
<
0
&&
OW
>=
HW
)
?
1
:
0
;
localparam
MX
=
(
DLY
>
0
)?
M
+
DLY
:
(
DLY
<
0
)?
M
-
DLY
:
M
;
wire
[
M
-
1
:
0
]
z106
=
z43
[
0
];
wire
[
M
-
1
:
0
]
z103
=
(
ren
[
0
]
&&
(
OW
==
1
||
z106
==
0
))?
stride
:
0
;
reg
[
MX
:
0
]
z104
;
wire
[
MX
:
0
]
z105
=
z104
-
z103
;
always
@(
posedge
clk
)
if
(
rst
)
z104
<=
0
;
else
z104
<=
z105
+
(
z47
?
IW
:
0
);
CxFptx
z110
[
OW
+
1
];
genvar
i
;
generate
if
(
USEREG
)
begin
:
usereg
CxFptx
z107
[
TW
+
1
];
for
(
i
=
0
;
i
<
TW
+
1
;
i
=
i
+
1
)
begin
always
@(
posedge
clk
)
if
(
rst
)
z107
[
i
]
<=
0
;
else
if
(
z47
)
z107
[
i
]
<=
(
i
<
NP
)?
wbus
[
NP
-
1
-
i
]
:
z107
[
i
-
NP
];
end
for
(
i
=
0
;
i
<
OW
+
1
;
i
=
i
+
1
)
begin
assign
z110
[
i
]
=
(
OW
>
HW
)?
z107
[
i
]
:
z106
[
OWO
]?
z107
[
i
+
HW
]
:
z107
[
i
];
end
end
if
(!
USEREG
)
begin
:
usesrl
for
(
i
=
0
;
i
<
OW
+
1
;
i
=
i
+
1
)
begin
wire
[
MX
:
0
]
z46
;
if
(
i
<
OW
)
assign
z46
=
(
DLY
==
0
)?
z43
[
i
]
:
z43
[
i
]+
z105
;
if
(
i
==
OW
)
assign
z46
=
(
DLY
==
0
)?
z43
[
OW
-
1
]+
1
:
z43
[
OW
-
1
]+
1
+
z105
;
srlMxN
#
(
MX
,
64
,
0
)
srl
(
clk
,
rst
|
z47
,
z46
>>
IWO
,
rst
?
0
:
wbus
[
IW
-
1
-(
i
%
IW
)],
z110
[
i
]);
end
end
for
(
i
=
0
;
i
<
OW
;
i
=
i
+
1
)
begin
assign
rbus
[
i
]=
z110
[
i
];
assign
rbus2
[
i
]=
z110
[
i
+
1
];
end
endgenerate
`ifdef DBG_CXBUF
reg
[
3
:
0
]
z111
,
z112
;
wire
z113
=
z47
&&
(
z111
<
15
);
wire
z114
=
(
z103
!=
0
)
&&
(
z112
<
15
);
always
@(
posedge
clk
)
begin
if
(
z113
)
z111
<=
z111
+
1
;
if
(
z113
)
$write
(
"I=%d M=%d off=%x   %x %x %x %x\n"
,
z111
,
M
,
z105
,
wbus
[
0
]
.x
,
wbus
[
1
]
.x
,
wbus
[
2
]
.x
,
wbus
[
3
]
.x
);
if
(
z114
)
z112
<=
z112
+
1
;
if
(
z114
)
$write
(
"O=%d MX=%d off=%x   %x %x %x %x %x %x %x %x %x\n"
,
z112
,
MX
,
z105
,
z110
[
0
]
.x
,
z110
[
1
]
.x
,
z110
[
2
]
.x
,
z110
[
3
]
.x
,
z110
[
4
]
.x
,
z110
[
5
]
.x
,
z110
[
6
]
.x
,
z110
[
7
]
.x
,
z110
[
8
]
.x
);
end
`endif
endmodule
module
StatBuf
#
(
M
=
4
)
(
input
clk
,
input
rst
,
input
set
,
input
[
31
:
0
]
sadr
,
input
[
31
:
0
]
sbus
,
input
z47
,
input
fptx
vbus
,
input
intx
mode
,
input
domid
,
output
fptx
omid
,
input
domin
,
input
dominm
,
output
fptx
omin
,
input
domax
,
input
domaxm
,
output
fptx
omax
,
input
domini
,
output
intx
omini
);
localparam
N
=
(
1
<<
M
);
localparam
H
=
(
N
>>
1
);
reg
[
M
:
0
]
z115
,
z116
;
fptx
z117
[
N
];
fptx
z118
[
N
],
z119
[
N
];
always
@(
posedge
clk
)
begin
if
(
set
&&
sadr
[
11
:
0
]==
2
)
z115
<=
sbus
;
if
(
set
&&
sadr
[
11
:
0
]==
6
)
z116
<=
sbus
;
end
genvar
i
,
j
;
generate
for
(
i
=
0
;
i
<
N
;
i
=
i
+
1
)
begin
always
@(
posedge
clk
)
if
(
z47
)
z117
[
i
]
<=
(
i
==
0
||
i
>=
z115
)?
vbus
:
z117
[
i
-
1
];
end
for
(
i
=
0
;
i
<
H
;
i
=
i
+
1
)
begin
:
row0
always
@(
posedge
clk
)
z118
[
H
+
i
]
<=
(
z117
[
i
]
<
z117
[
N
-
1
-
i
])?
z117
[
i
]
:
z117
[
N
-
1
-
i
];
always
@(
posedge
clk
)
z119
[
H
+
i
]
<=
(
z117
[
i
]
>
z117
[
N
-
1
-
i
])?
z117
[
i
]
:
z117
[
N
-
1
-
i
];
end
for
(
j
=
M
-
2
;
j
>=
0
;
j
=
j
-
1
)
begin
:
outer
localparam
TROW
=
1
<<
j
;
localparam
TOFF
=
2
<<
j
;
for
(
i
=
0
;
i
<
TROW
;
i
++)
always
@(
posedge
clk
)
z118
[
TROW
+
i
]
<=
(
z118
[
TOFF
+
i
]
<
z118
[
TOFF
+
TOFF
-
1
-
i
])?
z118
[
TOFF
+
i
]
:
z118
[
TOFF
+
TOFF
-
1
-
i
];
for
(
i
=
0
;
i
<
TROW
;
i
++)
always
@(
posedge
clk
)
z119
[
TROW
+
i
]
<=
(
z119
[
TOFF
+
i
]
>
z119
[
TOFF
+
TOFF
-
1
-
i
])?
z119
[
TOFF
+
i
]
:
z119
[
TOFF
+
TOFF
-
1
-
i
];
end
endgenerate
srlMxN
#
(
M
,
32
,
0
)
srl
(
clk
,
z47
,
z116
,
vbus
,
omid
);
assign
omin
=
z118
[
1
];
assign
omax
=
z119
[
1
];
assign
omini
=
0
;
endmodule
module
DelayHold
(
input
clk
,
input
set
,
output
z95
);
reg
z120
;
reg
[
3
:
0
]
z8
;
wire
z121
=
(
z8
!=
0
);
always
@(
posedge
clk
)
begin
if
(
set
)
z8
<=
15
;
else
if
(
z121
)
z8
<=
z8
-
1
;
z120
<=
set
||
z121
;
end
assign
z95
=
z120
;
endmodule
module
RamBuf
#
(
M
=
5
,
IW
=
1
,
OW
=
1
)
(
input
clk
,
input
rst
,
input
set
,
input
[
31
:
0
]
sadr
,
input
[
31
:
0
]
sbus
,
input
wen
[
IW
],
input
[
M
-
1
:
0
]
wadr
[
IW
],
input
fptx
wbus
[
IW
],
input
ren
[
OW
],
input
[
M
-
1
:
0
]
z43
[
OW
],
output
fptx
rbus
[
OW
],
input
rdonly
);
localparam
IWO
=
(
IW
>
16
)?
5
:
(
IW
>
8
)?
4
:
(
IW
>
4
)?
3
:
(
IW
>
2
)?
2
:
(
IW
>
1
)?
1
:
0
;
wire
[
M
-
1
:
0
]
z122
=
sadr
[
15
:
8
];
genvar
i
;
generate
for
(
i
=
0
;
i
<
OW
;
i
=
i
+
1
)
begin
wire
[
M
-
1
:
0
]
z46
=
z43
[
i
];
wire
[
M
-
1
:
0
]
z123
=
wadr
[
i
];
wire
z124
;
if
(
IWO
==
0
)
assign
z124
=
1
;
else
assign
z124
=(
z122
[
IWO
-
1
:
0
]==
i
);
wire
z125
=
(
set
&&
z124
)
||
(
wen
[
i
]
&&
!
rdonly
);
cram16xNsd
#
(
32
)
ram
(
set
?
sbus
:
wbus
[
i
%
IW
],
set
?
z122
[
M
-
1
:
IWO
]:
z123
[
M
-
1
:
IWO
],
clk
,
z125
,
z46
[
M
-
1
:
IWO
],
rbus
[
i
]);
end
endgenerate
endmodule
module
CxRamBuf
#
(
M
=
5
,
IW
=
1
,
OW
=
1
)
(
input
clk
,
input
rst
,
input
set
,
input
[
31
:
0
]
sadr
,
input
[
31
:
0
]
sbus
,
input
wen
[
IW
],
input
[
M
-
1
:
0
]
wadr
[
IW
],
input
CxFptx
wbus
[
IW
],
input
ren
[
OW
],
input
[
M
-
1
:
0
]
z43
[
OW
],
output
CxFptx
rbus
[
OW
],
input
[
1
:
0
]
rdonly
);
localparam
IWO
=
(
IW
>
16
)?
5
:
(
IW
>
8
)?
4
:
(
IW
>
4
)?
3
:
(
IW
>
2
)?
2
:
(
IW
>
1
)?
1
:
0
;
wire
[
M
:
0
]
z122
=
sadr
[
15
:
8
];
genvar
i
;
generate
for
(
i
=
0
;
i
<
OW
;
i
=
i
+
1
)
begin
wire
[
M
-
1
:
0
]
z46
=
z43
[
i
];
wire
[
M
-
1
:
0
]
z123
=
wadr
[
i
];
wire
z124
;
if
(
IWO
==
0
)
assign
z124
=
1
;
else
assign
z124
=(
z122
[
IWO
:
1
]==
i
);
wire
z126
=
(
set
&&
z124
&&
!
z122
[
0
])
||
(
wen
[
i
]
&&
!
rdonly
[
0
]);
wire
z127
=
(
set
&&
z124
&&
z122
[
0
])
||
(
wen
[
i
]
&&
!
rdonly
[
1
]);
cram16xNsd
#
(
32
)
ramx
(
set
?
sbus
:
wbus
[
i
%
IW
][
31
:
0
],
set
?
z122
[
M
:
IWO
+
1
]:
z123
[
M
-
1
:
IWO
],
clk
,
z126
,
z46
[
M
-
1
:
IWO
],
rbus
[
i
][
31
:
0
]);
cram16xNsd
#
(
32
)
ramy
(
set
?
sbus
:
wbus
[
i
%
IW
][
63
:
32
],
set
?
z122
[
M
:
IWO
+
1
]:
z123
[
M
-
1
:
IWO
],
clk
,
z127
,
z46
[
M
-
1
:
IWO
],
rbus
[
i
][
63
:
32
]);
end
endgenerate
endmodule
module
convertEndian
#
(
BW
=
32
,
BWP
=
BW
/
8
)
(
input
clk
,
input
rst
,
input
[
7
:
0
]
swaps
,
input
vena
,
input
[
BWP
-
1
:
0
]
vsel
,
input
[
BW
-
1
:
0
]
vbus
,
output
reg
z37
,
output
reg
[
BWP
-
1
:
0
]
wsel
,
output
reg
[
BW
-
1
:
0
]
wbus
);
reg
[
1
:
0
]
z128
,
z129
;
reg
[
31
:
0
]
z110
,
z130
;
reg
[
BWP
-
1
:
0
]
z131
;
wire
z132
=
swaps
[
2
];
wire
z133
=
rst
||
!
swaps
[
2
];
always
@(
posedge
clk
)
begin
if
(
rst
)
z129
<=
0
;
else
if
(
vena
&&
!
z129
[
0
])
z129
<=
z129
+
1
;
if
(
z133
)
z128
<=
0
;
else
if
(
vena
)
z128
<=
(
z128
==
3
)?
1
:
z128
+
1
;
if
(
vena
)
z131
<=
vsel
;
if
(
vena
)
wsel
<=
z131
;
if
(
vena
)
z110
<=
vbus
;
if
(
vena
)
z130
<=
z110
;
z37
<=
vena
&&
z129
[
0
];
if
(
vena
)
wbus
<=
(
z128
==
1
)?
{
z110
[
27
:
24
],
vbus
[
7
:
4
],
z110
[
11
:
8
],
z110
[
23
:
16
],
z110
[
7
:
0
],
z110
[
15
:
12
]}
:
(
z128
==
2
)?
{
vbus
[
3
:
0
],
z110
[
23
:
16
],
z110
[
31
:
28
],
z110
[
3
:
0
],
z110
[
15
:
8
],
z130
[
31
:
28
]}
:
(
z128
==
3
)?
{
z110
[
19
:
16
],
z110
[
31
:
24
],
z110
[
15
:
8
],
z110
[
23
:
20
],
z130
[
27
:
24
],
z110
[
7
:
4
]}
:
swaps
[
0
]?
{
z110
[
23
:
16
],
z110
[
31
:
24
],
z110
[
7
:
0
],
z110
[
15
:
8
]
}
:
swaps
[
1
]?
{
z110
[
7
:
0
],
z110
[
15
:
8
],
z110
[
23
:
16
],
z110
[
31
:
24
]
}
:
z110
;
end
endmodule
