module
cicengine
(
sclk
,
srst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
OBW
=
IBW
;
localparam
ORDER
=
5
;
localparam
DBW
=
16
;
localparam
DW
=
11
;
localparam
SW
=
6
;
localparam
FW
=
16
;
input
sclk
;
input
srst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
assign
sack
=
z2
;
wire
[
DBW
-
1
:
0
]
z3
;
wire
[
DBW
-
1
:
0
]
z4
;
reg
[
DW
-
1
:
0
]
z5
;
wire
z6
,
z7
,
z8
;
reg
z9
,
z10
,
z11
,
z12
;
reg
[
31
:
0
]
z13
;
always
@(
posedge
ioclk
)
z11
<=
iena
;
reg
z14
,
z15
,
z16
;
always
@(
posedge
sclk
)
begin
z14
<=
scs
&&
swr
&&
saddr
[
3
:
0
]==
0
;
z15
<=
scs
&&
swr
&&
saddr
[
3
:
0
]==
4
;
z16
<=
scs
&&
swr
&&
saddr
[
3
:
0
]==
8
;
z9
<=
z6
;
z10
<=
z9
;
z12
<=
!
z13
[
0
]
||
srst
;
if
(
z14
)
z13
<=
swrbus
;
if
(
z15
)
z5
<=
swrbus
[
DW
-
1
:
0
];
end
fifoNxM
#
(
IBW
,
DBW
)
fin
(
ioclk
,
z12
,
istat
,
z11
,
ibus
,
sclk
,
z12
,
z6
,
z9
,
z3
);
cicfilter
#
(
ORDER
,
DBW
,
DBW
,
DW
,
SW
,
FW
)
cic
(
sclk
,
z12
,
z5
,
z16
,
swrbus
,
z10
,
z3
,
z8
,
z4
);
fifoNxM
#
(
DBW
,
IBW
)
fout
(
sclk
,
z12
,
z7
,
z8
,
z4
,
ioclk
,
z12
,
ostat
,
oena
,
obus
);
endmodule
module
cicfilter
(
clk
,
rst
,
z5
,
wgain
,
data
,
vin
,
din
,
vout
,
dout
);
parameter
ORDER
=
5
;
parameter
IBW
=
16
;
parameter
OBW
=
16
;
parameter
DW
=
10
;
parameter
SW
=
6
;
parameter
FW
=
16
;
parameter
GSH
=
0
;
localparam
ABW
=
DW
*
ORDER
+
IBW
;
localparam
DBW
=
18
;
localparam
PBW
=
FW
+
DBW
;
localparam
CBW
=
OBW
+
1
+
7
;
input
clk
,
rst
,
vin
,
wgain
;
input
[
DW
-
1
:
0
]
z5
;
input
[
31
:
0
]
data
;
input
signed
[
IBW
-
1
:
0
]
din
;
output
signed
[
OBW
-
1
:
0
]
dout
;
output
vout
;
reg
[
DW
-
1
:
0
]
z17
;
reg
signed
[
ABW
-
1
:
0
]
z18
[
ORDER
:
0
];
reg
signed
[
DBW
-
1
:
0
]
z19
[
ORDER
:
0
],
z20
[
ORDER
:
0
];
reg
signed
[
PBW
-
1
:
0
]
z21
,
z22
;
reg
[
SW
-
1
:
0
]
z23
;
reg
[
FW
-
1
:
0
]
z24
;
wire
z1
=
0
,
z2
=
1
;
(*
dont_touch
=
"yes"
*)
reg
z25
,
z26
;
wire
z27
=
vin
;
wire
z28
=
(
z27
&&
(
z17
==
0
))
||
z25
;
reg
z29
,
z30
,
z31
,
z32
,
z33
,
z34
,
z35
;
always
@(
posedge
clk
)
begin
z25
<=
rst
;
if
(
z25
)
z29
<=
0
;
else
z29
<=
z27
;
if
(
z25
)
z30
<=
0
;
else
z30
<=
z28
;
if
(
z25
)
z31
<=
0
;
else
z31
<=
z30
;
if
(
z25
)
z32
<=
0
;
else
z32
<=
z31
;
if
(
z25
)
z33
<=
0
;
else
z33
<=
z32
;
if
(
z25
)
z34
<=
0
;
else
z34
<=
z33
;
if
(
z25
)
z35
<=
0
;
else
z35
<=
z34
;
end
always
@(
posedge
clk
)
begin
if
(
wgain
)
z24
<=
data
[
FW
-
1
:
0
];
if
(
wgain
)
z23
<=
data
[
SW
+
FW
-
1
:
FW
]-
GSH
;
if
(
z28
)
z17
<=
z5
;
else
if
(
z27
)
z17
<=
z17
-
1
;
z26
<=
rst
;
end
reg
signed
[
IBW
-
1
:
0
]
z36
;
always
@(
posedge
clk
)
z36
<=
din
;
genvar
i
;
generate
always
@(
posedge
clk
)
if
(
z26
)
z18
[
1
]
<=
0
;
else
if
(
z29
)
z18
[
1
]
<=
z18
[
1
]
+
z36
;
for
(
i
=
2
;
i
<=
ORDER
;
i
=
i
+
1
)
begin
:
add
always
@(
posedge
clk
)
if
(
z26
)
z18
[
i
]
<=
0
;
else
if
(
z29
)
z18
[
i
]
<=
z18
[
i
]
+
z18
[
i
-
1
];
end
wire
signed
[
ABW
-
1
:
0
]
z37
=
z18
[
ORDER
]
>>
z23
;
always
@(
posedge
clk
)
z19
[
0
]
<=
$signed
(
z37
[
DBW
-
1
:
0
]);
for
(
i
=
1
;
i
<=
ORDER
;
i
=
i
+
1
)
begin
:
sub
always
@(
posedge
clk
)
if
(
z26
)
z19
[
i
]
<=
0
;
else
if
(
z31
)
z19
[
i
]
<=
z19
[
i
-
1
]
-
z20
[
i
-
1
];
end
for
(
i
=
0
;
i
<
ORDER
;
i
=
i
+
1
)
begin
:
store
always
@(
posedge
clk
)
if
(
z26
)
z20
[
i
]
<=
0
;
else
if
(
z31
)
z20
[
i
]
<=
z19
[
i
];
end
endgenerate
wire
signed
[
DBW
-
1
:
0
]
z38
=
z19
[
ORDER
];
always
@(
posedge
clk
)
z21
<=
z38
*
$signed
({
z1
,
z24
});
wire
z39
;
wire
[
CBW
-
1
:
0
]
z40
;
roundN2Mc
#
(
CBW
,
OBW
,
1
,
2
)
cvt
(
z21
[
PBW
-
1
:
PBW
-
CBW
],
z40
,
z2
,
z2
,
clk
,
z39
);
assign
vout
=
z35
;
assign
dout
=
z40
[
CBW
-
1
-
1
:
CBW
-
1
-
OBW
];
endmodule
