!******************************************************************************!
! Macro to set the NeXtMidas options path
!
! @author Jeff Schoen / Neon Ngo
! @version $Id: path.mm,v 1.26 2012/11/01 13:19:54 ntn Exp $
!******************************************************************************!
startmacro s:func
  switch SKIPRUN skiprun GET DEF=FALSE SDEF=TRUE
  res args this.args  ! get the raw Args for this macro
  res oldpath ",^{opt.path},"

  if /redo OR func eqs "REDO"
    sedit "PATH,SET,^OPT.PATH" args parseargs   ! parses current path
    set func "SET"
  elseif func eqss "REM" OR func eqs "-"
    res prefix ","
    do i 2 args.size
      if i gt 2 then set prefix ""   ! Bug 2202: do not put multiple commas at the beginning of the path
      sedit/force "^{prefix}^{opt.path}" "OPT.PATH" gsub ",^args.getu(i)," ","
    enddo
    sedit "PATH,SET,^OPT.PATH.substring(1)" args parseargs   ! parses current path
    set func "SET"
    set z:skiprun true
  elseif func EQS "GET"
    set myopt     ^args.getU(2)
    set myResname ^args.getU(3)
    if myOpt EQS "" then
      warning "You must enter an OPTION tree name to get path"
    else
      fname myPath AREA="",NAME="",EXT="",OPT=myOpt,
      if myResname EQS "" then
        info "Path for ^myopt = ^myPath"
      else
        res/parent ^myResname "^myPath"
      endif
    endif
    stop
  elseif func eqs "PUT" then   ! PUT added in 2.7.4 for BUG 2023
    do i 2 args.size
      sedit ",^opt.path" idx "BSEARCH" ",^args.getu(i),"
      if idx gt -1 then
       ! do nothing, it is already there
       info "Option Tree ^args.getu(i) is already in path. Doing nothing."
      else
        path add "^args.getu(i)"  ! if not there, add it
      endif
    enddo
    stop
  elseif func EQS "ADD" OR func EQS "+" then
    ! Insert the given options at the end (but before SYS)
    do i 2 args.size
      sedit/force ",^opt.path" "OPT.PATH" gsub ",^args.getu(i)," ","  ! Remove multiple options
      set/force opt.path "^args.getu(i)^{OPT.PATH}"                   ! add to front
    enddo
    sedit "PATH,SET,^OPT.PATH" args parseargs   ! parses current path
    set func "SET"
  elseif func EQS "ADD+" then
    ! Insert the given options at the end (but before SYS)
    do i 2 args.size
      sedit/force opt.path "OPT.PATH" gsub ",^args.getu(i)," ","      ! Remove duplicate options
      sedit/force opt.path "OPT.PATH" gsub "SYS" "^args.getu(i),SYS"  ! Add option just before SYS
    enddo
    sedit "PATH,SET,^OPT.PATH" args parseargs   ! parses current path
    set func "SET"
  endif

  if args.size eq 0 then
    res opt.path
  elseif func eqs "SHOW" then
    res opt.path
    if /rerun then call runOptstarts  ! BUG 2283 make sure optstart macros rerun
    stop                              ! BUG 2206 display path then stop macro
  elseif func eqs "SET" then
    ! Since 3.0.1: update OPT.CLASSPATH to match PATH (left to right) entries to
    !              ensure proper precedence for Java class loading (BUG 1795/2344)
    configure "K"                     ! clear command dictionary
    do i 2 args.size 1
      invoke ,, nxm.sys.lib.Shell.addOptToClasspath(args.getu(i),true)
    enddo
    configure "C" SYS                 ! add SYS commands

    ! configure "KC" SYS              ! <== behavior prior to 3.0.1
  else
    error "Illegal PATH function: ^func  Use: +|-|ADD|ADD+|GET|REDO|REMove|SET|SHOW"
    stop
  endif

  do i args.size 2 -1
    if args.getu(i) eqs "SYS"
      ! don't add or remove system tree
    else
      configure "C" ^args.getu(i)
    endif
  enddo

  ! print updated path (when not GET and SHOW)
  if this.verbose then
    res opt.path
  endif

  if skiprun isFalse then
    call runOptstarts
  endif

endmacro

!******************************************************************************!
! Procedure to run the optstart.mm scripts in each option tree
! Added in 2.9.0 for Bug 2283
!******************************************************************************!
procedure runOptstarts

  foreach/rev option inlist opt.path
    if /rerun OR ",^{option}," nsubs oldpath then
      fname fname OPT="^{option}" AREA="cfg" NAME="optstart" EXT="mm"
      if fname fexists run %optstart/mfn=fname
    endif
  endfor

return
