!******************************************************************************!
!  Macro to build an option tree
!
!  This macro uses the MAKE macro build/generate the necessary components of
!  an option tree.  If option tree specific functions need to be performed,
!  copy this macro to the option tree's mcr area and modify as necessary.
!  Do NOT add the BUILDOPT to the commands.cnf for the option.
!
!  Switches:
!    /NC - Suggests that No Code files need be built.
!    /NH - Suggests that No Help files need be built.
!    /NJ - Suggests that No Jar  files need be built.
!    /NB - Suggests that No OSGi Bundle files need be built. Since 3.3.0
!
!  @author  Jeff Schoen / J. Czechowski IV / Neon Ngo
!  @version $Id: buildopt.mm,v 1.19 2014/03/18 16:35:39 ntn Exp $
!******************************************************************************!
startmacro u:option
  switch "NB"  noBundle  GET DEF=TRUE SDEF=TRUE

  if /nc isFalse then
    ! Verify that option tree is on the path (otherwise BUILD could fail)
    if ",^{option}," NSUBS ",^{opt.path}," then
      warning "Option tree [^{option}] should be on the path otherwise you could get build failures."
    endif
    say "--> Building Java/C/Fortran Sources for ^option <--"
    build/verbose all all ^option
  endif

  if /nh isFalse then
    say "--> Building Help for ^option <--"
    help/build ,, ^option

    ! Build the Training and User's Guide materials -- This will probably change!
    if option eqs "SYS" then
      file name userGuideOptions (^env.nmroot,htdocs,usersguide,rawfiles) options.tbl
      file name trainingOptions  (^env.nmroot,htdocs,training,rawfiles)   options.tbl
      say "--> Building NeXtMidas User's Guide <--"
      nxm.sys.prim.makedocs options=userGuideOptions
      say "--> Building NeXtMidas Training Docs <--"
      nxm.sys.prim.makedocs options=trainingOptions
    endif
  endif

  if /nj isFalse then
    say "--> Building WebStart Jars for ^option <--"

    if (option EQS "SYS") then
      ! Since 3.3.0: Since we have pre-built .dll files for Windows... we might as well make the
      !   native WebStart JARs for Windows too -- but do this FIRST so that any updates build under
      !   the option tree will override this when we do the normal generate. (BUG 2648)
      generate/verbose JARS ^option jars /SKIP=JARSTANDARD|COPYJARS /OS="windows" /ARCH="x86"    /ROOT="^{ENV.NMROOT}" /FFILT="os/dos/dlls/*_win32.dll"
      generate/verbose JARS ^option jars /SKIP=JARSTANDARD|COPYJARS /OS="windows" /ARCH="x86_64" /ROOT="^{ENV.NMROOT}" /FFILT="os/dos/dlls/*_win64.dll"
    endif

    generate/verbose jars ^option jars
  endif

  if noBundle isFalse then
    ! Since 3.3.0 for BUG 2484
    say "--> Building OSGi Bundle for ^option <--"
    generate/verbose bun ^option bundle
  endif

endmacro
