!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  SNAPPER Snapshot/Archive/Analysis macro for ICE cards
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/msgid=main/xmlog/server=9000/headless=n fn:config

! status logger
!switch "LOGFN" logfn get "appserver"
!if logfn neqs "OFF" then report on logfn

pipe on

panel/controls=gc	! this will inherit the headless switch and not show

rmif/http ^/server 

gcontrol button "ACTION"  "" "Setup,Config,Exit" "Setup" /nc=2
gcontrol tval   "TIME"    "Time: " 0 1 -1 1

pipe off

endmacro

procedure open
  set this.timers 2
  set this.timer(0) 1
  set this.timer(1) 10
return

procedure processMessage

  !say "Got message ^msg.name = ^msg.data from ^msg.fid"

  if msg.name eqs "ACTION"
    if msg.data eqs "EXIT"
      pipe stop
    elseif msg.data eqs "CONFIG"
      convert "^config" "T2B" "^config" "A8|A8|A8|A16|A80" 5
      header config sr(1)=(TAG,1A,0) sr(2)=(STAT,1A,8) sr(3)=(PORT,1A,16) &
                    sr(4)=(HOST,2A,24) sr(5)=(CMD,XA,40)
    endif

  elseif msg.name eqs "TIMER" and msg.info eq 0 then  ! 1 sec
    set gc.time.v msg.data

  elseif msg.name eqs "TIMER" and msg.info eq 1 then  ! 10 sec
    report flush

  elseif msg.fid eqs "RMIF" then          ! handle server/client messaging
    if msg.name eqs "OPEN"
      info "Got open ^msg.data from ^msg.fid"
    elseif msg.name eqs "OPENED"
      info "Got opened ^msg.data from ^msg.fid"
      pause 0.5  ! make sure plots are up
      set gc.COMP.action "PLOT"
    elseif msg.name eqs "CLOSE"
      info "Got close ^msg.data from ^msg.fid"
    elseif msg.name eqs "CLOSED"
      info "Got closed ^msg.data from ^msg.fid"
    endif

  elseif msg.name eqs "GET" then          ! server side
    set t:sets msg.data
    foreach key intable sets
      set sets.^key gc.^{key}.value
    endfor
    message send "REPLY" msg "RET" ,, sets

  elseif msg.name eqs "RET" then          ! client side
    set t:sets msg.data
    foreach key intable sets
      if key eqss "TIVO" then
        ! TIVO messages handled locally
      else
        set gc.^{key}.value "^sets.^key"
        if key eqs "FREQ" call updateFreqMarker
      endif
    endfor

  elseif msg.name eqs "SET" then          ! server side
    set t:sets msg.data
    foreach key intable sets
      if key eqs "INFO" then
        info sets.^key
      else
        set gc.^{key}.action "^sets.^key"
      endif
    endfor
    message send "REPLY" msg "ACK" ,, sets

  elseif msg.name eqs "ACK" then          ! client side
    set t:sets msg.data
    foreach key intable sets
      if key eqs "SYSTEM" then
        call picsystem sets.SYSTEM
      elseif key eqs "SCALE" then
        set d:scale ^msg.data
      elseif key eqss "TIVO" then
        ! TIVO messages handled locally
      else
        set gc.^{key}.value "^sets.^key"
        if key eqs "FREQ" call updateFreqMarker
      endif
    endfor

  elseif msg.name eqs "EXIT"
    pipe stop

  else
    ! the rest need no other action
  endif
return


