startmacro fn:outfile fn:psdfile
!
! FIRDEMO - Interactive demo of the FIR generator primitives
! @author Jeff Schoen
! @version $Id: firdemo.mm,v 1.4 2014/08/04 14:42:49 jgs Exp $
!
switch "NFFT" nfft get 1k

pipe/panel/setup/controls=gc on

plot/id=tdp layer={type=~dot}
plot/id=fdp/db range=80 axis=+grid

gcontrol button "ACTION" "Action  " "Refresh,Exit" 
gcontrol choice "TYPE" "Method    " "WINDOW,KAISER,PARKS,METEOR,HLBRT" "WINDOW"
gcontrol choice "TYP2" "Method2   " "WINDOW,KAISER,PARKS,METEOR,NONE" "NONE"
gcontrol choice "OPER" "Operator  " "LOWPASS,HIGHPASS,BANDPASS,STOPBAND" "LOWPASS"
gcontrol choice "WIND" "Window    " "NONE,BART,HANN,HAMM,BLACK,BH61,BH67,BH74,BH92" "HANN"
gcontrol dval   "FC"   "FCenter   " 0.5 0 1 0.1
gcontrol dval   "FW"   "FWidth    " 0.2 0 1 0.1
gcontrol dval   "FT"   "FTrans    " 0.02 0 1 0.01
gcontrol dval "ATTN"   "Atten-dB  " 60 0 100 10
gcontrol lval "NTAPS"  "Taps-ask  " 64 -1 32768 16
gcontrol lval "TAPS"   "Taps-use  " 64 -1 32768 16 /edit=n
gcontrol choice "FORM" "Format    " "SF,CF,SI,CI" "SF"
gcontrol dval "SCALE"  "Scale     " 64k 1 128k 1 
gcontrol lval "DBR"    "Range-dB  " 80 10 120 10 

pipe run

set gc.ACTION.action "REFRESH"

pipe off

endmacro

procedure processMessage
if msg.name eqs "ACTION" then
  if msg.data eqs "EXIT" then
    stop
  endif
endif
send "TDP" "CLOSEFILE" "*"
send "FDP" "CLOSEFILE" "*"
if msg.name eqs "DBR" then
  set reg.fdp.range gc.DBR.v
endif
if "BAND" subs gc.OPER.v then
  calc f1 gc.FC.v gc.FW.v/2 -
  calc f2 gc.FC.v gc.FW.v/2 +
else
  calc f1 gc.FC.v 
  calc f2 gc.FC.v 
endif
set form gc.FORM.v
set complex test(form,eqss,C)
set scale  gc.SCALE.v

if gc.TYPE.v eqs "WINDOW" then
  calc gc.TAPS.v gc.NTAPS.v 2 / fix 2 *
  firwind/scale=scale/sym/cmplx=^complex outfile{format=^FORM} gc.OPER.v gc.WIND.v gc.TAPS.v f1 f2 1.0
elseif gc.TYPE.v eqs "KAISER" then
  firkais/scale=scale/cmplx=^complex outfile{format=^FORM} gc.OPER.v gc.FC.v gc.FW.v gc.FT.v 1.0 gc.ATTN.v gc.NTAPS.v /taprslt=gc.TAPS.v
elseif gc.TYPE.v eqs "HLBRT" then
  calc gc.TAPS.v gc.NTAPS.v-1 2 / fix 2 * 1 +
  firhlbrt/scale=scale outfile gc.TAPS.v gc.WIND.v
else
  say "Unsupported type: ^gc.TYPE.v"
endif

if gc.TYP2.v eqs "WINDOW" then
  calc gc.TAPS.v gc.NTAPS.v 2 / fix 2 *
  firwind/scale=scale/sym/cmplx=^complex outfile2{format=^FORM} gc.OPER.v gc.WIND.v gc.TAPS.v f1 f2 1.0
elseif gc.TYP2.v eqs "KAISER" then
  firkais/scale=scale/cmplx=^complex outfile2{format=^FORM} gc.OPER.v gc.FC.v gc.FW.v gc.FT.v 1.0 gc.ATTN.v gc.NTAPS.v /taprslt=gc.TAPS.v
endif

if gc.TYP2.v eqs "NONE" then
  spectra outfile psdfile nfft=nfft
  send "TDP" "OPENFILE" "outfile"
  send "FDP" "OPENFILE" "psdfile"
else
  spectra outfile psdfile nfft=nfft
  spectra outfile2 psdfile2 nfft=nfft
  send "TDP" "OPENFILE" "outfile|outfile2"
  send "FDP" "OPENFILE" "psdfile|psdfile2"
endif

return

