/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.test;

import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Primitive;

@ProvisionalUseOnly(value="Minimally tested for educational purposes")
public class filter4newrate
extends Primitive {
    private DataFile inFile;
    private DataFile outFile;
    private Data dataBuffer;
    private Data outBuffer;
    private int factor;
    private int inSize;
    private int outSize;
    private int frameSize;
    private int dbpe;
    float[] filter1000;

    public int open() {
        this.inFile = this.MA.getDataFile("IN", "1000", "S#", 0);
        this.inFile.open();
        double inXDelta = this.inFile.getXDelta();
        double xStart = this.inFile.getXStart();
        String format = this.inFile.getFormat();
        this.inSize = (int)this.inFile.getSize();
        this.factor = this.MA.getL("FACTOR", 1);
        this.frameSize = (int)Math.ceil((double)this.inSize / (double)this.factor);
        this.dbpe = (int)(this.inFile.getBPE() * (double)this.frameSize);
        this.outFile = this.MA.getDataFile("OUT", "2000", format, 0);
        this.outFile.setSubSize(this.frameSize);
        this.outFile.setXStart(xStart);
        this.outFile.setXDelta(inXDelta * (double)this.frameSize);
        this.outFile.setYDelta(inXDelta);
        this.outFile.setInternals();
        this.outFile.open(2);
        this.dataBuffer = this.inFile.getDataBuffer(this.inSize, (byte)68);
        this.outSize = this.factor + 1;
        this.outBuffer = this.outFile.getDataBuffer(this.outSize, (byte)68);
        return 0;
    }

    public int process() {
        this.read1000Filter();
        this.create2000();
        this.outFile.write(this.outBuffer, 0.0, this.outSize * this.dbpe);
        return 9;
    }

    public int close() {
        this.inFile.close();
        this.outFile.close();
        return 0;
    }

    private void read1000Filter() {
        int nGot = this.inFile.read(this.dataBuffer, this.inSize);
        this.filter1000 = this.dataBuffer.castF(true);
        if (this.filter1000.length != this.inSize) {
            throw new MidasException("Failed to read all " + this.inSize + " elements from filter file - only got " + nGot + " from" + this.inFile.getName());
        }
    }

    private void create2000() {
        float[] filter2000 = this.outBuffer.castF(false);
        int i = this.filter1000.length - 1;
        for (int tap = this.frameSize - 1; tap >= 0; --tap) {
            for (int f = 0; f < this.outSize - 1; ++f) {
                filter2000[f * this.frameSize + tap] = i >= 0 ? this.filter1000[i--] : 0.0f;
            }
        }
        int idxFillerFrame = (this.outSize - 1) * this.frameSize;
        filter2000[idxFillerFrame] = 0.0f;
        for (int tap = 1; tap < this.frameSize; ++tap) {
            filter2000[idxFillerFrame + tap] = filter2000[tap];
        }
        this.outBuffer.uncast(filter2000, true);
    }
}

