/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

@ProvisionalUseOnly(value="This was created for educational purposes and has been minimally tested")
public class upsample
extends Primitive {
    private DataFile inFile;
    private DataFile outFile;
    private Data dataBuffer;
    private Data outBuffer;
    private int factor;
    private float fillValue;

    public int open() {
        this.inFile = this.MA.getDataFile("IN", "1000", "S#", 0);
        this.inFile.open();
        double inXDelta = this.inFile.getXDelta();
        this.factor = this.MA.getL("FACTOR", 1);
        this.fillValue = this.MA.getF("FILLVALUE", 0.0f);
        this.outFile = this.MA.getDataFile("OUT", this.inFile, 0);
        this.outFile.open();
        this.outFile.setXDelta(inXDelta / (double)this.factor);
        int xfer = this.MA.getL("/TL", 1024);
        this.dataBuffer = this.inFile.getDataBuffer(xfer, (byte)68);
        this.outBuffer = this.outFile.getDataBuffer(xfer * this.factor, (byte)68);
        return 0;
    }

    public int process() {
        int status = 0;
        int numRead = this.inFile.read(this.dataBuffer);
        if (numRead < 0) {
            status = 9;
        } else if (numRead == 0) {
            status = -1;
        } else {
            int numOutput = this.upSample(numRead);
            if (numOutput > 0) {
                this.outFile.write(this.outBuffer, numOutput);
            }
        }
        return status;
    }

    private int upSample(int numRead) {
        float[] fbuf = this.dataBuffer.castF(true);
        float[] outBuf = this.outBuffer.castF(false);
        int numOutput = numRead * this.factor;
        for (int i = 0; i < numRead; ++i) {
            int outIndex = i * this.factor;
            outBuf[outIndex] = fbuf[i];
            for (int z = 1; z < this.factor; ++z) {
                outBuf[outIndex + z] = this.fillValue;
            }
        }
        this.outBuffer.uncast(outBuf, true);
        return numOutput;
    }

    public int close() {
        this.inFile.close();
        this.outFile.close();
        return 0;
    }
}

