/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.Primitive;

public class uprightspectrum
extends Primitive {
    private DataFile inFile;
    private DataFile outFile;
    private Data dataBuffer;
    private boolean invertData = false;
    static final String[][] KEYWORDS_VALUES = new String[][]{{"SNAP_SPECTRAL_SENSE", "S:", "NORMAL", "INVERTED", "NONE", "INVALID"}, {"DATA_INVERSION_FLAG", "L:", "0", "1", "2", "-1"}};
    static final int KEYWORD_NAME = 0;
    static final int KEYWORD_TYPE = 1;
    static final int UPRIGHT_NAME = 2;
    static final int INVERTED_NAME = 3;
    static final int BLUE_INDEX = 0;
    static final int PLATUNUM_INDEX = 1;

    public int open() {
        String keyword;
        String dataInversion;
        this.inFile = this.MA.getDataFile("IN", "1000", "", 0);
        this.inFile.open();
        int kwNum = -1;
        while ((dataInversion = Convert.o2s((Object)this.inFile.getKeyWord(keyword = KEYWORDS_VALUES[++kwNum][0]))) == null && kwNum < KEYWORDS_VALUES.length - 1) {
        }
        if (dataInversion != null && dataInversion.equals(KEYWORDS_VALUES[kwNum][3])) {
            this.invertData = true;
        }
        this.invertData = this.MA.getState("/FORCEINVERSION", this.invertData);
        this.outFile = this.MA.getDataFile("OUT", this.inFile, 0);
        this.outFile.open();
        if (this.invertData) {
            Keywords kw = this.outFile.getKeywordsObject();
            kw.put("UPRIGHTSPECTRUM_COMMENT", (Object)"This data has been uprighted by the UPRIGHTSPECTRUM command");
            if (this.invertData && dataInversion != null) {
                kw.put(KEYWORDS_VALUES[kwNum][1] + keyword, (Object)KEYWORDS_VALUES[kwNum][2]);
                kw.put(KEYWORDS_VALUES[kwNum][1] + "ORIG_" + keyword, (Object)KEYWORDS_VALUES[kwNum][3]);
            }
        }
        int xfer = this.MA.getL("/TL", 1024);
        this.dataBuffer = this.inFile.getDataBuffer(xfer);
        return 0;
    }

    public int process() {
        int status = 0;
        int numRead = this.inFile.read(this.dataBuffer);
        if (numRead < 0) {
            status = 9;
        } else if (numRead == 0) {
            status = -1;
        } else {
            if (this.invertData) {
                this.invertData(numRead);
            }
            this.outFile.write(this.dataBuffer, numRead);
        }
        return status;
    }

    private void invertData(int numRead) {
        float[] fbuf = this.dataBuffer.castF(true);
        for (int i = 1; i < fbuf.length; i += 2) {
            fbuf[i] = -fbuf[i];
        }
        this.dataBuffer.uncast(fbuf, true);
    }

    public int close() {
        this.inFile.close();
        this.outFile.close();
        return 0;
    }
}

