/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.Primitive;
import nxm.sys.libm.Fft;
import nxm.sys.libm.MMath;

public class fastcorrelate
extends Primitive {
    private DataFile hi;
    private DataFile hf;
    private DataFile ho;
    private Data dbw;
    private Data dbf;
    private Data dbm;
    private int nfft;
    private int nfir;
    private int nbins;
    private int flags;
    private int bias;
    private int keep;
    private int over;
    private int pad1;
    private int pad2;
    private boolean mux;
    private boolean pad;
    private boolean cxm;
    private Fft fft;
    private Fft ifft;
    private double scale;

    public int open() {
        double hfXDelta;
        double hiXDelta;
        this.hi = this.MA.getDataFile("IN", "1000", "S#,C#,-SD,-CD", 0);
        this.hi.open();
        this.hf = this.MA.getDataFile("FIR", "1000", "S#,C#,-SD,-CD", 0);
        this.hf.open();
        this.cxm = this.hi.spa == 2 || this.hf.spa == 2;
        this.mux = this.MA.getState("/MUX");
        boolean bl = this.pad = this.MA.getState("/PAD", false) || this.mux;
        if (this.mux && this.cxm) {
            this.M.error("Cannot /MUX with complex input file");
        }
        double size1 = this.hi.getSize();
        double size2 = this.hf.getSize();
        this.nfir = (int)size2;
        this.nfft = Math.max(32768, MMath.power2GE((int)(2 * this.nfir)));
        if (this.MA.getState("/FFT")) {
            this.nfft = this.MA.getL("/FFT");
            this.M.deprecate((CharSequence)"FASTCORRELATE: Use of /FFT is deprecated. Use /NFFT instead.");
        }
        this.nfft = this.MA.getL("/NFFT", this.nfft);
        double size3 = size1 - size2 + 1.0;
        if (size3 <= 0.0) {
            this.M.error("input length [" + size1 + "] is not longer than short (FIR) input [" + size2 + "]");
        }
        if ((hiXDelta = this.hi.getXDelta()) != (hfXDelta = this.hf.getXDelta())) {
            this.M.warning((CharSequence)("Abscissa deletas of inputs are unequal: " + hiXDelta + " vs " + hfXDelta));
        }
        this.over = this.nfir - 1;
        this.keep = this.nfft - this.over;
        this.bias = (int)Math.round(this.hf.getXStart() / hfXDelta);
        if (this.pad) {
            this.pad1 = this.pad2 = this.over;
        } else {
            this.pad2 = 0;
            this.pad1 = 0;
        }
        if (this.cxm) {
            this.flags = 2;
            this.scale = 1.0 / (double)this.nfft;
            this.nbins = this.nfft;
        } else {
            this.flags = 65;
            this.scale = 1.0 / (double)(4 * this.nfft);
            this.nbins = this.nfft / 2 + 1;
        }
        this.fft = new Fft(this.nfft, this.flags | 8);
        this.ifft = new Fft(this.nfft, this.flags | 0x10);
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        this.ho.setSize(size1 - (double)this.over + (double)this.pad1 + (double)this.pad2);
        double outXStart = this.pad ? this.hi.getXStart() - this.hf.getXStart() + (double)this.pad1 * this.hi.getXDelta() : this.hi.getXStart() - this.hf.getXStart();
        this.ho.setXStart(outXStart);
        if (this.cxm || this.mux) {
            this.ho.setFormatMode((byte)67);
        }
        String outFormat = (char)this.ho.getFormatMode() + "F";
        outFormat = Data.promoteFormat((String)this.hi.getFormat(), (String)this.hf.getFormat(), (String)outFormat);
        this.ho.setFormat(outFormat);
        this.ho.open();
        this.hi.setXferLength(this.nfft);
        this.hi.setConsLength(this.keep);
        String bufFormat = Data.promoteFormat((String)outFormat, (String)"CF", null);
        this.dbw = new Data(bufFormat, this.nbins);
        this.dbf = new Data(bufFormat, this.nbins);
        if (this.mux) {
            this.dbm = new Data(bufFormat, this.nfft);
        }
        return 0;
    }

    public int process() {
        int n;
        if (this.hf.avail() > 0.0) {
            this.loadFilter();
        }
        this.dbw.setSPA(this.hi.spa);
        if (this.pad1 > 0) {
            DataOp.zero((Data)this.dbw, (int)0, (int)this.pad1);
            this.dbw.boff = this.pad1 * this.dbw.bpe;
            this.hi.setXferLength(this.nfft - this.pad1);
            this.hi.setConsLength(this.keep - this.pad1);
        }
        if ((n = this.hi.read(this.dbw)) == 0) {
            return -1;
        }
        if (n < 0) {
            return 9;
        }
        if (this.pad1 > 0) {
            this.dbw.boff = 0;
            this.hi.setXferLength(this.nfft);
            this.hi.setConsLength(this.keep);
            n += this.pad1;
            this.pad1 = 0;
        }
        if (n < this.nfft) {
            if (n <= this.over && this.pad2 <= 0) {
                return 9;
            }
            DataOp.zero((Data)this.dbw, (int)n, (int)(this.nfft - n));
            n = Math.min(this.nfft, n + this.pad2);
        }
        if (this.cxm && this.hi.spa == 1) {
            DataOp.cmplx((Data)this.dbw, (Data)this.dbw, (int)this.nfft, (int)33);
        }
        if (this.mux) {
            DataOp.copy((Data)this.dbw, (int)(-this.bias * 4), (int)4, (Data)this.dbm, (int)0, (int)8, (int)4, (int)(n - this.over));
        }
        this.fft.work(this.dbw);
        this.dbw.setSPA(2);
        DataOp.mul((Data)this.dbw, (Data)this.dbf, (Data)this.dbw, (int)this.nbins, (int)674);
        this.ifft.work(this.dbw);
        if (this.mux) {
            this.dbw.setSPA(1);
            DataOp.copy((Data)this.dbw, (int)0, (int)4, (Data)this.dbm, (int)4, (int)8, (int)4, (int)(n - this.over));
            this.ho.write(this.dbm, n - this.over);
        } else {
            this.dbw.setSPA(this.ho.spa);
            this.ho.write(this.dbw, n - this.over);
        }
        return 0;
    }

    public int close() {
        this.fft.free();
        this.ifft.free();
        this.hi.close();
        this.hf.close();
        this.ho.close();
        return 0;
    }

    private void loadFilter() {
        float fscale = (float)this.scale;
        this.dbf.setSPA(this.hf.spa);
        int read = this.hf.read(this.dbf, this.nfir);
        this.over = read - 1;
        this.keep = this.nfft - this.over;
        if (this.pad) {
            this.pad1 = this.pad2 = this.over;
        }
        Data dbs = new Data(fscale *= this.MA.getF("/SCALE", 1.0f));
        DataOp.mul((Data)this.dbf, (Data)dbs, (Data)this.dbf, (int)read);
        if (this.cxm && this.hf.spa == 1) {
            DataOp.cmplx((Data)this.dbf, (Data)this.dbf, (int)this.nfft, (int)33);
        }
        this.fft.work(this.dbf);
        this.dbf.setSPA(2);
    }

    public int getNFft() {
        return this.nfft;
    }

    public void setNFft(int value) {
        if (value == this.nfft) {
            return;
        }
        this.MA.put("/NFFT", "" + value);
        this.setState(7);
    }
}

