/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import java.text.NumberFormat;
import java.util.StringTokenizer;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.ICEPacket;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libm.Fft;
import nxm.sys.libm.Window;

public class cyclofunc
extends Primitive {
    private static final int DEBUG_BASIC = 1;
    private static final int DEBUG_EXTRA = 2;
    private static final int DEBUG_STATROT = 4;
    private static final int DEBUG_FFT = 8;
    private static final int DEBUG_SXXPSD = 16;
    private static final int DEBUG_COHER = 32;
    private static final int DEBUG_NCOHER = 64;
    private static final int max_ncyclo = 10;
    private static final int max_fft_size = 4194394;
    private static final int med_fft_size = 1024;
    private static final int min_fft_size = 16;
    private static final int max_xlate_taps = 11;
    private static final float floorval = 1.0E-15f;
    private static final double sqrt2o2 = Math.sqrt(2.0) / 2.0;
    private static final String rptSubrecordFormat = "FILE/XA,NCYC/SD,FREQ/9D,FTSZ/SD,AVGS/SD,OVLP/SD,TTAG/SD,TDUR/SD,TINC/SD,SIZE/SD,SAMP/SD,MEAN/SD,MMAX/SD,MMIN/SD,VARI/SD,VMAX/SD,VMIN/SD";
    private DataFile hin;
    private DataFile hpsd;
    private DataFile hrpt;
    private ICEPacket pkt;
    private int debug;
    private int thinfact;
    private int thincnt;
    private boolean log_smooth;
    private boolean log_magout;
    private boolean log_normalize;
    private double dminpwr;
    private String c_wind;
    private int num_xlate_taps;
    private float rwhiten;
    private float rwhiten_avg;
    private double dsmooth;
    private int izerobins;
    private double dfrqbgn;
    private int ifrqbgn;
    private double dfrqend;
    private int ifrqend;
    private String name_realtime;
    private int mode_realtime;
    private int nfft;
    private double doverlap;
    private boolean log_navg;
    private int navg;
    private String c_navg;
    private int nacc_coher;
    private int nacc_coher_max;
    private int nacc_norm;
    private int nacc_norm_max;
    private int ncyclo;
    private double dxstart;
    private int isubsize;
    private CycRecord[] Cyc;
    private DataFile[] hCyc;
    private Data grab;
    private float[] win;
    private Data sxx;
    private Data psd;
    private Data wddat;
    private double dcons_len;
    private double dfsamp;
    private Table Rpt;
    private Fft fft;
    String name_navg;
    private int gnum = 0;
    private double ttag = 0.0;
    private double dst_rsum;
    private double dst_isum;
    private double dst_sqsum;
    Statistics Stat;
    private boolean log_gate;
    private boolean log_init_psd;
    private boolean log_init_sxx;
    private boolean log_init_sxy;
    private boolean log_init_nmsxy;

    public int open() {
        int i;
        StringTokenizer tokens3;
        this.debug = this.MA.getL("/DEBUG");
        if (-1 == this.debug) {
            this.debug = 0;
        }
        if (0 != (this.debug & 2)) {
            this.debug |= 1;
        }
        this.log_smooth = this.MA.find("/SMOOTH");
        this.log_magout = this.MA.find("/MAGOUT");
        this.log_normalize = this.MA.find("/NORM");
        this.dminpwr = this.MA.getD("/MINPWR", 1.0E-20);
        this.c_wind = this.MA.getString("/WIND", "BH61", 0);
        this.num_xlate_taps = this.MA.getL("/NTAPS", 5);
        if (this.num_xlate_taps % 2 == 0) {
            ++this.num_xlate_taps;
            this.num_xlate_taps = Math.min(Math.max(3, this.num_xlate_taps), 11);
        }
        this.rwhiten = (float)this.MA.getD("/WHITE", 1.0000000036274937E-14);
        this.rwhiten = (float)Math.min(Math.max(0.0, (double)this.rwhiten), 1.0);
        this.dsmooth = this.MA.getD("/SMOOTH", 0.1);
        if (1.0 == this.dsmooth) {
            this.dsmooth = 0.1;
        }
        this.dsmooth = Math.min(Math.max(0.0, this.dsmooth), 1.0);
        this.izerobins = this.MA.getL("/ZEROBINS", 3);
        this.izerobins = Math.min(Math.max(0, this.izerobins), 16);
        if (this.MA.find("/FRQBGN")) {
            this.dfrqbgn = this.MA.getD("/FRQBGN");
            this.ifrqbgn = 0;
        } else {
            this.dfrqbgn = 0.0;
            this.ifrqbgn = -1;
        }
        if (this.MA.find("/FRQEND")) {
            this.dfrqend = this.MA.getD("/FRQEND");
            this.ifrqend = 0;
        } else {
            this.dfrqend = 0.0;
            this.ifrqend = -1;
        }
        if (this.MA.find("/REALTIME")) {
            this.name_realtime = this.MA.getU("/REALTIME");
            this.mode_realtime = this.name_realtime.length() > 0 ? 2 : 1;
        } else {
            this.mode_realtime = 0;
        }
        this.thinfact = this.MA.getL("/THINFACT", 1);
        this.thinfact = Math.max(1, this.thinfact);
        this.thincnt = 0;
        this.hin = this.MA.getDataFile("IN", "1000|2000", "S#|C#|-SP|-CP", 0);
        this.hin.open();
        if (this.hin.typeClass > 1) {
            this.hin.setType(1000);
        }
        this.pkt = (ICEPacket)this.hin.getPacketHandler();
        if (this.pkt == null) {
            this.M.info((CharSequence)("Input file is not packetized: " + this.hin.getTag()));
        }
        this.nfft = this.MA.getL("NFFT");
        if (this.nfft <= 1) {
            this.nfft = 1024;
        }
        this.nfft = Math.min(4194394, Math.max(16, this.nfft));
        if (0 != (this.debug & 1)) {
            this.M.info((CharSequence)("FFT size: " + this.nfft));
        }
        this.grab = this.hin.getDataBuffer(this.nfft);
        this.doverlap = this.MA.getD("OVERLAP", 0.0);
        this.doverlap = Math.min(Math.max(0.0, this.doverlap), 0.999999);
        if (0 != (this.debug & 1)) {
            this.M.info((CharSequence)("Overlap: " + this.doverlap));
        }
        this.name_navg = this.MA.getU("INTEGRATE");
        this.c_navg = this.MR.getS(this.name_navg);
        if (null != this.c_navg) {
            this.log_navg = true;
        } else {
            this.c_navg = this.name_navg;
            this.log_navg = false;
        }
        String noBars = this.c_navg.replace('|', ' ');
        String noQuotes = noBars.replace('\"', ' ');
        this.nacc_coher_max = 0;
        this.nacc_norm_max = 0;
        try {
            StringTokenizer tokens2 = new StringTokenizer(noQuotes);
            this.nacc_coher_max = Integer.parseInt(tokens2.nextToken());
            this.nacc_norm_max = Integer.parseInt(tokens2.nextToken());
        }
        catch (Exception e) {
            this.M.warning((CharSequence)"Invalid integration parameter");
        }
        this.nacc_coher_max = Math.min(Math.max(1, this.nacc_coher_max), Integer.MAX_VALUE);
        this.nacc_norm_max = Math.min(Math.max(1, this.nacc_norm_max), Integer.MAX_VALUE);
        this.navg = (int)Math.min((double)this.nacc_coher_max * (double)this.nacc_norm_max, 2.147483647E9);
        this.rwhiten_avg = this.rwhiten * (float)this.nacc_coher_max * (float)this.nacc_coher_max;
        if (0 != (this.debug & 2)) {
            this.M.info((CharSequence)("navg,ncoher,nnorm: " + this.navg + " " + this.nacc_coher_max + " " + this.nacc_norm_max));
        }
        this.ncyclo = 0;
        String cycloParam = this.MA.getU("CFREQ");
        try {
            tokens3 = new StringTokenizer(cycloParam, "|");
            while (tokens3.hasMoreTokens()) {
                ++this.ncyclo;
                tokens3.nextToken();
            }
        }
        catch (Exception tokens3) {
            // empty catch block
        }
        if (this.ncyclo > 10) {
            this.ncyclo = 10;
            this.M.warning((CharSequence)"Too many cycle frequencies specified.");
        }
        this.Cyc = new CycRecord[this.ncyclo];
        try {
            tokens3 = new StringTokenizer(cycloParam, "|");
            for (int cycloNum = 0; cycloNum < this.ncyclo; ++cycloNum) {
                this.Cyc[cycloNum] = new CycRecord();
                this.Cyc[cycloNum].nmrslt = tokens3.nextToken();
                if (null == this.MR.get(this.Cyc[cycloNum].nmrslt)) {
                    this.Cyc[cycloNum].isrslt = false;
                    this.Cyc[cycloNum].cycfreq = Double.parseDouble(this.Cyc[cycloNum].nmrslt);
                    continue;
                }
                this.Cyc[cycloNum].isrslt = true;
                this.Cyc[cycloNum].cycfreq = this.MR.getD(this.Cyc[cycloNum].nmrslt);
            }
        }
        catch (Exception tokens4) {
            // empty catch block
        }
        if (0 != (this.debug & 2)) {
            this.M.info((CharSequence)("ncyclo: " + this.ncyclo));
            for (int i2 = 0; i2 < this.ncyclo; ++i2) {
                this.M.info((CharSequence)(this.Cyc[i2].nmrslt + "\t" + this.Cyc[i2].isrslt + "\t" + this.Cyc[i2].cycfreq));
            }
        }
        int fftFlags = 8;
        if (this.hin.getFormatMode() == 67) {
            this.dxstart = -((double)(this.nfft / 2 - 1)) / (this.hin.getXDelta() * (double)this.nfft);
            this.isubsize = this.nfft;
            fftFlags |= 2;
        } else {
            this.dxstart = 0.0;
            this.isubsize = this.nfft / 2 + 1;
            fftFlags |= 1;
        }
        this.fft = new Fft();
        this.fft.init(this.nfft, fftFlags);
        this.hCyc = new DataFile[this.ncyclo];
        for (i = 0; i < this.ncyclo; ++i) {
            String fileName = this.MA.getS("OUT");
            if (this.ncyclo > 1) {
                NumberFormat f = NumberFormat.getInstance();
                f.setMinimumIntegerDigits(2);
                fileName = fileName + "_" + f.format(i + 1);
            }
            this.hCyc[i] = this.log_magout ? new DataFile((MidasReference)this.M, (Object)fileName, "2000", "SF", 66, 1.0, null) : new DataFile((MidasReference)this.M, (Object)fileName, "2000", "CF", 66, 1.0, null);
            this.hCyc[i].setXDelta(1.0 / (this.hin.getXDelta() * (double)this.nfft));
            this.hCyc[i].setXStart(this.dxstart);
            this.hCyc[i].setXUnits(3);
            this.hCyc[i].setYDelta(this.hin.getXDelta() * (1.0 - this.doverlap) * (double)(this.nfft * this.navg));
            this.hCyc[i].setYStart(this.hin.getXStart() + 0.5 * this.hCyc[i].getYDelta());
            this.hCyc[i].setYUnits(1);
            this.hCyc[i].setSubSize(this.isubsize);
            this.hCyc[i].setTimeCode(this.hin.getTimeCode());
            this.hCyc[i].open();
        }
        this.hpsd = this.MA.getDataFile("PSDOUT", "2000", "SF", 66, 1.0, null);
        this.hpsd.setXDelta(1.0 / (this.hin.getXDelta() * (double)this.nfft));
        this.hpsd.setXStart(this.dxstart);
        this.hpsd.setXUnits(3);
        this.hpsd.setYDelta(this.hin.getXDelta() * (1.0 - this.doverlap) * (double)(this.nfft * this.navg));
        this.hpsd.setYStart(this.hin.getXStart() + 0.5 * this.hpsd.getYDelta());
        this.hpsd.setYUnits(1);
        this.hpsd.setSubSize(this.isubsize);
        this.hpsd.setTimeCode(this.hin.getTimeCode());
        this.hpsd.open();
        this.hrpt = this.MA.getDataFile("RPTOUT", null, 66);
        this.hrpt.setXDelta(this.hin.getXDelta() * (1.0 - this.doverlap) * (double)(this.nfft * this.navg));
        this.hrpt.setXStart(this.hin.getXStart() + 0.5 * this.hrpt.getYDelta());
        this.hrpt.setType(3000);
        this.hrpt.setSubRecords(rptSubrecordFormat);
        this.hrpt.setTimeCode(this.hin.getTimeCode());
        this.hrpt.open();
        this.sxx = new Data("SF", this.nfft);
        this.psd = this.hpsd.getDataBuffer(this.hpsd.getSubSize());
        this.wddat = this.hin.getFormatMode() == 67 ? new Data("CF", this.nfft) : new Data("SF", this.nfft + 2);
        for (i = 0; i < this.ncyclo; ++i) {
            this.Cyc[i].cnmsxy = new Data("CF", this.hCyc[i].getSubSize());
            this.Cyc[i].mag = new Data("SF", this.hCyc[i].getSubSize());
            this.Cyc[i].csxy = new Data("CF", this.hCyc[i].getSubSize());
            this.Cyc[i].syy = new Data("SF", this.hCyc[i].getSubSize());
        }
        this.win = Window.get((String)this.c_wind, (int)this.nfft, (double)(1.0 / (double)(this.nfft * this.navg)));
        if (this.ifrqbgn == -1) {
            this.dfrqbgn = this.hpsd.getXStart();
        }
        if (this.ifrqend == -1) {
            this.dfrqend = this.hpsd.getXStart() + (double)(this.hpsd.getFrameSize() - 1) * this.hpsd.getXDelta();
        }
        this.dfrqbgn = (this.dfrqbgn - this.hpsd.getXStart()) / Math.max(1.0E-20, this.hpsd.getXDelta());
        this.dfrqend = (this.dfrqend - this.hpsd.getXStart()) / Math.max(1.0E-20, this.hpsd.getXDelta());
        this.ifrqbgn = (int)Math.min(Math.max(0.0, this.dfrqbgn), 2.147483647E9);
        this.ifrqend = (int)Math.min(Math.max(0.0, this.dfrqend), 2.147483647E9);
        this.ifrqbgn = Math.min(Math.max(0, this.ifrqbgn), this.hpsd.getFrameSize() - 1);
        this.ifrqend = Math.min(Math.max(0, this.ifrqend), this.hpsd.getFrameSize() - 1);
        this.ifrqbgn = Math.min(this.ifrqbgn, this.ifrqend);
        if (0 != (this.debug & 2)) {
            this.M.info((CharSequence)("Freq Start/Stop Bins: " + this.ifrqbgn + "\t" + this.ifrqend));
        }
        this.hin.setXferLength(this.nfft);
        if (this.doverlap > 0.0) {
            this.hin.setConsLength((int)((1.0 - this.doverlap) * (double)this.nfft));
            this.dcons_len = this.hin.getConsLength();
        } else {
            this.hin.setConsLength(-1);
            this.dcons_len = (int)((1.0 - this.doverlap) * (double)this.nfft);
        }
        for (i = 0; i < this.ncyclo; ++i) {
            this.Cyc[i].ntaps = this.num_xlate_taps;
            this.Cyc[i].nshift = this.gen_xlate_taps(this.Cyc[i].cxlo, this.Cyc[i].ntaps, this.Cyc[i].cycfreq, this.hin.getXDelta());
        }
        this.dfsamp = 1.0 / this.hin.getXDelta();
        for (i = 0; i < this.ncyclo; ++i) {
            this.Cyc[i].nsmth = (int)(this.dsmooth * this.Cyc[i].cycfreq / (this.dfsamp / (double)this.nfft));
            this.Cyc[i].nsmth = Math.min(Math.max(1, this.Cyc[i].nsmth), this.Cyc[i].nshift);
            this.Cyc[i].blkphas = 0.0;
            if (0 == (this.debug & 1)) continue;
            this.M.info((CharSequence)("Bin offset: " + this.Cyc[i].nshift + "\t" + this.Cyc[i].nsmth));
        }
        this.Rpt = new Table(2);
        try {
            StringTokenizer tokens5 = new StringTokenizer(rptSubrecordFormat, ",");
            while (tokens5.hasMoreTokens()) {
                StringTokenizer key = new StringTokenizer(tokens5.nextToken(), "/");
                this.Rpt.setKey(key.nextToken(), (Object)key.nextToken());
            }
        }
        catch (Exception e) {
            this.M.info((CharSequence)"Error parsing FILE/XA,NCYC/SD,FREQ/9D,FTSZ/SD,AVGS/SD,OVLP/SD,TTAG/SD,TDUR/SD,TINC/SD,SIZE/SD,SAMP/SD,MEAN/SD,MMAX/SD,MMIN/SD,VARI/SD,VMAX/SD,VMIN/SD");
        }
        this.Rpt.put("FILE", (Object)(this.hin.getURL().length() < 80 ? this.hin.getURL() : this.hin.getURL().substring(0, 80)));
        this.Rpt.put("NCYC", this.ncyclo);
        this.Rpt.put("FREQ", 0);
        this.Rpt.put("FTSZ", (double)this.nfft);
        this.Rpt.put("AVGS", (double)this.navg);
        this.Rpt.put("OVLP", this.doverlap);
        this.Rpt.put("TTAG", 0.0);
        this.ttag = 0.0;
        this.Rpt.put("TDUR", 0.0);
        this.Rpt.put("TINC", 0.0);
        this.Rpt.put("SIZE", 0.0);
        this.Rpt.put("SAMP", 0.0);
        this.Rpt.put("MEAN", 0.0);
        this.Rpt.put("MMAX", 0.0);
        this.Rpt.put("MMIN", 0.0);
        this.Rpt.put("VARI", 0.0);
        this.Rpt.put("VMAX", 0.0);
        this.Rpt.put("VMIN", 0.0);
        if (this.mode_realtime == 2) {
            this.Rpt.put("SIZE", -1.0);
            if (null == this.MR.get(this.name_realtime)) {
                this.M.warning((CharSequence)("Time result not found: " + this.name_realtime));
            } else {
                this.Rpt.put("TTAG", this.MR.getD(this.name_realtime));
            }
        } else if (this.mode_realtime == 1) {
            this.Rpt.put("SIZE", -1.0);
            this.Rpt.put("TTAG", Time.current());
        } else {
            this.Rpt.put("SIZE", this.hin.getSize());
            this.ttag = this.hin.getXStart() + (this.hin.getOffset() - (1.0 - this.doverlap) * (double)(this.nfft * this.navg)) * this.hin.getXDelta();
            this.Rpt.put("TTAG", this.ttag);
        }
        this.Rpt.put("TDUR", this.hpsd.getYDelta());
        this.Rpt.put("TINC", this.hin.getXDelta());
        this.Rpt.put("SAMP", this.hin.getOffset());
        this.Stat = new Statistics();
        this.dst_rsum = 0.0;
        this.dst_isum = 0.0;
        this.dst_sqsum = 0.0;
        this.log_gate = false;
        this.log_init_psd = true;
        this.log_init_sxx = true;
        this.log_init_sxy = true;
        this.log_init_nmsxy = true;
        this.nacc_coher = 0;
        this.nacc_norm = 0;
        return 0;
    }

    public int process() {
        int n = this.hin.read(this.grab);
        ++this.thincnt;
        if (this.thincnt < this.thinfact) {
            return -1;
        }
        this.thincnt = 0;
        ++this.gnum;
        if (0 != (this.debug & 0x7C)) {
            this.M.info((CharSequence)"**************************************************************");
            this.M.info((CharSequence)("grab " + this.gnum + " got " + n));
        }
        if (n > 0) {
            int i;
            int i2;
            float[] x;
            int istat = this.win_stat_rot(this.win, this.grab, this.wddat, n);
            if (0 != (this.debug & 4)) {
                int i3;
                this.M.info((CharSequence)"wddat after win_stat_rot");
                x = this.wddat.castF(true);
                if (this.hin.getFormatMode() == 67) {
                    for (i3 = 0; i3 < 10; ++i3) {
                        this.M.info((CharSequence)("  " + i3 + ", (" + x[2 * i3] + "," + x[2 * i3 + 1] + ")"));
                    }
                    if (n < this.nfft) {
                        for (i3 = n - 5; i3 < n + 5; ++i3) {
                            this.M.info((CharSequence)("  " + i3 + ", (" + x[2 * i3] + "," + x[2 * i3 + 1] + ")"));
                        }
                    }
                    for (i3 = this.nfft - 10; i3 < this.nfft; ++i3) {
                        this.M.info((CharSequence)("  " + i3 + ", (" + x[2 * i3] + "," + x[2 * i3 + 1] + ")"));
                    }
                } else {
                    for (i3 = 0; i3 < 10; ++i3) {
                        this.M.info((CharSequence)("  " + i3 + ", " + x[i3]));
                    }
                    if (n < this.nfft) {
                        for (i3 = n - 5; i3 < n + 5; ++i3) {
                            this.M.info((CharSequence)("  " + i3 + ", " + x[i3]));
                        }
                    }
                    for (i3 = this.nfft - 10; i3 < this.nfft; ++i3) {
                        this.M.info((CharSequence)("  " + i3 + ", " + x[i3]));
                    }
                }
                this.wddat.uncast(x, true);
            }
            this.Stat.mean += this.dst_rsum;
            this.Stat.vari += this.dst_sqsum;
            this.Stat.ntot += this.nfft;
            this.Stat.nsub = this.nfft;
            if (0 != (this.debug & 4)) {
                this.M.info((CharSequence)("Stat.mean " + this.Stat.mean));
                this.M.info((CharSequence)("Stat.vari " + this.Stat.vari));
                this.M.info((CharSequence)("Stat.ntot " + this.Stat.ntot));
                this.M.info((CharSequence)("Stat.nsub " + this.Stat.nsub));
            }
            if (this.dst_rsum > this.Stat.mmax) {
                this.Stat.mmax = this.dst_rsum;
            }
            if (this.dst_rsum < this.Stat.mmin) {
                this.Stat.mmin = this.dst_rsum;
            }
            if (this.dst_sqsum > this.Stat.vmax) {
                this.Stat.vmax = this.dst_sqsum;
            }
            if (this.dst_sqsum < this.Stat.vmin) {
                this.Stat.vmin = this.dst_sqsum;
            }
            if (istat < 0) {
                this.M.warning((CharSequence)("Unknown input data type: " + this.hin.getFormat()));
            }
            this.log_gate = !(this.dst_sqsum > (double)this.nfft * this.dminpwr);
            if (!this.log_gate) {
                this.fft.work(this.wddat);
                if (this.hin.getFormatMode() == 67) {
                    float b0r = this.wddat.getF(0);
                    float b0i = this.wddat.getF(1);
                    DataOp.copy((Data)this.wddat, (int)1, (Data)this.wddat, (int)0, (int)(this.wddat.getSize() - 1));
                    this.wddat.setF(2 * (this.wddat.getSize() - 1), b0r);
                    this.wddat.setF(2 * (this.wddat.getSize() - 1) + 1, b0i);
                } else {
                    x = this.wddat.castF(true);
                    x[this.nfft] = x[1];
                    x[1] = 0.0f;
                    this.wddat.uncast(x, true);
                }
                if (0 != (this.debug & 8)) {
                    int j;
                    this.M.info((CharSequence)"after fft");
                    float[] x2 = this.wddat.castF(true);
                    for (j = 0; j < 10; ++j) {
                        System.out.println(j + "\t(" + x2[2 * j] + "," + x2[2 * j + 1] + ")");
                    }
                    for (j = this.nfft - 10; j < this.nfft; ++j) {
                        System.out.println(j + "\t(" + x2[2 * j] + "," + x2[2 * j + 1] + ")");
                    }
                    this.wddat.uncast(x2, true);
                }
                float ftemp = 1.0f;
                if (this.log_normalize) {
                    ftemp = (float)(1.0 / Math.sqrt(Math.max(1.0E-20, this.dst_sqsum / (double)this.Stat.nsub)));
                }
                istat = this.accum_sxx_psd(this.wddat, this.sxx, this.psd, ftemp, this.hpsd.getSubSize(), this.izerobins);
                if (0 != (this.debug & 0x10)) {
                    this.M.info((CharSequence)"after accum_sxx_psd");
                    this.M.info((CharSequence)"sxx");
                    float[] x3 = this.sxx.castF(true);
                    for (i2 = 0; i2 < 20; ++i2) {
                        this.M.info((CharSequence)("\t" + i2 + "\t" + x3[i2]));
                    }
                    for (i2 = this.hpsd.getSubSize() - 10; i2 < this.hpsd.getSubSize(); ++i2) {
                        this.M.info((CharSequence)("\t" + i2 + "\t" + x3[i2]));
                    }
                    this.sxx.uncast(x3, true);
                    this.M.info((CharSequence)"psd");
                    x3 = this.psd.castF(true);
                    for (i2 = 0; i2 < 10; ++i2) {
                        this.M.info((CharSequence)("\t" + i2 + "\t" + x3[i2]));
                    }
                    for (i2 = this.hpsd.getSubSize() - 10; i2 < this.hpsd.getSubSize(); ++i2) {
                        this.M.info((CharSequence)("\t" + i2 + "\t" + x3[i2]));
                    }
                    this.psd.uncast(x3, true);
                }
            }
            ++this.nacc_coher;
            for (i = 0; i < this.ncyclo; ++i) {
                if (0 != (this.debug & 0x60)) {
                    this.M.info((CharSequence)("cycle\t" + i));
                }
                this.Cyc[i].blkphas = (this.Cyc[i].blkphas - this.Cyc[i].cycfreq * this.hin.getXDelta() * this.dcons_len) % 1.0;
                if (!this.log_gate) {
                    float[] cxphase = new float[]{(float)Math.cos(this.Cyc[i].blkphas * (Math.PI * 2)), (float)Math.sin(this.Cyc[i].blkphas * (Math.PI * 2))};
                    if (0 != (this.debug & 0x20)) {
                        this.M.info((CharSequence)(" blkphas (" + cxphase[0] + "," + cxphase[1] + ")"));
                    }
                    istat = this.accum_coher(this.wddat, this.Cyc[i].csxy, this.Cyc[i].syy, this.Cyc[i], cxphase, this.hCyc[i].getSubSize(), this.nacc_coher_max, this.ifrqbgn, this.ifrqend);
                    if (i >= this.ncyclo - 1) {
                        this.log_init_sxy = false;
                    }
                }
                if (this.nacc_coher < this.nacc_coher_max) continue;
                if (!this.log_gate) {
                    istat = this.accum_norm(this.Cyc[i].csxy, this.sxx, this.Cyc[i].syy, this.Cyc[i].cnmsxy, this.Cyc[i], this.hCyc[i].getSubSize(), this.nacc_coher_max, this.nacc_norm_max, this.rwhiten_avg, this.ifrqbgn, this.ifrqend);
                    if (i >= this.ncyclo - 1) {
                        this.log_init_nmsxy = false;
                    }
                }
                if (i < this.ncyclo - 1) continue;
                this.log_init_sxx = true;
                this.log_init_sxy = true;
                this.nacc_coher = 0;
                ++this.nacc_norm;
            }
            if (this.nacc_norm >= this.nacc_norm_max) {
                String aaval;
                for (i = 0; i < this.ncyclo; ++i) {
                    if (this.log_init_nmsxy) {
                        DataOp.zero((Data)this.Cyc[i].cnmsxy, (int)0, (int)this.Cyc[i].cnmsxy.getSize());
                    } else if (this.log_smooth || this.log_magout) {
                        istat = this.clean_cycspec(this.Cyc[i].cnmsxy, this.Cyc[i].mag, this.hCyc[i].getSubSize(), this.ifrqbgn, this.ifrqend, this.Cyc[i].nsmth, this.log_smooth, this.log_magout);
                    }
                    if (this.hCyc[i].getFormat().startsWith("C")) {
                        this.hCyc[i].write(this.Cyc[i].cnmsxy, 1);
                        continue;
                    }
                    this.hCyc[i].write(this.Cyc[i].mag, 1);
                }
                if (this.log_init_psd) {
                    double ftemp = this.dminpwr / (double)Math.max(1, this.navg * this.nfft);
                    ftemp = 0.2021311785 * ftemp * ftemp;
                    DataOp.fill((Data)this.psd, (int)0, (double)ftemp, (int)this.hpsd.getSubSize());
                }
                if (this.izerobins > 0) {
                    DataOp.fill((Data)this.psd, (int)0, (double)this.psd.getF(this.izerobins), (int)this.izerobins);
                    DataOp.fill((Data)this.psd, (int)(this.hpsd.getSubSize() - this.izerobins), (double)this.psd.getF(this.hpsd.getSubSize() - this.izerobins - 1), (int)this.izerobins);
                }
                this.hpsd.write(this.psd, 1);
                if (this.hrpt.isOpen()) {
                    double mean = this.Stat.mean / Math.max(1.0, (double)this.Stat.ntot);
                    this.Rpt.put("MEAN", mean);
                    this.Rpt.put("VARI", this.Stat.vari - mean * mean);
                    this.Rpt.put("MMAX", this.Stat.mmax / Math.max(1.0, (double)this.Stat.nsub));
                    this.Rpt.put("mmin", this.Stat.mmin / Math.max(1.0, (double)this.Stat.nsub));
                    this.Rpt.put("vmax", this.Stat.vmax / Math.max(1.0, (double)this.Stat.nsub));
                    this.Rpt.put("vmin", this.Stat.vmin / Math.max(1.0, (double)this.Stat.nsub));
                    for (i2 = 0; i2 < this.ncyclo; ++i2) {
                        String f1 = new String("FREQ(");
                        String f2 = f1.concat(String.valueOf(i2));
                        String f3 = f2.concat(")");
                        this.Rpt.put(f3, this.Cyc[i2].cycfreq);
                    }
                    this.Rpt.put("AVGS", this.navg);
                    this.Rpt.put("SAMP", this.hin.getOffset());
                    switch (this.mode_realtime) {
                        case 2: {
                            this.Rpt.put("SIZE", -1.0);
                            this.Rpt.put("TTAG", 0.0);
                            break;
                        }
                        case 1: {
                            this.Rpt.put("SIZE", -1.0);
                            this.ttag += Time.current();
                            this.Rpt.put("TTAG", this.ttag);
                            break;
                        }
                        case 0: {
                            this.Rpt.put("SIZE", this.hin.getSize());
                            this.ttag = this.hin.getXStart() + (this.hin.getOffset() - (1.0 - this.doverlap) * (double)(this.nfft * this.navg)) * this.hin.getXDelta();
                            this.Rpt.put("TTAG", this.ttag);
                        }
                    }
                    this.hrpt.setData(this.hrpt.getOffset(), this.Rpt);
                    this.Stat.mean = 0.0;
                    this.Stat.mmax = -1.0E20;
                    this.Stat.mmin = 1.0E20;
                    this.Stat.vari = 0.0;
                    this.Stat.vmax = -1.0E20;
                    this.Stat.vmin = 1.0E20;
                    this.Stat.ntot = 0;
                    this.Stat.nsub = this.nfft;
                }
                for (int i4 = 0; i4 < this.ncyclo; ++i4) {
                    double ddval;
                    if (!this.Cyc[i4].isrslt || !(Math.abs(this.Cyc[i4].cycfreq - (ddval = this.MR.getD(this.Cyc[i4].nmrslt))) >= 1.0E-10)) continue;
                    this.Cyc[i4].cycfreq = ddval;
                    this.Cyc[i4].nshift = this.gen_xlate_taps(this.Cyc[i4].cxlo, this.Cyc[i4].ntaps, this.Cyc[i4].cycfreq, this.hin.getXDelta());
                    this.Cyc[i4].blkphas = 0.0;
                    this.Cyc[i4].nsmth = (int)(this.dsmooth * this.Cyc[i4].cycfreq / (this.dfsamp / (double)this.nfft));
                    this.Cyc[i4].nsmth = Math.min(Math.max(1, this.Cyc[i4].nsmth), this.Cyc[i4].nshift);
                    DataOp.fill((Data)this.Cyc[i4].cnmsxy, (int)0, (double)0.0, (int)this.Cyc[i4].cnmsxy.getSize());
                    DataOp.fill((Data)this.Cyc[i4].csxy, (int)0, (double)0.0, (int)this.Cyc[i4].csxy.getSize());
                    DataOp.fill((Data)this.Cyc[i4].syy, (int)0, (double)0.0, (int)this.Cyc[i4].syy.getSize());
                }
                if (this.log_navg && 0 != (aaval = this.MR.getS(this.name_navg)).compareTo(this.c_navg)) {
                    this.c_navg = aaval;
                    String noBars = this.c_navg.replace('|', ' ');
                    String noQuotes = noBars.replace('\"', ' ');
                    this.nacc_coher_max = 0;
                    this.nacc_norm_max = 0;
                    try {
                        StringTokenizer tokens = new StringTokenizer(noQuotes);
                        this.nacc_coher_max = Integer.parseInt(tokens.nextToken());
                        this.nacc_norm_max = Integer.parseInt(tokens.nextToken());
                    }
                    catch (Exception e) {
                        this.M.warning((CharSequence)"Invalid integration parameter");
                    }
                    this.nacc_coher_max = Math.min(Math.max(1, this.nacc_coher_max), Integer.MAX_VALUE);
                    this.nacc_norm_max = Math.min(Math.max(1, this.nacc_norm_max), Integer.MAX_VALUE);
                    this.navg = (int)Math.min((double)this.nacc_coher_max * (double)this.nacc_norm_max, 2.147483647E9);
                    this.rwhiten_avg = this.rwhiten * (float)this.nacc_coher_max * (float)this.nacc_coher_max;
                    this.win = Window.get((String)this.c_wind, (int)this.nfft, (double)(1.0 / (double)(this.nfft * this.navg)));
                }
                this.log_init_psd = true;
                this.log_init_sxx = true;
                this.log_init_sxy = true;
                this.log_init_nmsxy = true;
                this.nacc_coher = 0;
                this.nacc_norm = 0;
            }
        } else {
            if (n == 0) {
                return -1;
            }
            return 9;
        }
        return 0;
    }

    public int close() {
        this.hin.close();
        for (int i = 0; i < this.ncyclo; ++i) {
            this.hCyc[i].close();
        }
        this.hpsd.close();
        this.hrpt.close();
        return 0;
    }

    int win_stat_rot(float[] awin, Data dadat, Data daout, int n) {
        int ci;
        int i;
        int retVal = n;
        if (0 != (this.debug & 4)) {
            this.M.info((CharSequence)("win_stat_rot nelem " + n + ", n " + daout.getSize()));
        }
        float[] asfout = daout.castF(true);
        this.dst_rsum = 0.0;
        this.dst_isum = 0.0;
        this.dst_sqsum = 0.0;
        String cfmt = dadat.getFormat();
        if (cfmt.startsWith("SF")) {
            float[] sfbuf = dadat.castF(true);
            for (i = 0; i < n; ++i) {
                this.dst_rsum += (double)sfbuf[i];
                this.dst_sqsum += (double)(sfbuf[i] * sfbuf[i]);
                asfout[i] = awin[i] * sfbuf[i];
            }
            dadat.uncast(sfbuf, true);
        } else if (cfmt.startsWith("SB")) {
            byte[] sbbuf = dadat.castB(true);
            for (i = 0; i < n; ++i) {
                asfout[i] = sbbuf[i];
                this.dst_rsum += (double)asfout[i];
                this.dst_sqsum += (double)(asfout[i] * asfout[i]);
                asfout[i] = awin[i] * asfout[i];
            }
            dadat.uncast(sbbuf, true);
        } else if (cfmt.startsWith("SI")) {
            short[] sibuf = dadat.castI(true);
            for (i = 0; i < n; ++i) {
                asfout[i] = sibuf[i];
                this.dst_rsum += (double)asfout[i];
                this.dst_sqsum += (double)(asfout[i] * asfout[i]);
                asfout[i] = awin[i] * asfout[i];
            }
            dadat.uncast(sibuf, true);
        } else if (cfmt.startsWith("SL")) {
            int[] slbuf = dadat.castL(true);
            for (i = 0; i < n; ++i) {
                asfout[i] = slbuf[i];
                this.dst_rsum += (double)asfout[i];
                this.dst_sqsum += (double)(asfout[i] * asfout[i]);
                asfout[i] = awin[i] * asfout[i];
            }
            dadat.uncast(slbuf, true);
        } else if (cfmt.startsWith("SD")) {
            double[] sdbuf = dadat.castD(true);
            for (i = 0; i < n; ++i) {
                asfout[i] = (float)sdbuf[i];
                this.dst_rsum += (double)asfout[i];
                this.dst_sqsum += (double)(asfout[i] * asfout[i]);
                asfout[i] = awin[i] * asfout[i];
            }
            dadat.uncast(sdbuf, true);
        } else if (cfmt.startsWith("CB")) {
            byte[] sbbuf = dadat.castB(true);
            for (i = 0; i < n; i += 2) {
                ci = i * 2;
                asfout[ci] = sbbuf[ci];
                asfout[ci + 1] = sbbuf[ci + 1];
                this.dst_rsum += (double)asfout[ci];
                this.dst_isum += (double)asfout[ci + 1];
                this.dst_sqsum += (double)(asfout[ci] * asfout[ci] + asfout[ci + 1] * asfout[ci + 1]);
                asfout[ci] = awin[i] * asfout[ci];
                asfout[ci + 1] = awin[i] * asfout[ci + 1];
                asfout[ci += 2] = sbbuf[ci];
                asfout[ci + 1] = sbbuf[ci + 1];
                this.dst_rsum += (double)asfout[ci];
                this.dst_isum += (double)asfout[ci + 1];
                this.dst_sqsum += (double)(asfout[ci] * asfout[ci] + asfout[ci + 1] * asfout[ci + 1]);
                asfout[ci] = -awin[i + 1] * asfout[ci];
                asfout[ci + 1] = -awin[i + 1] * asfout[ci + 1];
            }
            dadat.uncast(sbbuf, true);
        } else if (cfmt.startsWith("CI")) {
            short[] sibuf = dadat.castI(true);
            for (i = 0; i < n; i += 2) {
                ci = i * 2;
                asfout[ci] = sibuf[ci];
                asfout[ci + 1] = sibuf[ci + 1];
                this.dst_rsum += (double)asfout[ci];
                this.dst_isum += (double)asfout[ci + 1];
                this.dst_sqsum += (double)(asfout[ci] * asfout[ci] + asfout[ci + 1] * asfout[ci + 1]);
                asfout[ci] = awin[i] * asfout[ci];
                asfout[ci + 1] = awin[i] * asfout[ci + 1];
                asfout[ci += 2] = sibuf[ci];
                asfout[ci + 1] = sibuf[ci + 1];
                this.dst_rsum += (double)asfout[ci];
                this.dst_isum += (double)asfout[ci + 1];
                this.dst_sqsum += (double)(asfout[ci] * asfout[ci] + asfout[ci + 1] * asfout[ci + 1]);
                asfout[ci] = -awin[i + 1] * asfout[ci];
                asfout[ci + 1] = -awin[i + 1] * asfout[ci + 1];
            }
            dadat.uncast(sibuf, true);
        } else if (cfmt.startsWith("CL")) {
            int[] slbuf = dadat.castL(true);
            for (i = 0; i < n; i += 2) {
                ci = i * 2;
                asfout[ci] = slbuf[ci];
                asfout[ci + 1] = slbuf[ci + 1];
                this.dst_rsum += (double)asfout[ci];
                this.dst_isum += (double)asfout[ci + 1];
                this.dst_sqsum += (double)(asfout[ci] * asfout[ci] + asfout[ci + 1] * asfout[ci + 1]);
                asfout[ci] = awin[i] * asfout[ci];
                asfout[ci + 1] = awin[i] * asfout[ci + 1];
                asfout[ci += 2] = slbuf[ci];
                asfout[ci + 1] = slbuf[ci + 1];
                this.dst_rsum += (double)asfout[ci];
                this.dst_isum += (double)asfout[ci + 1];
                this.dst_sqsum += (double)(asfout[ci] * asfout[ci] + asfout[ci + 1] * asfout[ci + 1]);
                asfout[ci] = -awin[i + 1] * asfout[ci];
                asfout[ci + 1] = -awin[i + 1] * asfout[ci + 1];
            }
            dadat.uncast(slbuf, true);
        } else if (cfmt.startsWith("CF")) {
            float[] sfbuf = dadat.castF(true);
            for (i = 0; i < n; i += 2) {
                ci = i * 2;
                asfout[ci] = sfbuf[ci];
                asfout[ci + 1] = sfbuf[ci + 1];
                this.dst_rsum += (double)asfout[ci];
                this.dst_isum += (double)asfout[ci + 1];
                this.dst_sqsum += (double)(asfout[ci] * asfout[ci] + asfout[ci + 1] * asfout[ci + 1]);
                asfout[ci] = awin[i] * asfout[ci];
                asfout[ci + 1] = awin[i] * asfout[ci + 1];
                asfout[ci += 2] = sfbuf[ci];
                asfout[ci + 1] = sfbuf[ci + 1];
                this.dst_rsum += (double)asfout[ci];
                this.dst_isum += (double)asfout[ci + 1];
                this.dst_sqsum += (double)(asfout[ci] * asfout[ci] + asfout[ci + 1] * asfout[ci + 1]);
                asfout[ci] = -awin[i + 1] * asfout[ci];
                asfout[ci + 1] = -awin[i + 1] * asfout[ci + 1];
            }
            dadat.uncast(sfbuf, true);
        } else if (cfmt.startsWith("CD")) {
            double[] sdbuf = dadat.castD(true);
            for (i = 0; i < n; i += 2) {
                ci = i * 2;
                asfout[ci] = (float)sdbuf[ci];
                asfout[ci + 1] = (float)sdbuf[ci + 1];
                this.dst_rsum += (double)asfout[ci];
                this.dst_isum += (double)asfout[ci + 1];
                this.dst_sqsum += (double)(asfout[ci] * asfout[ci] + asfout[ci + 1] * asfout[ci + 1]);
                asfout[ci] = awin[i] * asfout[ci];
                asfout[ci + 1] = awin[i] * asfout[ci + 1];
                asfout[ci += 2] = (float)sdbuf[ci];
                asfout[ci + 1] = (float)sdbuf[ci + 1];
                this.dst_rsum += (double)asfout[ci];
                this.dst_isum += (double)asfout[ci + 1];
                this.dst_sqsum += (double)(asfout[ci] * asfout[ci] + asfout[ci + 1] * asfout[ci + 1]);
                asfout[ci] = -awin[i + 1] * asfout[ci];
                asfout[ci + 1] = -awin[i + 1] * asfout[ci + 1];
            }
            dadat.uncast(sdbuf, true);
        } else {
            int i2;
            if (cfmt.startsWith("C")) {
                for (i2 = 0; i2 < 2 * n; ++i2) {
                    asfout[i2] = 0.0f;
                }
            } else {
                for (i2 = 0; i2 < n; ++i2) {
                    asfout[i2] = 0.0f;
                }
            }
            retVal = -1;
        }
        int size = daout.getSize();
        if (n < size) {
            if (cfmt.startsWith("C")) {
                for (i = n * 2; i < 2 * size; ++i) {
                    asfout[i] = 0.0f;
                }
            } else {
                for (i = n; i < size; ++i) {
                    asfout[i] = 0.0f;
                }
            }
        }
        daout.uncast(asfout, true);
        return retVal;
    }

    int gen_xlate_taps(float[] cxresp, int ntaps, double dfreq, double dtincr) {
        int i;
        Data cxbuf = new Data("CF", this.nfft);
        float[] cxbuf1 = cxbuf.castF(true);
        double dstrt = -0.5 * (double)(this.nfft - 1);
        double darg = Math.PI * 2 * Math.abs(dfreq) * dtincr;
        for (int i2 = 0; i2 < this.nfft; ++i2) {
            double ang = darg * (dstrt + (double)i2);
            cxbuf1[2 * i2] = (float)Math.cos(ang);
            cxbuf1[2 * i2 + 1] = (float)Math.sin(ang);
        }
        cxbuf.uncast(cxbuf1, true);
        Fft fft = new Fft(this.nfft, 10);
        fft.work(cxbuf);
        cxbuf1 = cxbuf.castF(true);
        float fmax = 0.0f;
        int nmax = 0;
        for (int i3 = 0; i3 < this.nfft / 2; ++i3) {
            float ftest = cxbuf1[2 * i3] * cxbuf1[2 * i3] + cxbuf1[2 * i3 + 1] * cxbuf1[2 * i3 + 1];
            if (!(ftest >= fmax)) continue;
            fmax = ftest;
            nmax = i3;
        }
        if (0 != (this.debug & 2)) {
            this.M.info((CharSequence)("nmax,fmax: " + nmax + "\t" + fmax));
        }
        int nctap = ntaps / 2;
        for (i = 0; i < nctap; ++i) {
            int ilow = nmax - i;
            int ihigh = nmax + i;
            if (ilow < 0) {
                ilow += this.nfft;
            }
            if (ihigh >= this.nfft) {
                ihigh -= this.nfft;
            }
            cxresp[2 * (nctap + i)] = cxbuf1[2 * ilow];
            cxresp[2 * (nctap + i) + 1] = cxbuf1[2 * ilow + 1];
            cxresp[2 * (nctap - i)] = cxbuf1[2 * ihigh];
            cxresp[2 * (nctap - i) + 1] = cxbuf1[2 * ihigh + 1];
        }
        if (0 != (this.debug & 2)) {
            this.M.info((CharSequence)("key tap: 0 (" + cxbuf1[0] + "," + cxbuf1[1] + ")"));
            this.M.info((CharSequence)("key tap: 1 (" + cxbuf1[2] + "," + cxbuf1[3] + ")"));
            this.M.info((CharSequence)("key tap: " + (this.nfft - 2) + " (" + cxbuf1[2 * (this.nfft - 2)] + "," + cxbuf1[2 * (this.nfft - 2) + 1] + ")"));
            this.M.info((CharSequence)("key tap: " + (this.nfft - 1) + " (" + cxbuf1[2 * (this.nfft - 1)] + "," + cxbuf1[2 * (this.nfft - 1) + 1] + ")"));
            for (i = 0; i < ntaps; ++i) {
                this.M.info((CharSequence)("i,ntaps,ctap: " + i + "\t" + ntaps + "\t(" + cxresp[2 * i] + "," + cxresp[2 * i + 1] + ")"));
            }
        }
        fmax = 1.0f / (float)this.nfft;
        for (i = 0; i < ntaps; ++i) {
            cxresp[2 * i] = fmax * cxresp[2 * i];
            cxresp[2 * i + 1] = -fmax * cxresp[2 * i + 1];
        }
        cxbuf.uncast(cxbuf1, true);
        return nmax;
    }

    int accum_sxx_psd(Data dcfft, Data dfsxx, Data dfpsd, float fscale, int n, int iedge) {
        float[] fpsd = dfpsd.castF(true);
        float[] fsxx = dfsxx.castF(true);
        float[] cfft = dcfft.castF(true);
        if (0 != (this.debug & 0x10)) {
            this.M.info((CharSequence)("cfft " + dcfft.getSize() + ", " + dcfft.getFormat()));
            this.M.info((CharSequence)("fsxx " + dfsxx.getSize() + ", " + dfsxx.getFormat()));
            this.M.info((CharSequence)("fpsd " + dfpsd.getSize() + ", " + dfpsd.getFormat()));
            this.M.info((CharSequence)("n " + n));
            this.M.info((CharSequence)("fscale " + fscale));
        }
        if (fscale != 1.0f) {
            float ftemp;
            int i;
            float fscalesq = fscale * fscale;
            if (!this.log_init_sxx && !this.log_init_psd) {
                for (i = 0; i < n; ++i) {
                    ftemp = cfft[2 * i] * cfft[2 * i] + cfft[2 * i + 1] * cfft[2 * i + 1];
                    fpsd[i] = fpsd[i] + ftemp;
                    fsxx[i] = fsxx[i] + fscalesq * ftemp;
                    cfft[2 * i] = fscale * cfft[2 * i];
                    cfft[2 * i + 1] = fscale * cfft[2 * i + 1];
                }
            } else if (this.log_init_sxx && !this.log_init_psd) {
                this.log_init_sxx = false;
                for (i = 0; i < n; ++i) {
                    ftemp = cfft[2 * i] * cfft[2 * i] + cfft[2 * i + 1] * cfft[2 * i + 1];
                    fpsd[i] = fpsd[i] + ftemp;
                    fsxx[i] = fscalesq * ftemp;
                    cfft[2 * i] = fscale * cfft[2 * i];
                    cfft[2 * i + 1] = fscale * cfft[2 * i + 1];
                }
            } else if (!this.log_init_sxx && this.log_init_psd) {
                this.log_init_psd = false;
                for (i = 0; i < n; ++i) {
                    fpsd[i] = ftemp = cfft[2 * i] * cfft[2 * i] + cfft[2 * i + 1] * cfft[2 * i + 1];
                    fsxx[i] = fsxx[i] + fscalesq * ftemp;
                    cfft[2 * i] = fscale * cfft[2 * i];
                    cfft[2 * i + 1] = fscale * cfft[2 * i + 1];
                }
            } else if (this.log_init_sxx && this.log_init_psd) {
                this.log_init_sxx = false;
                this.log_init_psd = false;
                for (i = 0; i < n; ++i) {
                    fpsd[i] = ftemp = cfft[2 * i] * cfft[2 * i] + cfft[2 * i + 1] * cfft[2 * i + 1];
                    fsxx[i] = fscalesq * ftemp;
                    cfft[2 * i] = fscale * cfft[2 * i];
                    cfft[2 * i + 1] = fscale * cfft[2 * i + 1];
                }
            }
        } else if (!this.log_init_sxx && !this.log_init_psd) {
            for (int i = 0; i < n; ++i) {
                float ftemp = cfft[2 * i] * cfft[2 * i] + cfft[2 * i + 1] * cfft[2 * i + 1];
                fpsd[i] = fpsd[i] + ftemp;
                fsxx[i] = fsxx[i] + ftemp;
            }
        } else if (this.log_init_sxx && !this.log_init_psd) {
            this.log_init_sxx = false;
            for (int i = 0; i < n; ++i) {
                float ftemp = cfft[2 * i] * cfft[2 * i] + cfft[2 * i + 1] * cfft[2 * i + 1];
                fpsd[i] = fpsd[i] + ftemp;
                fsxx[i] = ftemp;
            }
        } else if (!this.log_init_sxx && this.log_init_psd) {
            this.log_init_psd = false;
            for (int i = 0; i < n; ++i) {
                float ftemp;
                fpsd[i] = ftemp = cfft[2 * i] * cfft[2 * i] + cfft[2 * i + 1] * cfft[2 * i + 1];
                fsxx[i] = fsxx[i] + ftemp;
            }
        } else if (this.log_init_sxx && this.log_init_psd) {
            this.log_init_sxx = false;
            this.log_init_psd = false;
            for (int i = 0; i < n; ++i) {
                float ftemp;
                fpsd[i] = ftemp = cfft[2 * i] * cfft[2 * i] + cfft[2 * i + 1] * cfft[2 * i + 1];
                fsxx[i] = ftemp;
            }
        }
        dfpsd.uncast(fpsd, true);
        dfsxx.uncast(fsxx, true);
        dcfft.uncast(cfft, true);
        if (iedge > 0) {
            for (int i = 0; i < iedge; ++i) {
                fsxx[i] = 0.0f;
                cfft[2 * i] = 0.0f;
                cfft[2 * i + 1] = 0.0f;
                fsxx[n - 1 - i] = 0.0f;
                cfft[2 * (n - 1 - i)] = 0.0f;
                cfft[2 * (n - 1 - i) + 1] = 0.0f;
            }
        }
        return n;
    }

    int accum_coher(Data dcsxx, Data dcsxy, Data dfsyy, CycRecord Cinf, float[] crotat, int n, int nacc_max, int ibinbgn, int ibinend) {
        float csyyim;
        float csyyre;
        int i;
        float[] csyy = new float[2];
        float[] csxy = dcsxy.castF(true);
        float[] fsyy = dfsyy.castF(true);
        float[] csxx = dcsxx.castF(true);
        int nctap = Cinf.ntaps / 2;
        int nbck = Cinf.nshift - Cinf.nshift / 2;
        int noff = -Cinf.nshift - nctap;
        int istrt = Math.max(Cinf.nshift, ibinbgn + nbck);
        int istop = Math.min(ibinend + nbck, n);
        istrt = Math.min(istrt, istop);
        if (0 != (this.debug & 0x20)) {
            this.M.info((CharSequence)"accum_coher:");
            this.M.info((CharSequence)(" ibinbgn " + ibinbgn));
            this.M.info((CharSequence)(" ibinend " + ibinend));
            this.M.info((CharSequence)(" n       " + n));
            this.M.info((CharSequence)(" ntaps   " + Cinf.ntaps));
            this.M.info((CharSequence)(" nshift  " + Cinf.nshift));
            this.M.info((CharSequence)(" nctap   " + nctap));
            this.M.info((CharSequence)(" nbck    " + nbck));
            this.M.info((CharSequence)(" noff    " + noff));
            this.M.info((CharSequence)(" istrt   " + istrt));
            this.M.info((CharSequence)(" istop   " + istop));
            this.M.info((CharSequence)(" min     " + (nctap - 1 + istrt + noff)));
            this.M.info((CharSequence)(" max     " + (nctap + 1 + istop + noff)));
            this.M.info((CharSequence)("nacc_max " + nacc_max));
        }
        if (nacc_max <= 1) {
            float abscsyymax;
            if (istrt - nbck < 0) {
                istrt = nbck;
                if (0 != (this.debug & 0x20)) {
                    this.M.info((CharSequence)("coher: new istrt " + istrt));
                }
            }
            if (istop - nbck >= n) {
                istop = n - 1 + nbck;
                if (0 != (this.debug & 0x20)) {
                    this.M.info((CharSequence)("coher: new istop " + istop));
                }
            }
            if (nctap - 1 + istrt + noff < 0) {
                istrt = 1 - nctap - noff;
                if (0 != (this.debug & 0x20)) {
                    this.M.info((CharSequence)("coher: new istrt, min " + istrt + ", " + (nctap - 1 + istrt + noff)));
                }
            }
            if (nctap + 1 + istop + noff >= n) {
                istop = n - nctap - 2 - noff;
                if (0 != (this.debug & 0x20)) {
                    this.M.info((CharSequence)("coher: new istop, max " + istop + ", " + (nctap + 1 + istop + noff)));
                }
            }
            if (istop >= n) {
                istop = n - 1;
            }
            if (0 != (this.debug & 0x20)) {
                this.M.info((CharSequence)("centered " + (istrt + nctap + noff) + ", " + (istop + nctap + noff)));
            }
            if (!this.log_init_sxy) {
                for (i = istrt; i <= istop; ++i) {
                    csyy[0] = Cinf.cxlo[2 * nctap] * csxx[2 * (nctap + i + noff)] - Cinf.cxlo[2 * nctap + 1] * csxx[2 * (nctap + i + noff) + 1];
                    csyy[1] = Cinf.cxlo[2 * nctap] * csxx[2 * (nctap + i + noff) + 1] + Cinf.cxlo[2 * nctap + 1] * csxx[2 * (nctap + i + noff)];
                    csyy[0] = csyy[0] + (Cinf.cxlo[2 * (nctap - 1)] * csxx[2 * (nctap - 1 + i + noff)] - Cinf.cxlo[2 * (nctap - 1) + 1] * csxx[2 * (nctap - 1 + i + noff) + 1]);
                    csyy[1] = csyy[1] + (Cinf.cxlo[2 * (nctap - 1)] * csxx[2 * (nctap - 1 + i + noff) + 1] + Cinf.cxlo[2 * (nctap - 1) + 1] * csxx[2 * (nctap - 1 + i + noff)]);
                    csyy[0] = csyy[0] + (Cinf.cxlo[2 * (nctap + 1)] * csxx[2 * (nctap + 1 + i + noff)] - Cinf.cxlo[2 * (nctap + 1) + 1] * csxx[2 * (nctap + 1 + i + noff) + 1]);
                    csyy[1] = csyy[1] + (Cinf.cxlo[2 * (nctap + 1)] * csxx[2 * (nctap + 1 + i + noff) + 1] + Cinf.cxlo[2 * (nctap + 1) + 1] * csxx[2 * (nctap + 1 + i + noff)]);
                    csyyre = csxx[2 * i] * csyy[0] + csxx[2 * i + 1] * csyy[1];
                    csyyim = -csxx[2 * i] * csyy[1] + csxx[2 * i + 1] * csyy[0];
                    csyy[0] = csyyre * crotat[0] - csyyim * crotat[1];
                    csyy[1] = csyyre * crotat[1] + csyyim * crotat[0];
                    abscsyymax = Math.max((float)Math.sqrt(csyy[0] * csyy[0] + csyy[1] * csyy[1]), 1.0E-15f);
                    int n2 = 2 * (i - nbck);
                    csxy[n2] = csxy[n2] + csyy[0] / abscsyymax;
                    int n3 = 2 * (i - nbck) + 1;
                    csxy[n3] = csxy[n3] + csyy[1] / abscsyymax;
                }
            } else {
                for (i = istrt; i <= istop; ++i) {
                    csyy[0] = Cinf.cxlo[2 * nctap] * csxx[2 * (nctap + i + noff)] - Cinf.cxlo[2 * nctap + 1] * csxx[2 * (nctap + i + noff) + 1];
                    csyy[1] = Cinf.cxlo[2 * nctap] * csxx[2 * (nctap + i + noff) + 1] + Cinf.cxlo[2 * nctap + 1] * csxx[2 * (nctap + i + noff)];
                    csyy[0] = csyy[0] + (Cinf.cxlo[2 * (nctap - 1)] * csxx[2 * (nctap - 1 + i + noff)] - Cinf.cxlo[2 * (nctap - 1) + 1] * csxx[2 * (nctap - 1 + i + noff) + 1]);
                    csyy[1] = csyy[1] + (Cinf.cxlo[2 * (nctap - 1)] * csxx[2 * (nctap - 1 + i + noff) + 1] + Cinf.cxlo[2 * (nctap - 1) + 1] * csxx[2 * (nctap - 1 + i + noff)]);
                    csyy[0] = csyy[0] + (Cinf.cxlo[2 * (nctap + 1)] * csxx[2 * (nctap + 1 + i + noff)] - Cinf.cxlo[2 * (nctap + 1) + 1] * csxx[2 * (nctap + 1 + i + noff) + 1]);
                    csyy[1] = csyy[1] + (Cinf.cxlo[2 * (nctap + 1)] * csxx[2 * (nctap + 1 + i + noff) + 1] + Cinf.cxlo[2 * (nctap + 1) + 1] * csxx[2 * (nctap + 1 + i + noff)]);
                    csyyre = csxx[2 * i] * csyy[0] + csxx[2 * i + 1] * csyy[1];
                    csyyim = -csxx[2 * i] * csyy[1] + csxx[2 * i + 1] * csyy[0];
                    csyy[0] = csyyre * crotat[0] - csyyim * crotat[1];
                    csyy[1] = csyyre * crotat[1] + csyyim * crotat[0];
                    abscsyymax = Math.max((float)Math.sqrt(csyy[0] * csyy[0] + csyy[1] * csyy[1]), 1.0E-15f);
                    csxy[2 * (i - nbck)] = csyy[0] / abscsyymax;
                    csxy[2 * (i - nbck) + 1] = csyy[1] / abscsyymax;
                }
            }
        } else {
            if (istrt - nbck < 0) {
                istrt = nbck;
                if (0 != (this.debug & 0x20)) {
                    this.M.info((CharSequence)("coher: new istrt " + istrt));
                }
            }
            if (istop - nbck >= n) {
                istop = n - 1 + nbck;
                if (0 != (this.debug & 0x20)) {
                    this.M.info((CharSequence)("coher: new istop " + istop));
                }
            }
            if (istrt + noff < 0) {
                istrt = -noff;
                if (0 != (this.debug & 0x20)) {
                    this.M.info((CharSequence)("coher: new istrt, min " + istrt + ", " + (istrt + noff)));
                }
            }
            if (Cinf.ntaps + istop + noff >= n) {
                istop = n - Cinf.ntaps - noff;
                if (0 != (this.debug & 0x20)) {
                    this.M.info((CharSequence)("coher: new istop, max " + istop + "," + (Cinf.ntaps + istop + noff)));
                }
            }
            if (istop >= n) {
                istop = n - 1;
            }
            if (0 != (this.debug & 0x20)) {
                this.M.info((CharSequence)("centered " + (istrt + nctap + noff) + ", " + (istop + nctap + noff)));
            }
            if (!this.log_init_sxy) {
                i = istrt;
                while (i <= istop) {
                    csyy[0] = 0.0f;
                    csyy[1] = 0.0f;
                    for (int ii = 0; ii < Cinf.ntaps; ++ii) {
                        csyy[0] = csyy[0] + (Cinf.cxlo[2 * ii] * csxx[2 * (ii + i + noff)] - Cinf.cxlo[2 * ii + 1] * csxx[2 * (ii + i + noff) + 1]);
                        csyy[1] = csyy[1] + (Cinf.cxlo[2 * ii] * csxx[2 * (ii + i + noff) + 1] + Cinf.cxlo[2 * ii + 1] * csxx[2 * (ii + i + noff)]);
                    }
                    csyyre = csxx[2 * i] * csyy[0] + csxx[2 * i + 1] * csyy[1];
                    csyyim = -csxx[2 * i] * csyy[1] + csxx[2 * i + 1] * csyy[0];
                    int n4 = 2 * (i - nbck);
                    csxy[n4] = csxy[n4] + (csyyre * crotat[0] - csyyim * crotat[1]);
                    int n5 = 2 * (i - nbck) + 1;
                    csxy[n5] = csxy[n5] + (csyyre * crotat[1] + csyyim * crotat[0]);
                    int n6 = i++;
                    fsyy[n6] = fsyy[n6] + (csyy[0] * csyy[0] + csyy[1] * csyy[1]);
                }
            } else {
                for (i = istrt; i <= istop; ++i) {
                    csyy[0] = 0.0f;
                    csyy[1] = 0.0f;
                    for (int ii = 0; ii < Cinf.ntaps; ++ii) {
                        csyy[0] = csyy[0] + (Cinf.cxlo[2 * ii] * csxx[2 * (ii + i + noff)] - Cinf.cxlo[2 * ii + 1] * csxx[2 * (ii + i + noff) + 1]);
                        csyy[1] = csyy[1] + (Cinf.cxlo[2 * ii] * csxx[2 * (ii + i + noff) + 1] + Cinf.cxlo[2 * ii + 1] * csxx[2 * (ii + i + noff)]);
                    }
                    csyyre = csxx[2 * i] * csyy[0] + csxx[2 * i + 1] * csyy[1];
                    csyyim = -csxx[2 * i] * csyy[1] + csxx[2 * i + 1] * csyy[0];
                    csxy[2 * (i - nbck)] = csyyre * crotat[0] - csyyim * crotat[1];
                    csxy[2 * (i - nbck) + 1] = csyyre * crotat[1] + csyyim * crotat[0];
                    fsyy[i] = csyy[0] * csyy[0] + csyy[1] * csyy[1];
                }
            }
        }
        if (0 != (this.debug & 0x20)) {
            int j;
            this.M.info((CharSequence)"accum_coher:");
            this.M.info((CharSequence)"  sxy");
            for (j = 0; j < istrt + 10; ++j) {
                this.M.info((CharSequence)("\t" + j + "\t(" + csxy[2 * j] + "," + csxy[2 * j + 1] + ")"));
            }
            for (j = istop - 10; j < istop; ++j) {
                this.M.info((CharSequence)("\t" + j + "\t(" + csxy[2 * j] + "," + csxy[2 * j + 1] + ")"));
            }
            if (this.nacc_coher_max > 1) {
                this.M.info((CharSequence)"  syy");
                for (j = 0; j < istrt + 10; ++j) {
                    this.M.info((CharSequence)("\t" + j + "\t" + fsyy[j]));
                }
                for (j = istop - 10; j < istop; ++j) {
                    this.M.info((CharSequence)("\t" + j + "\t" + fsyy[j]));
                }
            }
        }
        dcsxy.uncast(csxy, true);
        dfsyy.uncast(fsyy, true);
        dcsxx.uncast(csxx, true);
        return n;
    }

    int accum_norm(Data dcsxy, Data dfsxx, Data dfsyy, Data dcnmsxy, CycRecord Cinf, int n, int ncoher_max, int nnorm_max, float rwhite, int ibinbgn, int ibinend) {
        float[] csxy = dcsxy.castF(true);
        float[] fsxx = dfsxx.castF(true);
        float[] fsyy = dfsyy.castF(true);
        float[] cnmsxy = dcnmsxy.castF(true);
        if (ncoher_max <= 1) {
            int i;
            float rscale = 1.0f / ((float)nnorm_max * (float)Math.max(1, ncoher_max));
            this.M.info((CharSequence)("rscale=" + rscale));
            if (!this.log_init_nmsxy) {
                for (i = ibinbgn; i <= ibinend; ++i) {
                    int n2 = 2 * i;
                    cnmsxy[n2] = cnmsxy[n2] + rscale * csxy[2 * i];
                    int n3 = 2 * i + 1;
                    cnmsxy[n3] = cnmsxy[n3] + rscale * csxy[2 * i + 1];
                }
            } else {
                for (i = ibinbgn; i <= ibinend; ++i) {
                    cnmsxy[2 * i] = rscale * csxy[2 * i];
                    cnmsxy[2 * i + 1] = rscale * csxy[2 * i + 1];
                }
            }
        } else {
            float fsxymax;
            int i;
            int nbck = Math.max(1, Cinf.nshift - Cinf.nshift / 2);
            int istrt = ibinbgn;
            int istop = Math.min(ibinend, n - nbck + 1);
            istrt = Math.min(istrt, istop);
            float rscale = 1.0f / (float)Math.max(1, nnorm_max);
            if (istrt + nbck < 0) {
                istrt = -nbck;
                if (0 != (this.debug & 0x40)) {
                    this.M.info((CharSequence)("ncoher: new istrt " + istrt));
                }
            }
            if (istop + nbck >= n) {
                istop = n - nbck - 1;
                if (0 != (this.debug & 0x40)) {
                    this.M.info((CharSequence)("ncoher: new istop " + istop));
                }
            }
            if (!this.log_init_nmsxy) {
                for (i = istrt; i <= istop; ++i) {
                    fsxymax = (float)Math.sqrt(fsxx[i + nbck] * fsyy[i + nbck] + rwhite);
                    fsxymax = Math.max(fsxymax, 1.0E-15f);
                    int n4 = 2 * i;
                    cnmsxy[n4] = cnmsxy[n4] + rscale * csxy[2 * i] / fsxymax;
                    int n5 = 2 * i + 1;
                    cnmsxy[n5] = cnmsxy[n5] + rscale * csxy[2 * i + 1] / fsxymax;
                }
            } else {
                for (i = istrt; i <= istop; ++i) {
                    fsxymax = (float)Math.sqrt(fsxx[i + nbck] * fsyy[i + nbck] + rwhite);
                    fsxymax = Math.max(fsxymax, 1.0E-15f);
                    cnmsxy[2 * i] = rscale * csxy[2 * i] / fsxymax;
                    cnmsxy[2 * i + 1] = rscale * csxy[2 * i + 1] / fsxymax;
                }
            }
        }
        if (0 != (this.debug & 0x40)) {
            int j;
            this.M.info((CharSequence)"accum_norm cnmsxy");
            this.M.info((CharSequence)("rwhiten_avg " + this.rwhiten_avg));
            for (j = 0; j < 10; ++j) {
                this.M.info((CharSequence)("\t" + j + "\t(" + cnmsxy[2 * j] + "," + cnmsxy[2 * j + 1] + ")"));
            }
            for (j = n - 10; j < n; ++j) {
                this.M.info((CharSequence)("\t" + j + "\t(" + cnmsxy[2 * j] + "," + cnmsxy[2 * j + 1] + ")"));
            }
        }
        dcsxy.uncast(csxy, true);
        dfsxx.uncast(fsxx, true);
        dfsyy.uncast(fsyy, true);
        dcnmsxy.uncast(cnmsxy, true);
        return n;
    }

    int clean_cycspec(Data dcspec, Data dfspec, int n, int ibgn, int iend, int nwin, boolean log_dosmooth, boolean log_dopower) {
        float[] cspec = dcspec.castF(true);
        float[] fspec = dfspec.castF(true);
        if (log_dosmooth) {
            int i;
            float fbeta = (float)(1.0 / Math.max(1.0, Math.sqrt(sqrt2o2 * (double)nwin)));
            float fbetai = 1.0f - fbeta;
            float[] ctemp = new float[]{0.0f, 0.0f};
            for (i = n - 1; i >= 0; --i) {
                ctemp[0] = fbetai * ctemp[0] + fbeta * cspec[2 * i];
                ctemp[1] = fbetai * ctemp[1] + fbeta * cspec[2 * i + 1];
                cspec[2 * i] = ctemp[0];
                cspec[2 * i + 1] = ctemp[1];
            }
            if (log_dopower) {
                for (i = 0; i < n; ++i) {
                    ctemp[0] = fbetai * ctemp[0] + fbeta * cspec[2 * i];
                    ctemp[1] = fbetai * ctemp[1] + fbeta * cspec[2 * i + 1];
                    fspec[i] = (float)Math.sqrt(ctemp[0] * ctemp[0] * ctemp[1] * ctemp[1]);
                }
                for (i = iend + 1; i < n; ++i) {
                    fspec[i] = 0.0f;
                }
                for (i = 0; i < ibgn; ++i) {
                    fspec[i] = 0.0f;
                }
            } else {
                for (i = 0; i < n; ++i) {
                    ctemp[0] = fbetai * ctemp[0] + fbeta * cspec[2 * i];
                    ctemp[1] = fbetai * ctemp[1] + fbeta * cspec[2 * i + 1];
                    cspec[2 * i] = ctemp[0];
                    cspec[2 * i + 1] = ctemp[1];
                }
                for (i = iend + 1; i < n; ++i) {
                    cspec[2 * i] = 0.0f;
                    cspec[2 * i + 1] = 0.0f;
                }
                for (i = 0; i < ibgn; ++i) {
                    cspec[2 * i] = 0.0f;
                    cspec[2 * i + 1] = 0.0f;
                }
            }
        }
        if (log_dopower && !log_dosmooth) {
            int i;
            for (i = 0; i < ibgn; ++i) {
                fspec[i] = 0.0f;
            }
            for (i = ibgn; i <= iend; ++i) {
                fspec[i] = (float)Math.sqrt(cspec[2 * i] * cspec[2 * i] + cspec[2 * i + 1] * cspec[2 * i + 1]);
            }
            for (i = iend + 1; i < n; ++i) {
                fspec[i] = 0.0f;
            }
        }
        dcspec.uncast(cspec, true);
        dfspec.uncast(fspec, true);
        return n;
    }

    private class Statistics {
        public double mean = 0.0;
        public double mmax = -1.0E20;
        public double mmin = 1.0E20;
        public double vari = 0.0;
        public double vmax = -1.0E20;
        public double vmin = 1.0E20;
        public int ntot = 0;
        public int nsub;

        Statistics() {
            this.nsub = cyclofunc.this.nfft;
        }
    }

    class CycRecord {
        Data syy;
        Data csxy;
        Data cnmsxy;
        Data mag;
        double cycfreq;
        double blkphas;
        int nfft;
        int nfft2;
        int ffttype;
        int nshift;
        int nsmth;
        int ntaps;
        float[] cxlo;
        boolean isrslt;
        String nmrslt;

        CycRecord() {
            this.cxlo = new float[2 * cyclofunc.this.num_xlate_taps];
        }
    }

    private static final class RealTime {
        public static final int DEFAULT = 0;
        public static final int NOW = 1;
        public static final int SPECIFIED = 2;

        private RealTime() {
        }
    }
}

