/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

public class convolve
extends Primitive {
    private DataFile inputFile;
    private DataFile outputFile;
    private DataFile impulseFile;
    private Data inputData;
    private Data impulseData;
    private Data outputData;
    private int bufsize;
    private int impulseTaps;
    private int numImpulse;
    private int inpst;
    private float[] impulse;
    private float[] impulseWork;
    private float[] inputWork;

    public int open() {
        this.inputFile = this.MA.getDataFile("IN", "1000", "S#", 0);
        this.inputFile.open();
        this.impulseFile = this.MA.getDataFile("IMPULSE", "1000", "S#", 0);
        this.impulseFile.open();
        this.impulseTaps = this.bufsize = (int)this.impulseFile.getSize();
        this.outputFile = this.MA.getDataFile("OUT", this.inputFile, 0);
        this.outputFile.setXStart(this.inputFile.getXStart() + this.inputFile.getXDelta() * (this.impulseFile.getXStart() / this.impulseFile.getXDelta()));
        this.outputFile.setXDelta(this.inputFile.getXDelta());
        this.outputFile.setXUnits(this.inputFile.getXUnits());
        this.outputFile.setSize(this.inputFile.getSize() + this.impulseFile.getSize() - 1.0);
        this.outputFile.open();
        if (this.impulseFile.filename.equals(this.outputFile.filename)) {
            this.M.error("Output file may not override impulse response");
        }
        this.inputData = this.inputFile.getDataBuffer(this.impulseTaps * 4, (byte)70);
        this.outputData = this.outputFile.getDataBuffer(this.impulseTaps * 4, (byte)70);
        this.impulseData = this.impulseFile.getDataBuffer(this.impulseTaps, (byte)70);
        this.numImpulse = this.impulseFile.read(this.impulseData);
        this.inpst = this.numImpulse - 1;
        if (this.numImpulse <= 0) {
            return 9;
        }
        this.impulse = this.impulseData.castF(true);
        this.impulseWork = new float[this.impulseTaps];
        for (int i = 0; i < this.numImpulse; ++i) {
            this.impulseWork[i] = this.impulse[this.numImpulse - 1 - i];
        }
        this.impulseData.uncast(this.impulse, false);
        this.inputWork = new float[this.impulseTaps * 4];
        return 0;
    }

    public int process() {
        int numInput = this.inputFile.read(this.inputData, this.numImpulse);
        if (numInput == 0) {
            return -1;
        }
        if (numInput < 0) {
            numInput = 0;
        }
        this.conv(this.inputData, this.outputData, numInput, this.numImpulse);
        this.outputFile.write(this.outputData, this.bufsize);
        if (numInput < this.numImpulse) {
            return 9;
        }
        return 0;
    }

    public int close() {
        this.inputFile.close();
        this.impulseFile.close();
        this.outputFile.close();
        return 0;
    }

    private void conv(Data inputData, Data outputData, int numInput, int numImpulse) {
        int i;
        float[] input = inputData.castF(true);
        float[] output = outputData.castF(false);
        if (numImpulse + numInput > this.inputWork.length) {
            this.M.error("Working input array not large enough.\nnumImpulse = " + numImpulse + "\nnumImput = " + numInput + "\ninputWork.length = " + this.inputWork.length);
        }
        if (numInput > input.length) {
            this.M.error("input array(" + input.length + ") returned by cast issmaller than numRead(" + numInput + ")");
        }
        int j = 0;
        for (i = this.inpst; i < this.inpst + numInput; ++i) {
            this.inputWork[i] = input[j++];
        }
        if (numInput == this.bufsize) {
            for (i = 0; i < this.bufsize; ++i) {
                output[i] = 0.0f;
                for (j = 0; j < numImpulse; ++j) {
                    int n = i;
                    output[n] = output[n] + this.inputWork[i + j] * this.impulseWork[j];
                }
            }
            for (i = 0; i < numImpulse - 1; ++i) {
                this.inputWork[i] = this.inputWork[i + this.bufsize];
            }
        } else {
            for (i = this.bufsize = numInput + this.inpst; i < this.bufsize + numImpulse - 1; ++i) {
                this.inputWork[i] = 0.0f;
            }
            for (i = 0; i < this.bufsize; ++i) {
                output[i] = 0.0f;
                for (j = 0; j < numImpulse; ++j) {
                    int n = i;
                    output[n] = output[n] + this.inputWork[i + j] * this.impulseWork[j];
                }
            }
        }
        inputData.uncast(input, false);
        outputData.uncast(output, true);
    }
}

