/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.ICEPacket;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;
import nxm.sys.libm.Add;
import nxm.sys.libm.Fft;
import nxm.sys.libm.Fill;
import nxm.sys.libm.Magnitude;
import nxm.sys.libm.Multiply;
import nxm.sys.libm.Noop;
import nxm.sys.libm.Scale;
import nxm.sys.libm.Window;

public class picmeasure
extends Primitive {
    private DataFile hi;
    private DataFile ho;
    private Data dbi;
    private Data dbo;
    private byte ftype;
    private int bpa;
    private int nchan;
    private int nfft;
    private int nfit;
    private int nffti;
    private int npkts;
    private ICEPacket pkt;
    private ChanData[] chns;
    private double tdelta;
    private double scale;
    private float[] fwin;
    private float[] fbuf;
    private float[] fbufa;
    private float[] fbufb;
    private float[] fbufi;
    private float[] fbufp;
    private Fft fftf;
    private Fft ffti;

    public int open() {
        this.hi = this.MA.getDataFile("IN");
        this.hi.open();
        this.tdelta = this.hi.getXDelta();
        this.bpa = this.hi.getBPA();
        this.ftype = this.hi.getFormatType();
        this.pkt = (ICEPacket)this.hi.getPacketHandler();
        if (this.pkt == null) {
            this.M.error("Input file is not packetized: " + this.hi.getTag());
        }
        this.ho = this.MA.getDataFile("OUT");
        this.ho.setSubRecords("CHAN|SI,STAT|SI,DIFF|SL,TIME|SD,TDIF|SD,SDIF|SD");
        this.ho.open(2 | 0x40);
        this.nchan = this.MA.getL("NCHAN");
        this.npkts = this.MA.getL("/NPKT", 5);
        this.nfft = this.MA.getL("/NFFT", 16384);
        this.nfit = this.MA.getL("/NFIT", 16384);
        this.nffti = this.MA.getL("/NFFTI", 131072);
        this.scale = 1.0 / (double)this.nfft;
        this.xfer = this.MA.getL("/TL", this.pkt.getFixedSize());
        this.dbi = this.hi.getDataBuffer(this.xfer);
        this.dbo = this.ho.getDataBuffer(1);
        this.chns = new ChanData[this.nchan];
        for (int i = 0; i < this.nchan; ++i) {
            this.chns[i] = new ChanData();
            this.chns[i].chan = (short)(i + 1);
            this.chns[i].clear();
        }
        this.fbuf = new float[this.nfft];
        this.fbufi = new float[this.nfft];
        this.fbufa = new float[this.nfft];
        this.fbufb = new float[this.nfft];
        this.fwin = Window.get((String)"HANN", (int)this.nfft, (double)this.scale);
        this.fftf = new Fft(this.nfft, 137);
        this.ffti = new Fft(this.nffti, 18);
        this.fbufp = new float[this.nffti * 2];
        return 0;
    }

    public int process() {
        int n = this.hi.read(this.dbi);
        if (n == 0) {
            return -1;
        }
        if (n < 0) {
            return 9;
        }
        int n2 = this.pkt.getChannel();
        if (n2 <= 0 || n2 > this.nchan) {
            this.M.warning((CharSequence)("Channel " + n2 + " out of range [1-" + this.nchan + "]"));
            return -1;
        }
        ChanData chanData = this.chns[n2 - 1];
        if (n2 == 1 && chanData.ipkts == this.npkts) {
            int n3;
            this.MT.writeln((CharSequence)("At time " + chanData.tc));
            for (n3 = 0; n3 < this.nchan; ++n3) {
                ChanData chanData2 = this.chns[n3];
                if (chanData2.ipkts == 0) continue;
                this.measure(chanData, chanData2);
                this.MT.writeln((CharSequence)chanData2.toString());
                chanData2.setDataBuffer(this.dbo);
                this.ho.write(this.dbo);
                n = 0;
                while (this.hi.isStream() && this.hi.avail() > 0.0) {
                    this.hi.read(this.dbi);
                    ++n;
                }
            }
            if (this.hi.isStream()) {
                Time.sleep((double)0.1);
                for (n3 = 0; n3 < this.nchan; ++n3) {
                    this.chns[n3].clear();
                }
            }
        } else {
            chanData.addData(this.dbi, this.pkt, this.xfer);
        }
        return 0;
    }

    public int close() {
        this.fftf.free();
        this.ffti.free();
        this.hi.close();
        this.ho.close();
        return 0;
    }

    public int getChannels() {
        return this.nchan;
    }

    public void measure(ChanData chanData, ChanData chanData2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 16384;
        chanData2.time = chanData2.tc.getSec();
        chanData2.tdif = chanData2.tc.diff(chanData.tc);
        n2 = (int)Math.round(chanData2.tdif / this.tdelta);
        if (n2 > 0) {
            n3 = n2;
        } else {
            n4 = -n2;
        }
        chanData2.tdif -= (double)n2 * this.tdelta;
        if (Math.abs(chanData2.tdif) < 1.0E-12) {
            chanData2.tdif = 0.0;
        }
        int n6 = Math.min(chanData.ipkts * this.xfer - n3, chanData2.ipkts * this.xfer - n4);
        int n7 = Math.max(0, n6 / n5);
        chanData2.sdif = 0.0;
        chanData2.difn = 0;
        chanData2.stat = (short)n7;
        chanData2.navg = n7;
        if (n7 <= 0) {
            return;
        }
        Fill.S((float[])this.fbufi, (int)n5, (double)0.0);
        for (n = 0; n < n7; ++n) {
            Convert.bb2ja((byte[])chanData.bbuf, (int)(n * n5 + n3), (byte)this.ftype, (Object)this.fbufa, (int)0, (byte)70, (int)n5);
            Convert.bb2ja((byte[])chanData2.bbuf, (int)(n * n5 + n4), (byte)this.ftype, (Object)this.fbufb, (int)0, (byte)70, (int)n5);
            Multiply.SSS((float[])this.fbufa, (float[])this.fwin, (float[])this.fbufa, (int)n5);
            Multiply.SSS((float[])this.fbufb, (float[])this.fwin, (float[])this.fbufb, (int)n5);
            this.fftf.work((Object)this.fbufa);
            this.fftf.work((Object)this.fbufb);
            Multiply.GCC((float[])this.fbufa, (float[])this.fbufb, (float[])this.fbuf, (int)(n5 / 2));
            Add.SSS((float[])this.fbufi, (float[])this.fbuf, (float[])this.fbufi, (int)n5);
        }
        if (n7 > 1) {
            double d = 1.0 / (double)n7;
            Scale.SS((float[])this.fbufi, (float[])this.fbufi, (int)n5, (double)d);
        }
        Fill.C((float[])this.fbufp, (int)this.nffti, (double)0.0);
        Noop.CC((float[])this.fbufi, (float[])this.fbufp, (int)(n5 / 2));
        this.ffti.work((Object)this.fbufp);
        Magnitude.CS((float[])this.fbufp, (float[])this.fbufp, (int)this.nffti);
        n = 0;
        float f = this.fbufp[0];
        for (int i = 1; i < this.nffti; ++i) {
            if (!(this.fbufp[i] > f)) continue;
            n = i;
            f = this.fbufp[i];
        }
        if (n >= this.nffti / 2) {
            n -= this.nffti;
        }
        double d = Math.sqrt(this.fbufp[(n - 1 + this.nffti) % this.nffti]);
        double d2 = Math.sqrt(this.fbufp[(n + 0 + this.nffti) % this.nffti]);
        double d3 = Math.sqrt(this.fbufp[(n + 1 + this.nffti) % this.nffti]);
        double d4 = d3 + d - 2.0 * d2;
        if (Math.abs(d4) < 1.0E-20) {
            d4 = 1.0E-20;
        }
        d4 = ((double)n - (d3 - d) / (2.0 * d4)) * (double)n5 / (double)this.nffti;
        chanData2.sdif = d4 * this.tdelta;
        chanData2.difn = (int)((chanData2.sdif + chanData2.tdif) * 1.0E9);
    }

    private class ChanData {
        int ipkts;
        short chan;
        short stat;
        int difn;
        int navg;
        int count;
        double time;
        double tdif;
        double sdif;
        double delta;
        Time tc;
        byte[] bbuf;

        private ChanData() {
            this.delta = picmeasure.this.tdelta;
            this.tc = new Time();
            this.bbuf = new byte[picmeasure.this.xfer * picmeasure.this.npkts * picmeasure.this.bpa];
        }

        public void setDataBuffer(Data data) {
            Convert.packI((byte[])data.buf, (int)0, (short)this.chan);
            Convert.packI((byte[])data.buf, (int)2, (short)this.stat);
            Convert.packL((byte[])data.buf, (int)4, (int)this.difn);
            Convert.packD((byte[])data.buf, (int)8, (double)this.time);
            Convert.packD((byte[])data.buf, (int)16, (double)this.tdif);
            Convert.packD((byte[])data.buf, (int)24, (double)this.sdif);
        }

        public int addData(Data data, ICEPacket iCEPacket, int n) {
            int n2 = iCEPacket.getCount();
            if (this.ipkts > 0 && ++this.count != n2) {
                this.ipkts = 0;
            }
            if (this.ipkts < picmeasure.this.npkts) {
                int n3;
                System.arraycopy(data.buf, 0, this.bbuf, this.ipkts * n * picmeasure.this.bpa, n * picmeasure.this.bpa);
                if (this.ipkts == 0 && (n3 = iCEPacket.getTC(this.tc, 0.0, picmeasure.this.tdelta)) < 0) {
                    picmeasure.this.M.warning((CharSequence)("Bad TimeCode status: " + n3));
                }
                ++this.ipkts;
            }
            this.count = n2;
            return this.ipkts;
        }

        public void clear() {
            this.ipkts = 0;
            this.time = 0.0;
            this.tdif = 0.0;
        }

        public String toString() {
            return "Chan " + this.chan + " Pkts " + this.ipkts + " NAvg " + this.navg + " Diff " + this.difn;
        }
    }
}

