/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import java.security.MessageDigest;
import java.util.ArrayList;
import nxm.ice.lib.MDevIce;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;

public class icemeasure
extends Primitive {
    private static final String funcList = "Bandwidth,Characterize,Flash,Harmonics,Histogram,Mse,NoiseFloor,Notch,Npr,Sonet,Udp";
    private static final int BAND = 1;
    private static final int CHAR = 2;
    private static final int FLASH = 3;
    private static final int HARM = 4;
    private static final int HIST = 5;
    private static final int MSE = 6;
    private static final int NOISE = 7;
    private static final int NOTCH = 8;
    private static final int NPR = 9;
    private static final int SONET = 10;
    private static final int UDP = 11;
    private static final int FLASHSIZE = 65536;
    private static final int MATCH = 24;
    private static final int BER = 25;
    private int func;
    private DataFile hi1;
    private DataFile hi2;
    private DataFile ho;
    private Data dbi1;
    private Data dbi2;
    private double freq1;
    private double freq2;
    private double fbw;
    private int dcend;
    private double[] data1;
    private int[] inds1;
    private int len1 = 0;
    private double[] data2;
    private int[] inds2;
    private int len2;
    private double[] datan;
    private int[] indsn;
    private int lenn;
    private double adj_val;
    private double fpb;
    private double fs;
    private double thresh;
    private QuickSort qsort;
    private ArrayList<IceSpur> spurs;
    private boolean complex;
    private int medind;
    private int mode;
    private int seek_ind;
    private int frames;
    private int matched;
    private long skip;
    private String str;
    private long[] bit_accumr;
    private long[] bit_accumi;

    public int open() {
        this.hi1 = this.MA.getDataFile("IN1");
        this.hi1.open();
        this.hi1.setDFS(0);
        this.xfer = this.hi1.getFrameSize();
        this.complex = this.hi1.getXStart() < 0.0;
        this.hi2 = null;
        this.ho = this.MA.getDataFile("OUT", "3000", "NH", 0);
        this.func = this.MA.getSelectionIndex("FUNC", funcList, 0);
        int n = this.MA.getNArgs();
        this.str = null;
        switch (this.func) {
            case 1: {
                int n2;
                double d;
                if (n != 6) {
                    this.M.error("Error! Incorrect number of arguments for function: Bandwidth! i.e. icemeasure band <out> <in1> <fs> <fbw> <thresh>");
                }
                this.ho.setSubRecords("MEDIAN|SD,IN|SD,OUT|SD");
                double d2 = this.fs = this.MA.get("FS") == null ? this.MA.getD(4) : this.MA.getD("FS");
                if (this.fs <= 0.0) {
                    this.M.error("You must supply a valid sampling rate!");
                }
                double d3 = this.fbw = this.MA.get("FBW") == null ? this.MA.getD(5) : this.MA.getD("FBW");
                if (this.fbw < 0.0 || this.fbw > 1.0) {
                    this.M.error("Fractional bandwidth (FBW) must be between 0.0 and 1.0!");
                }
                double d4 = d = this.MA.get("THRESH") == null ? (double)this.MA.getL(6) : (double)this.MA.getL("THRESH");
                if (d < 0.0) {
                    this.M.error("Threshold must be a logarithmic value!");
                }
                this.thresh = Math.pow(10.0, d / 10.0);
                this.dcend = this.detDcInds(this.xfer);
                double d5 = this.fbw * (double)this.xfer - (double)(2 * this.dcend);
                int n3 = (int)Math.floor(0.5 * ((double)this.xfer - d5));
                int n4 = n3 + (int)Math.ceil(d5);
                this.len1 = n4 - n3;
                this.data1 = new double[this.len1];
                this.inds1 = new int[this.len1];
                this.len2 = this.xfer - this.len1;
                this.data2 = new double[this.len2];
                this.inds2 = new int[this.len2];
                for (n2 = 0; n2 < this.len1; ++n2) {
                    this.inds1[n2] = n2 + n3;
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    this.inds2[n2] = n2;
                }
                n2 = n4;
                int n5 = n3;
                while (n2 < this.xfer) {
                    this.inds2[n5] = n2++;
                    ++n5;
                }
                this.medind = this.len1 / 2;
                this.qsort = new QuickSort();
                break;
            }
            case 2: {
                double d;
                if (n != 7) {
                    this.M.error("Error! Error! Incorrect number of arguments for function: Characterize! i.e. icemeasure char <out> <in1> <fs> <fbw> <thresh> <freq1>");
                }
                this.ho.setSubRecords("SNR|SD,SFDR|SD,NF|SD,THRESH|SD,SIG|SD,MAXSPUR|SD,MAXSPURFREQ|SD");
                double d6 = this.fs = this.MA.get("FS") == null ? this.MA.getD(4) : this.MA.getD("FS");
                if (this.fs <= 0.0) {
                    this.M.error("You must supply a valid sampling rate!");
                }
                double d7 = this.fbw = this.MA.get("FBW") == null ? this.MA.getD(5) : this.MA.getD("FBW");
                if (this.fbw < 0.0 || this.fbw > 1.0) {
                    this.M.error("Fractional bandwidth (FBW) must be between 0.0 and 1.0!");
                }
                double d8 = d = this.MA.get("THRESH") == null ? (double)this.MA.getL(6) : (double)this.MA.getL("THRESH");
                if (d < 0.0) {
                    this.M.error("Threshold must be a logarithmic value!");
                }
                this.thresh = Math.pow(10.0, d / 10.0);
                this.freq1 = this.MA.get("FREQ1") == null ? this.MA.getD(7) : this.MA.getD("FREQ1");
                double d9 = this.mapFreq(this.freq1);
                if (d9 > this.fs || d9 < 0.0) {
                    this.M.error("Specified frequency is outside of sampling rate!");
                }
                this.fpb = this.complex ? this.fs / (double)this.xfer : 0.5 * this.fs / (double)this.xfer;
                this.adj_val = 10.0 * Math.log10(this.fpb);
                this.dcend = this.detDcInds(this.xfer);
                double d10 = this.fbw * (double)this.xfer - (double)(2 * this.dcend);
                int n6 = (int)Math.floor(0.5 * ((double)this.xfer - d10));
                int n7 = n6 + (int)Math.ceil(d10);
                this.len1 = n7 - n6;
                this.data1 = new double[this.len1];
                this.inds1 = new int[this.len1];
                int n8 = n6;
                for (int i = 0; i < this.len1; ++i) {
                    this.inds1[i] = n8++;
                }
                this.medind = this.len1 / 2;
                this.inds2 = this.fillIndices(d9, this.dcend, 0);
                this.len2 = this.inds2.length;
                this.qsort = new QuickSort();
                break;
            }
            case 3: {
                if (n != 5) {
                    this.M.error("Error! Incorrect number of arguments for function: Bandwidth! i.e. icemeasure flash <out> <in1> <alias> <cardnum>");
                }
                this.xfer = (int)this.hi1.getSize();
                if (this.xfer != 65536) {
                    this.M.error("File size (" + this.xfer + ") not equal to " + 65536);
                    return 9;
                }
                if (!this.hi1.getFormat().equals("SB")) {
                    this.M.error("Input type must be SB");
                    return 9;
                }
                this.ho.setSubRecords("ERROR|SB,SHA1|8A,SHA2|8A");
                this.str = this.MA.get("ALIAS") == null ? this.MA.getCS(4) : this.MA.getCS("ALIAS");
                int n9 = this.MA.get("CARDNUM") == null ? this.MA.getL(5) : this.MA.getL("CARDNUM");
                this.str = String.format(this.str, n9 - 1);
                break;
            }
            case 4: {
                int n10;
                double d;
                if (n != 8) {
                    this.M.error("Error!  Error! Incorrect number of arguments for function: Harmonics! i.e. icemeasure harm <out> <in1> <fs> <thresh> <freq1> <freq2> <order>");
                }
                this.ho.setSubRecords("SNR|SD,S1S2|SD,SFDR|SD,NF|SD,THRESH|SD,MAXSPURFREQ|SL,MAXSPUR|SD");
                double d11 = this.fs = this.MA.get("FS") == null ? this.MA.getD(4) : this.MA.getD("FS");
                if (this.fs <= 0.0) {
                    this.M.error("You must supply a valid sampling rate!");
                }
                double d12 = d = this.MA.get("THRESH") == null ? (double)this.MA.getL(5) : (double)this.MA.getL("THRESH");
                if (d < 0.0) {
                    this.M.error("Threshold must be a logarithmic value!");
                }
                this.thresh = Math.pow(10.0, d / 10.0);
                this.freq1 = this.MA.get("FREQ1") == null ? this.MA.getD(6) : this.MA.getD("FREQ1");
                double d13 = this.mapFreq(this.freq1);
                if (d13 < 0.0 || d13 > this.fs) {
                    this.M.error("First frequency is outside of sampling rate!");
                }
                this.freq2 = this.MA.get("FREQ2") == null ? this.MA.getD(7) : this.MA.getD("FREQ2");
                double d14 = this.mapFreq(this.freq2);
                if (d14 < 0.0 || d14 > this.fs) {
                    this.M.error("Second frequency is outside of sampling rate!");
                }
                int n11 = this.MA.get("ORDER") == null ? this.MA.getL(8) : this.MA.getL("ORDER");
                this.dcend = this.detDcInds(this.xfer);
                this.lenn = this.xfer - 2 * this.dcend;
                this.datan = new double[this.lenn];
                this.indsn = new int[this.lenn];
                int n12 = this.dcend;
                for (n10 = 0; n10 < this.lenn; ++n10) {
                    this.indsn[n10] = n12++;
                }
                this.fpb = this.complex ? this.fs / (double)this.xfer : 0.5 * this.fs / (double)this.xfer;
                this.adj_val = 10.0 * Math.log10(this.fpb);
                this.inds1 = this.fillIndices(d13, this.dcend, 0);
                this.len1 = this.inds1.length;
                this.inds2 = this.fillIndices(d14, this.dcend, 0);
                this.len2 = this.inds2.length;
                this.spurs = new ArrayList();
                for (n10 = 2; n10 <= n11; ++n10) {
                    double d15;
                    double d16;
                    double d17;
                    IceSpur iceSpur;
                    double d18 = this.mapFreq((double)n10 * this.freq1);
                    double d19 = this.mapFreq((double)n10 * this.freq2);
                    if (d18 <= this.fs && d18 > 0.0) {
                        iceSpur = new IceSpur();
                        iceSpur.setIndices(this.fillIndices(d18, this.dcend, this.dcend));
                        iceSpur.setColumn("H" + n10 + "F1");
                        iceSpur.setFreq(this.unmapFreq(d18));
                        this.spurs.add(iceSpur);
                        this.ho.addSubRec(iceSpur.getColumn() + "FREQ", "SL");
                        this.ho.addSubRec(iceSpur.getColumn() + "POW", "SD");
                        this.ho.addSubRec(iceSpur.getColumn() + "DBC", "SD");
                    }
                    if (d19 <= this.fs && d19 > 0.0) {
                        iceSpur = new IceSpur();
                        iceSpur.setIndices(this.fillIndices(d19, this.dcend, this.dcend));
                        iceSpur.setColumn("H" + n10 + "F2");
                        iceSpur.setFreq(this.unmapFreq(d19));
                        this.spurs.add(iceSpur);
                        this.ho.addSubRec(iceSpur.getColumn() + "FREQ", "SL");
                        this.ho.addSubRec(iceSpur.getColumn() + "POW", "SD");
                        this.ho.addSubRec(iceSpur.getColumn() + "DBC", "SD");
                    }
                    if (n10 % 2 == 0) {
                        d17 = n10 / 2;
                        d18 = this.mapFreq(Math.abs(d17 * this.freq1 - d17 * this.freq2));
                        d19 = this.mapFreq(d17 * this.freq1 + d17 * this.freq2);
                        d16 = this.fs + 1.0;
                        d15 = this.fs + 1.0;
                    } else {
                        d17 = (n10 - 1) / 2;
                        d18 = this.mapFreq((d17 + 1.0) * this.freq1 - d17 * this.freq2);
                        d19 = this.mapFreq((d17 + 1.0) * this.freq2 - d17 * this.freq1);
                        d16 = this.mapFreq((d17 + 1.0) * this.freq1 + d17 * this.freq2);
                        d15 = this.mapFreq((d17 + 1.0) * this.freq2 + d17 * this.freq1);
                    }
                    if (d18 <= this.fs && d18 > 0.0) {
                        iceSpur = new IceSpur();
                        iceSpur.setIndices(this.fillIndices(d18, this.dcend, this.dcend));
                        iceSpur.setColumn("I" + n10 + "A");
                        iceSpur.setFreq(this.unmapFreq(d18));
                        this.spurs.add(iceSpur);
                        this.ho.addSubRec(iceSpur.getColumn() + "FREQ", "SL");
                        this.ho.addSubRec(iceSpur.getColumn() + "POW", "SD");
                        this.ho.addSubRec(iceSpur.getColumn() + "DBC", "SD");
                    }
                    if (d19 <= this.fs && d19 > 0.0) {
                        iceSpur = new IceSpur();
                        iceSpur.setIndices(this.fillIndices(d19, this.dcend, this.dcend));
                        iceSpur.setColumn("I" + n10 + "B");
                        iceSpur.setFreq(this.unmapFreq(d19));
                        this.spurs.add(iceSpur);
                        this.ho.addSubRec(iceSpur.getColumn() + "FREQ", "SL");
                        this.ho.addSubRec(iceSpur.getColumn() + "POW", "SD");
                        this.ho.addSubRec(iceSpur.getColumn() + "DBC", "SD");
                    }
                    if (d16 <= this.fs && d16 > 0.0) {
                        iceSpur = new IceSpur();
                        iceSpur.setIndices(this.fillIndices(d16, this.dcend, this.dcend));
                        iceSpur.setColumn("I" + n10 + "C");
                        iceSpur.setFreq(this.unmapFreq(d16));
                        this.spurs.add(iceSpur);
                        this.ho.addSubRec(iceSpur.getColumn() + "FREQ", "SL");
                        this.ho.addSubRec(iceSpur.getColumn() + "POW", "SD");
                        this.ho.addSubRec(iceSpur.getColumn() + "DBC", "SD");
                    }
                    if (!(d15 <= this.fs) || !(d15 > 0.0)) continue;
                    iceSpur = new IceSpur();
                    iceSpur.setIndices(this.fillIndices(d15, this.dcend, this.dcend));
                    iceSpur.setColumn("I" + n10 + "D");
                    iceSpur.setFreq(this.unmapFreq(d15));
                    this.spurs.add(iceSpur);
                    this.ho.addSubRec(iceSpur.getColumn() + "FREQ", "SL");
                    this.ho.addSubRec(iceSpur.getColumn() + "POW", "SD");
                    this.ho.addSubRec(iceSpur.getColumn() + "DBC", "SD");
                }
                this.medind = this.xfer / 2;
                this.qsort = new QuickSort();
                break;
            }
            case 5: {
                int n13;
                if (n != 5) {
                    this.M.error("Error! Incorrect number of arguments for function: Bandwidth! i.e. icemeasure stuck <out> <in1> <bits> <bitsoff>");
                }
                int n14 = this.MA.get("BITS") == null ? this.MA.getL(4) : this.MA.getL("BITS");
                int n15 = this.MA.get("BITSOFF") == null ? this.MA.getL(5) : this.MA.getL("BITSOFF");
                int n16 = n14 + n15 - 1;
                this.adj_val = (int)Math.pow(2.0, n16 + 1);
                this.bit_accumr = new long[n14];
                this.bit_accumi = new long[n14];
                this.indsn = new int[n14];
                this.ho.addSubRec("REMSB", "SL");
                this.indsn[0] = (int)Math.pow(2.0, n16);
                for (n13 = 1; n13 < n14; ++n13) {
                    this.indsn[n13] = (int)Math.pow(2.0, n16 - n13);
                    this.ho.addSubRec("RE" + n13, "SL");
                }
                this.ho.addSubRec("IMMSB", "SL");
                for (n13 = 1; n13 < n14; ++n13) {
                    this.ho.addSubRec("IM" + n13, "SL");
                }
                this.xfer = this.MA.getL("/TL", 16384);
                break;
            }
            case 6: {
                int n17;
                if (n != 5) {
                    this.M.error("Error! Error! Incorrect number of arguments for function: Mean Square Error! i.e. icemeasure mse <out> <in1> <in2> <segments>");
                }
                this.ho.setSubRecords("AVERAGE|SD,WORST|SD");
                this.hi2 = this.MA.get("IN2") == null ? this.MA.getDataFile(4) : this.MA.getDataFile("IN2");
                this.hi2.open();
                this.hi2.setDFS(0);
                this.dbi2 = this.hi2.getDataBuffer(this.xfer);
                int n18 = this.MA.get("SEGMENTS") == null ? this.MA.getL(5) : this.MA.getL("SEGMENTS");
                n18 = n18 < 0 ? 1 : n18;
                this.dcend = this.detDcInds(this.xfer);
                this.len1 = this.len2 = this.xfer - 2 * this.dcend;
                this.data1 = new double[this.len1];
                this.data2 = new double[this.len1];
                this.inds1 = new int[this.len1];
                int n19 = this.dcend;
                for (n17 = 0; n17 < this.len1; ++n17) {
                    this.inds1[n17] = n19++;
                }
                this.indsn = new int[n18];
                if (n18 > 1) {
                    int n20 = (int)Math.floor(1.0 * (double)this.len1 / (double)n18);
                    for (n17 = 0; n17 < n18 - 1; ++n17) {
                        this.indsn[n17] = n20 * (n17 + 1) + this.dcend;
                    }
                }
                this.indsn[n18 - 1] = this.len1 + this.dcend;
                this.qsort = new QuickSort();
                break;
            }
            case 7: {
                double d;
                if (n != 6) {
                    this.M.error("Error! Incorrect number of arguments for function: Noise Floor! i.e. icemeasure noise <out> <in1> <fs> <fbw> <thresh>");
                }
                this.ho.setSubRecords("NF|SD,THRESH|SD,MAXSPUR|SD,MAXSPURFREQ|SD");
                double d20 = this.fs = this.MA.get("FS") == null ? this.MA.getD(4) : this.MA.getD("FS");
                if (this.fs <= 0.0) {
                    this.M.error("You must supply a valid sampling rate!");
                }
                double d21 = this.fbw = this.MA.get("FBW") == null ? this.MA.getD(5) : this.MA.getD("FBW");
                if (this.fbw < 0.0 || this.fbw > 1.0) {
                    this.M.error("Fractional bandwidth (FBW) must be between 0.0 and 1.0!");
                }
                double d22 = d = this.MA.get("THRESH") == null ? (double)this.MA.getL(6) : (double)this.MA.getL("THRESH");
                if (d < 0.0) {
                    this.M.error("Threshold must be a logarithmic value!");
                }
                this.thresh = Math.pow(10.0, d / 10.0);
                this.fpb = this.complex ? this.fs / (double)this.xfer : 0.5 * this.fs / (double)this.xfer;
                this.adj_val = 10.0 * Math.log10(this.fpb);
                this.dcend = this.detDcInds(this.xfer);
                this.fbw = this.fbw > 1.0 ? 1.0 : (this.fbw < 0.0 ? 0.0 : this.fbw);
                double d23 = this.fbw * (double)this.xfer - (double)(2 * this.dcend);
                int n21 = (int)Math.floor(0.5 * ((double)this.xfer - d23));
                int n22 = n21 + (int)Math.ceil(d23);
                this.len1 = n22 - n21;
                this.data1 = new double[this.len1];
                this.inds1 = new int[this.len1];
                int n23 = n21;
                for (int i = 0; i < this.len1; ++i) {
                    this.inds1[i] = n23++;
                }
                this.medind = this.len1 / 2;
                this.qsort = new QuickSort();
                break;
            }
            case 8: {
                double d;
                if (n != 6) {
                    this.M.error("Error! Error! Incorrect number of arguments for function: Notch! i.e. icemeasure notch <out> <in1> <fs> <nbw> <fbw>");
                }
                this.ho.setSubRecords("MEDIAN|SD,NOTCH|SD,TONE|SD");
                double d24 = this.fs = this.MA.get("FS") == null ? this.MA.getD(4) : this.MA.getD("FS");
                if (this.fs <= 0.0) {
                    this.M.error("You must supply a valid sampling rate!");
                }
                double d25 = d = this.MA.get("NBW") == null ? this.MA.getD(5) : this.MA.getD("NBW");
                if (d > this.fs || d < 0.0) {
                    this.M.error("Notch bandwidth must be less than the sampling rate and greater than zero!");
                }
                double d26 = this.fbw = this.MA.get("FBW") == null ? this.MA.getD(6) : this.MA.getD("FBW");
                if (this.fbw < 0.0 || this.fbw > 1.0) {
                    this.M.error("Fractional bandwidth (FBW) must be between 0.0 and 1.0!");
                }
                this.fpb = this.complex ? this.fs / (double)this.xfer : 0.5 * this.fs / (double)this.xfer;
                double d27 = 500.0 / this.fpb;
                int n24 = (int)Math.floor(0.5 * ((double)this.xfer - d27));
                int n25 = (int)Math.ceil(0.5 * ((double)this.xfer + d27));
                int n26 = n25 - n24;
                d27 = d / this.fpb;
                int n27 = (int)Math.floor(0.5 * ((double)this.xfer - d27));
                int n28 = (int)Math.ceil(0.5 * ((double)this.xfer + d27));
                this.len1 = n28 - n27 - n26;
                this.inds1 = new int[this.len1];
                this.data1 = new double[this.len1];
                int n29 = 0;
                int n30 = n27;
                while (n30 < n24) {
                    this.inds1[n29] = n30++;
                    ++n29;
                }
                n30 = n25;
                while (n30 < n28) {
                    this.inds1[n29] = n30++;
                    ++n29;
                }
                d27 = (this.fbw > 1.0 ? 1.0 : (this.fbw < 0.0 ? 0.0 : this.fbw)) * (double)this.xfer;
                n27 = (int)Math.floor(0.5 * ((double)this.xfer - d27));
                n28 = (int)Math.ceil(0.5 * ((double)this.xfer + d27));
                this.len2 = n28 - n27 - (n26 + this.len1) + 1;
                if (this.len2 < 0) {
                    this.M.error("FBW (" + this.fbw + ")value is too small! Please increase!");
                }
                this.inds2 = new int[this.len2];
                this.data2 = new double[this.len2];
                n29 = 0;
                n30 = n27;
                while (n30 < this.inds1[0]) {
                    this.inds2[n29] = n30++;
                    ++n29;
                }
                n30 = this.inds1[this.len1 - 1];
                while (n30 < n28) {
                    this.inds2[n29] = n30++;
                    ++n29;
                }
                this.qsort = new QuickSort();
                break;
            }
            case 9: {
                double d;
                double d28;
                double d29;
                double d30;
                if (n != 9) {
                    this.M.error("Error! Error! Incorrect number of arguments for function: Noise Power Ratio! i.e. icemeasure npr <out> <in1> <freq1> <bw1> <freq2> <bw2> <freqn> <bwn>");
                }
                this.ho.setSubRecords("SIGNAL|SD,NOTCH|SD");
                double d31 = this.freq1 = this.MA.get("FREQ1") == null ? this.MA.getD(4) : this.MA.getD("FREQ1");
                if (this.freq1 < 0.0 || this.freq1 > 1.0) {
                    this.M.error("Please specify passband as a percentage into the signal (i.e. 0 < freq1 < 1.0)!");
                }
                double d32 = d30 = this.MA.get("BW1") == null ? this.MA.getD(5) : this.MA.getD("BW1");
                if (d30 < 0.0 || d30 > 1.0) {
                    this.M.error("Please specify passband width as a percentage into the signal (i.e. 0 < bw1 < 1.0)!");
                }
                double d33 = this.freq2 = this.MA.get("FREQ2") == null ? this.MA.getD(6) : this.MA.getD("FREQ2");
                if (this.freq2 < 0.0 || this.freq2 > 1.0) {
                    this.M.error("Please specify passband as a percentage into the signal (i.e. 0 < freq2 < 1.0)!");
                }
                double d34 = d29 = this.MA.get("BW2") == null ? this.MA.getD(7) : this.MA.getD("BW2");
                if (d29 < 0.0 || d29 > 1.0) {
                    this.M.error("Please specify passband width as a percentage into the signal (i.e. 0 < bw2 < 1.0)!");
                }
                double d35 = d28 = this.MA.get("FREQN") == null ? this.MA.getD(8) : this.MA.getD("FREQN");
                if (d28 < 0.0 || d28 > 1.0) {
                    this.M.error("Please specify passband as a percentage into the signal (i.e. 0 < freqn < 1.0)!");
                }
                double d36 = d = this.MA.get("BWN") == null ? this.MA.getD(9) : this.MA.getD("BWN");
                if (d < 0.0 || d > 1.0) {
                    this.M.error("Please specify passband width as a percentage into the signal (i.e. 0 < bwn < 1.0)!");
                }
                this.inds1 = this.detInds(this.freq1, d30);
                this.inds2 = this.detInds(this.freq2, d29);
                this.indsn = this.detInds(d28, d);
                break;
            }
            case 10: {
                if (n != 8) {
                    this.M.error("Error! Error! Incorrect number of arguments for function: SONET! i.e. icemeasure sonet <out> <in1> <in2> <skip2> <frame> <cor> <off>");
                }
                this.ho.setSubRecords("ERRORS|SD,PROC|SD,BER|SD");
                this.xfer = this.MA.getL("/TL", 4096);
                this.hi2 = this.MA.get("IN2") == null ? this.MA.getDataFile(4) : this.MA.getDataFile("IN2");
                this.hi2.open();
                this.hi2.setDFS(0);
                int n31 = this.MA.get("SKIP2") == null ? this.MA.getL(5) : this.MA.getL("SKIP2");
                this.xfer = this.MA.get("FRAME") == null ? this.MA.getL(6) : this.MA.getL("FRAME");
                this.frames = this.MA.get("COR") == null ? this.MA.getL(7) : this.MA.getL("COR");
                this.str = this.MA.get("OFF") == null ? this.MA.getS(8) : this.MA.getS("OFF");
                this.MR.put(this.str, -1);
                this.skip = n31 * this.xfer;
                this.dbi2 = this.hi2.getDataBuffer(this.xfer);
                this.hi2.seek((double)this.skip);
                this.mode = 24;
                this.matched = 0;
                this.seek_ind = 0;
                break;
            }
            case 11: {
                if (n != 4) {
                    this.M.error("Error! Error! Incorrect number of arguments for function: UDP! i.e. icemeasure udp <out> <in1> <levels>");
                }
                this.ho.setSubRecords("MAXDELTA|SD,ERRORS|SI");
                int n32 = this.MA.get("LEVELS") == null ? this.MA.getL(4) : this.MA.getL("LEVELS");
                this.thresh = Math.pow(2.0, n32);
                this.xfer = (int)this.thresh;
                break;
            }
            default: {
                this.M.error("Error! Function TBD does not exist! Valid functions are Bandwidth,Characterize,Flash,Harmonics,Histogram,Mse,NoiseFloor,Notch,Npr,Sonet,Udp");
            }
        }
        this.ho.open(2);
        this.dbi1 = this.hi1.getDataBuffer(this.xfer);
        return 0;
    }

    public int process() {
        int n = this.hi1.read(this.dbi1);
        if (n < 0) {
            return 9;
        }
        double[] dArray = this.dbi1.castD(true);
        switch (this.func) {
            case 1: {
                int n2;
                int n3 = this.inds1[0];
                int n4 = this.inds1[this.len1 - 1] + 1;
                System.arraycopy(dArray, n3, this.data1, 0, this.len1);
                int[] nArray = (int[])this.inds1.clone();
                this.qsort.sort(this.data1, nArray, this.len1);
                double d = this.data1[this.medind];
                double d2 = d * this.thresh;
                for (n2 = 0; n2 < this.medind && !(this.data1[n2] < d2); ++n2) {
                }
                double d3 = 100.0 * (double)n2 / (double)this.len1;
                double d4 = 0.0;
                if (this.len2 > 0) {
                    System.arraycopy(dArray, 0, this.data2, 0, n3);
                    System.arraycopy(dArray, n4, this.data2, n3, this.xfer - n4);
                    int[] nArray2 = (int[])this.inds2.clone();
                    this.qsort.sort(this.data2, nArray2, this.len2);
                    for (n2 = 0; n2 < this.len2 && !(this.data2[n2] < d2); ++n2) {
                        d4 = 100.0 * (double)(n2 + 1) / (double)this.xfer;
                    }
                }
                this.str = String.format("{MEDIAN=%f,IN=%f,OUT=%f}", 10.0 * Math.log10(d), d3, d4);
                break;
            }
            case 2: {
                int n5;
                double d = Double.MIN_VALUE;
                for (n5 = 0; n5 < this.len2; ++n5) {
                    if (!(d < dArray[this.inds2[n5]])) continue;
                    d = dArray[this.inds2[n5]];
                }
                System.arraycopy(dArray, this.inds1[0], this.data1, 0, this.len1);
                int[] nArray = (int[])this.inds1.clone();
                this.qsort.sort(this.data1, nArray, this.len1);
                int n6 = this.inds2[0];
                int n7 = this.inds2[this.len2 - 1];
                double d5 = Double.MIN_VALUE;
                int n8 = -1;
                for (n5 = 0; n5 < this.len1; ++n5) {
                    if (nArray[n5] >= n6 && nArray[n5] <= n7) continue;
                    d5 = this.data1[n5];
                    n8 = nArray[n5];
                    break;
                }
                double d6 = this.data1[this.medind];
                double d7 = d6 * this.thresh;
                int n9 = 0;
                for (n5 = 0; n5 < this.medind && !(this.data1[n5] < d7); ++n5) {
                    if (nArray[n5] >= n6 && nArray[n5] <= n7) continue;
                    ++n9;
                }
                double d8 = 10.0 * Math.log10(d);
                double d9 = 10.0 * Math.log10(d5);
                double d10 = 10.0 * Math.log10(d6) - this.adj_val;
                this.str = String.format("{SNR=%s,SFDR=%s,NF=%s,THRESH=%s,SIG=%s,MAXSPUR=%s,MAXSPURFREQ=%s}", d8 - d10, d8 - d9, d10, 100.0 * (double)n9 / (double)this.len1, d8, d9, this.freqFromInd(n8));
                break;
            }
            case 3: {
                MDevIce mDevIce = new MDevIce(this.MA, this.str);
                if (mDevIce.open() <= 0) {
                    this.M.error("Cannot open alias: " + this.str);
                    return 9;
                }
                if (mDevIce.reset(0) <= 0) {
                    this.M.error("Cannot reset card");
                    return 9;
                }
                if (mDevIce.setKey(0, 32768, this.dbi1.buf, 65536) <= 0) {
                    this.M.error("Cannot set flash");
                    return 9;
                }
                byte[] byArray = new byte[65536];
                if (mDevIce.getKey(0, 32768, byArray, 65536) <= 0) {
                    this.M.error("Cannot get flash");
                    return 9;
                }
                mDevIce.close();
                int n10 = new String(this.dbi1.buf).equals(new String(byArray)) ? 0 : 1;
                this.str = String.format("{ERROR=%s,SHA1=%s,SHA2=%s}", n10, this.checkSum(this.dbi1.buf, 65536), this.checkSum(byArray, 65536));
                break;
            }
            case 4: {
                int n11;
                double d = Double.MIN_VALUE;
                for (n11 = 0; n11 < this.len1; ++n11) {
                    if (!(d < dArray[this.inds1[n11]])) continue;
                    d = dArray[this.inds1[n11]];
                }
                double d11 = Double.MIN_VALUE;
                for (n11 = 0; n11 < this.len2; ++n11) {
                    if (!(d11 < dArray[this.inds2[n11]])) continue;
                    d11 = dArray[this.inds2[n11]];
                }
                String string = "";
                for (n11 = 0; n11 < this.spurs.size(); ++n11) {
                    double d12 = Double.MIN_VALUE;
                    int[] nArray = this.spurs.get(n11).getIndices();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (!(d12 < dArray[nArray[i]])) continue;
                        d12 = dArray[nArray[i]];
                    }
                    this.spurs.get(n11).setMaxPower(d12, -1);
                    string = String.format("%s,%sFREQ=%d", string, this.spurs.get(n11).getColumn(), (int)this.spurs.get(n11).getFreq());
                    string = String.format("%s,%sPOW=%.02f", string, this.spurs.get(n11).getColumn(), 10.0 * Math.log10(this.spurs.get(n11).getMaxPower()));
                    string = String.format("%s,%sDBC=%.02f", string, this.spurs.get(n11).getColumn(), -10.0 * Math.log10(d / this.spurs.get(n11).getMaxPower()));
                }
                System.arraycopy(dArray, this.indsn[0], this.datan, 0, this.lenn);
                int[] nArray = (int[])this.indsn.clone();
                this.qsort.sort(this.datan, nArray, this.lenn);
                int n12 = this.inds1[0];
                int n13 = this.inds1[this.len1 - 1];
                int n14 = this.inds2[0];
                int n15 = this.inds2[this.len2 - 1];
                double d13 = Double.MIN_VALUE;
                int n16 = -1;
                for (n11 = 0; n11 < this.lenn; ++n11) {
                    if (nArray[n11] >= n12 && nArray[n11] <= n13 || nArray[n11] >= n14 && nArray[n11] <= n15) continue;
                    d13 = this.datan[n11];
                    n16 = nArray[n11];
                    break;
                }
                int n17 = 0;
                double d14 = this.datan[this.medind];
                double d15 = d14 * this.thresh;
                for (n11 = 0; n11 < this.medind && !(this.datan[n11] < d15); ++n11) {
                    if (nArray[n11] >= n12 && nArray[n11] <= n13 || nArray[n11] >= n14 && nArray[n11] <= n15) continue;
                    ++n17;
                }
                this.str = String.format("{SNR=%.02f,S1S2=%.02f,SFDR=%.02f,NF=%02f,THRESH=%.02f,MAXSPURFREQ=%d,MAXSPUR=%.02f%s}", 10.0 * Math.log10(d / d14) + this.adj_val, 10.0 * Math.log10(d / d11), 10.0 * Math.log10(d / d13), 10.0 * Math.log10(d14) - this.adj_val, 100.0 * (double)n17 / (double)this.lenn, (int)this.unmapFreq(this.freqFromInd(n16)), 10.0 * Math.log10(d13), string);
                break;
            }
            case 5: {
                int n18;
                int n19 = this.bit_accumr.length;
                for (n18 = 0; n18 < n19; ++n18) {
                    this.bit_accumi[n18] = 0L;
                    this.bit_accumr[n18] = 0L;
                }
                for (n18 = 0; n18 < 2 * n; n18 += 2) {
                    int n20 = (int)(dArray[n18] >= 0.0 ? dArray[n18] : 0.0);
                    int n21 = (int)(dArray[n18 + 1] >= 0.0 ? dArray[n18 + 1] : 0.0);
                    for (int i = 0; i < n19; ++i) {
                        if (n20 >= this.indsn[i]) {
                            int n22 = i;
                            this.bit_accumr[n22] = this.bit_accumr[n22] + 1L;
                            n20 %= this.indsn[i];
                        }
                        if (n21 < this.indsn[i]) continue;
                        int n23 = i;
                        this.bit_accumi[n23] = this.bit_accumi[n23] + 1L;
                        n21 %= this.indsn[i];
                    }
                }
                this.str = "{REMSB=" + this.bit_accumr[0] + ",IMMSB=" + this.bit_accumi[0];
                for (n18 = 1; n18 < n19; ++n18) {
                    this.str = this.str + ",RE" + n18 + "=" + this.bit_accumr[n18] + ",IM" + n18 + "=" + this.bit_accumi[n18];
                }
                this.str = this.str + "}";
                break;
            }
            case 6: {
                int n24;
                int n25 = this.hi2.read(this.dbi2);
                if (n25 < 0) {
                    return 9;
                }
                double[] dArray2 = this.dbi2.castD(true);
                double d = 0.0;
                double d16 = 0.0;
                for (n24 = 0; n24 < this.len1; ++n24) {
                    this.data1[n24] = Math.sqrt(dArray[this.inds1[n24]]);
                    this.data2[n24] = Math.sqrt(dArray2[this.inds1[n24]]);
                    d16 += this.data1[n24] / (double)this.len1;
                    d += this.data2[n24] / (double)this.len1;
                }
                this.dbi2.uncast(dArray2, false);
                double d17 = d16 / d;
                double d18 = -1.0;
                double d19 = 0.0;
                double d20 = 1.0 / (d16 * d16 * (double)this.len1 / (double)this.indsn.length);
                int n26 = this.inds1[0];
                int n27 = 0;
                for (n24 = 0; n24 < this.indsn.length; ++n24) {
                    double d21 = 0.0;
                    double d22 = 0.0;
                    while (n26 < this.indsn[n24]) {
                        d22 += this.data1[n27];
                        d21 += this.data2[n27];
                        ++n26;
                        ++n27;
                    }
                    double d23 = Math.pow(d22 - d17 * d21, 2.0) * d20;
                    if (d18 < d23) {
                        d18 = d23;
                    }
                    d19 += d23;
                }
                this.str = String.format("{AVERAGE=%f,WORST=%f}", d19 / (double)this.indsn.length, d18);
                break;
            }
            case 7: {
                int n28;
                System.arraycopy(dArray, this.inds1[0], this.data1, 0, this.len1);
                int[] nArray = (int[])this.inds1.clone();
                this.qsort.sort(this.data1, nArray, this.len1);
                double d = this.data1[this.medind];
                double d24 = this.thresh * d;
                for (n28 = 0; n28 < this.medind && !(this.data1[n28] < d24); ++n28) {
                }
                this.str = String.format("{NF=%f,THRESH=%f,MAXSPUR=%f,MAXSPURFREQ=%f}", 10.0 * Math.log10(d) - this.adj_val, 100.0 * (double)(n28 + 1) / (double)this.len1, 10.0 * Math.log10(this.data1[0]), this.freqFromInd(nArray[0]));
                break;
            }
            case 8: {
                System.arraycopy(dArray, this.inds1[0], this.data1, 0, this.len1);
                System.arraycopy(dArray, this.inds2[0], this.data2, 0, this.len2);
                int[] nArray = (int[])this.inds1.clone();
                this.qsort.sort(this.data1, nArray, this.len1);
                int[] nArray3 = (int[])this.inds2.clone();
                this.qsort.sort(this.data2, nArray3, this.len2);
                double d = Double.MIN_VALUE;
                for (int i = this.inds1[0]; i < this.inds1[this.len1 - 1]; ++i) {
                    if (!(d < dArray[i])) continue;
                    d = dArray[i];
                }
                this.str = String.format("{MEDIAN=%f,NOTCH=%f,TONE=%f}", 10.0 * Math.log10(this.data2[this.len2 / 2]), 10.0 * Math.log10(this.data1[this.len1 / 2]), 10.0 * Math.log10(d));
                break;
            }
            case 9: {
                int n29;
                double d = 0.0;
                for (n29 = 0; n29 < this.inds1.length; ++n29) {
                    d += dArray[this.inds1[n29]];
                }
                d /= (double)this.inds1.length;
                double d25 = 0.0;
                for (n29 = 0; n29 < this.inds2.length; ++n29) {
                    d25 += dArray[this.inds2[n29]];
                }
                d25 /= (double)this.inds2.length;
                double d26 = 0.0;
                for (n29 = 0; n29 < this.indsn.length; ++n29) {
                    d26 += dArray[this.indsn[n29]];
                }
                this.str = String.format("{SIGNAL=%f,NOTCH=%f}", 10.0 * Math.log10(d / d25), 10.0 * Math.log10(d / (d26 /= (double)this.indsn.length)));
                break;
            }
            case 10: {
                int n30 = this.hi2.read(this.dbi2);
                int n31 = this.len1 = n30 > n ? n : n30;
                if (this.len1 <= 0) {
                    return 9;
                }
                double[] dArray3 = this.dbi2.castD(true);
                switch (this.mode) {
                    case 24: {
                        for (int i = 0; i < this.len1; ++i) {
                            if (dArray[i] == dArray3[i]) continue;
                            this.matched = 0;
                            ++this.seek_ind;
                            this.hi1.seek((double)(this.seek_ind * this.xfer));
                            this.hi2.seek((double)this.skip);
                            this.dbi1.uncast(dArray, false);
                            this.dbi2.uncast(dArray3, false);
                            return 0;
                        }
                        this.dbi1.uncast(dArray, false);
                        this.dbi2.uncast(dArray3, false);
                        ++this.matched;
                        if (this.matched >= this.frames) {
                            this.mode = 25;
                            this.hi1.seek((double)(this.seek_ind * this.xfer));
                            this.hi2.seek((double)this.skip);
                            this.MR.put(this.str, this.seek_ind * this.xfer);
                        }
                        return 0;
                    }
                    case 25: {
                        double d = 0.0;
                        double d27 = 0.0;
                        for (int i = 0; i < this.len1; ++i) {
                            if (dArray[i] == dArray3[i]) continue;
                            d27 += 1.0;
                        }
                        this.dbi2.uncast(dArray3, false);
                        this.str = String.format("{ERRORS=%s,PROC=%s,BER=%.02f}", d27, d += (double)this.len1, 100.0 * (d27 / d));
                    }
                }
                break;
            }
            case 11: {
                double d = 0.0;
                int n32 = 0;
                for (int i = 1; i < dArray.length; ++i) {
                    double d28 = Math.abs(dArray[i] - dArray[i - 1]);
                    if (d28 == 2.0 * this.thresh - 1.0) continue;
                    if (d28 > d) {
                        d = d28;
                    }
                    if (!(d28 > 1.0)) continue;
                    ++n32;
                }
                this.str = String.format("{MAXDELTA=%f,ERRORS=%s}", d, n32);
                break;
            }
            default: {
                this.str = null;
                this.M.error("Got through to default case!!");
            }
        }
        this.ho.insertData(-1.0, (Object)new Table(this.str));
        this.dbi1.uncast(dArray, false);
        return 0;
    }

    public int close() {
        this.hi1.close();
        this.ho.close();
        if (this.hi2 != null) {
            this.hi2.close();
        }
        return 9;
    }

    private double mapFreq(double d) {
        return this.complex ? d + 0.5 * this.fs : d;
    }

    private double unmapFreq(double d) {
        return this.complex ? d - 0.5 * this.fs : d;
    }

    private double freqFromInd(int n) {
        return this.complex ? (double)n * this.fpb - 0.5 * this.fs : (double)n * this.fpb;
    }

    private int[] fillIndices(double d, int n, int n2) {
        if (d < 0.0 || d >= this.fs) {
            int[] nArray = new int[]{0};
            return nArray;
        }
        double d2 = d / this.fpb;
        int n3 = (int)Math.floor(d2 - 0.5 * (double)n);
        int n4 = (int)Math.ceil(d2 + 0.5 * (double)n);
        n3 = n3 < n2 ? n2 : n3;
        int n5 = n4 = n4 >= this.xfer - (n2 + 1) ? this.xfer - (n2 + 1) : n4;
        if (n3 >= this.xfer || n4 <= 0 || n4 < n3) {
            this.M.warning((CharSequence)"Signal falls outside of sampling rate!!!");
            int[] nArray = new int[]{0};
            return nArray;
        }
        int[] nArray = new int[n4 - n3 + 1];
        int n6 = 0;
        int n7 = n3;
        while (n7 <= n4) {
            nArray[n6] = n7++;
            ++n6;
        }
        return nArray;
    }

    private int[] detInds(double d, double d2) {
        int n = (int)Math.ceil((double)this.xfer * d);
        int n2 = (int)Math.floor((double)this.xfer * d2);
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i + n;
        }
        return nArray;
    }

    private int detDcInds(int n) {
        return (int)Math.floor(0.01 * (double)n);
    }

    private String checkSum(byte[] byArray, int n) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(byArray, 0, n);
            byte[] byArray2 = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray2.length; ++i) {
                stringBuffer.append(String.format("%02x", byArray2[i] & 0xFF));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private class QuickSort {
        private double[] out;
        private int[] ind;

        private QuickSort() {
        }

        public void sort(double[] dArray, int[] nArray, int n) {
            this.out = dArray;
            this.ind = nArray;
            this.quicksortInds(0, n - 1);
        }

        public void sort(double[] dArray, int n) {
            this.out = dArray;
            this.quicksort(0, n - 1);
        }

        private void quicksortInds(int n, int n2) {
            int n3 = n;
            int n4 = n2;
            double d = this.out[n + (n2 - n) / 2];
            while (n3 <= n4) {
                while (this.out[n3] > d) {
                    ++n3;
                }
                while (this.out[n4] < d) {
                    --n4;
                }
                if (n3 > n4) continue;
                this.swapInds(n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.quicksortInds(n, n4);
            }
            if (n3 < n2) {
                this.quicksortInds(n3, n2);
            }
        }

        private void quicksort(int n, int n2) {
            int n3 = n;
            int n4 = n2;
            double d = this.out[n + (n2 - n) / 2];
            while (n3 <= n4) {
                while (this.out[n3] > d) {
                    ++n3;
                }
                while (this.out[n4] < d) {
                    --n4;
                }
                if (n3 > n4) continue;
                this.swap(n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.quicksort(n, n4);
            }
            if (n3 < n2) {
                this.quicksort(n3, n2);
            }
        }

        private void swapInds(int n, int n2) {
            double d = this.out[n];
            int n3 = this.ind[n];
            this.out[n] = this.out[n2];
            this.out[n2] = d;
            this.ind[n] = this.ind[n2];
            this.ind[n2] = n3;
        }

        private void swap(int n, int n2) {
            double d = this.out[n];
            this.out[n] = this.out[n2];
            this.out[n2] = d;
        }
    }

    private class IceSpur {
        private int[] inds = null;
        private double freq = 0.0;
        private double maxpow = 0.0;
        private int maxind = -1;
        private String col = null;

        public void setIndices(int[] nArray) {
            this.inds = nArray;
        }

        public void setMaxPower(double d, int n) {
            this.maxpow = d;
            this.maxind = n;
        }

        public void setColumn(String string) {
            this.col = string;
        }

        public void setFreq(double d) {
            this.freq = d;
        }

        public int[] getIndices() {
            return this.inds;
        }

        public double getMaxPower() {
            return this.maxpow;
        }

        public int getMaxInd() {
            return this.maxind;
        }

        public String getColumn() {
            return this.col;
        }

        public double getFreq() {
            return this.freq;
        }
    }
}

