/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.Archiver;
import nxm.ice.lib.DevIce;
import nxm.ice.lib.MDevIce;
import nxm.ice.lib.RamDiskResource;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Native;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;
import nxm.sys.libg.GProgress;

public class icecopy
extends Primitive {
    private static final int XFER = 0x400000;
    private static final long B2G = 0x80000000L;
    private DataFile hi;
    private DataFile ho;
    private long length;
    private long offset;
    private long olen;
    private long ooff;
    private long ptr;
    private long ptrm;
    private long ptri;
    private long ptro;
    private int flags = F_NATIVE;
    private GProgress gpw;
    private double time;
    private double rate;
    private double osize;
    private MDevIce pic;
    private DevIce.DmaMap mapi;
    private DevIce.DmaMap mapo;
    private Archiver ha;
    private int replay;
    private int pass;
    private int unpack;
    private int upm;
    private byte[] tbuf;
    private String arch;
    private boolean async;
    private static int F_ATTACH = 1;
    private static int F_NATIVE = 2;
    private static int F_NIN = 4;
    private static int F_NOUT = 8;
    private static int F_ASYNC = 16;
    private static String flagList = "Attach,Native,nIn,nOut,Async";

    public int open() {
        this.flags = this.MA.getOptionMask("/FLAGS", flagList, this.flags);
        boolean bl = this.is(F_NATIVE);
        boolean bl2 = this.is(F_ATTACH) || this.MA.getState("/ATTACH");
        int n = bl ? 128 : 0;
        this.unpack = this.MA.getL("/UNPACK");
        this.arch = this.MA.getS("/ARCH");
        if (this.arch.length() <= 0) {
            this.arch = null;
        }
        this.replay = this.MA.getL("/REPLAY", 1);
        this.osize = this.MA.getD("/OSIZE", -1.0);
        this.async = this.is(F_ASYNC);
        this.pic = new MDevIce();
        if (this.pic.open("ICERAM", 0) < 0) {
            this.M.error("Problem opening ICERAM");
        }
        this.hi = this.MA.getDataFile("IN");
        this.hi.open(1 | n);
        if (this.hi.io instanceof RamDiskResource) {
            this.mapi = this.pic.mapFile(this.hi);
            if (this.mapi == null) {
                this.M.error("Problem mapping ICERAM DMA memory");
            }
            this.mapi.setPaged(false);
            this.ptri = this.mapi.getVirtualAddress(0L, this.mapi.bytes);
        }
        this.rate = this.hi.getRate();
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        this.ho.setDetached(bl2 ? 0 : 1);
        if (this.unpack == 12) {
            this.ho.setFormatType((byte)73);
        }
        if (this.arch != null) {
            this.ha = new Archiver();
            this.ha.init((MidasReference)this, this.ho.getURL() + this.arch, this.ho, 0);
            this.ha.open(128);
            this.osize = this.ha.getSize();
        } else {
            if (this.osize < 0.0) {
                this.osize = this.hi.getSize() * (double)this.replay;
            }
            this.ho.setSize(this.osize);
            this.ho.open(2 | n);
        }
        if (this.ho.io instanceof RamDiskResource) {
            this.mapo = this.pic.mapFile(this.ho);
            if (this.mapo == null) {
                this.M.error("Problem mapping ICERAM DMA memory");
            }
            this.mapo.setPaged(false);
            this.ptro = this.mapo.getVirtualAddress(0L, this.mapo.bytes);
            this.ho.seek(this.osize);
        }
        this.xfer = this.MA.getL("/TL", 0x400000);
        this.pass = 0;
        this.offset = 0L;
        this.length = (long)(this.hi.getSize() * (double)this.hi.bpa);
        this.ooff = 0L;
        this.olen = (long)(this.ho.getSize() * (double)this.ho.bpa);
        this.ptr = this.ptrm = Native.alloc((long)this.xfer);
        if (this.ptr < 0L) {
            this.M.error("Unable to allocate buffer");
        }
        double d = this.MA.getD("/TOP");
        double d2 = this.MA.getD("/DUR");
        if (this.unpack == 12) {
            this.xfer = this.xfer / 768 * 768;
            this.upm = this.rate > 6.5E8 ? -2 : -1;
            this.tbuf = new byte[this.xfer / 3 * 4];
            if (d > 0.0) {
                this.offset = (long)(d * 0.75 * this.rate) * (long)this.hi.bpa & 0xFFFFFFFFFFFFFF00L;
            }
            if (d2 > 0.0) {
                this.length = Math.min(this.length, this.offset + (long)(d2 * 0.75 * this.rate) * (long)this.hi.bpa);
            }
        } else {
            if (d > 0.0) {
                this.offset = (long)(d * this.rate) * (long)this.hi.bpa;
            }
            if (d2 > 0.0) {
                this.length = Math.min(this.length, this.offset + (long)(d2 * this.rate) * (long)this.hi.bpa);
            }
        }
        if (this.offset != 0L) {
            this.hi.seek((double)(this.offset / (long)this.hi.bpa));
        }
        if (this.MA.find("/AGPW")) {
            String string = "ICECOPY " + this.hi.getURL() + " to " + this.ho.getURL();
            this.gpw = new GProgress((Object)this, "Transfer Progress", "Run,Pause,Abort", string, 0, 0, 0, (MessageHandler)this);
            this.gpw.setLabel("PROGRESS");
        }
        this.time = Time.current();
        return 0;
    }

    public int process() {
        long l = Math.min(this.length - this.offset, this.olen - this.ooff);
        int n = (int)Math.min((long)this.xfer, l);
        if (n <= 0) {
            return 9;
        }
        int n2 = n;
        if (!this.is(F_NIN) && n2 > 0) {
            if (this.mapi != null) {
                this.ptr = this.ptri + this.offset;
            } else {
                n2 = this.mapo != null ? this.hi.read(this.ptro + this.ooff, 0, n) : this.hi.read(this.ptr, 0, n);
            }
        }
        int n3 = n2;
        if (!this.is(F_NOUT) && n3 > 0) {
            if (this.ha != null) {
                this.ha.write(this.ptr, 0, n2, -1);
            } else if (this.mapo != null) {
                if (this.mapi != null) {
                    Native.p2p((long)this.ptr, (int)0, (long)(this.ptro + this.ooff), (int)0, (int)n3);
                }
            } else if (this.unpack == 12) {
                n3 = n2 * 4 / 3;
                this.pic.cvt12(this.ptr, this.tbuf, n3, this.upm);
                this.ho.write(this.tbuf, 0, n3);
            } else if (!this.async || this.ho.io.avail() >= (long)n2) {
                n3 = this.ho.write(this.ptr, 0, n2);
            }
        }
        if (n3 < n2) {
            this.M.warning((CharSequence)"Problem performing I/O");
        }
        this.offset += (long)n2;
        if (this.offset == this.length) {
            this.offset = 0L;
            this.hi.seek((double)this.offset);
            ++this.pass;
        }
        this.ooff += (long)n3;
        if (this.ooff == this.olen) {
            this.ooff = 0L;
            this.ho.seek((double)this.ooff);
        }
        if (this.gpw != null) {
            this.gpw.setProgress(this.getProgress());
        }
        if (this.pass >= this.replay) {
            return 9;
        }
        return 0;
    }

    public int close() {
        double d = (long)this.pass * this.length + this.offset;
        double d2 = Time.current() - this.time;
        int n = (int)(1.0E-6 * d / Math.max(0.0011, d2));
        float f = (float)(d * 1.0E-6);
        float f2 = (float)(d2 - d2 % 0.001);
        if (this.verbose) {
            this.M.info((CharSequence)("Transfer rate = " + f + " / " + f2 + " = " + n + " Mby/sec"));
        }
        this.MR.put(this.MA.getU("/STAT"), n);
        if (this.mapi != null) {
            this.mapi.close();
        }
        if (this.mapo != null) {
            this.mapo.close();
        }
        if (this.pic != null) {
            this.pic.close();
        }
        if (this.ptrm > 0L) {
            Native.free((long)this.ptrm);
        }
        if (this.gpw != null) {
            this.gpw.close();
        }
        this.hi.close();
        this.ho.close();
        if (this.ha != null) {
            this.ha.flush();
            this.ha.close();
        }
        return 9;
    }

    public double getProgress() {
        return ((double)this.pass + (double)this.offset / (double)this.length) / (double)this.replay;
    }

    private boolean is(int n) {
        return (this.flags & n) != 0;
    }
}

