/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import java.io.File;
import nxm.ice.lib.DevIce;
import nxm.ice.lib.MDevIce;
import nxm.sys.lib.Convert;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class RamDiskResource
extends IOResource {
    private int fd;
    private int fb;
    private File file;
    private static int PGSZ = 8192;
    private static int PGMSK = PGSZ - 1;
    private long paddr = -1L;
    private long psize;
    private long rdaddr;
    private long rdsize;
    private String rdpath;
    public MDevIce pic;
    public DevIce.DmaMap map;
    private long extent = 0xFFFFFFL;
    File lockFile;

    public boolean exists() {
        return this.file.exists();
    }

    public boolean isFile() {
        return true;
    }

    public void setURL(String string) {
        super.setURL(string);
        if (string.startsWith("ramd:")) {
            string = string.substring(5);
        }
        this.file = new File(string);
    }

    public boolean open() {
        String string;
        this.isOpen = false;
        String string2 = null;
        Table table = (Table)this.M.results.get("AUX");
        String string3 = this.urlstr.substring(0, this.urlstr.lastIndexOf(47) + 1);
        Table.Iterator iterator = table.iterator();
        while (string2 == null && iterator.getNext()) {
            string = iterator.value.toString();
            if (!string.startsWith(string3)) continue;
            string2 = string;
        }
        if (string2 == null) {
            this.M.error("RamDisk AUX entry not found for: " + this.urlstr);
        }
        iterator = new Parser(string2);
        this.rdpath = iterator.get(1).substring(5);
        string = iterator.get(2);
        this.rdaddr = Convert.s2xl((String)iterator.get(3));
        this.rdsize = Convert.s2xl((String)iterator.get(4));
        if (this.urlstr.endsWith("/")) {
            return false;
        }
        int n = string.length() == 4 ? string.charAt(3) - 48 : 0;
        this.pic = new MDevIce(this.M, "ICERAM,DEVNO=" + n + ",IOM=NONE,PM=NONE");
        long l = this.M.results.getL("ENV.ICE.MAXALLOC", -1);
        if (l > 0L) {
            this.pic.setMaxAlloc(l << 20);
        }
        if (this.rdaddr == 0L && this.rdsize != 0L) {
            this.pic.open();
            this.rdaddr = this.pic.phys2long(this.pic.getKeyL(0, 129));
            this.pic.close();
        }
        this.fd = Native.fopen((String)this.file.toString(), (int)this.dir);
        byte[] byArray = new byte[16];
        if (this.dir <= 0) {
            Native.freadb((int)this.fd, (Object)byArray, (int)0, (int)16);
            this.paddr = Convert.unpackX((byte[])byArray, (int)0);
            this.psize = Convert.unpackX((byte[])byArray, (int)8);
            this.length = Math.min(this.length, this.psize);
        } else {
            this.lockFileAlloc();
            Convert.packX((byte[])byArray, (int)0, (long)-1L);
            Convert.packX((byte[])byArray, (int)8, (long)1L);
            Native.fwriteb((int)this.fd, (Object)byArray, (int)0, (int)16);
            Native.fseek((int)this.fd, (long)0L);
            this.psize = (this.length + (long)PGMSK) / (long)PGSZ * (long)PGSZ;
            this.getAllocation();
            Convert.packX((byte[])byArray, (int)0, (long)this.paddr);
            Convert.packX((byte[])byArray, (int)8, (long)this.psize);
            Native.fwriteb((int)this.fd, (Object)byArray, (int)0, (int)16);
            this.lockFileFree();
        }
        if (string.startsWith("RAM") || string.startsWith("ram")) {
            this.map = this.pic.getMap();
            this.map.mode = 2;
            this.map.bytes = this.length;
            this.map.paddr = this.getPhysicalAddress();
            this.map.dev = this.pic;
            this.map.devn = "iceram";
            if (string.length() == 4) {
                this.map.devn = "iceram" + n;
            }
            this.map.setPaged(Shell.ostag.startsWith("lin"));
            this.isOpen = true;
        } else {
            this.fb = Native.fopen((String)("/dev/" + string), (int)this.dir);
            Native.fseek((int)this.fb, (long)this.getPhysicalAddress());
            this.isOpen = this.fb > 0;
        }
        return this.isOpen;
    }

    public boolean close() {
        if (!this.isOpen) {
            return false;
        }
        if (this.fd != 0) {
            Native.fclose((int)this.fd);
        }
        if (this.fb != 0) {
            Native.fclose((int)this.fb);
        }
        if (this.map != null) {
            this.map.close(10);
        }
        this.isOpen = false;
        return true;
    }

    public boolean delete() {
        return this.file.delete();
    }

    public long getLength() {
        return this.length;
    }

    public boolean seek(long l) {
        if (l == this.offset) {
            return true;
        }
        this.offset = l;
        if (this.fb != 0) {
            Native.fseek((int)this.fb, (long)(this.getPhysicalAddress() + l));
        }
        return true;
    }

    public long avail() {
        return this.length - this.offset;
    }

    public int read(byte[] byArray, int n, int n2) {
        n2 = (int)Math.min((long)n2, this.length - this.offset);
        if (this.map != null) {
            long l = this.map.getVirtualAddress(this.offset, n2);
            Native.p2ja((long)l, (int)0, (Object)byArray, (int)n, (int)n2);
        } else {
            Native.freadb((int)this.fb, (Object)byArray, (int)n, (int)n2);
        }
        this.offset += (long)n2;
        return n2;
    }

    public int write(byte[] byArray, int n, int n2) {
        if (this.map != null) {
            n2 = (int)Math.min((long)n2, this.length - this.offset);
            long l = this.map.getVirtualAddress(this.offset, n2);
            Native.ja2p((Object)byArray, (int)n, (long)l, (int)0, (int)n2);
        } else {
            n2 = this.checkAllocation(n2);
            Native.fwriteb((int)this.fb, (Object)byArray, (int)n, (int)n2);
        }
        this.offset += (long)n2;
        return n2;
    }

    public int read(long l, int n, int n2) {
        n2 = (int)Math.min((long)n2, this.length - this.offset);
        if (this.map != null) {
            long l2 = this.map.getVirtualAddress(this.offset, n2);
            Native.p2p((long)l2, (int)0, (long)l, (int)n, (int)n2);
        } else {
            Native.fread((int)this.fb, (long)l, (int)n, (int)n2);
        }
        this.offset += (long)n2;
        return n2;
    }

    public int write(long l, int n, int n2) {
        if (this.map != null) {
            n2 = (int)Math.min((long)n2, this.length - this.offset);
            long l2 = this.map.getVirtualAddress(this.offset, n2);
            Native.p2p((long)l, (int)n, (long)l2, (int)0, (int)n2);
        } else {
            n2 = this.checkAllocation(n2);
            Native.fwrite((int)this.fb, (long)l, (int)n, (int)n2);
        }
        this.offset += (long)n2;
        return n2;
    }

    public String toString() {
        return "RamDiskResource : " + this.getURL();
    }

    private synchronized void getAllocation() {
        long l;
        int n;
        String[] stringArray = this.M.io.listFiles((Object)this.rdpath, "*", "det");
        int n2 = stringArray.length;
        long[] lArray = new long[n2 + 1];
        long[] lArray2 = new long[n2 + 1];
        byte[] byArray = new byte[16];
        for (int i = 0; i < n2; ++i) {
            int n3;
            String string = this.rdpath + stringArray[i];
            n = Native.fopen((String)string, (int)-1);
            Native.freadb((int)n, (Object)byArray, (int)0, (int)16);
            Native.fclose((int)n);
            l = Convert.unpackX((byte[])byArray, (int)0);
            long l2 = Convert.unpackX((byte[])byArray, (int)8);
            for (n3 = 0; n3 < i && l > lArray[n3]; ++n3) {
            }
            for (int j = i - 1; j >= n3; --j) {
                lArray[j + 1] = lArray[j];
                lArray2[j + 1] = lArray2[j];
            }
            lArray[n3] = l;
            lArray2[n3] = l2;
        }
        this.paddr = -1L;
        long l3 = lArray[n2] = this.rdsize;
        for (n = n2 - 1; n >= 0; --n) {
            l = lArray[n + 1] - (lArray[n] + lArray2[n]);
            if (l < this.psize || l > l3) continue;
            this.paddr = lArray[n] + lArray2[n];
            l3 = l;
        }
        if (this.paddr < 0L) {
            this.M.error("Could not allocate RamDisk buffer of " + this.psize + " bytes");
        }
    }

    public int checkAllocation(int n) {
        long l = this.offset + (long)n;
        if (this.length >= l) {
            return n;
        }
        this.length = l;
        if (this.psize >= this.length) {
            return n;
        }
        this.psize = l + (long)n + this.extent & (this.extent ^ 0xFFFFFFFFFFFFFFFFL);
        byte[] byArray = new byte[16];
        Convert.packX((byte[])byArray, (int)0, (long)this.paddr);
        Convert.packX((byte[])byArray, (int)8, (long)this.psize);
        Native.fseek((int)this.fd, (long)0L);
        Native.fwriteb((int)this.fd, (Object)byArray, (int)0, (int)16);
        return n;
    }

    public long getPhysicalAddress() {
        return this.rdaddr + this.paddr;
    }

    public Table getStatFS() {
        int n;
        int n2;
        if (!this.isOpen) {
            this.open();
        }
        String[] stringArray = this.M.io.listFiles((Object)this.rdpath, "*", "det");
        int n3 = stringArray.length;
        long l = 0L;
        byte[] byArray = new byte[16];
        for (n2 = 0; n2 < n3; ++n2) {
            String string = this.rdpath + stringArray[n2];
            n = Native.fopen((String)string, (int)-1);
            Native.freadb((int)n, (Object)byArray, (int)0, (int)16);
            Native.fclose((int)n);
            long l2 = Convert.unpackX((byte[])byArray, (int)8);
            l += l2;
        }
        n2 = (int)(this.rdsize / 1000000L);
        int n4 = n2 - (int)(l / 1000000L);
        n = 100 - 100 * n4 / n2;
        String string = "{PATH=" + this.rdpath + ",FILES=" + n3 + ",TMBY=" + n2 + ",FMBY=" + n4 + ",USED=" + n + "}";
        return new Table(string);
    }

    private void lockFileAlloc() {
        this.lockFile = new File(this.rdpath + "allocate.LOCK");
        for (int i = 0; i < 100; ++i) {
            try {
                if (this.lockFile.createNewFile()) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Time.sleep((double)0.01);
        }
        System.out.println("Overriding stale lock file " + this.lockFile);
    }

    private void lockFileFree() {
        this.lockFile.delete();
    }
}

