/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import java.io.InputStream;
import java.io.OutputStream;
import nxm.ice.lib.MDevIce;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Midas;
import nxm.sys.lib.OS;
import nxm.sys.lib.Query;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class IceSys {
    public static Table config;
    public static Midas M;
    public static boolean isLoaded;

    public IceSys() {
        IceSys.load();
    }

    public static boolean load() {
        M = Shell.getMidasContext();
        String string = IceSys.M.io.name("HOME", "iceauto", "tbl", "AUX");
        config = Convert.o2t((Object)string, (Object)M);
        return true;
    }

    public static void query(String string) {
        String string2;
        int n = 0;
        String string3 = null;
        int n2 = 32;
        Object object = config;
        Query query = new Query(object, string3, n2);
        int n3 = string.length();
        int n4 = string.indexOf("=");
        if (n4 < 0) {
            n4 = n3;
        }
        int n5 = 0;
        while ((n = string.indexOf("/", n5)) > n5) {
            int n6;
            if ((n6 = string.indexOf("/", ++n)) < 0) {
                n6 = n4;
            }
            string2 = string.substring(n, n6);
            System.out.println("Key=" + string2);
            query.parse();
            object = query.getObject(string2);
            query = new Query(object, string3, n2);
            n5 = n;
        }
        if (n < 0) {
            n = 0;
        }
        string2 = string.substring(n, n4);
        query.parse();
        object = query.getObject(string2);
        System.out.println(string.substring(0, n4) + "=" + object);
    }

    public static Table getNICs() {
        Table table = new Table();
        int n = config.getL("NICS");
        table.put("NICS", n);
        for (int i = 0; i < n; ++i) {
            String string = "NIC" + i + "AUTO";
            String string2 = config.getS(string);
            Table table2 = new Table("{" + string2 + "}");
            table.put(string, (Object)table2);
        }
        return table;
    }

    public static Table getPICs() {
        Table table = new Table();
        int n = config.getL("PICS");
        table.put("PICS", n);
        for (int i = 1; i <= n; ++i) {
            String string = "PIC" + i + "AUTO";
            String string2 = config.getS(string);
            MDevIce mDevIce = new MDevIce(M, string2);
            while (string2.endsWith(",")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            mDevIce.open();
            int n2 = mDevIce.getKeyL(0, 17);
            int n3 = -1;
            int[] nArray = new int[]{-1, -1, -1, -1, -1};
            if (n2 >= 0) {
                n3 = nArray[0] = (int)mDevIce.getKeyD(0, 106);
                if (mDevIce.getKeyL(0, 191) != 0) {
                    nArray[1] = (int)mDevIce.getKeyD(1, 106);
                    if (nArray[1] > n3) {
                        n3 = nArray[1];
                    }
                }
                if (mDevIce.getKeyL(0, 192) != 0) {
                    nArray[2] = (int)mDevIce.getKeyD(2, 106);
                    if (nArray[2] > n3) {
                        n3 = nArray[2];
                    }
                }
                if (mDevIce.getKeyL(0, 195) != 0) {
                    nArray[3] = (int)mDevIce.getKeyD(11, 106);
                    if (nArray[3] > n3) {
                        n3 = nArray[3];
                    }
                }
                if (mDevIce.getKeyL(0, 196) != 0) {
                    nArray[4] = (int)mDevIce.getKeyD(12, 106);
                    if (nArray[4] > n3) {
                        n3 = nArray[4];
                    }
                }
            }
            int n4 = n2 >= 0 ? mDevIce.getKeyL(0, 161) : 0;
            mDevIce.close();
            string2 = string2.replace("ICEPIC", "ACTIVE=" + n2 + ",TEMP=" + n3 + ",FLAGS=" + Convert.l2x((int)n4));
            string2 = string2 + ",COMPTEMP=(" + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + nArray[4] + ")";
            Table table2 = new Table("{" + string2 + "}");
            table.put(string, (Object)table2);
        }
        return table;
    }

    public static Table getQICs() {
        Table table = new Table();
        int n = config.getL("QICS");
        table.put("QICS", n);
        return table;
    }

    public static Table getDisks() {
        Table table = new Table();
        String string = IceSys.M.results.getS("AUX.READ");
        String[] stringArray = StringUtil.cleanSplit((String)string, (String)"|");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = IceSys.M.io.getAuxPath(string2);
            Table table2 = OS.getStatFS((String)string3);
            table.put(string2, (Object)table2);
        }
        return table;
    }

    public static Table getFS() {
        return null;
    }

    public static int runCommand(String string, int n, byte[] byArray) {
        int n2 = 0;
        int n3 = 20;
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string);
            OutputStream outputStream = process.getOutputStream();
            InputStream inputStream = process.getInputStream();
            int n4 = 0;
            while (n4 >= 0 && n3 != 0 && n2 < byArray.length) {
                int n5 = inputStream.available();
                if (n5 > 0) {
                    n5 = Math.min(n5, byArray.length - n2);
                    if ((n5 = inputStream.read(byArray, n2, n5)) > 0) {
                        n2 += n5;
                    }
                    n4 = 1;
                }
                try {
                    int n6 = process.exitValue();
                    if (inputStream.available() > 0) {
                        n4 = 0;
                        continue;
                    }
                    n4 = -1;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (n4 == 0) {
                        Time.sleep((double)0.1);
                        --n3;
                        continue;
                    }
                    n4 = 0;
                }
            }
            outputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            Shell.printStackTrace((CharSequence)"Error running OS cmd", (Throwable)exception);
        }
        return n2;
    }

    static {
        isLoaded = IceSys.load();
    }
}

