/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.IceJVM;

public class IceNVME
extends IceJVM {
    public static final int DSCR = 0x800000;
    public static final int DBUF = 0x800000;
    public static final int DBUFX = 0x800010;
    public static final int BSCR = 0x810000;
    public static final int BMGM = 8455920;
    public static final int BPGL = 8455936;
    public static final int BCQ0 = 0x810800;
    public static final int BCQ1 = 8456448;
    public static final int BSQ0 = 8456704;
    public static final int BSQ1 = 8457216;
    public static final int BBUF = 0x811000;
    public static final int XMEM = 8192;
    public static final int XPGP = 16384;
    public static final int SQS0 = 8;
    public static final int CQS0 = 16;
    public static final int SQS1 = 16;
    public static final int CQS1 = 16;
    public static final int DCFG = 98304;
    public static final int DCMD = 81920;
    public static final int CF_SLOTS = 131080;
    public static final int CF_SNIFF = 131072;
    public static final int CF_XFER = 131088;
    public static final int R_STATE = 96;
    public static final int R_STATUS = 100;
    public static final int R_QIO = 104;
    public static final int R_QDIF = 108;
    public static final int Q_WRB = 0x20000000;
    public static final int Q_RDB = 0x10000000;
    public static final int CMD_RVW = 0x1000000;
    public static final int CMD_RVC = 0x2000000;
    public static final int CMD_CYC = 0x4000000;
    public static final int CMD_CFG = 0x8000000;
    public static final int CMD_RST = 0x10000000;
    public static final int CMD_ACK = 0x20000000;
    public static final int CIDTAG = 0x1000000;
    public static final int OPCODE_DELETE_SQ = 0;
    public static final int OPCODE_CREATE_SQ = 1;
    public static final int OPCODE_DELETE_CQ = 4;
    public static final int OPCODE_CREATE_CQ = 5;
    public static final int OPCODE_IDENTIFY = 6;
    public static final int OPCODE_SET_FEATURE = 9;
    public static final int OPCODE_FLUSH = 0;
    public static final int OPCODE_WRITE = 1;
    public static final int OPCODE_READ = 2;
    public static final int OPCODE_MANAGE = 9;
    public static final int OPCODE_USESGL = 16384;
    static int cqhead0;
    static int cqhead1;
    static int sqtail0;
    static int sqtail1;
    static int requests;
    static int ttt;
    static int useSGL;

    public static void run() {
        int n = 0;
        for (int i = 0; i < 256; i += 4) {
            IceNVME.awMem(i, 0);
            IceNVME.awMem(-50266116, i);
        }
        IceNVME.resetFIFOs();
        IceNVME.awMem(24, 484442112);
        useSGL = 0;
        int n2 = 484442112;
        while (true) {
            int n3;
            int n4;
            IceNVME.awMem(-50266116, n2);
            int n5 = IceNVME.arBus(81920);
            boolean bl = (n5 & 0x80) != 0;
            IceNVME.awMem(16, n5);
            if (n == 0) {
                if (bl) {
                    IceNVME.awMem(-50266116, 484487175);
                    n = IceNVME.boot();
                }
            } else if (!bl) {
                n = 0;
            }
            if ((n4 = IceNVME.arBusSync(131080) & 0xFFF) >= 4) {
                IceNVME.processCmdFifo();
            }
            if ((n3 = IceNVME.arMemSync(24) & 0xFF) > 0) {
                if (n3 == 99) {
                    n = IceNVME.fullReset();
                } else {
                    IceNVME.command(n3);
                }
                IceNVME.awMem(24, 484442112);
            }
            if ((n2 & 0xFFF) == 0) {
                n5 &= 0xFFFF;
                n5 |= n << 16;
                if (n > 0) {
                    n5 |= IceNVME.rdmem(28) << 24;
                }
                IceNVME.awMem(28, n5);
            }
            IceNVME.handleCompletions1();
            ++n2;
        }
    }

    public static void waitOnFI(int n) {
        while (n > 0 && (IceNVME.arBus(81920) & 0x20000) == 0) {
            IceNVME.udelay(1000);
            --n;
        }
    }

    public static void waitOnFO(int n) {
        while (n > 0 && (IceNVME.arBus(81920) & 0x40000) == 0) {
            IceNVME.udelay(1000);
            --n;
        }
    }

    public static int fullReset() {
        IceNVME.awBus(81920, 0x50000000);
        IceNVME.awBus(81920, 0);
        return 0;
    }

    public static void resetFIFOs() {
        IceNVME.awBus(81920, 0x10000000);
        IceNVME.awBus(81920, 0);
    }

    public static int boot() {
        int n = 0;
        int n2 = 0;
        IceNVME.resetFIFOs();
        IceNVME.zeroMem(0x800000, 64);
        for (n2 = 1; n == 0 && n2 < 8; ++n2) {
            IceNVME.configRoot();
            IceNVME.udelay(100);
            IceNVME.configTarget();
            n = IceNVME.rdmem(0);
        }
        return n2;
    }

    public static void command(int n) {
        int n2;
        if (n == 1) {
            for (n2 = 0; n2 < 256; n2 += 4) {
                IceNVME.awMem(2048 + n2, n2 >= 240 ? ttt : (n2 >= 224 ? IceNVME.arBus(81920) : IceNVME.arMem(0x800000 + n2)));
            }
        }
        if (n == 1) {
            IceNVME.awMem(2296, cqhead0);
            IceNVME.awMem(2300, cqhead1);
        }
        if (n == 2) {
            for (n2 = 0; n2 < 256; n2 += 4) {
                IceNVME.awMem(2048 + n2, IceNVME.rdmem(n2));
            }
        }
        if (n == 2) {
            for (n2 = 0; n2 < 16; n2 += 4) {
                IceNVME.awMem(2272 + n2, IceNVME.rdmem(4096 + n2));
            }
        }
        if (n == 2) {
            for (n2 = 0; n2 < 16; n2 += 4) {
                IceNVME.awMem(2288 + n2, IceNVME.rdmem(8192 + n2));
            }
        }
        if (n == 3) {
            for (n2 = 0; n2 < 256; n2 += 4) {
                IceNVME.awMem(2048 + n2, IceNVME.rdcfg(n2));
            }
        }
        if (n == 4) {
            for (n2 = 0; n2 < 256; n2 += 4) {
                IceNVME.awMem(2048 + n2, IceNVME.rdcfgl(n2));
            }
        }
        if (n == 5) {
            for (n2 = 0; n2 < 256; n2 += 4) {
                IceNVME.awMem(2048 + n2, IceNVME.arBus(262144));
            }
        }
        if (n == 6) {
            IceNVME.enableController();
        }
        if (n == 6) {
            IceNVME.configController();
        }
        if (n == 7) {
            IceNVME.awMem(2048, IceNVME.arBus(81920));
        }
        if (n == 8) {
            IceNVME.identify(1, 512, 0);
        }
        if (n == 9) {
            IceNVME.disableController();
        }
        if (n == 10) {
            for (n2 = 0; n2 < 256; n2 += 4) {
                IceNVME.awMem(2048 + n2, IceNVME.arMem(0x810800 + n2));
            }
        }
        if (n == 11) {
            for (n2 = 0; n2 < 256; n2 += 4) {
                IceNVME.awMem(2048 + n2, IceNVME.arMem(8456704 + n2));
            }
        }
        if (n == 12) {
            for (n2 = 0; n2 < 256; n2 += 4) {
                IceNVME.awMem(2048 + n2, IceNVME.arMem(8456704 + n2 + 256));
            }
        }
        if (n == 20) {
            for (n2 = 0; n2 < 256; n2 += 4) {
                IceNVME.awMem(2048 + n2, IceNVME.arMem(8456448 + n2));
            }
        }
        if (n == 21) {
            for (n2 = 0; n2 < 256; n2 += 4) {
                IceNVME.awMem(2048 + n2, IceNVME.arMem(8457216 + n2));
            }
        }
        if (n == 22) {
            for (n2 = 0; n2 < 256; n2 += 4) {
                IceNVME.awMem(2048 + n2, IceNVME.arMem(8457216 + n2 + 256));
            }
        }
        if (n == 23) {
            for (n2 = 0; n2 < 256; n2 += 4) {
                IceNVME.awMem(2048 + n2, IceNVME.arMem(8457216 + n2 + 512));
            }
        }
        if (n == 24) {
            for (n2 = 0; n2 < 256; n2 += 4) {
                IceNVME.awMem(2048 + n2, IceNVME.arMem(8457216 + n2 + 768));
            }
        }
        if (n == 30) {
            IceNVME.identify(0, 512, 0);
        }
        if (n == 31) {
            IceNVME.identify(1, 512, 0);
        }
        if (n == 32) {
            IceNVME.identify(2, 512, 0);
        }
        if (n == 33) {
            IceNVME.identify(1, 512, 512);
        }
        if (n == 40) {
            IceNVME.capabilities();
        }
        if (n == 98) {
            IceNVME.boot();
        }
    }

    public static void identify(int n, int n2, int n3) {
        int n4 = n == 0 ? 1 : 0;
        IceNVME.submitQueue0(6, n4, 4096, n, 0);
        if (n == 1) {
            int n5 = IceNVME.arMem(0x811218);
            useSGL = (n5 & 3) != 0 ? 16384 : 0;
            IceNVME.awMem(8458556, useSGL);
        }
        IceNVME.copyMem(0x811000 + n3, 2048, n2);
    }

    public static void processCmdFifo() {
        int n = IceNVME.arBus(131088);
        int n2 = IceNVME.rBus();
        int n3 = IceNVME.rBus();
        int n4 = IceNVME.rBus();
        if (n == 484442173) {
            IceNVME.rwBlocks(-1, n2, n3, n4);
        } else if (n == 484442174) {
            IceNVME.rwBlocks(1, n2, n3, n4);
        } else {
            IceNVME.cleanupCmdFifo();
        }
    }

    public static void cleanupCmdFifo() {
        while ((IceNVME.arBusSync(131080) & 0xFFF) > 0) {
            int n = IceNVME.arBus(131072);
            if (n == 484442173 || n == 484442174) {
                return;
            }
            IceNVME.arBus(131088);
        }
    }

    public static void rwBlocks(int n, int n2, int n3, int n4) {
        int n5 = cqhead1;
        int n6 = n > 0 ? 1 : 2;
        IceNVME.submitQueue1(n6, useSGL, 8192, n4, n3, n2);
        while (cqhead1 == n5) {
            IceNVME.handleCompletions1();
        }
    }

    public static int rdcfgl(int n) {
        IceNVME.arBus(98304 + n);
        return IceNVME.arBus(98304 + n);
    }

    public static int wrcfgl(int n, int n2) {
        IceNVME.awBus(98304 + n, n2);
        return n2;
    }

    public static void clearresp() {
        IceNVME.aBus(81920);
        for (int i = 0; i < 1000 && (IceNVME.rBus() & 0x4000) != 0; ++i) {
            IceNVME.wBus(133189632);
            IceNVME.udelay(1);
        }
    }

    public static void wait4resp() {
        IceNVME.aBus(81920);
        for (int i = 0; i < 1000 && (IceNVME.rBus() & 0x40) != 0; ++i) {
        }
    }

    public static int getresp() {
        IceNVME.aBus(81920);
        for (int i = 0; i < 1000 && (IceNVME.rBus() & 0x4000) == 0; ++i) {
        }
        IceNVME.wBus(133189633);
        maddr = 0x800010;
        return mdata;
    }

    public static int rdcfg(int n) {
        IceNVME.clearresp();
        maddr = 0x800000;
        mdata = n;
        mdata = 0;
        mdata = 16385;
        mdata = 0x1000000;
        IceNVME.awBus(81920, 116396032);
        return IceNVME.getresp();
    }

    public static int wrcfg(int n, int n2) {
        maddr = 0x800000;
        mdata = n;
        mdata = 0;
        mdata = 20481;
        mdata = 0x1000000;
        mdata = n2;
        IceNVME.awBus(81920, 101720065);
        return IceNVME.getresp();
    }

    public static int rdmem(int n) {
        IceNVME.clearresp();
        maddr = 0x800000;
        mdata = 0x1CE10000 | n;
        mdata = 0;
        mdata = 1;
        mdata = 0x1000000;
        IceNVME.awBus(81920, 116396032);
        return IceNVME.getresp();
    }

    public static void wrmem(int n, int n2) {
        maddr = 0x800000;
        mdata = 0x1CE10000 | n;
        mdata = 0;
        mdata = 2049;
        mdata = 0x1000000;
        mdata = n2;
        IceNVME.awBus(81920, 101720065);
    }

    public static void wrmemx(int n, int n2, int n3) {
        maddr = 0x800000;
        mdata = 0x1CE10000 | n;
        mdata = 0;
        mdata = 2050;
        mdata = 0x1000000;
        mdata = n3;
        mdata = n2;
        IceNVME.awBus(81920, 104341505);
    }

    public static int sndmsgD(int n, int n2) {
        maddr = 0x800000;
        mdata = 0;
        mdata = 0;
        mdata = 24577;
        mdata = 0x1040000 | n << 8;
        mdata = n2;
        IceNVME.awBus(81920, 101720065);
        return n2;
    }

    public static void configRoot() {
        IceNVME.wrcfgl(24, 65792);
        IceNVME.wrcfgl(4, -2147483642);
        IceNVME.wrcfgl(32, 0x40001000);
        IceNVME.wrcfgl(36, -65536);
        IceNVME.wrcfgl(40, 1);
        IceNVME.wrcfgl(44, 2);
        IceNVME.wrcfgl(48, -2147483647);
    }

    public static void configTarget() {
        IceNVME.wrcfg(4, -65536);
        IceNVME.wrcfg(16, -1);
        IceNVME.wrcfg(20, -1);
        IceNVME.wrcfg(24, -1);
        IceNVME.wrcfg(28, -1);
        IceNVME.wrcfg(16, 484507652);
        IceNVME.wrcfg(20, 0);
        IceNVME.wrcfg(4, -268435450);
    }

    public static void enableController() {
        cqhead0 = 0;
        cqhead1 = 0;
        sqtail0 = 0;
        sqtail1 = 0;
        requests = 0;
        IceNVME.wrmem(20, 0x460000);
        maddr = 8455936;
        for (int i = 1; i <= 32; ++i) {
            mdata = i << 12;
            mdata = 8192;
        }
        IceNVME.zeroMem(0x810000, 64);
        IceNVME.zeroMem(8456704, 128);
        IceNVME.zeroMem(0x810800, 64);
        IceNVME.zeroMem(8457216, 256);
        IceNVME.zeroMem(8456448, 64);
        IceNVME.wrmem(12, -1);
        IceNVME.wrmem(16, -1);
        IceNVME.wrmem(36, 983047);
        IceNVME.wrmemx(40, 2560, 0);
        IceNVME.wrmemx(48, 2048, 0);
        IceNVME.wrmem(4096, sqtail0);
        IceNVME.wrmem(4100, cqhead0);
        IceNVME.wrmem(4104, sqtail1);
        IceNVME.wrmem(4108, cqhead1);
        IceNVME.wrmem(20, 4587521);
    }

    public static void configController() {
        IceNVME.submitQueue0(9, 0, 0, 7, 0);
        IceNVME.submitQueue0(5, 0, 2304, 983041, 1);
        IceNVME.submitQueue0(1, 0, 3072, 983041, 65537);
    }

    public static void disableController() {
        IceNVME.submitQueue0(4, 0, 2304, 1, 0);
        IceNVME.submitQueue0(0, 0, 3072, 1, 0);
        IceNVME.wrmem(20, 0x460000);
    }

    public static void zeroMem(int n, int n2) {
        maddr = n;
        for (int i = 0; i < n2; ++i) {
            mdata = 0;
        }
    }

    public static void submitQueue0(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = sqtail0 & 7;
        maddr = n6 = 8456704 + (n7 << 6);
        mdata = (0x1CE0 | n7) << 16 | n;
        mdata = n2;
        maddr = n6 + 24;
        mdata = 0;
        mdata = n3;
        mdata = 0;
        mdata = 0;
        mdata = n4;
        mdata = n5;
        mdata = 0;
        n7 = ++sqtail0 & 7;
        IceNVME.wrmem(4096, n7);
        int n8 = cqhead0;
        for (int i = 0; i < 1000 && cqhead0 == n8; ++i) {
            IceNVME.udelay(1000);
            IceNVME.handleCompletions0();
        }
    }

    public static void submitQueue1(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = sqtail1 & 0xF;
        maddr = n7 = 8457216 + (n8 << 6);
        mdata = (0x1CE0 | n8) << 16 | n2 | n;
        mdata = 1;
        maddr = n7 + 24;
        mdata = 0;
        mdata = n3;
        if (n2 != 0) {
            mdata = n6 << 9;
            mdata = 0;
        } else if (n6 <= 8) {
            mdata = 0;
            mdata = 0;
        } else if (n6 <= 16) {
            mdata = 4096;
            mdata = n3;
        } else {
            mdata = 0;
            mdata = 1792;
        }
        mdata = n5;
        mdata = n4;
        mdata = n6 - 1;
        mdata = 82;
        n8 = ++sqtail1 & 0xF;
        IceNVME.wrmem(4104, n8);
    }

    public static void copyMem(int n, int n2, int n3) {
        int n4 = n3 >> 2;
        for (int i = 0; i < n4; ++i) {
            IceNVME.awMem(n2, IceNVME.arMem(n));
            n += 4;
            n2 += 4;
        }
    }

    public static int handleCompletions(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        for (int i = 0; i < 32 && (n7 = n >> 4) != (n6 = (n5 = IceNVME.arMem((n4 = n2 + ((n3 = n & 0xF) << 4)) + 12)) >> 16 & 1); ++i) {
            n = n + 1 & 0x1F;
        }
        return n;
    }

    public static void handleCompletions0() {
        int n = IceNVME.handleCompletions(cqhead0, 0x810800);
        if (n == cqhead0) {
            return;
        }
        cqhead0 = n;
        IceNVME.wrmem(4100, cqhead0 & 0xF);
    }

    public static void handleCompletions1() {
        int n = IceNVME.handleCompletions(cqhead1, 8456448);
        if (n == cqhead1) {
            return;
        }
        cqhead1 = n;
        IceNVME.wrmem(4108, cqhead1 & 0xF);
    }

    public static void capabilities() {
        int n = IceNVME.rdcfg(52) & 0xFF;
        for (int i = 0; i < 32; i += 4) {
            int n2 = n > 0 ? IceNVME.rdcfg(n) : 0;
            if ((n2 & 0xFF) == 16) {
                int n3 = IceNVME.rdcfg(n + 8);
                IceNVME.wrcfg(n + 8, n3 |= 0x20);
            }
            IceNVME.awMem(2048 + i, n2);
            n = n2 >> 8 & 0xFF;
        }
    }
}

