/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.IceIOM;

public class IceGPS
extends IceIOM {
    public static int lvco;
    public static int loff;
    public static int mode;
    public static int calib;
    public static int dfvco;
    public static int dpvco;
    public static int cvco;
    public static int acc_off;
    public static int acc_dif;
    public static int acc_sav;
    public static int nos;
    public static int dop;
    public static int sog;
    public static int count;
    public static int week;
    public static int sow;
    public static int alt;
    public static int lat;
    public static int lon;
    public static int mrev;
    public static int debug;
    public static int mindop;

    public static void run() {
        loff = 0;
        lvco = -1811939328;
        mode = 0;
        dop = 10;
        sog = 100;
        nos = 0;
        count = 0;
        mindop = 16;
        IceGPS.awBus(65536, 1);
        IceGPS.awBus(524288, 22);
        int n = IceGPS.arMem(8);
        mrev = n >> 24 & 0xFF;
        lvco = mrev <= 1 ? -2013265920 : -1811939328;
        int n2 = 1;
        while (true) {
            IceGPS.awMem(-50266116, n2);
            if (mode != 0 || n2 >= 1000) {
                int n3 = IceGPS.getStatus();
                int n4 = IceGPS.getTenths(n3);
                if (n4 == 0) {
                    IceGPS.awMem(256, 0);
                }
                if (n4 == 1) {
                    IceGPS.processTick(n3);
                    while (IceGPS.getStatusTenths() == 1) {
                        IceGPS.udelay(10);
                    }
                }
                if (n4 == 3) {
                    IceGPS.processNEMA(n3);
                    while (IceGPS.getStatusTenths() == 3) {
                        IceGPS.udelay(10);
                    }
                }
            }
            ++n2;
        }
    }

    public static int getStatus() {
        return IceGPS.arBusSync(65536);
    }

    public static int getTenths(int n) {
        return n >> 28 & 7;
    }

    public static int getStatusTenths() {
        return IceGPS.getTenths(IceGPS.getStatus());
    }

    public static void processTick(int n) {
        int n2;
        int n3 = n & 0xFFFFFFF;
        if (n3 > 80000000) {
            n3 -= 160000000;
        }
        IceGPS.awMem(28, n);
        int n4 = IceGPS.arMem(8);
        int n5 = n4 >> 8 & 0xFF;
        int n6 = n4 >> 16 & 0xFF;
        mrev = n4 >> 24 & 0xFF;
        if ((n4 & 0x80) != 0) {
            n2 = IceGPS.arMem(12);
            if (n2 != 0) {
                lvco = n2;
                count = -4;
            }
            mode = 8;
            IceGPS.awMem(12, 0);
        }
        if (mode == 0 && (n4 & 8) != 0) {
            count = -4;
            mode = -1;
        }
        if (mode == 6 && ((n3 -= n5) > 1600 || n3 < -1600)) {
            count = -4;
        }
        n2 = n3 - loff;
        if (count <= -4 && mode == 6) {
            lvco = cvco;
        }
        if (count <= -4) {
            IceGPS.awBus(65536, 1);
        }
        if (count >= 0 && count < 64) {
            IceGPS.setOff(count, n3);
            IceGPS.setDif(count, n2);
        }
        ++count;
        if (nos > 6 && dop < mindop && mode == 0) {
            mode = 1;
            count = -4;
        }
        if (mode > 0 && (nos < 3 || dop > mindop)) {
            mode = 0;
        }
        if (mode >= 1 && mode <= 4 && count >= n6) {
            acc_dif = IceGPS.getAccDif(n6);
            dpvco = 0;
            if (acc_dif > 40) {
                dpvco = -256;
                mode = 1;
            } else if (acc_dif > 20) {
                dpvco = -128;
                mode = 1;
            } else if (acc_dif > 2) {
                dpvco = -16;
                mode = 2;
            } else if (acc_dif < -40) {
                dpvco = 256;
                mode = 1;
            } else if (acc_dif < -20) {
                dpvco = 128;
                mode = 1;
            } else if (acc_dif < -2) {
                dpvco = 16;
                mode = 2;
            } else if (++mode > 4) {
                cvco = lvco;
                mode = 6;
            }
            lvco += dpvco << 16;
            count = -4;
        } else if (mode == 6 && count >= 0) {
            acc_off = IceGPS.getAccOff(1);
            acc_dif = IceGPS.getAccDif(1);
            dpvco = 0;
            if (acc_off > 0 && acc_dif >= 0) {
                dpvco = -2;
            }
            if (acc_off < 0 && acc_dif <= 0) {
                dpvco = 2;
            }
            lvco += dpvco << 16;
            count = 0;
        } else if (mode < 0 && count > 0) {
            count = 0;
        }
        loff = n3;
        IceGPS.awBus(262144, lvco >> 16);
        IceGPS.awMem(32, mode << 24 | (count & 0xFF) << 16 | dop << 8 | nos);
        IceGPS.awMem(36, n);
        IceGPS.awMem(40, n3);
        IceGPS.awMem(44, n2);
        IceGPS.awMem(48, acc_off);
        IceGPS.awMem(52, acc_dif);
        IceGPS.awMem(56, lvco);
        IceGPS.awMem(60, calib);
        IceGPS.awMem(64, dpvco);
        IceGPS.awMem(68, dfvco);
    }

    public static void setOff(int n, int n2) {
        IceGPS.awMem(512 + (n << 2), n2);
    }

    public static int getAccOff(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += IceGPS.arMem(512 + (i << 2));
        }
        return n2;
    }

    public static void setDif(int n, int n2) {
        IceGPS.awMem(768 + (n << 2), n2);
    }

    public static int getAccDif(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += IceGPS.arMem(768 + (i << 2));
        }
        return n2;
    }

    public static void copyNEMA(int n) {
        IceGPS.awMem(256, 1);
        IceGPS.awMem(260, week << 16 | dop << 12 | mode << 8 | nos);
        IceGPS.awMem(264, sow);
        IceGPS.awMem(268, alt);
        IceGPS.awMem(272, lat);
        IceGPS.awMem(276, lon);
        IceGPS.awMem(280, n);
        IceGPS.awMem(256, 2);
    }

    public static void processNEMA(int n) {
        int n2 = 131072;
        int n3 = 131072;
        while (n3 < 132096 && (n2 = IceGPS.checkLine(n3)) != 0) {
            n3 = n2;
        }
        int n4 = n3 - 1 - 131072;
        IceGPS.copyNEMA(n4);
    }

    public static int parseDec(int n, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        while (n < n2) {
            int n5;
            if ((n5 = IceGPS.arBus(n++)) == 46) {
                bl2 = true;
            } else if (n5 != 43) {
                if (n5 == 45) {
                    bl = true;
                } else {
                    if (n5 < 48 || n5 > 57) break;
                    n4 = n4 * 10 + (n5 - 48);
                    if (bl2) {
                        --n3;
                    }
                }
            }
            if (!bl2 || n3 > 0) continue;
        }
        if (bl) {
            n4 = -n4;
        }
        return n4;
    }

    public static int checkLine(int n) {
        int n2 = IceGPS.arBus(n + 3);
        int n3 = IceGPS.arBus(n + 4);
        int n4 = IceGPS.arBus(n + 5);
        if (n2 == 82 && n3 == 77 && n4 == 67) {
            n = IceGPS.nextField(n, 7);
            int n5 = IceGPS.nextField(n, 1);
            sog = IceGPS.parseDec(n, n5, 0);
            IceGPS.awMem(108, sog);
        } else if (n2 == 71 && n3 == 71 && n4 == 65) {
            n = IceGPS.nextField(n, 2);
            int n6 = IceGPS.nextField(n, 1);
            lat = IceGPS.parseDec(n, n6, 4);
            if (IceGPS.arBus(n6) == 83) {
                lat = -lat;
            }
            IceGPS.awMem(80, lat);
            n = IceGPS.nextField(n6, 1);
            n6 = IceGPS.nextField(n, 1);
            lon = IceGPS.parseDec(n, n6, 4);
            if (IceGPS.arBus(n6) == 87) {
                lon = -lon;
            }
            IceGPS.awMem(84, lon);
            n = IceGPS.nextField(n6, 4);
            n6 = IceGPS.nextField(n, 1);
            alt = IceGPS.parseDec(n, n6, 2);
            IceGPS.awMem(88, alt);
        } else if (n2 == 71 && n3 == 83 && n4 == 65) {
            int n7;
            dop = IceGPS.parseDec(n = IceGPS.nextField(n, 15), n7 = IceGPS.nextField(n, 1), 0);
            if (dop > 15) {
                dop = 15;
            }
            IceGPS.awMem(92, dop);
        } else if (n2 == 71 && n3 == 83 && n4 == 86) {
            n = IceGPS.nextField(n, 3);
            int n8 = IceGPS.nextField(n, 1);
            nos = IceGPS.parseDec(n, n8, 0);
            IceGPS.awMem(96, nos);
        } else if (n2 == 76 && n3 == 89 && n4 == 84) {
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = IceGPS.nextField(n = IceGPS.nextField(n, 1), 1);
            if (n13 - n >= 6) {
                n9 = IceGPS.arBCD(n, 5);
                n9 += 10 * IceGPS.arBCD(n, 4);
                n9 += 60 * IceGPS.arBCD(n, 3);
                n9 += 600 * IceGPS.arBCD(n, 2);
                n9 += 3600 * IceGPS.arBCD(n, 1);
                n9 += 36000 * IceGPS.arBCD(n, 0);
            }
            if ((n13 = IceGPS.nextField(n = IceGPS.nextField(n, 1), 1)) - n >= 6) {
                n10 = 10 * IceGPS.arBCD(n, 0) + IceGPS.arBCD(n, 1);
                n11 = 10 * IceGPS.arBCD(n, 2) + IceGPS.arBCD(n, 3);
                n12 = 10 * IceGPS.arBCD(n, 4) + IceGPS.arBCD(n, 5);
            }
            if (n9 != 0 && n12 != 0) {
                IceGPS.processIRB(n12, n11, n10, n9);
            }
            n = IceGPS.nextField(n, 2);
            n13 = IceGPS.nextField(n, 1);
            week = IceGPS.parseDec(n, n13, 0);
            if (mrev <= 1) {
                week += 1024;
            }
            IceGPS.awMem(100, week);
            n = IceGPS.nextField(n13, 1);
            sow = IceGPS.parseDec(n13, n, 3);
            IceGPS.awMem(104, sow);
        } else if (n2 == 76 && n3 == 89 && n4 == 83) {
            return 0;
        }
        return IceGPS.nextLine(n, 200);
    }

    public static void processIRB(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = IceGPS.getDoY(n3, n2, n);
        IceGPS.awMem(16, n);
        IceGPS.awMem(20, n8);
        IceGPS.awMem(24, n4);
        if (++n4 >= 86400) {
            ++n8;
            n4 -= 86400;
        }
        n7 |= n4 << 8;
        int n9 = 36000;
        int n10 = 0;
        while (n4 >= n9) {
            ++n10;
            n4 -= n9;
        }
        n5 |= n10 << 23;
        n9 = 3600;
        n10 = 0;
        while (n4 >= n9) {
            ++n10;
            n4 -= n9;
        }
        n5 |= n10 << 18;
        n9 = 600;
        n10 = 0;
        while (n4 >= n9) {
            ++n10;
            n4 -= n9;
        }
        n5 |= n10 << 14;
        n9 = 60;
        n10 = 0;
        while (n4 >= n9) {
            ++n10;
            n4 -= n9;
        }
        n5 |= n10 << 9;
        n9 = 10;
        n10 = 0;
        while (n4 >= n9) {
            ++n10;
            n4 -= n9;
        }
        n5 |= n10 << 6;
        n10 = n4;
        n5 |= n10 << 1;
        n9 = 100;
        n10 = 0;
        while (n8 >= n9) {
            ++n10;
            n8 -= n9;
        }
        n6 |= n10 << 4;
        n9 = 10;
        n10 = 0;
        while (n8 >= n9) {
            ++n10;
            n8 -= n9;
        }
        n6 |= n10 << 0;
        n10 = n8;
        n5 |= n10 << 27;
        n9 = 10;
        n10 = 0;
        while (n >= n9) {
            ++n10;
            n -= n9;
        }
        n6 |= n10 << 18;
        n10 = n;
        IceGPS.awBus(131072, n5);
        IceGPS.awBus(131076, n6 |= n10 << 13);
        IceGPS.awBus(131080, n7);
    }

    public static int nextLine(int n, int n2) {
        ++n;
        while (IceGPS.arBus(n) != 36 && IceGPS.arBus(n) != 35 && IceGPS.arBus(n) != 0 && n2 > 0) {
            ++n;
            --n2;
        }
        return n;
    }

    public static int findChar(int n, int n2, int n3) {
        while (n2 > n && IceGPS.arBus(n) != n3) {
            ++n;
        }
        return n;
    }

    public static int arBCD(int n, int n2) {
        int n3 = IceGPS.arBus(n + n2) - 48;
        return n3;
    }

    public static int nextField(int n, int n2) {
        while (n2 > 0) {
            int n3;
            if ((n3 = IceGPS.arBus(n++)) == 44) {
                --n2;
            }
            if (n3 == 42) {
                --n2;
            }
            if (n3 != 0) continue;
            break;
        }
        return n;
    }

    public static int getDoY(int n, int n2, int n3) {
        if (n2 > 1) {
            n += 31;
        }
        if (n2 > 2) {
            n += 28;
        }
        if (n2 > 3) {
            n += 31;
        }
        if (n2 > 4) {
            n += 30;
        }
        if (n2 > 5) {
            n += 31;
        }
        if (n2 > 6) {
            n += 30;
        }
        if (n2 > 7) {
            n += 31;
        }
        if (n2 > 8) {
            n += 31;
        }
        if (n2 > 9) {
            n += 30;
        }
        if (n2 > 10) {
            n += 31;
        }
        if (n2 > 11) {
            n += 30;
        }
        if (n2 > 2 && (n3 & 3) == 0) {
            ++n;
        }
        return n;
    }

    public static int addBCD(int n, int n2, int n3) {
        return n | n2 << n3;
    }
}

