/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreNative;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;

public class CoreComponent
extends CoreCommon {
    public short V2s(Value value) {
        return value.getI(0);
    }

    public int V2i(Value value) {
        return value.getL(0);
    }

    public float V2f(Value value) {
        return value.getF(0);
    }

    public double V2d(Value value) {
        return value.getD(0);
    }

    public int process(Stream stream, Stream stream2) {
        return -1;
    }

    public static class Viterbi {
        public static final String handleArgs = "noinit,i:load,i:uint8:bi,i:uint4:pflg,i:uint8:vflg,o:uint4:bo";
        public static final String handleAuto = "process=iii";
        public static final String handleMethod_process = "$load==T,$bi==%1,$pflg==%2,$vflg==%3,x=0,%0=$bo,o=1";

        public int process(int n, int n2, int n3) {
            return 8 | n;
        }
    }

    public static class DelayLine {
        double[] dar;
        float[] far;
        float[] fai;
        int n;

        public DelayLine(int n) {
            this.n = n;
            this.dar = new double[this.n + 1];
            this.far = new float[this.n + 1];
            this.fai = new float[this.n + 1];
            System.out.println("New DelayLine size=" + this.n);
        }

        public double loadD(double d) {
            for (int i = 0; i < this.n; ++i) {
                this.dar[i] = this.dar[i + 1];
            }
            this.dar[this.n] = d;
            return this.dar[0];
        }

        public float loadF(float f) {
            for (int i = 0; i < this.n; ++i) {
                this.far[i] = this.far[i + 1];
            }
            this.far[this.n] = f;
            return this.far[0];
        }
    }

    public static class CxRamBuf {
        int N;
        int n;
        int rdOnly;
        DataFile df;
        public float[] datax;
        public float[] datay;
        public static final String handleArgs = "sets,noinit,i:wen[#3],i:#1:wadr[#3],i:CxFptx:wbus[#2],i:ren[#3],i:#1:radr[#3],o:CxFptx:rbus[#3],i:rdonly";
        public static final String handleAuto = "set=ii,get=io,setxy=iii,setRdOnly=i,setLength=i";
        public static final String handleMethod_set = "$wen[IX]==T,$wadr[IX]==%1,$wbus[IX]==%2";
        public static final String handleMethod_get = "$ren[IX]==T,$radr[IX]==%1,x=0,%2=$rbus[IX],o=1";
        public static final String handleMethod_setRdOnly = "x=0,$rdonly==%1";

        public CxRamBuf(int n, int n2, int n3) {
            this.N = 1 << n;
            this.datax = new float[this.N];
            this.datay = new float[this.N];
        }

        public void setLength(int n) {
            this.n = CoreCommon.imin(n, this.N);
            if (n > this.N) {
                System.out.println("RamBuffer limited from " + n + " to " + this.n + " taps");
            }
        }

        public void setRdOnly(int n) {
            this.rdOnly = n;
        }

        public void get(int n, CoreCommon.CxFloat cxFloat) {
            cxFloat.x = this.datax[n];
            cxFloat.y = this.datay[n];
        }

        public void set(int n, CoreCommon.CxFloat cxFloat) {
            if ((this.rdOnly & 1) == 0) {
                this.datax[n] = cxFloat.x;
            }
            if ((this.rdOnly & 2) == 0) {
                this.datay[n] = cxFloat.y;
            }
        }

        public void setxy(int n, float f, float f2) {
            if ((this.rdOnly & 1) == 0) {
                this.datax[n] = f;
            }
            if ((this.rdOnly & 2) == 0) {
                this.datay[n] = f2;
            }
        }

        public void print() {
            float f = 0.0f;
            float f2 = 0.0f;
            System.out.print("Taps ");
            for (int i = 0; i < this.n; ++i) {
                System.out.printf("(%7.3f,%6.3f) ", Float.valueOf(this.datax[i]), Float.valueOf(this.datay[i]));
                f += this.datax[i];
                f2 += this.datay[i];
            }
            System.out.printf(" [%d] (%7.3f,%6.3f)\n", this.n, Float.valueOf(f), Float.valueOf(f2));
        }

        public void getSum(CoreCommon.CxFloat cxFloat) {
            float f = 0.0f;
            float f2 = 0.0f;
            for (int i = 0; i < this.n; ++i) {
                f += this.datax[i];
                f2 += this.datay[i];
            }
            cxFloat.x = f;
            cxFloat.y = f2;
        }

        public void dump(String string) {
            if (this.df == null) {
                this.df = new DataFile(null, (Object)string, "1000", "CF", 0, 128.0, null);
                this.df.setFS(this.n);
                this.df.setXUnits(1);
                this.df.setYUnits(1);
                this.df.open(2);
            }
            byte[] byArray = new byte[8];
            for (int i = 0; i < this.n; ++i) {
                Convert.packF((byte[])byArray, (int)0, (float)this.datax[i]);
                Convert.packF((byte[])byArray, (int)4, (float)this.datay[i]);
                this.df.write(byArray, 0, 8);
            }
            this.df.flush();
        }

        public String toString() {
            return "RamBufCF N=" + this.N;
        }
    }

    public static class RamBuf {
        int N;
        int n;
        boolean rdOnly;
        public float[] data;
        public static final String handleArgs = "sets,noinit,i:wen[#3],i:#1:wadr[#3],i:fptx:wbus[#2],i:ren[#3],i:#1:radr[#3],o:fptx:rbus[#3],i:rdonly";
        public static final String handleAuto = "set=ii,get=i";
        public static final String handleMethod_set = "$wen[IX]==T,$wadr[IX]==%1,wbus[IX]==%2";
        public static final String handleMethod_get = "$ren[IX]==T,$radr[IX]==%1,x=0,%0=$rbus[IX],o=1";
        public static final String handleMethod_setRdOnly = "x=0,$rdonly=%1";

        public RamBuf(int n, int n2, int n3) {
            this.N = 1 << n;
            this.data = new float[this.N];
        }

        public void setLength(int n) {
            this.n = CoreCommon.imin(n, this.N);
            if (n > this.N) {
                System.out.println("RamBuffer limited from " + n + " to " + this.n + " taps");
            }
        }

        public void setRdOnly(boolean bl) {
            this.rdOnly = bl;
        }

        public void set(int n, float f) {
            if (this.rdOnly) {
                return;
            }
            this.data[n] = f;
        }

        public float get(int n) {
            return this.data[n];
        }

        public String toString() {
            return "RamBuf N=" + this.N;
        }
    }

    public static class StatBuf {
        int N;
        int n;
        int m;
        public float[] data;
        public static final String handleArgs = "sets,noinit,i:load,i:fptx:vbus,i:intx:mode,i:domid,o:fptx:omid,i:domin,i:dominm,o:fptx:omin,i:domax,i:domaxm,o:fptx:omax,i:domini,o:intx:omini";
        public static final String handleAuto = "load=i,getMid=,getMin=,getMax=,getMinM=i,getMaxM=i,getMinI=i";
        public static final String handleMethod_load = "$load==T,$vbus==%1,o=1";
        public static final String handleMethod_getMid = "$domid==T,x=0,%0=$omid,o=1";
        public static final String handleMethod_getMin = "$domin==T,x=0,%0=$omin,o=4";
        public static final String handleMethod_getMax = "$domax==T,x=0,%0=$omax,o=4";
        public static final String handleMethod_getMinM = "$dominm==T,$mode=%1,x=0,%0=$omin,o=4";
        public static final String handleMethod_getMaxM = "$domaxm==T,$mode=%1,x=0,%0=$omax,o=4";
        public static final String handleMethod_getMinI = "$domini==T,$mode=%1,x=0,%0=$omini,o=4";

        public StatBuf(int n) {
            this.n = this.N = 1 << n;
            this.data = new float[this.N];
        }

        public void setLength(int n) {
            this.n = CoreCommon.imin(n, this.N);
            this.m = this.n >> 1;
            if (n > this.N) {
                System.out.println("Vector limited from " + n + " to " + this.n + " taps");
            }
        }

        public void load(float f) {
            for (int i = this.n - 1; i > 0; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[0] = f;
        }

        public float getMid() {
            return this.data[this.m];
        }

        public float getMin() {
            float f = this.data[0];
            for (int i = 1; i < this.n; ++i) {
                if (!(this.data[i] < f)) continue;
                f = this.data[i];
            }
            return f;
        }

        public float getMax() {
            float f = this.data[0];
            for (int i = 1; i < this.n; ++i) {
                if (!(this.data[i] > f)) continue;
                f = this.data[i];
            }
            return f;
        }

        public float getMinM(int n) {
            if (n > 0) {
                return this.getMinFilt(1, this.m);
            }
            if (n < 0) {
                return this.getMinFilt(this.m, this.n - 1);
            }
            return CoreCommon.fmaxf(this.getMinFilt(1, this.m), this.getMinFilt(this.m, this.n - 1));
        }

        public float getMaxM(int n) {
            if (n > 0) {
                return this.getMaxFilt(1, this.m);
            }
            if (n < 0) {
                return this.getMaxFilt(this.m, this.n - 1);
            }
            return CoreCommon.fminf(this.getMaxFilt(1, this.m), this.getMaxFilt(this.m, this.n - 1));
        }

        public float getMinFilt(int n, int n2) {
            float f = 1.0E32f;
            for (int i = n; i < n2; ++i) {
                float f2 = this.data[i];
                if (this.data[i - 1] > f2) {
                    f2 = this.data[i - 1];
                }
                if (this.data[i + 1] > f2) {
                    f2 = this.data[i + 1];
                }
                if (!(f2 < f)) continue;
                f = f2;
            }
            return f;
        }

        public float getMaxFilt(int n, int n2) {
            float f = -1.0E32f;
            for (int i = n; i < n2; ++i) {
                float f2 = this.data[i];
                if (this.data[i - 1] < f2) {
                    f2 = this.data[i - 1];
                }
                if (this.data[i + 1] < f2) {
                    f2 = this.data[i + 1];
                }
                if (!(f2 > f)) continue;
                f = f2;
            }
            return f;
        }

        public int getMinI(int n) {
            float f;
            int n2 = 0;
            int n3 = this.m;
            float f2 = this.data[n3];
            n2 = 1;
            while (n2 < this.m - 1 && !((f = this.data[n3]) > f2)) {
                f2 = f;
                ++n2;
                n3 += n;
            }
            return n2;
        }

        public String toString() {
            return "StatBuf N=" + this.N;
        }
    }

    public static class CxTapBuf_NPO
    extends CxTapBuf {
        public static final String handleArgs = "noinit,i:load,i:CxFptx:wbus,i:fptx:fps[#5],i:ren[#5][#3],i:#1:radr[#5][#3],o:CxFptx:rbus[#5][#3]";

        public CxTapBuf_NPO(int n, int n2, int n3, int n4, int n5) {
            super(n, n2, n3, n4);
        }
    }

    public static class CxTapBuf_NP2
    extends CxTapBuf {
        public static final String handleArgs = "noinit,i:4:stride,i:load,i:CxFptx:wbus[#5],i:ren[#3],i:#1:radr[#3],o:CxFptx:rbus[#3],o:CxFptx:rbus2[#3]";

        public CxTapBuf_NP2(int n, int n2, int n3, int n4, int n5) {
            super(n, n2, n3, n4);
        }
    }

    public static class CxTapBuf_NP
    extends CxTapBuf {
        public static final String handleArgs = "noinit,i:4:stride,i:split,i:load,i:CxFptx:wbus[#5],i:ren[#3],i:#1:radr[#3],o:CxFptx:rbus[#3]";

        public CxTapBuf_NP(int n, int n2, int n3, int n4, int n5) {
            super(n, n2, n3, n4);
        }
    }

    public static class CxTapBuf {
        int N;
        int IW;
        int n;
        int NH;
        public float[] datax;
        public float[] datay;
        public static final String handleArgs = "noinit,i:4:stride,i:split,i:load,i:CxFptx:wbus,i:ren[#3],i:#1:radr[#3],o:CxFptx:rbus[#3]";
        public static final String handleAuto = "load=i,loadA=ii,get=io,get2=ioo,get_vs=ioi,getrN_NPO=iioi,set=ii,setxy=iii";
        public static final String handleMethod_load = "$load==T,$wbus==%1";
        public static final String handleMethod_loadA = "$load==T,$wbus==%1";
        public static final String handleMethod_get = "$stride==#2,$ren[IX]==T,$radr[IX]==%1,x=0,%2=$rbus[IX],o=1";
        public static final String handleMethod_get2 = "$stride==#2,$ren[IX]==T,$radr[IX]==%1,x=0,%2=$rbus[IX],%3=$rbus2[IX],o=1";
        public static final String handleMethod_get_vs = "$stride==%3,$ren[IX]==T,$radr[IX]==%1,x=0,%2=$rbus[IX],o=1";
        public static final String handleMethod_getrN_NPO = "$ren[%4][IX]==T,$radr[%4][IX]==%2,$fps[%4]==%1,x=0,%3=$rbus[%4][IX],o=1";

        public CxTapBuf(int n, int n2, int n3, int n4) {
            this.N = 1 << n;
            this.NH = this.N >> 1;
            this.IW = n2;
            this.n = this.N + this.IW;
            this.datax = new float[this.n];
            this.datay = new float[this.n];
        }

        public void setLength(int n) {
            this.n = CoreCommon.imin(n, this.N);
            if (n > this.N) {
                System.out.println("CxTapBuffer limited from " + n + " to " + this.n + " taps");
            }
            this.n += this.IW;
        }

        public void setStride(int n) {
            if (n > this.N) {
                System.out.println("CxTapBuffer stride limited from " + n + " to " + this.N + " taps");
            }
        }

        public void load(CoreCommon.CxFloat cxFloat) {
            for (int i = this.n - 1; i > 0; --i) {
                this.datax[i] = this.datax[i - 1];
                this.datay[i] = this.datay[i - 1];
            }
            this.datax[0] = cxFloat.x;
            this.datay[0] = cxFloat.y;
        }

        public void loadA(CoreCommon.CxFloat[] cxFloatArray, int n) {
            int n2;
            for (n2 = this.n - 1; n2 >= n; --n2) {
                this.datax[n2] = this.datax[n2 - n];
                this.datay[n2] = this.datay[n2 - n];
            }
            n2 = n - 1;
            int n3 = 0;
            while (n2 >= 0) {
                this.datax[n2] = cxFloatArray[n3].x;
                this.datay[n2] = cxFloatArray[n3].y;
                --n2;
                ++n3;
            }
        }

        public void get(int n, CoreCommon.CxFloat cxFloat) {
            cxFloat.x = this.datax[n];
            cxFloat.y = this.datay[n];
        }

        public void get2(int n, CoreCommon.CxFloat cxFloat, CoreCommon.CxFloat cxFloat2) {
            cxFloat.x = this.datax[n];
            cxFloat.y = this.datay[n];
            cxFloat2.x = this.datax[n + 1];
            cxFloat2.y = this.datay[n + 1];
        }

        public void getrN(float f, int n, CoreCommon.CxFloat cxFloat) {
            int n2 = (int)f;
            if (n > 0) {
                n -= n2;
            }
            cxFloat.x = this.datax[n];
            cxFloat.y = this.datay[n];
        }

        public void set(int n, CoreCommon.CxFloat cxFloat) {
            this.datax[n] = cxFloat.x;
            this.datay[n] = cxFloat.y;
        }

        public void setxy(int n, float f, float f2) {
            this.datax[n] = f;
            this.datay[n] = f2;
        }

        public void print() {
            float f = 0.0f;
            float f2 = 0.0f;
            System.out.print("Taps ");
            for (int i = 0; i < this.n - this.IW; ++i) {
                System.out.printf("(%7.3f,%6.3f) ", Float.valueOf(this.datax[i]), Float.valueOf(this.datay[i]));
                f += this.datax[i];
                f2 += this.datay[i];
            }
            System.out.printf(" [%d] (%7.3f,%6.3f)\n", this.n, Float.valueOf(f), Float.valueOf(f2));
        }

        public void getSum(CoreCommon.CxFloat cxFloat) {
            float f = 0.0f;
            float f2 = 0.0f;
            for (int i = 0; i < this.n - this.IW; ++i) {
                f += this.datax[i];
                f2 += this.datay[i];
            }
            cxFloat.x = f;
            cxFloat.y = f2;
        }

        public String toString() {
            return "TapBufCF N=" + this.N;
        }
    }

    public static class TapBuf {
        int N;
        int IW;
        int n;
        public float[] data;
        public static final String handleArgs = "noinit,i:load,i:fptx:wbus,i:ren[#3],i:#1:radr[#3],o:fptx:rbus[#3]";
        public static final String handleAuto = "load=i,loadA=ii,get=i";
        public static final String handleMethod_load = "$load==T,$wbus==%1";
        public static final String handleMethod_loadA = "$load==T,$wbus==%1";
        public static final String handleMethod_get = "$ren[IX]==T,$radr[IX]==%1,x=0,%0=$rbus[IX],o=1";

        public TapBuf(int n, int n2, int n3, int n4) {
            this.N = 1 << n;
            this.IW = n2;
            this.n = this.N + this.IW;
            this.data = new float[this.n];
        }

        public void setLength(int n) {
            this.n = CoreCommon.imin(n, this.N);
            if (n > this.N) {
                System.out.println("TapBuffer limited from " + n + " to " + this.n + " taps");
            }
            this.n += this.IW;
        }

        public void load(float f) {
            for (int i = this.n - 1; i > 0; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[0] = f;
        }

        public void loadA(float[] fArray, int n) {
            int n2;
            for (n2 = this.n - 1; n2 >= n; --n2) {
                this.data[n2] = this.data[n2 - n];
            }
            n2 = n - 1;
            int n3 = 0;
            while (n2 >= 0) {
                this.data[n2] = fArray[n3];
                --n2;
                ++n3;
            }
        }

        public float get(int n) {
            return this.data[n];
        }

        public String toString() {
            return "TapBufSF N=" + this.N;
        }
    }

    public static class RomF2Di_CX
    extends RomF2Di {
        public static final String handleArgs = "sets,noinit,i:renr,i:fptx:rNr,i:#1:rN,i:#2:rM[#3],i:cx,o:CxFptx:rbus[#3]";

        public RomF2Di_CX(int n, int n2, int n3) {
            super(n, n2, n3);
        }
    }

    public static class RomF2Di_NP
    extends RomF2Di {
        public static final String handleArgs = "sets,noinit,i:renr,i:fptx:rNr[#4],i:#1:rN,i:#2:rM[#3],o:fptx:rbus[#4][#3]";

        public RomF2Di_NP(int n, int n2, int n3, int n4, int n5) {
            super(n, n2, n3);
        }
    }

    public static class RomF2Di {
        int N;
        int M;
        int L;
        int MC;
        public float[] data;
        public static final String handleArgs = "sets,noinit,i:renr,i:fptx:rNr,i:#1:rN,i:#2:rM[#3],o:fptx:rbus[#3]";
        public static final String handleAuto = "getrN=ii,getrN_NP=iii,getrNc=iiio,set=iii";
        public static final String handleMethod_getrN = "$renr==T,$rNr==%1,$rM[IX]==%2,x=1,%0==$rbus[IX],o=2";
        public static final String handleMethod_getrN_NP = "$renr==T,$rNr[%3]==%1,$rM[IX]==%2,x=1,%0==$rbus[%3][IX],o=2";
        public static final String handleMethod_getrNc = "$renr==T,$rNr==%1,$rM[IX]==%2,$cx==%3,x=1,%4==$rbus[IX],o=3";

        public RomF2Di(int n, int n2, int n3) {
            this.N = 1 << n;
            this.M = 1 << n2;
            this.L = this.N * this.M + 1;
            this.MC = n3 / 2;
            this.data = new float[this.L + 1];
        }

        public void clear() {
            for (int i = 0; i < this.L; ++i) {
                this.data[i] = 0.0f;
            }
        }

        public void set(int n, int n2, float f) {
            int n3 = n + n2 * this.N;
            if (n3 >= this.L) {
                System.out.println("RomF2D set out of range: N=" + this.N + " M=" + this.M + " n=" + n + " m=" + n2);
                return;
            }
            this.data[n3] = f;
            if (++n3 == this.L) {
                this.data[n3] = 2.0f * this.data[n3 - 1] - this.data[n3 - 2];
            }
        }

        public float getrN(float f, int n) {
            float f2 = f * (float)this.N;
            int n2 = (int)f2;
            int n3 = n2 + n * this.N;
            if (n3 >= this.L) {
                return this.data[this.L];
            }
            float f3 = f2 - (float)n2;
            float f4 = this.data[n3];
            float f5 = this.data[n3 + 1];
            return f4 + (f5 - f4) * f3;
        }

        public void getrNc(float f, int n, boolean bl, CoreCommon.CxFloat cxFloat) {
            cxFloat.x = this.getrN(f, n);
            cxFloat.y = bl ? this.getrN(f, n + this.MC) : cxFloat.x;
        }

        public String toString() {
            return "RomF2Di N=" + this.N + " M=" + this.M;
        }
    }

    public static class RomF2D {
        int N;
        int M;
        int L;
        public float[] data;
        public static final String handleArgs = "sets,noinit,i:ren,i:#1:rN,i:#2:rM[#3],o:fptx:rbus[#3]";
        public static final String handleAuto = "get=ii,set=iii";
        public static final String handleMethod_get = "$ren==T,$rN==%1,$rM[IX]==%2,x=0,%0==$rbus[IX],o=1";

        public RomF2D(int n, int n2, int n3) {
            this.N = 1 << n;
            this.M = 1 << n2;
            this.L = this.N * this.M + 4;
            this.data = new float[this.L];
        }

        public void clear() {
            for (int i = 0; i < this.L; ++i) {
                this.data[i] = 0.0f;
            }
        }

        public void set(int n, int n2, float f) {
            this.data[n + n2 * this.N] = f;
        }

        public float get(int n, int n2) {
            return this.data[n + n2 * this.N];
        }

        public String toString() {
            return "RomF2D N=" + this.N + " M=" + this.M;
        }
    }

    public static class RomF {
        int N;
        int M;
        int L;
        public float[] data;
        public static final String handleArgs = "sets,noinit,i:ren,i:#1:rM[#2],o:fptx:rbus[#2]";
        public static final String handleAuto = "get=i,set=ii";
        public static final String handleMethod_get = "$ren==T,$rM[IX]==%1,x=0,%0==$rbus[IX],o=1";

        public RomF(int n, int n2) {
            this.M = 1 << n;
            this.L = this.M + 2;
            this.data = new float[this.L];
        }

        public void clear() {
            for (int i = 0; i < this.L; ++i) {
                this.data[i] = 0.0f;
            }
        }

        public void set(int n, float f) {
            this.data[n] = f;
        }

        public float get(int n) {
            return this.data[n];
        }

        public String toString() {
            return "RomF M=" + this.M;
        }
    }

    public static class Dma {
        public static int SWP2 = 1;
        public static int SWP4 = 2;
        public static int C12T16 = 4;
        public static int C16T12 = 8;
        public int flags;
        public static final String handleArgs = "i:start,i:#1:cnt,s:8:flags,o:shrd,o:busy,NL2,i:rok,i:#1:radr,i:#2:rbus,d:32:rdma,NL2,i:wok,i:#1:wadr,o:#2:wbus,o:32:wdma";
        public static final String handleAuto = "r2r=iioii,r2b=iioii,b2r=iioii,b2b=iioii,b2s=iioii,r2s=iioii,addReader=i,sync=,setFlags=i";
        public static final String handleMethod_r2r = "$start=T,$radr=%2,$wadr=%4,$cnt=%5,x=0,$rok=%1_rok,%1_rdma==$rdma,$rbus=%1_rbus,$wok=%3_wok,%3_wdma=$wdma,%3_wbus=$wbus,a=$busy";
        public static final String handleMethod_r2b = "$start=T,$radr=%2,$wadr=%4,$cnt=%5,x=0,$rok=%1_rok,%1_rdma==$rdma,$rbus=%1_rbus,$wok=%3_wok,%3_dma=$wdma,%3_bus=$wbus,a=$busy";
        public static final String handleMethod_b2r = "$start=T,$radr=%2,$wadr=%4,$cnt=%5,x=0,$rok=%1_rok,%1_dma==$rdma,$rbus=%1_bus,$wok=%3_wok,%3_wdma=$wdma,%3_wbus=$wbus,a=$busy";
        public static final String handleMethod_b2b = "$start=T,$radr=%2,$wadr=%4,$cnt=%5,x=0,$rok=%1_rok,%1_dma==$rdma,$rbus=%1_bus,$wok=%3_wok,%3_dma=$wdma,%3_bus=$wbus,a=$busy";
        public static final String handleMethod_b2s = "$start=T,$radr=%2,$wadr=%4,$cnt=%5,x=0,$rok=%1_rok,%1_dma==$rdma,$rbus=%1_bus,$wok=%3_wok,%3_wen=$wdma[31],%3_wbus=$wbus,a=$busy";
        public static final String handleMethod_r2s = "$start=T,$radr=%2,$wadr=%4,$cnt=%5,x=0,$rok=%1_rok,%1_rdma==$rdma,$rbus=%1_rbus,$wok=%3_wok,%3_wen=$wdma[31],%3_wbus=$wbus,a=$busy";
        public static final String handleMethod_addReader = "$shrd==%1_rd";
        public static final String handleMethod_sync = "s=1,a=$busy";
        public static final String handleMethod_setFlags = "$flags=%1";

        public Dma(int n, int n2) {
        }

        private void ba2ba(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5) {
            boolean bl;
            int n6 = n2 - 1;
            int n7 = n4 - 1;
            boolean bl2 = bl = (this.flags & SWP2) != 0;
            while (n5 > 0) {
                int n8 = n5;
                n3 &= n7;
                if ((n &= n6) + n8 > n2) {
                    n8 = n2 - n;
                }
                if (n3 + n8 > n4) {
                    n8 = n4 - n3;
                }
                System.arraycopy(byArray, n, byArray2, n3, n8);
                if (bl) {
                    Convert.swap2((byte[])byArray2, (int)n3, (int)(n8 >> 1));
                }
                n += n8;
                n3 += n8;
                n5 -= n8;
            }
        }

        private void ba2bs(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, Stream stream) {
            int n6 = n2 - 1;
            int n7 = n4 - 1;
            n &= n6;
            n3 &= n7;
            if ((this.flags & SWP2) != 0) {
                for (int i = 0; i < n5; i += 2) {
                    byArray2[n3] = byArray[n + 1];
                    byArray2[n3 + 1] = byArray[n];
                    n += 2;
                    n &= n6;
                    n3 += 2;
                    n3 &= n7;
                }
            } else if ((this.flags & C16T12) != 0) {
                for (int i = 0; i < n5; i += 4) {
                    byArray2[n3++] = (byte)(byArray[n + 1] << 4 & 0xF0 | byArray[n + 0] >> 4 & 0xF);
                    n3 &= n7;
                    byArray2[n3++] = (byte)(byArray[n + 2] & 0xF0 | byArray[n + 1] >> 4 & 0xF);
                    n3 &= n7;
                    byArray2[n3++] = byArray[n + 3];
                    n3 &= n7;
                    n += 4;
                    n &= n6;
                }
                n5 = n5 / 4 * 3;
            } else if ((this.flags & C12T16) != 0) {
                for (int i = 0; i < n5; i += 3) {
                    byte by = byArray[n++];
                    n &= n6;
                    byte by2 = byArray[n++];
                    n &= n6;
                    byte by3 = byArray[n++];
                    n &= n6;
                    byArray2[n3++] = (byte)(by << 4);
                    byArray2[n3++] = (byte)(by2 << 4 & 0xF0 | by >> 4 & 0xF);
                    byArray2[n3++] = (byte)(by2 & 0xF0);
                    byArray2[n3++] = by3;
                    n3 &= n7;
                }
                n5 = n5 / 3 * 4;
            } else {
                for (int i = 0; i < n5; ++i) {
                    byArray2[n3++] = byArray[n++];
                    n &= n6;
                    n3 &= n7;
                }
            }
            stream.update(n5);
        }

        public void r2b(RamRWC ramRWC, int n, Buffer buffer, int n2, int n3) {
            int n4 = (n &= ramRWC.ML) + n3 - ramRWC.AL;
            if (n4 > 0) {
                n3 -= n4;
            } else {
                n4 = 0;
            }
            System.arraycopy(ramRWC.b, ramRWC.chn << ramRWC.OL | n, buffer.b, buffer.woff + n2, n3);
            if (n4 > 0) {
                System.arraycopy(ramRWC.b, ramRWC.chn << ramRWC.OL, buffer.b, buffer.woff + n2 + n3, n4);
            }
        }

        public void b2r(Buffer buffer, int n, RamRWC ramRWC, int n2, int n3) {
            int n4 = (n2 &= ramRWC.ML) + n3 - ramRWC.AL;
            if (n4 > 0) {
                n3 -= n4;
            } else {
                n4 = 0;
            }
            System.arraycopy(buffer.b, buffer.roff + n, ramRWC.b, ramRWC.chn << ramRWC.OL | n2, n3);
            if (n4 > 0) {
                System.arraycopy(buffer.b, buffer.roff + n + n3, ramRWC.b, ramRWC.chn << ramRWC.OL, n4);
            }
        }

        public void r2r(RamRWC ramRWC, int n, RamRWC ramRWC2, int n2, int n3) {
            this.ba2ba(ramRWC.b, ramRWC.chn << ramRWC.OL | n, ramRWC.len, ramRWC2.b, ramRWC2.chn << ramRWC2.OL | n2, ramRWC2.len, n3);
        }

        public void b2b(Buffer buffer, int n, Buffer buffer2, int n2, int n3) {
            this.ba2ba(buffer.b, buffer.roff + n, buffer.len, buffer2.b, buffer2.woff + n2, buffer2.len, n3);
        }

        public void b2s(Buffer buffer, int n, Stream stream, int n2, int n3) {
            this.ba2bs(buffer.b, buffer.roff + n, buffer.len, stream.b, stream.woff, stream.len, n3, stream);
        }

        public void r2s(RamRWC ramRWC, int n, Stream stream, int n2, int n3) {
            this.ba2ba(ramRWC.b, ramRWC.chn << ramRWC.OL | n, ramRWC.len, stream.b, stream.woff, stream.len, n3);
        }

        public void setFlags(int n) {
            this.flags = n;
        }

        public static void sync() {
        }

        public static void addReader(Object object) {
        }
    }

    public static class RamRWC {
        public byte[] b;
        public int WA;
        public int WB;
        public int OL;
        public int OC;
        private int AL;
        private int AC;
        private int ML;
        private int MC;
        private int chn;
        private int len;
        public static final String handleArgs = "i:wr,c:32:wdma,i:#4:wchn,i:#1:wadr,i:#2:wbus,NL2,i:rd,d:32:rdma,i:#4:rchn,i:#1:radr,o:#3:rbus,o:8:rbusb";
        public static final String handleAuto = "rd=io,wr=ii,rdB=i,wrB=ii,rdF=i,wrF=ii,setC=i";
        public static final String handleMethod_setC = "x=0,$rchn=%1,$wchn=%1";
        public static final String handleMethod_wr = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rd = "$rd=T,$radr=%1,x=2,%2=$rbus,o=3";
        public static final String handleMethod_wrB = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rdB = "$rd=T,$radr=%1,x=2,%0=$rbusb,o=3";
        public static final String handleMethod_wrF = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rdF = "$rd=T,$radr=%1,x=2,%0=$rbus,o=3";

        public RamRWC(int n, int n2, int n3, int n4) {
            this.WA = n2;
            this.WB = n3;
            this.OL = n;
            this.AL = 1 << this.OL;
            this.ML = this.AL - 1;
            this.OC = n4;
            this.AC = 1 << this.OC;
            this.MC = this.AC - 1;
            this.len = 1 << this.OL + this.OC;
            this.b = new byte[this.len];
            this.chn = 0;
        }

        public void setC(int n) {
            this.chn = n;
        }

        public void rd(int n, Value value) {
            System.arraycopy(this.b, this.chn << this.OL | n, value.buf, 0, value.len);
        }

        public void wr(int n, Value value) {
            System.arraycopy(value.buf, 0, this.b, this.chn << this.OL | n, value.len);
        }

        public byte rdB(int n) {
            return this.b[this.chn << this.OL | (n &= this.ML)];
        }

        public float rdF(int n) {
            return Convert.unpackF((byte[])this.b, (int)(this.chn << this.OL | (n &= this.ML)));
        }

        public void wrB(int n, int n2) {
            this.b[this.chn << this.OL | (n &= this.ML)] = (byte)n2;
        }

        public void wrF(int n, float f) {
            Convert.packF((byte[])this.b, (int)(this.chn << this.OL | (n &= this.ML)), (float)f);
        }

        public String toString() {
            return "Ram len=" + (1 << this.OL) + " chn=" + (1 << this.OC);
        }
    }

    public static class Ram {
        public byte[] b;
        public int OL;
        public int WA;
        public int WB;
        private int AL;
        private int ML;
        private int len;
        public static final String handleArgs = "i:wr,c:32:wdma,i:#1:wadr,i:#2:wbus,NL2,i:rd,d:32:rdma,i:#1:radr,o:#3:rbus,o:8:rbusb";
        public static final String handleAuto = "rd=io,wr=ii,rdB=i,wrB=ii,rdI=i,wrI=ii,rdL=i,wrL=ii,rdF=i,wrF=ii,wrX=ii";
        public static final String handleMethod_wr = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rd = "$rd=T,$radr=%1,x=2,%2=$rbus,o=3";
        public static final String handleMethod_wrB = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rdB = "$rd=T,$radr=%1,x=2,%0=$rbusb,o=3";
        public static final String handleMethod_wrI = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rdI = "$rd=T,$radr=%1,x=2,%0=$rbus,o=3";
        public static final String handleMethod_wrL = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rdL = "$rd=T,$radr=%1,x=2,%0=$rbus,o=3";
        public static final String handleMethod_wrF = "x=0,$wr=T,$wadr=%1,$wbus=%2";
        public static final String handleMethod_rdF = "$rd=T,$radr=%1,x=2,%0=$rbus,o=3";
        public static final String handleMethod_wrX = "$wr=T,$wadr=%1,$wbus=%2,x=1,$wr=T,$wadr=%1+4,$wbus=%2>>32";

        public Ram(int n, int n2, int n3) {
            this.OL = n;
            this.AL = 1 << this.OL;
            this.ML = this.AL - 1;
            this.WA = n2;
            this.WB = n3;
            this.len = 1 << this.OL;
            this.b = new byte[this.len];
        }

        public void rd(int n, Value value) {
            System.arraycopy(this.b, n, value.buf, 0, value.len);
        }

        public void wr(int n, Value value) {
            System.arraycopy(value.buf, 0, this.b, n, value.len);
        }

        public byte rdB(int n) {
            return this.b[n &= this.ML];
        }

        public short rdI(int n) {
            return Convert.unpackI((byte[])this.b, (int)(n &= this.ML));
        }

        public int rdL(int n) {
            return Convert.unpackL((byte[])this.b, (int)(n &= this.ML));
        }

        public float rdF(int n) {
            return Convert.unpackF((byte[])this.b, (int)(n &= this.ML));
        }

        public void wrB(int n, int n2) {
            this.b[n &= this.ML] = (byte)n2;
        }

        public void wrI(int n, short s) {
            Convert.packI((byte[])this.b, (int)(n &= this.ML), (short)s);
        }

        public void wrL(int n, int n2) {
            Convert.packL((byte[])this.b, (int)(n &= this.ML), (int)n2);
        }

        public void wrF(int n, float f) {
            Convert.packF((byte[])this.b, (int)(n &= this.ML), (float)f);
        }

        public String toString() {
            return "Ram len=" + (1 << this.OL) + " widthA=" + this.WA + " widthB=" + this.WB;
        }
    }

    public static class Queue {
        public int len;
        public int roff;
        public int woff;
        public int bpe;
        public int shft;
        public int mask;
        public int afull;
        public int aempty;
        public boolean wok;
        public boolean rok;
        public byte[] b;
        public static final String handleArgs = "o:wok,i:wen,i:BPW:wbus,o:rok,i:ren,o:BPW:rbus";
        public static final String handleAuto = "rd=o,rdB,rdI,rdL,rdF,rdD,rdCF=o,rok,wr=i,wrB=i,wrI=i,wrL=i,wrF=i,wrD=i,wrCF=i,wok";
        public static final String handleMethod_wr = "x=0,$wen==T,$wbus==%1_rbus";
        public static final String handleMethod_wrB = "x=0,$wen==T,$wbus==%1";
        public static final String handleMethod_wrI = "x=0,$wen==T,$wbus==%1";
        public static final String handleMethod_wrL = "x=0,$wen==T,$wbus==%1";
        public static final String handleMethod_wrF = "x=0,$wen==T,$wbus==%1";
        public static final String handleMethod_wrD = "x=0,$wen==T,$wbus==%1";
        public static final String handleMethod_wrCF = "x=0,$wen==T,$wbus==%1";
        public static final String handleMethod_rd = "$ren==T,x=0,%1_wen=T,%1_wbus==$rbus,o=0";
        public static final String handleMethod_rdB = "$ren==T,x=0,%0==$rbus,o=0";
        public static final String handleMethod_rdI = "$ren==T,x=0,%0==$rbus,o=0";
        public static final String handleMethod_rdL = "$ren==T,x=0,%0==$rbus,o=0";
        public static final String handleMethod_rdF = "$ren==T,x=0,%0==$rbus,o=0";
        public static final String handleMethod_rdD = "$ren==T,x=0,%0==$rbus,o=0";
        public static final String handleMethod_rdCF = "$ren==T,x=0,%1==$rbus,o=0";
        public static final String handleMethod_wok = "x=0,%0==$wok,o=0";
        public static final String handleMethod_rok = "x=0,%0==$rok,o=0";

        public Queue(int n, int n2, int n3, int n4) {
            this.bpe = (n2 + 7) / 8;
            this.len = n * this.bpe;
            this.mask = this.len - 1;
            this.shft = 0;
            while (1 << this.shft < this.bpe) {
                ++this.shft;
            }
            this.roff = 0;
            this.woff = 0;
            this.rok = false;
            this.wok = true;
            this.afull = n3;
            this.aempty = n4;
            this.b = new byte[this.len];
        }

        public void update(int n) {
            int n2;
            if (n > 0) {
                this.woff = this.woff + this.bpe & this.mask;
            }
            if (n < 0) {
                this.roff = this.roff + this.bpe & this.mask;
            }
            this.wok = (n2 = (this.woff - this.roff & this.mask) >> this.shft) <= this.afull;
            this.rok = n2 > this.aempty;
        }

        public boolean rok() {
            return this.rok;
        }

        public boolean wok() {
            return this.wok;
        }

        public void wr(Value value) {
            System.arraycopy(value.buf, 0, this.b, this.woff, this.bpe);
            this.update(1);
        }

        public void wrB(int n) {
            this.b[this.woff] = (byte)n;
            this.update(1);
        }

        public void wrI(int n) {
            Convert.packI((byte[])this.b, (int)this.woff, (short)((short)n));
            this.update(1);
        }

        public void wrL(int n) {
            Convert.packL((byte[])this.b, (int)this.woff, (int)n);
            this.update(1);
        }

        public void wrF(float f) {
            Convert.packF((byte[])this.b, (int)this.woff, (float)f);
            this.update(1);
        }

        public void wrD(double d) {
            Convert.packD((byte[])this.b, (int)this.woff, (double)d);
            this.update(1);
        }

        public void wrCF(CoreCommon.CxFloat cxFloat) {
            Convert.packF((byte[])this.b, (int)this.woff, (float)cxFloat.x);
            Convert.packF((byte[])this.b, (int)(this.woff + 4), (float)cxFloat.y);
            this.update(1);
        }

        public void rd(Value value) {
            System.arraycopy(this.b, this.roff, value.buf, 0, this.bpe);
            this.update(-1);
        }

        public byte rdB() {
            byte by = this.b[this.roff];
            this.update(-1);
            return by;
        }

        public short rdI() {
            short s = Convert.unpackI((byte[])this.b, (int)this.roff);
            this.update(-1);
            return s;
        }

        public int rdL() {
            int n = Convert.unpackL((byte[])this.b, (int)this.roff);
            this.update(-1);
            return n;
        }

        public float rdF() {
            float f = Convert.unpackF((byte[])this.b, (int)this.roff);
            this.update(-1);
            return f;
        }

        public double rdD() {
            double d = Convert.unpackD((byte[])this.b, (int)this.roff);
            this.update(-1);
            return d;
        }

        public void rdCF(CoreCommon.CxFloat cxFloat) {
            cxFloat.x = Convert.unpackF((byte[])this.b, (int)this.roff);
            cxFloat.y = Convert.unpackF((byte[])this.b, (int)(this.roff + 4));
            this.update(-1);
        }

        public String toString() {
            return "Queue len=" + this.len + " woff=" + this.woff + " wok=" + this.wok + " roff=" + this.roff + " rok=" + this.rok;
        }
    }

    public static interface BufferO {
        public static final String handleArgs = "o:wok,i:wr,c:32:dma,i:nxt,i:AW:adr,o:AW:len,i:BW:bus";
        public static final String handleAuto = "wr=ii,wnxt=i,setX=ii,setF=ii,setL=ii,setB=ii,setC=i,wptr=i,setBPE=i,wokLen=i";
        public static final String handleMethod_wr = "x=0,$wr=T,$adr=%1,$bus=%2.bus";
        public static final String handleMethod_wnxt = "$nxt=T,$adr=%1";
        public static final String handleMethod_setX = "x=0,$wr=T,$adr=%1,$bus=%2";
        public static final String handleMethod_setF = "x=0,$wr=T,$adr=%1,$bus=%2";
        public static final String handleMethod_setL = "x=0,$wr=T,$adr=%1,$bus=%2";
        public static final String handleMethod_setB = "x=0,$wr=T,$adr=%1,$bus=%2";
        public static final String handleMethod_setC = "x=0,$sel=%1";
        public static final String handleMethod_setBPE = "$nxt=F,$adr=%1";
        public static final String handleMethod_wokLen = "$len=%1";
    }

    public static interface BufferI {
        public static final String handleArgs = "o:rok,i:rd,d:32:dma,i:nxt,i:AW:adr,o:AW:len,o:BW:bus,o:8:busb";
        public static final String handleAuto = "rd=io,rnxt=i,getX=i,getF=i,getL=i,getB=i,setC=i,rptr=i,setBPE=i,rokLen=i";
        public static final String handleMethod_rd = "$rd=T,$adr=%1,x=2,%2.bus=$bus,o=3";
        public static final String handleMethod_rnxt = "$nxt=T,$adr=%1";
        public static final String handleMethod_getX = "$rd=T,$adr=%1,x=2,%0=$bus,o=3";
        public static final String handleMethod_getL = "$rd=T,$adr=%1,x=2,%0=$bus,o=3";
        public static final String handleMethod_getF = "$rd=T,$adr=%1,x=2,%0=$bus,o=3";
        public static final String handleMethod_getB = "$rd=T,$adr=%1,x=2,%0=$busb,o=3";
        public static final String handleMethod_setC = "x=0,$sel=%1";
        public static final String handleMethod_setBPE = "$nxt=F,$adr=%1";
        public static final String handleMethod_rokLen = "$len=%1";
    }

    public static class Buffer
    extends Stream {
        public Buffer(int n, int n2, int n3, boolean bl) {
            super(n, n2, n3, bl);
        }

        public void setBPE(int n) {
            this.rbpe = n;
            this.wbpe = n;
            this.update(0);
        }

        public void rd(int n, Value value) {
            System.arraycopy(this.b, this.roff + n, value.buf, 0, value.len);
        }

        public void wr(int n, Value value) {
            System.arraycopy(value.buf, 0, this.b, this.woff + n, value.len);
        }

        public byte getB(int n) {
            return Convert.unpackB((byte[])this.b, (int)(this.roff + n & this.mask));
        }

        public void setB(int n, byte by) {
            Convert.packB((byte[])this.b, (int)(this.woff + n & this.mask), (byte)by);
        }

        public int getL(int n) {
            return Convert.unpackL((byte[])this.b, (int)(this.roff + n & this.mask));
        }

        public void setL(int n, int n2) {
            Convert.packL((byte[])this.b, (int)(this.woff + n & this.mask), (int)n2);
        }

        public float getF(int n) {
            return Convert.unpackF((byte[])this.b, (int)(this.roff + n & this.mask));
        }

        public void setF(int n, float f) {
            Convert.packF((byte[])this.b, (int)(this.woff + n & this.mask), (float)f);
        }

        public long getX(int n) {
            return ((long)Convert.unpackL((byte[])this.b, (int)(this.roff + n + 4 & this.mask)) << 32) + (long)Convert.unpackL((byte[])this.b, (int)(this.roff + n & this.mask));
        }

        public void setX(int n, long l) {
            Convert.packX((byte[])this.b, (int)(this.woff + n & this.mask), (long)l);
        }

        public void rokLen(int n) {
            this.rper = n;
        }

        public void wokLen(int n) {
            this.wper = n;
        }

        public void rnxt(int n) {
            this.update(-n);
        }

        public void wnxt(int n) {
            this.update(n);
        }

        @Override
        public String toString() {
            return "Buffer len=" + this.len + " woff=" + this.woff + " wok=" + this.wok + " roff=" + this.roff + " rok=" + this.rok;
        }
    }

    public static interface StreamO {
        public static final String handleArgs = "o:wok,i:wen,i:BWP:wsel,i:BW:wbus";
        public static final String handleAuto = "wr=i,wrx=ii,wrCI=i,wrCF=i,wrCFx=ii,wrCFB=i,wrCFBA=ii,wrCFI=i,wrCFIA=ii,wrCFIAX=iii,wrCFIx=ii,wrCFIS=ii,wrCFISA=iii,wrCFxy=ii,wrCIxy=ii,wrBits=ii,wrB=i,wrL=i,wrLCS=iii,wrX=i,wrF=i,setC=i";
        public static final String handleMethod_wr = "x=0,$wen=T,%1_ren==$wen,$wbus==%1_rbus";
        public static final String handleMethod_wrx = "x=0,$wen=%2,%1_ren==$wen,$wbus==%1_rbus";
        public static final String handleMethod_wrCI = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_wrCF = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_wrCFx = "x=0,$wen=%2,$wbus=%1";
        public static final String handleMethod_wrCFB = "x=0,$wen=T,$wbus=CF2CB(%1)";
        public static final String handleMethod_wrCFBA = "x=0,$wen=T,t=CFA2CBB_task(%2)(%1,$wbus)";
        public static final String handleMethod_wrCFI = "x=0,$wen=T,$wbus=CF2CI(%1)";
        public static final String handleMethod_wrCFIA = "x=0,$wen=T,t=CFA2CIB_task(%2)(%1,$wbus)";
        public static final String handleMethod_wrCFIAX = "x=0,$wen=T,t=CFA2CIB_task(%2,%3)(%1,$wbus)";
        public static final String handleMethod_wrCFIx = "x=0,$wen=T,t=CFx2CIB_task(%2)(%1_rbus,$wbus)";
        public static final String handleMethod_wrCFIS = "x=0,$wen=T,$wbus=CF2CIS(%1,%2)";
        public static final String handleMethod_wrCFISA = "x=0,$wen=T,t=CFA2CIBS_task(%3)(%1,%2,$wbus)";
        public static final String handleMethod_wrCFxy = "x=0,$wen=T,$wbus=muxf(%1,%2)";
        public static final String handleMethod_wrCIxy = "x=0,$wen=T,$wbus=muxs(%1,%2)";
        public static final String handleMethod_wrBits = "x=0,$wen=T,$bits=%1,$wbus=%2";
        public static final String handleMethod_wrB = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_wrI = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_wrL = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_wrF = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_wrX = "x=0,$wen=T,$wbus=%1";
        public static final String handleMethod_wrLCS = "x=0,$wen=T,$wbus=%1,$wsel=%2,$swaps=%3";
        public static final String handleMethod_setC = "x=0,$wsel=%1";
    }

    public static interface StreamI {
        public static final String handleArgs = "o:rok,i:ren,o:BWP:rsel,o:BW:rbus";
        public static final String handleAuto = "rd=o,rdx=oi,rdCI=o,rdCF=o,rdCIF=o,rdCIFA=oi,rdCIFx=oi,rdBits=i,rdB=,rdL=,rdF=,getC=";
        public static final String handleMethod_rd = "$ren=T,x=2,%1_wen==xn,%1_wbus==$rbus,o=2";
        public static final String handleMethod_rdx = "$ren=T,x=2,%1_wen==xn,%1_wbus==$rbus,o=2";
        public static final String handleMethod_rdCI = "$ren=T,x=2,%1=$rbus,o=3";
        public static final String handleMethod_rdCF = "$ren=T,x=2,%1=$rbus,o=3";
        public static final String handleMethod_rdCIF = "$ren=T,x=2,%1=CI2CF($rbus),o=3";
        public static final String handleMethod_rdCIFA = "$ren=T,x=2,t=CIB2CFA_task(%2)($rbus,%1),o=3";
        public static final String handleMethod_rdCIFx = "$ren=T,x=2,t=CIB2CFx_task(%2)($rbus,%1_wbus),o=3";
        public static final String handleMethod_rdBits = "$ren=T,$bits=%1,x=2,%0=$rbus,o=3";
        public static final String handleMethod_rdB = "$ren=T,x=2,%0=$rbus,o=3";
        public static final String handleMethod_rdI = "$ren=T,x=2,%0=$rbus,o=3";
        public static final String handleMethod_rdL = "$ren=T,x=2,%0=$rbus,o=3";
        public static final String handleMethod_rdF = "$ren=T,x=2,%0=$rbus,o=3";
        public static final String handleMethod_getC = "x=0,%0=$rsel";
    }

    public static class Stream {
        public int len;
        public int bib;
        public int woff;
        public int roff;
        public int wboff;
        public int rboff;
        public int wbpe;
        public int rbpe;
        public int wper;
        public int rper;
        public int mtl;
        public int mask;
        public int chn;
        public int cvt;
        public boolean wok;
        public boolean rok;
        public boolean useNative;
        public byte[] b;
        public byte[] c;
        public long handle;
        public CoreCommon.CxFloat cxt;
        private int dbgmod;
        private int dbgcnt;
        public static final String handleArgs = "b:swaps,b:wok,b:wen,b:#2/8:wsel,b:#2:wbus,b:rok,b:ren,b:#3/8:rsel,b:#3:rbus";
        public static final String handleMethod_rd = "$ren=T,x=2,%1_wen==xn,%1_wbus==$rbus,o=2";
        public static final String handleMethod_wr = "x=0,$wen=T,%1_ren==$wen,$wbus==%1_rbus";

        public Stream() {
            this(1024);
        }

        public Stream(int n) {
            this(n, 32, 32);
        }

        public Stream(int n, int n2, int n3) {
            this(n, n2, n3, false);
        }

        public Stream(int n, int n2, int n3, boolean bl) {
            this.len = n;
            this.mtl = this.len / 2;
            this.mask = this.len - 1;
            this.wok = true;
            this.rper = this.rbpe = n2 / 8;
            this.wper = this.wbpe = n3 / 8;
            if (bl) {
                this.handle = CoreNative.newStream(n, n2, n3);
            } else {
                this.b = new byte[this.len];
            }
            this.useNative = bl;
        }

        public int load(DataFile dataFile) {
            int n = 0;
            int n2 = this.roff - this.woff;
            if (n2 < 0 || this.bib == 0) {
                n2 = this.len - this.woff;
            }
            if (n2 > this.mtl) {
                n2 = this.mtl;
            }
            if (this.cvt == 1) {
                n = dataFile.read(this.b, this.woff, n2 >> 1) << 1;
                int n3 = n >> 1;
                int n4 = n;
                while (n3 > 0) {
                    this.b[this.woff + --n4] = this.b[this.woff + --n3];
                    this.b[this.woff + --n4] = 0;
                }
            } else if (this.cvt == 2) {
                int n5 = n2 >> 2;
                n = dataFile.read(this.b, this.woff, n5 * 3) / 3 * 4;
                int n6 = this.woff + n5 * 3;
                int n7 = this.woff + n5 * 4;
                for (int i = 0; i < n5; ++i) {
                    this.b[(n7 -= 4) + 0] = (byte)(this.b[(n6 -= 3) + 0] << 4);
                    this.b[n7 + 1] = (byte)(this.b[n6 + 1] << 4 | this.b[n6 + 0] >> 4 & 0xF);
                    this.b[n7 + 2] = (byte)(this.b[n6 + 1] & 0xF0);
                    this.b[n7 + 3] = this.b[n6 + 2];
                }
            } else {
                n = dataFile.read(this.b, this.woff, n2);
            }
            if (n == 0 && !dataFile.isStream()) {
                n = -1;
            }
            if (n > 0) {
                this.update(n);
            }
            return n;
        }

        public int unload(DataFile dataFile) {
            int n = this.woff - this.roff;
            if (n < 0 || this.bib == this.len) {
                n = this.len - this.roff;
            }
            if (n == 0) {
                return 0;
            }
            int n2 = dataFile.write(this.b, this.roff, n);
            if (n2 > 0) {
                this.update(-n2);
            }
            return n2;
        }

        public void update(int n) {
            this.bib += n;
            if (n > 0) {
                if (this.c != null) {
                    this.c[this.woff >> 2] = (byte)this.chn;
                }
                this.woff += n;
                if (this.woff >= this.len) {
                    this.woff -= this.len;
                }
            } else {
                if (this.dbgmod != 0) {
                    if (this.dbgcnt % this.dbgmod == 0) {
                        System.out.printf("Stream cnt=%x value=%x\n", this.dbgcnt, Convert.unpackL((byte[])this.b, (int)this.roff));
                    }
                    this.dbgcnt -= n;
                }
                this.roff += -n;
                if (this.roff >= this.len) {
                    this.roff -= this.len;
                }
            }
            this.rok = this.bib >= this.rper;
            this.wok = this.len - this.bib >= this.wper;
        }

        public void rd(Value value) {
            System.arraycopy(this.b, this.roff, value.buf, 0, value.len);
            this.update(-value.len);
        }

        public void rdx(Value value, int n) {
            int n2 = n * value.bps * value.spa;
            System.arraycopy(this.b, this.roff, value.buf, 0, n2);
            this.update(-n2);
        }

        public float rdF() {
            float f = Convert.unpackF((byte[])this.b, (int)this.roff);
            this.update(-4);
            return f;
        }

        public int rdL() {
            int n = Convert.unpackL((byte[])this.b, (int)this.roff);
            this.update(-4);
            return n;
        }

        public int rdI() {
            short s = Convert.unpackI((byte[])this.b, (int)this.roff);
            this.update(-2);
            return s;
        }

        public byte rdB() {
            byte by = this.b[this.roff];
            this.update(-1);
            return by;
        }

        public int rdBits(int n) {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if ((this.b[this.roff] & 1 << this.rboff) != 0) {
                    n2 |= 1 << i;
                }
                if (++this.rboff != 8) continue;
                this.update(-1);
                this.rboff = 0;
            }
            return n2;
        }

        public void rdCI(CoreCommon.CxShort cxShort) {
            cxShort.x = Convert.unpackI((byte[])this.b, (int)(this.roff + 0));
            cxShort.y = Convert.unpackI((byte[])this.b, (int)(this.roff + 2));
            this.update(-4);
        }

        public void rdCF(CoreCommon.CxFloat cxFloat) {
            cxFloat.x = Convert.unpackF((byte[])this.b, (int)(this.roff + 0));
            cxFloat.y = Convert.unpackF((byte[])this.b, (int)(this.roff + 4));
            this.update(-8);
        }

        public void rdCIF(CoreCommon.CxFloat cxFloat) {
            cxFloat.x = (float)Convert.unpackI((byte[])this.b, (int)(this.roff + 0)) / 32768.0f;
            cxFloat.y = (float)Convert.unpackI((byte[])this.b, (int)(this.roff + 2)) / 32768.0f;
            this.update(-4);
        }

        public void rdCIFA(CoreCommon.CxFloat[] cxFloatArray, int n) {
            for (int i = 0; i < n; ++i) {
                this.rdCIF(cxFloatArray[i]);
            }
        }

        public void rdCIFx(Value value, int n) {
            if (this.cxt == null) {
                this.cxt = new CoreCommon.CxFloat();
            }
            for (int i = 0; i < n; ++i) {
                this.rdCIF(this.cxt);
                value.setCF(i, this.cxt);
            }
        }

        public void wr(Value value) {
            System.arraycopy(value.buf, 0, this.b, this.woff, value.len);
            this.update(value.len);
        }

        public void wrx(Value value, int n) {
            if (n == 0) {
                return;
            }
            int n2 = n * value.bps * value.spa;
            System.arraycopy(value.buf, 0, this.b, this.woff, n2);
            this.update(n2);
        }

        public void wrX(long l) {
            Convert.packX((byte[])this.b, (int)this.woff, (long)l);
            this.update(8);
        }

        public void wrF(float f) {
            Convert.packF((byte[])this.b, (int)this.woff, (float)f);
            this.update(4);
        }

        public void wrL(int n) {
            Convert.packL((byte[])this.b, (int)this.woff, (int)n);
            this.update(4);
        }

        public void wrI(short s) {
            Convert.packI((byte[])this.b, (int)this.woff, (short)s);
            this.update(2);
        }

        public void wrB(byte by) {
            this.b[this.woff] = by;
            this.update(1);
        }

        public void wrLCS(int n, int n2, int n3) {
            if (this.c == null) {
                this.c = new byte[this.len >> 2];
            }
            this.chn = (byte)n2;
            if (n3 == 1) {
                n = CoreCommon.bswap2s(n);
            } else if (n3 == 2) {
                n = CoreCommon.bswap4(n);
            }
            Convert.packL((byte[])this.b, (int)this.woff, (int)n);
            this.update(4);
        }

        public void wrBits(int n, int n2) {
            for (int i = 0; i < n; ++i) {
                if ((n2 & 1) == 0) {
                    int n3 = this.woff;
                    this.b[n3] = (byte)(this.b[n3] & ~(1 << this.wboff));
                } else {
                    int n4 = this.woff;
                    this.b[n4] = (byte)(this.b[n4] | 1 << this.wboff);
                }
                if (++this.wboff == 8) {
                    this.update(1);
                    this.wboff = 0;
                }
                n2 >>= 1;
            }
        }

        public void wrCI(CoreCommon.CxShort cxShort) {
            Convert.packI((byte[])this.b, (int)(this.woff + 0), (short)cxShort.x);
            Convert.packI((byte[])this.b, (int)(this.woff + 2), (short)cxShort.y);
            this.update(4);
        }

        public void wrCF(CoreCommon.CxFloat cxFloat) {
            Convert.packF((byte[])this.b, (int)(this.woff + 0), (float)cxFloat.x);
            Convert.packF((byte[])this.b, (int)(this.woff + 4), (float)cxFloat.y);
            this.update(8);
        }

        public void wrCFx(CoreCommon.CxFloat cxFloat, int n) {
            if (n <= 0) {
                return;
            }
            Convert.packF((byte[])this.b, (int)(this.woff + 0), (float)cxFloat.x);
            Convert.packF((byte[])this.b, (int)(this.woff + 4), (float)cxFloat.y);
            this.update(8);
        }

        public void wrCFI(CoreCommon.CxFloat cxFloat) {
            Convert.packI((byte[])this.b, (int)(this.woff + 0), (short)((short)Math.round(cxFloat.x * 32768.0f)));
            Convert.packI((byte[])this.b, (int)(this.woff + 2), (short)((short)Math.round(cxFloat.y * 32768.0f)));
            this.update(4);
        }

        public void wrCFIA(CoreCommon.CxFloat[] cxFloatArray, int n) {
            for (int i = 0; i < n; ++i) {
                this.wrCFI(cxFloatArray[i]);
            }
        }

        public void wrCFIx(Value value, int n) {
            if (this.cxt == null) {
                this.cxt = new CoreCommon.CxFloat();
            }
            for (int i = 0; i < n; ++i) {
                value.getCF(i, this.cxt);
                this.wrCFI(this.cxt);
            }
        }

        public void wrCFIS(CoreCommon.CxFloat cxFloat, int n) {
            int n2 = 32768 << n;
            Convert.packI((byte[])this.b, (int)(this.woff + 0), (short)((short)Math.round(cxFloat.x * (float)n2)));
            Convert.packI((byte[])this.b, (int)(this.woff + 2), (short)((short)Math.round(cxFloat.y * (float)n2)));
            this.update(4);
        }

        public void wrCFISA(CoreCommon.CxFloat[] cxFloatArray, int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                this.wrCFIS(cxFloatArray[i], n);
            }
        }

        public void wrCFB(CoreCommon.CxFloat cxFloat) {
            Convert.packB((byte[])this.b, (int)(this.woff + 0), (byte)((byte)Math.round(cxFloat.x * 128.0f)));
            Convert.packB((byte[])this.b, (int)(this.woff + 1), (byte)((byte)Math.round(cxFloat.y * 128.0f)));
            this.update(2);
        }

        public void wrCFBA(CoreCommon.CxFloat[] cxFloatArray, int n) {
            for (int i = 0; i < n; ++i) {
                this.wrCFB(cxFloatArray[i]);
            }
        }

        public void wrCFxy(float f, float f2) {
            Convert.packF((byte[])this.b, (int)(this.woff + 0), (float)f);
            Convert.packF((byte[])this.b, (int)(this.woff + 4), (float)f2);
            this.update(8);
        }

        public void wrCIxy(int n, int n2) {
            Convert.packI((byte[])this.b, (int)(this.woff + 0), (short)((short)n));
            Convert.packI((byte[])this.b, (int)(this.woff + 2), (short)((short)n2));
            this.update(4);
        }

        public void setC(int n) {
            if (this.c == null) {
                this.c = new byte[this.len >> 2];
            }
            this.chn = n;
        }

        public int getC() {
            return this.c != null ? this.c[this.roff >> 2] : this.chn;
        }

        public int xgetL(int n) {
            if (this.useNative) {
                return CoreNative.xgetL(this.handle, n);
            }
            return Convert.unpackL((byte[])this.b, (int)(this.woff + n & this.mask));
        }

        public void xwrL(int n) {
            if (this.useNative) {
                CoreNative.xwrL(this.handle, n);
            } else {
                this.wrL(n);
            }
        }

        public void setDebug(int n) {
            this.dbgmod = n;
            this.dbgcnt = 0;
        }

        public String toString() {
            return "Stream len=" + this.len + " woff=" + this.woff + " wok=" + this.wok + " roff=" + this.roff + " rok=" + this.rok;
        }
    }

    public static interface ValueIF {
        public static final String handleMethod_getCF = "$.ren=T,$.roff=%1,x=1,%0=$.rbus,o=1";
        public static final String handleMethod_setCF = "$.wen=T,$.woff=%1,$.wbus=%2,x=0,o=1";
        public static final String handleMethod_setCFxy = "$.wen=T,$.woff=%1,$.wbus=muxf(%2,%3),x=0,o=1";
    }

    public static interface ValueO {
        public static final String handleAuto = "setCF=ii,setCFxy=iii";
        public static final String handleMethod_setCF = "$wen=T,$woff=%1,$wbus=%2,x=0,o=1";
        public static final String handleMethod_setCFxy = "$wen=T,$woff=%1,$wbus=muxf(%2,%3),x=0,o=1";
    }

    public static interface ValueI {
        public static final String handleMethod_getCF = "$ren=T,$roff=%1,x=1,%0=$rbus,o=1";
        public static final String handleAuto = "getCF=io";
    }

    public static class Value {
        public int bps;
        public int spa;
        public int bpa;
        public int boff;
        public int len;
        public byte mode;
        public byte type;
        public byte[] buf;
        private int scalars;
        public static final String handleArgs = "i:wen,i:8:woff,i:BPW:wbus,i:ren,i:8:roff,o:BPW:rbus";
        public static final String handleAuto = "getB=i,getI=i,getL=i,getF=i,getCF=io,getCIF=io,getCIFx=i,getCIFy=i,setB=ii,setI=ii,setL=ii,setF=ii,setCF=ii,setCFxy=iii,setCFI=ii,setCFIS2=iii";
        public static final String handleMethod_getB = "$ren=T,$roff=%1,x=1,%0=$rbus,o=1";
        public static final String handleMethod_getI = "$ren=T,$roff=%1,x=1,%0=$rbus,o=1";
        public static final String handleMethod_getL = "$ren=T,$roff=%1,x=1,%0=$rbus,o=1";
        public static final String handleMethod_getF = "$ren=T,$roff=%1,x=1,%0=$rbus,o=1";
        public static final String handleMethod_getCF = "$ren=T,$roff=%1,x=1,%2=$rbus,o=1";
        public static final String handleMethod_getCIF = "$ren=T,$roff=%1,x=1,%2=CI2CF($rbus),o=1";
        public static final String handleMethod_setB = "$wen=T,$woff=%1,$wbus=%2,x=0,o=1";
        public static final String handleMethod_setI = "$wen=T,$woff=%1,$wbus=%2,x=0,o=1";
        public static final String handleMethod_setL = "$wen=T,$woff=%1,$wbus=%2,x=0,o=1";
        public static final String handleMethod_setF = "$wen=T,$woff=%1,$wbus=%2,x=0,o=1";
        public static final String handleMethod_setCF = "$wen=T,$woff=%1,$wbus=%2,x=0,o=1";
        public static final String handleMethod_setCFxy = "$wen=T,$woff=%1,$wbus=muxf(%2,%3),x=0,o=1";
        public static final String handleMethod_setCFI = "$wen=T,$woff=%1,$wbus=CF2CI(%2),x=0,o=1";
        public static final String handleMethod_setCFIS2 = "$wen=T,$woff=0,$wbus=CF2CIS2(%1,%2,%3),x=0,o=1";

        public Value(String string, int n, int n2) {
            this(string, n);
        }

        public Value(String string, int n) {
            this.mode = (byte)string.charAt(0);
            this.type = (byte)string.charAt(1);
            this.spa = Data.getSPA((byte)this.mode);
            this.bps = Data.getBPS((byte)this.type);
            this.bpa = this.spa * this.bps;
            this.len = this.bpa * n;
            this.scalars = this.len / this.bps;
            this.buf = new byte[this.len];
        }

        public Value(byte[] byArray, byte by, byte by2, int n, int n2) {
            this.buf = byArray;
            this.mode = by;
            this.type = by2;
            this.boff = n;
            this.spa = Data.getSPA((byte)by);
            this.bps = Data.getBPS((byte)by2);
            this.bpa = this.spa * this.bps;
            this.len = this.bpa * n2;
            this.scalars = this.len / this.bps;
        }

        public void setSize(int n) {
            int n2 = n * this.bpa;
            if (n2 > this.len) {
                System.out.println("Value setSize=" + n + " with BPA=" + this.bpa + " greater than allocated len=" + this.len);
            }
            this.len = n2;
        }

        public void setBPA(int n) {
            if (n > this.bpa) {
                System.out.println("Value setBPA=" + n + " greater than allocated BPA=" + this.bpa);
            }
            this.bpa = n;
        }

        public void fromL(int n) {
            Convert.packL((byte[])this.buf, (int)this.boff, (int)n);
        }

        public void fromF(float f) {
            Convert.packF((byte[])this.buf, (int)this.boff, (float)f);
        }

        public void fromD(double d) {
            Convert.packD((byte[])this.buf, (int)this.boff, (double)d);
        }

        public void fromS(String string) {
            this.setS(string);
        }

        public int toL() {
            return this.type == 76 ? Convert.unpackL((byte[])this.buf, (int)this.boff) : this.getxL(0);
        }

        public float toF() {
            return this.type == 70 ? Convert.unpackF((byte[])this.buf, (int)this.boff) : (float)this.getxD(0);
        }

        public double toD() {
            return this.type == 68 ? Convert.unpackD((byte[])this.buf, (int)this.boff) : this.getxD(0);
        }

        public String toS() {
            int n;
            for (n = this.len; n > 0 && this.buf[n - 1] <= 32; --n) {
            }
            return new String(this.buf, 0, n);
        }

        public String toString() {
            if (this.type == 83 || this.type == 65) {
                return this.toS();
            }
            if (this.type == 68) {
                return Convert.d2s((double)this.toD());
            }
            if (this.type == 70) {
                return Convert.d2s((double)this.toF());
            }
            return Convert.l2s((int)this.toL());
        }

        public void fromList(String string, int n) {
            String string2 = CoreCommon.getListItem(string, n, -2);
            this.len = string2.length();
            Convert.packS((byte[])this.buf, (int)0, (int)this.len, (String)string2);
        }

        public int toItem(String string) {
            String string2 = Convert.unpackS((byte[])this.buf, (int)0, (int)this.len);
            int n = CoreCommon.findListItem(string, string2, -2);
            if (n < -1) {
                System.out.println("Item=" + string2 + " not found in list=" + string);
            }
            return n;
        }

        public int toMask(String string) {
            int n = 0;
            String string2 = Convert.unpackS((byte[])this.buf, (int)0, (int)this.len);
            if (string2.equalsIgnoreCase("None")) {
                return 0;
            }
            if (string2.equalsIgnoreCase("All")) {
                return -1;
            }
            for (int i = 0; i < 32; ++i) {
                String string3 = CoreCommon.getListItem(string2, i, 0);
                this.len = string3.length();
                if (string3 == null || string3.length() == 0) continue;
                if (string3.equals("Undefined")) break;
                int n2 = CoreCommon.findListItem(string, string3, 0);
                if (n2 < 0) {
                    System.out.println("Item=" + string3 + " not found in list=" + string);
                    continue;
                }
                n |= 1 << n2;
            }
            return n;
        }

        public int[] toLA() {
            int[] nArray = new int[this.scalars];
            Convert.bb2ja((byte[])this.buf, (int)0, (byte)this.type, (Object)nArray, (int)0, (byte)73, (int)this.scalars);
            return nArray;
        }

        public float[] toFA() {
            float[] fArray = new float[this.scalars];
            Convert.bb2ja((byte[])this.buf, (int)0, (byte)this.type, (Object)fArray, (int)0, (byte)70, (int)this.scalars);
            return fArray;
        }

        public double[] toDA() {
            double[] dArray = new double[this.scalars];
            Convert.bb2ja((byte[])this.buf, (int)0, (byte)this.type, (Object)dArray, (int)0, (byte)68, (int)this.scalars);
            return dArray;
        }

        public double getxD(int n) {
            switch (this.type) {
                case 66: {
                    return this.getB(n);
                }
                case 73: {
                    return this.getI(n);
                }
                case 76: {
                    return this.getL(n);
                }
                case 70: {
                    return this.getF(n);
                }
                case 68: {
                    return this.getD(n);
                }
            }
            return 0.0;
        }

        public int getxL(int n) {
            switch (this.type) {
                case 66: {
                    return this.getB(n);
                }
                case 73: {
                    return this.getI(n);
                }
                case 76: {
                    return this.getL(n);
                }
                case 70: {
                    return (int)this.getF(n);
                }
                case 68: {
                    return (int)this.getD(n);
                }
            }
            return 0;
        }

        public void setS(String string) {
            this.type = (byte)83;
            this.bps = 1;
            this.spa = 1;
            this.bpa = 1;
            this.buf = string.getBytes();
            this.len = this.buf.length;
        }

        public void setB(int n, byte by) {
            this.buf[n] = by;
        }

        public void setI(int n, short s) {
            Convert.packI((byte[])this.buf, (int)(n <<= 1), (short)s);
        }

        public void setL(int n, int n2) {
            Convert.packL((byte[])this.buf, (int)(n <<= 2), (int)n2);
        }

        public void setF(int n, float f) {
            Convert.packF((byte[])this.buf, (int)(n <<= 2), (float)f);
        }

        public void setD(int n, double d) {
            Convert.packD((byte[])this.buf, (int)(n <<= 3), (double)d);
        }

        public void setCF(int n, CoreCommon.CxFloat cxFloat) {
            Convert.packF((byte[])this.buf, (int)(n <<= 3), (float)cxFloat.x);
            Convert.packF((byte[])this.buf, (int)(n + 4), (float)cxFloat.y);
        }

        public void setCFxy(int n, float f, float f2) {
            Convert.packF((byte[])this.buf, (int)(n <<= 3), (float)f);
            Convert.packF((byte[])this.buf, (int)(n + 4), (float)f2);
        }

        public void setCFIxy(int n, float f, float f2) {
            Convert.packI((byte[])this.buf, (int)(n <<= 2), (short)((short)Math.rint(f * 32768.0f)));
            Convert.packI((byte[])this.buf, (int)(n + 2), (short)((short)Math.rint(f2 * 32768.0f)));
        }

        public void setCFI(int n, CoreCommon.CxFloat cxFloat) {
            Convert.packI((byte[])this.buf, (int)(n <<= 2), (short)((short)Math.rint(cxFloat.x * 32768.0f)));
            Convert.packI((byte[])this.buf, (int)(n + 2), (short)((short)Math.rint(cxFloat.y * 32768.0f)));
        }

        public void setCFIS2(int n, CoreCommon.CxFloat cxFloat, CoreCommon.CxFloat cxFloat2) {
            int n2 = n < 0 ? 32768 >> -n : 32768 << n;
            Convert.packI((byte[])this.buf, (int)0, (short)((short)Math.rint(cxFloat.x * (float)n2)));
            Convert.packI((byte[])this.buf, (int)2, (short)((short)Math.rint(cxFloat.y * (float)n2)));
            Convert.packI((byte[])this.buf, (int)4, (short)((short)Math.rint(cxFloat2.x * (float)n2)));
            Convert.packI((byte[])this.buf, (int)6, (short)((short)Math.rint(cxFloat2.y * (float)n2)));
        }

        public byte getB(int n) {
            return this.type == 66 ? this.buf[n] : (byte)this.getxL(n);
        }

        public short getI(int n) {
            return this.type == 73 ? Convert.unpackI((byte[])this.buf, (int)(n << 1)) : (short)this.getxL(n);
        }

        public int getL(int n) {
            return this.type == 76 ? Convert.unpackL((byte[])this.buf, (int)(n << 2)) : this.getxL(n);
        }

        public float getF(int n) {
            return this.type == 70 ? Convert.unpackF((byte[])this.buf, (int)(n << 2)) : (float)this.getxD(n);
        }

        public double getD(int n) {
            return this.type == 68 ? Convert.unpackD((byte[])this.buf, (int)(n << 3)) : this.getxD(n);
        }

        public void getCF(int n, CoreCommon.CxFloat cxFloat) {
            cxFloat.x = Convert.unpackF((byte[])this.buf, (int)(n <<= 3));
            cxFloat.y = Convert.unpackF((byte[])this.buf, (int)(n + 4));
        }

        public float getCFx(int n) {
            return Convert.unpackF((byte[])this.buf, (int)(n <<= 3));
        }

        public float getCFy(int n) {
            return Convert.unpackF((byte[])this.buf, (int)((n <<= 3) + 4));
        }

        public void getCIF(int n, CoreCommon.CxFloat cxFloat) {
            cxFloat.x = (float)Convert.unpackI((byte[])this.buf, (int)(n <<= 2)) / 32768.0f;
            cxFloat.y = (float)Convert.unpackI((byte[])this.buf, (int)(n + 2)) / 32768.0f;
        }

        public float getCIFx(int n) {
            return (float)Convert.unpackI((byte[])this.buf, (int)(n <<= 2)) / 32768.0f;
        }

        public float getCIFy(int n) {
            return (float)Convert.unpackI((byte[])this.buf, (int)((n <<= 2) + 2)) / 32768.0f;
        }

        public char charAt(int n) {
            return (char)this.buf[n];
        }
    }
}

