/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import java.util.Map;
import nxm.ice.lib.FileIO;
import nxm.ice.lib.ICEPacket;
import nxm.ice.lib.NetIO;
import nxm.ice.lib.SDDSPacket;
import nxm.ice.lib.VRTPacket;
import nxm.ice.prim.sourcepic;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.libm.Add;
import nxm.sys.libm.Fft;
import nxm.sys.libm.Multiply;
import nxm.sys.libm.Noop;
import nxm.sys.libm.Window;

public class Archiver
extends DataFile {
    public static final String propertyList = "Func,Multi,MaxLines,MaxLineSize,Channel,Channels,Cleanup";
    public static final String functionList = "Normal,ICEUnpack,SDDSUnpack,IceDemux,RawMulti,ICEMulti,SDDSMulti,VRTMulti";
    public static final int NORMAL = 0;
    public static final int ICEUNPACK = 1;
    public static final int SDDSUNPACK = 2;
    public static final int ICEDEMUX = 3;
    public static final int RAWMULTI = 4;
    public static final int ICEMULTI = 5;
    public static final int SDDSMULTI = 6;
    public static final int VRTMULTI = 7;
    public static final int NIO = 4;
    public static final int SDDSBUFSZ = 0x110000;
    public static final int ICEBUFSZ = 65536;
    public static final int MAXNIOBUF = 8256;
    public static final int RAWMULTISZ = 131072;
    private sourcepic sp;
    private NetIO nio;
    private ToC toc;
    private PSD psd;
    private KeyVector channels;
    private Channel channel;
    private int multi = 0;
    private int nchan = 0;
    private int func = 0;
    private int sock = 0;
    private double maxLineSize = 1.073741824E9;
    private int maxLines = 0;
    private DataFile dfSuper;
    private String aaux;
    private String aaux1;
    private String aaux2;
    private Parser auxes;
    private int naux = 0;
    private int headerLength = 0;
    private boolean netio;
    private long niobufp;
    private long niobuft;
    private SDDSPacket spkh;
    private VRTPacket vpkh;
    private ICEPacket ipkh;
    private Time stime;
    private int seqNext = 0;
    private int[] seqNextChn;
    private double niodelayfactor = 0.0;
    private long maxlen = 0L;
    private int pktlen = 0;
    private int pktflg = 0;
    private int pktelem;
    private int nfft = 8192;
    private int navg = 16;
    private double psdr = 1.0;
    private int ncpa = 1;
    private String event = "";
    private int tcmode;
    private boolean needTimeUpdate;
    private boolean needCloseOut;
    private boolean needCleanUp;
    private int ctxi;
    private int ctxm;
    private int nioFlg = 0;
    private int tocr = 1;
    private int eventCnt = 0;
    private String gpsfn;
    byte[] buffer = new byte[8];

    public Archiver(sourcepic sourcepic2) {
        this.sp = sourcepic2;
        this.dfSuper = this;
        this.tcmode = sourcepic2.getTCMode();
    }

    public Archiver() {
        this.dfSuper = this;
    }

    public int getMulti() {
        return this.multi;
    }

    public String getFunc() {
        return Parser.get((String)functionList, (int)this.func, (int)-1);
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public double getMaxLineSize() {
        return this.maxLineSize;
    }

    public String getEvent() {
        return this.event;
    }

    public void setMulti(int n) {
        this.multi = n;
    }

    public void setNChan(int n) {
        this.nchan = n;
    }

    public void setFunc(String string) {
        this.func = Parser.find((String)functionList, (String)string, (int)this.func, (int)-1);
    }

    public void setMaxLines(int n) {
        this.maxLines = n;
    }

    public void setMaxLineSize(double d) {
        this.maxLineSize = d;
    }

    public void setEvent(String string) {
        this.event = string;
        this.needCloseOut = true;
    }

    public void setCleanup(String string) {
        this.needCleanUp = true;
    }

    public void setThrottle(double d) {
        double d2 = 1.0 / this.getDelta() * this.getBPE();
        if (this.multi > 0) {
            d2 *= (double)this.multi;
        }
        if (this.nchan > 0) {
            d2 *= (double)this.nchan;
        }
        d2 *= 1.0E-6;
        d2 = d > 0.0 ? d : (d2 *= -d);
        this.niodelayfactor = d == 0.0 || d2 == 0.0 ? 0.0 : 1.0 / d2;
    }

    public boolean open() {
        Object object;
        Object object2;
        String string;
        String string2 = this.fn.getFullName();
        this.netio = string2.startsWith("udp:") || string2.startsWith("stp:");
        String string3 = this.netio ? "network_toc" : this.fn.getRoot() + "_toc";
        String string4 = string = this.netio ? "network_psd" : this.fn.getRoot() + "_psd";
        if (this.netio) {
            this.flags &= 0xFFFFFF7F;
        }
        this.isInput = (this.flags & 1) != 0;
        this.isOutput = (this.flags & 2) != 0;
        Object object3 = this.getQualifier("FUNC");
        if (object3 != null) {
            this.setFunc((String)object3);
        }
        if ((object3 = this.getQualifier("MULTI")) != null) {
            this.setMulti(Convert.o2l((Object)object3));
        }
        if ((object3 = this.getQualifier("THROTTLE")) != null) {
            this.setThrottle(Convert.o2d((Object)object3));
        }
        if ((object3 = this.getQualifier("MAXLEN")) != null) {
            this.maxlen = Convert.o2x((Object)object3);
        }
        if ((object3 = this.getQualifier("PKTLEN")) != null) {
            this.pktlen = Convert.o2l((Object)object3);
        }
        if ((object3 = this.getQualifier("PKTFLG")) != null) {
            this.pktflg = Convert.o2l((Object)object3);
        }
        if ((object3 = this.getQualifier("NFFT")) != null) {
            this.nfft = Convert.o2l((Object)object3);
        }
        if ((object3 = this.getQualifier("NAVG")) != null) {
            this.navg = Convert.o2l((Object)object3);
        }
        if ((object3 = this.getQualifier("PSDR")) != null) {
            this.psdr = Convert.o2d((Object)object3);
        }
        if ((object3 = this.getQualifier("NCPA")) != null) {
            this.ncpa = Convert.o2l((Object)object3);
        }
        if ((object3 = this.getQualifier("NIOTHR")) != null) {
            this.nioFlg = NetIO.THREAD;
        }
        if ((object3 = this.getQualifier("TOCR")) != null) {
            this.tocr = Convert.o2l((Object)object3);
        }
        if ((object3 = this.getQualifier("GPS")) != null) {
            this.gpsfn = (String)object3;
        }
        this.toc = new ToC((Object)this, string3, this.maxLines, this.maxLineSize, this.flags);
        if (this.isOutput && this.psdr > 0.0) {
            this.psd = new PSD(this, string, this.nfft, this.flags);
        }
        if (this.isOutput && this.gpsfn != null && this.gpsfn.length() > 0 && !this.gpsfn.equalsIgnoreCase("NONE") && this.toc != null) {
            object2 = null;
            object = new TextFile(this.gpsfn);
            if (object.exists()) {
                object2 = new Table((TextFile)object);
            }
            if (object2 != null) {
                this.toc.df.keywords.put("GPS", (Object)object2.toString());
            } else {
                this.M.warning((CharSequence)("Could not open GPS file=" + this.gpsfn + " for archive=" + this.getURL()));
                this.gpsfn = null;
            }
        } else {
            this.gpsfn = null;
        }
        object3 = this.getQualifier("TOP");
        if (object3 != null) {
            this.setTop(Convert.o2d((Object)object3));
        }
        if ((object3 = this.getQualifier("DUR")) != null) {
            this.setDur(Convert.o2d((Object)object3));
        }
        if ((object3 = this.getQualifier("EVENT")) != null) {
            this.setEvent(Convert.o2s((Object)object3));
        }
        this.ipkh = (ICEPacket)this.pkh;
        if (this.func >= 4) {
            if (this.pkh == null) {
                this.M.error("Must use /APACKET=ICE for NetIO options");
            }
            this.nio = new NetIO(true);
            this.sock = this.nio.nioOpen(this.fn.getFullName(), this.multi, this.nioFlg);
            this.niobufp = this.nio.nioAlloc(8256);
            if (this.pktlen == 0) {
                this.pktlen = this.ipkh.getSize() * this.ipkh.getBPA();
            }
            this.pktelem = this.pktlen / this.ipkh.getBPA();
            if (this.func == 5) {
                this.ipkh = new ICEPacket(this.getFormat(), this.pktelem, this.pktflg);
            }
            if (this.func == 6) {
                this.spkh = new SDDSPacket(this.getFormat(), 2);
            }
            if (this.func == 7) {
                this.vpkh = new VRTPacket(this.getFormat(), this.pktelem, this.pktflg);
            }
            if (this.func == 6) {
                this.spkh.setDelta(this.getDelta());
            }
            if (this.func == 7) {
                int n = (int)(1.0 / this.getXDelta() + 0.5);
                this.vpkh.createContextFor(1, n, 0, 0);
                this.ctxm = n / this.pktelem;
            }
            this.stime = new Time();
            this.isOpen = this.sock > 0;
            this.headerLength = this.func == 7 ? this.vpkh.getHeaderLength() : 64;
            this.seqNext = 0;
        } else if (this.func == 4) {
            super.open();
            this.offset = 0.0;
            object2 = this.getURL().replace(".tmp", "");
            this.channels = new KeyVector(this.nchan);
            for (int i = 0; i < this.nchan; ++i) {
                object = new Channel(this, (String)object2, i);
                ((Channel)object).open(i);
                this.channels.put(i, "CHAN_" + i, object);
            }
            this.isOpen = true;
        } else if (this.func == 1) {
            this.nio = new NetIO(true);
            this.sock = this.nio.nioOpen(this.fn.getFullName(), 1, 0);
            this.isOpen = this.sock > 0;
        } else if (this.multi <= 0) {
            this.channel = new Channel(this, this.multi);
            this.channel.tocr.setFreq(this.getChannelFreq());
            this.channel.tocr.setTime(this.getChannelTime().getSec());
            this.channel.open(-1);
            if (this.multi == 0) {
                super.open();
            } else {
                this.isOpen = this.channel.df.isOpen;
            }
            this.needTimeUpdate = this.tcmode > 0;
        } else {
            this.channels = new KeyVector(this.multi);
            for (int i = 0; i < this.multi; ++i) {
                object = new Channel(this, i);
                this.channels.put(i, "CHAN_" + i, object);
            }
            super.open();
        }
        int n = Math.max(1, Math.max(this.multi, this.nchan));
        this.seqNextChn = new int[n];
        if (this.ipkh != null) {
            this.ipkh.setTC(this.tcmode, 0, 0.0, 0.0, 0.0);
        }
        this.needCloseOut = false;
        return this.isOpen;
    }

    public void flush() {
        if (!this.isOutput || !this.isOpen) {
            return;
        }
        if (this.nio == null) {
            if (this.func != 4) {
                if (this.multi <= 0) {
                    this.channel.flush();
                } else {
                    for (int i = 0; i < this.multi; ++i) {
                        this.getChannel(i).flush();
                    }
                }
            }
            if (this.multi == 0) {
                super.flush();
            }
        }
        if (this.toc != null) {
            this.toc.flush();
        }
        if (this.psd != null) {
            this.psd.flush();
        }
    }

    public void close() {
        if (this.nio != null) {
            this.nio.nioClose(this.sock);
            this.nio.nioFree(this.niobufp);
        } else {
            if (this.func == 4) {
                for (int i = 0; i < this.nchan; ++i) {
                    this.getChannel(i).close();
                }
            } else if (this.multi <= 0) {
                this.channel.close();
            } else {
                for (int i = 0; i < this.multi; ++i) {
                    this.getChannel(i).close();
                }
            }
            if (this.multi == 0) {
                super.close();
            }
        }
        if (this.toc != null) {
            this.toc.close();
            if (this.needCleanUp) {
                this.toc.df.erase(true);
            }
        }
        if (this.psd != null) {
            this.psd.close();
            if (this.needCleanUp) {
                this.psd.df.erase(true);
            }
        }
    }

    public void setPktHeader(ICEPacket iCEPacket) {
        if (this.func != 5) {
            this.ipkh.copyFrom(iCEPacket);
        } else {
            ((ICEPacket)this.pkh).copyFrom(iCEPacket);
        }
    }

    public int read(long l, byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        if (l != 0L) {
            n4 = this.read(l, n, n2);
        } else if (byArray != null) {
            n4 = this.read(byArray, n, n2);
        }
        this.channel.bytes += (double)n4;
        return n4;
    }

    public int write(long l, int n, int n2, int n3) {
        return this.write(l, null, n, n2, n3);
    }

    public int write(long l, byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        if (this.nio != null) {
            int n5 = (int)(this.niodelayfactor * (double)n2);
            int n6 = n3;
            if (n6 < 0) {
                n6 = 0;
            }
            if (this.ncpa > 1) {
                n6 /= this.ncpa;
            }
            if (this.func == 5) {
                ICEPacket iCEPacket = (ICEPacket)this.pkh;
                this.ipkh.setCount(this.seqNextChn[n6]);
                this.ipkh.setChannel(n3 + 1);
                this.ipkh.setTC(iCEPacket);
                double d = iCEPacket.getUserDataD(1);
                if (d > 0.0) {
                    this.ipkh.setUserData(d, 1);
                }
                if (n3 == -2) {
                    Native.ja2p((Object)this.ipkh.buf, (int)0, (long)this.niobufp, (int)0, (int)this.headerLength);
                    this.nio.nioSendBank(this.sock, this.nchan, this.ncpa, this.niobufp, this.headerLength, this.pktlen, l + (long)n, n2, 0);
                    this.ipkh.upCount(n2 / this.pktlen / (this.nchan / this.ncpa));
                } else {
                    for (int i = 0; i < n2; i += this.pktlen) {
                        if (byArray != null) {
                            Native.ja2p((Object)this.ipkh.buf, (int)0, (long)this.niobufp, (int)0, (int)this.headerLength);
                            Native.ja2p((Object)byArray, (int)(n + i), (long)this.niobufp, (int)this.headerLength, (int)this.pktlen);
                            this.nio.nioSend(this.sock, n6, this.niobufp, this.headerLength + this.pktlen, i == 0 ? n5 : 0);
                        } else if (n >= this.headerLength) {
                            Native.ja2p((Object)this.ipkh.buf, (int)0, (long)(l + (long)n + (long)i), (int)(-this.headerLength), (int)this.headerLength);
                            this.nio.nioSend(this.sock, n6, l + (long)n + (long)i - (long)this.headerLength, this.headerLength + this.pktlen, i == 0 ? n5 : 0);
                        } else {
                            Native.ja2p((Object)this.ipkh.buf, (int)0, (long)this.niobufp, (int)0, (int)this.headerLength);
                            Native.p2p((long)l, (int)(n + i), (long)this.niobufp, (int)this.headerLength, (int)this.pktlen);
                            this.nio.nioSend(this.sock, n6, this.niobufp, this.headerLength + this.pktlen, i == 0 ? n5 : 0);
                        }
                        this.ipkh.upCount();
                        if (n2 == this.pktlen) continue;
                        this.ipkh.decTCO(this.pktelem);
                    }
                }
                this.seqNextChn[n6] = this.ipkh.getCount();
            } else if (this.func == 6) {
                double d = this.ipkh.getUserDataD(1);
                if (d > 0.0) {
                    this.spkh.setDelta(d);
                } else {
                    d = this.getDelta();
                }
                this.ipkh.getTC(this.stime, 0.0, d);
                if (this.ipkh.getTCStatus() > 0) {
                    this.spkh.setTC(0, d, this.stime.getWSec(), this.stime.getFSec());
                }
                this.spkh.setCount(this.seqNextChn[n6]);
                n5 = (int)(this.niodelayfactor * 1024.0);
                for (int i = 0; i < n2; i += 1024) {
                    Native.ja2p((Object)this.spkh.buf, (int)0, (long)this.niobufp, (int)0, (int)this.headerLength);
                    if (byArray != null) {
                        Native.ja2p((Object)byArray, (int)(n + i), (long)this.niobufp, (int)this.headerLength, (int)1024);
                    } else {
                        Native.p2p((long)l, (int)(n + i), (long)this.niobufp, (int)this.headerLength, (int)1024);
                    }
                    this.nio.nioSend(this.sock, n6, this.niobufp + 8L, 1080, n5);
                    if (i == 0) {
                        this.spkh.setTC(0, 0.0, 0.0, 0.0);
                    }
                    this.spkh.upCount();
                }
                this.seqNextChn[n6] = this.spkh.getCount();
            } else if (this.func == 7) {
                for (int i = 0; i < n2; i += this.pktlen) {
                    if (this.ctxi == 0 && this.vpkh.cbuf != null) {
                        int n7 = this.vpkh.ctx2pkt(this.niobufp);
                        this.nio.nioSend(this.sock, n6, this.niobufp, n7, 0);
                    }
                    Native.ja2p((Object)this.vpkh.buf, (int)0, (long)this.niobufp, (int)0, (int)(this.headerLength - 4));
                    if (byArray != null) {
                        Native.ja2p((Object)byArray, (int)(n + i), (long)this.niobufp, (int)(this.headerLength - 4), (int)this.pktlen);
                    } else {
                        Native.p2p((long)l, (int)(n + i), (long)this.niobufp, (int)(this.headerLength - 4), (int)this.pktlen);
                    }
                    Native.ja2p((Object)this.vpkh.buf, (int)(this.headerLength - 4), (long)this.niobufp, (int)(this.headerLength + this.pktlen - 4), (int)4);
                    this.nio.nioSend(this.sock, n6, this.niobufp, this.headerLength + this.pktlen, n5);
                    this.vpkh.upCount();
                    if (++this.ctxi < this.ctxm) continue;
                    this.ctxi = 0;
                }
            } else if (this.func == 1) {
                for (int i = 0; i < n2; i += this.pktlen) {
                    this.nio.nioSend(this.sock, n6, l + (long)i, this.pktlen, i == 0 ? n5 : 0);
                }
            }
        } else if (this.func == 2 && n3 < 0) {
            int n8 = Math.min(n2, 1088);
            int n9 = n + n2;
            while (n < n9) {
                n3 = this.findSDDSChannel(l, n, n2);
                if (n3 < 0) {
                    this.M.error("Out of archive channels");
                }
                n4 += this.write(l, n, n8, n3);
                n += n8;
            }
        } else if (this.func == 3 && n3 < 0) {
            int n10 = 1024;
            int n11 = n + n2;
            while (n < n11) {
                n3 = this.findDemuxChannel(l, n, n2);
                n4 += this.write(l, n, n10, n3);
                n += n10;
            }
        } else if (this.func == 4) {
            int n12 = (int)(this.maxlen <= 0L || this.offset + (double)n2 <= (double)this.maxlen ? (double)n2 : (double)this.maxlen - this.offset);
            if (n12 > 0) {
                int n13 = this.getFrameSize() * this.bpa;
                for (int i = 0; i < n12; i += n13) {
                    Channel channel = this.getChannel(this.seqNext);
                    Native.p2p((long)l, (int)i, (long)channel.lbuf, (int)channel.inbuf, (int)n13);
                    channel.inbuf += n13;
                    if (channel.inbuf + n13 > 131072) {
                        channel.df.write(channel.lbuf, 0, channel.inbuf);
                        channel.inbuf = 0;
                    }
                    this.seqNext = (this.seqNext + 1) % this.nchan;
                }
                this.offset += (double)n12;
                n4 = n12;
            }
        } else if (this.multi == 0) {
            if (l != 0L) {
                n4 = this.write(l, n, n2);
            } else if (byArray != null) {
                n4 = this.write(byArray, n, n2);
            }
            if (this.psd != null) {
                this.psd.proc(l, byArray, n, n2);
            }
            this.channel.bytes += (double)n4;
        } else {
            Object object;
            if (n3 < 0 && this.multi == 1) {
                n3 = 0;
            }
            Channel channel = this.getChannel(n3);
            if (this.needCloseOut) {
                channel.close();
                this.needCloseOut = false;
            }
            if (!channel.isOpen) {
                int n14;
                object = this.getChannelTime();
                this.needTimeUpdate = this.tcmode > 0;
                int n15 = n14 = this.multi > 1 ? n3 : -1;
                if (this.func == 2) {
                    object = SDDSPacket.getTC(null, n, l);
                }
                channel.tocr.setFreq(this.getChannelFreq());
                channel.tocr.setTime((Time)object);
                channel.tocr.setEvent(this.event);
                channel.time.fromTime((Time)object);
                channel.open(n14);
                if (this.func == 2) {
                    channel.df.keywords.putMain("PACKET", "SDDS/ICE");
                }
            }
            if (this.needTimeUpdate) {
                Object object2 = this.ipkh != null ? this.ipkh : (object = this.sp != null ? this.sp.getAPkt() : null);
                if (object != null && ((ICEPacket)object).getTCStatus() > 0) {
                    Time time = channel.time;
                    double d = channel.df.getOffset();
                    ((ICEPacket)object).getTC(time, -d, this.getXDelta());
                    channel.tocr.setTime(time);
                    if (this.toc != null) {
                        this.toc.df.write(channel.tocr.dtoc, (double)this.toc.offset, 1);
                    }
                    this.setTimeNicely(channel.df, time);
                    this.needTimeUpdate = false;
                }
            }
            if (channel.buf != null) {
                Native.p2ja((long)l, (int)n, (Object)channel.buf, (int)channel.inbuf, (int)n2);
                channel.inbuf += n2;
                if (channel.inbuf >= channel.buf.length) {
                    channel.df.write(channel.buf, 0, channel.inbuf);
                    channel.inbuf = 0;
                }
                n4 = n2;
            } else if (l != 0L) {
                n4 = channel.df.write(l, n, n2);
            } else if (byArray != null) {
                n4 = channel.df.write(byArray, n, n2);
            }
            if (this.psd != null) {
                this.psd.proc(l, byArray, n, n2);
            }
            channel.bytes += (double)n4;
            if (this.maxLineSize > 0.0 && channel.bytes >= this.maxLineSize) {
                channel.close();
            }
            channel.hasNewData = true;
        }
        return n4;
    }

    public void addEventKey(String string, double d) {
        if (!this.isOutput || this.sp == null || this.toc == null || this.toc.df == null || !this.toc.df.isOpen) {
            return;
        }
        if (this.eventCnt == 0 && this.seek() == 0.0) {
            return;
        }
        ++this.eventCnt;
        this.toc.df.keywords.put("EVENTS", (Object)this.eventCnt);
        this.toc.df.keywords.add("EVENT" + this.eventCnt, (Object)("{TIME=" + this.sp.getTime().getSec() + "," + string + "=" + d + "}"));
    }

    public static Archiver openForExport(Midas midas, String string, byte[] byArray, int n) {
        Archiver archiver = new Archiver();
        int n2 = n > 0 ? 3 | 8 : 1;
        boolean bl = new String(byArray, 0, 4).equals("BLUE");
        if (n <= 0 || !bl) {
            archiver.init((MidasReference)midas, string);
        } else {
            archiver.init(midas, string, byArray, n2);
        }
        archiver.open(n2 | 0x20);
        archiver.setMaxLines(archiver.toc.nsf);
        archiver.setMaxLineSize(archiver.toc.lineSize);
        if (n > 0 && bl) {
            double d = Convert.unpackD((byte[])byArray, (int)32);
            double d2 = Convert.unpackD((byte[])byArray, (int)40);
            long l = (long)(d + d2);
            archiver.toc.topLength = (long)d2;
        }
        return archiver;
    }

    public long getExportSize() {
        DataFile dataFile = this.channel.df;
        long l = 512L;
        l = this.toc.topLength > 0L ? (l += this.toc.topLength) : (long)((double)l + this.getLengthBytes());
        return l;
    }

    public int readExport(byte[] byArray, long l, int n) {
        if (l == 0L) {
            DataFile dataFile = this.channel.df;
            DataFile dataFile2 = new DataFile((MidasReference)this.M, (Object)"NULL", "1000", dataFile.getFormat(), 2);
            dataFile2.setXUnits(dataFile.getXUnits());
            dataFile2.setXDelta(dataFile.getXDelta());
            dataFile2.setDataSize((double)(this.getExportSize() - 512L));
            Time time = dataFile.getTime();
            if (this.toc.topIndex != 0L) {
                time.addSec(dataFile.getXDelta() * (double)this.toc.topIndex / this.getBPE());
            }
            dataFile2.setTime(time);
            System.arraycopy(dataFile2.hb, 0, byArray, 0, 512);
            return 512;
        }
        long l2 = this.toc.readOffset(l - 512L);
        if (this.toc.isf != this.channel.offset) {
            this.channel.open(this.toc.isf);
        }
        this.channel.df.io.seek(l2);
        this.channel.df.io.read(byArray, 0, n);
        return n;
    }

    public int writeExport(byte[] byArray, int n) {
        return this.write(0L, byArray, 0, n, 0);
    }

    public ToC getToC() {
        return this.toc;
    }

    public PSD getPSD() {
        return this.psd;
    }

    public double getLengthBytes() {
        double d = this.multi < 0 ? (double)this.toc.size * this.toc.lineSize : this.getDataSize();
        return d;
    }

    public double getLength() {
        double d = this.getLengthBytes() / this.getBPE();
        return d * this.getDelta();
    }

    public double getOffset() {
        double d = this.multi < 0 ? (double)this.channel.offset * this.toc.lineSize / this.getBPE() + this.channel.df.getOffset() : super.getOffset();
        return d;
    }

    public void setAAux(String string) {
        this.naux = 0;
        if (string == null || string.length() == 0) {
            return;
        }
        int n = string.indexOf("<>");
        if (n > 0) {
            int n2 = Convert.s2l((String)string.substring(0, n));
            int n3 = Convert.s2l((String)string.substring(n + 2));
            string = "" + n2;
            for (int i = n2 + 1; i <= n3; ++i) {
                string = string + "|" + i;
            }
        }
        if (string.indexOf(124) > 0) {
            this.auxes = new Parser(string, '|');
            this.naux = this.auxes.elements();
        } else {
            this.naux = 1;
            this.aaux = string;
        }
    }

    public void setAAux1(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.M.deprecate((CharSequence)"AAUX1=x,AAUX2=y changed to AAUX=x|y");
        this.aaux1 = string;
        if (this.aaux2 != null) {
            this.setAAux(this.aaux1 + "|" + this.aaux2);
        }
    }

    public void setAAux2(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.M.deprecate((CharSequence)"AAUX1=x,AAUX2=y changed to AAUX=x|y");
        this.aaux2 = string;
        if (this.aaux1 != null) {
            this.setAAux(this.aaux1 + "|" + this.aaux2);
        }
    }

    public double getChannelFreq() {
        if (this.sp != null) {
            return this.sp.getRfFreq() * 1000000.0 + this.sp.getFreq();
        }
        return 0.0;
    }

    public Time getChannelTime() {
        if (this.sp != null) {
            return this.sp.getTime();
        }
        return this.getTime();
    }

    public String getChannelFormat() {
        if (this.sp != null) {
            return this.sp.getFormat();
        }
        return this.getFormat();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Channel getChannel(int n) {
        return this.channels != null ? (Channel)this.channels.get(n) : this.channel;
    }

    public KeyVector getChannels() {
        return this.channels;
    }

    public int findSDDSChannel(long l, int n, int n2) {
        Native.p2ja((long)l, (int)n, (Object)this.buffer, (int)0, (int)8);
        Convert.swap4((byte[])this.buffer, (int)4, (int)1);
        int n3 = Convert.unpackL((byte[])this.buffer, (int)4);
        Convert.swap2((byte[])this.buffer, (int)2, (int)1);
        short s = Convert.unpackI((byte[])this.buffer, (int)2);
        int n4 = -1;
        for (int i = 0; i < this.multi; ++i) {
            Channel channel = (Channel)this.channels.get(i);
            if (channel.port == s && channel.addr == n3) {
                return i;
            }
            if (channel.isOpen || n4 >= 0) continue;
            n4 = i;
        }
        if (n4 >= 0) {
            Channel channel = (Channel)this.channels.get(n4);
            channel.port = s;
            channel.tocr.setPort(s);
            channel.addr = n3;
            channel.tocr.setAddress(n3);
        }
        return n4;
    }

    public int findDemuxChannel(long l, int n, int n2) {
        Native.p2ja((long)l, (int)n, (Object)this.buffer, (int)0, (int)8);
        int n3 = (this.buffer[0] & 1) + ((this.buffer[2] & 1) << 1) + ((this.buffer[4] & 1) << 2) + ((this.buffer[6] & 1) << 3);
        return n3;
    }

    public void checkChannels() {
        for (int i = 0; i < this.multi; ++i) {
            Channel channel = (Channel)this.channels.get(i);
            if (channel.isOpen && !channel.hasNewData) {
                channel.close();
            }
            channel.hasNewData = false;
        }
    }

    public void discontinue() {
        if (this.multi < 0) {
            Channel channel = this.getChannel(0);
            channel.close();
            if (this.ipkh != null) {
                this.ipkh.setTC(this.tcmode, 0, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean isFinished() {
        return this.isOpen && this.maxlen > 0L && this.offset >= (double)this.maxlen;
    }

    public void setTop(double d) {
        if (this.toc != null) {
            this.toc.setTop(d);
        }
    }

    public void setDur(double d) {
        if (this.toc != null) {
            this.toc.setDur(d);
        }
    }

    public void setTime(Time time) {
        Archiver.setTimeNicely(this, time.getWSec(), time.getFSec());
    }

    public void setTimeNicely(DataFile dataFile, Time time) {
        Archiver.setTimeNicely(dataFile, time.getWSec(), time.getFSec());
    }

    public void setTime(double d, double d2) {
        Archiver.setTimeNicely(this, d, d2);
    }

    public static void setTimeNicely(DataFile dataFile, double d, double d2) {
        double d3 = 1.0E-6 * Math.floor(d2 * 1000000.0 + 0.5);
        int n = (int)Math.floor((d2 - d3) * 1.0E12 + 0.5);
        dataFile.setTimeCode(d + d3);
        dataFile.keywords.putMain("TC_PREC", "" + n + "e-12");
    }

    public static int doFunc(Object object, String string, String string2, double d, double d2, String string3, String string4) {
        int n = 0;
        boolean bl = string.equals("ERASE");
        boolean bl2 = string.equals("ASSIGN");
        boolean bl3 = string.equals("SELECT");
        boolean bl4 = string.equals("IMPORT");
        boolean bl5 = string.equals("EXPORT");
        boolean bl6 = string.equals("PROTECT");
        boolean bl7 = string.equals("UNPROTECT");
        boolean bl8 = string3 == null || string3.length() == 0 || string3.equals("*");
        int n2 = 3;
        ToC toC = new ToC(object, string2 + "_toc", -1, -1.0, n2);
        ToCR toCR = toC.tocr;
        for (int i = 0; i < toC.size; ++i) {
            boolean bl9;
            toC.read(toCR, i);
            int n3 = i + 1;
            double d3 = toCR.getTime();
            double d4 = toCR.getLength();
            String string5 = toCR.getEvent();
            boolean bl10 = toCR.getStatus().startsWith("OPENED");
            boolean bl11 = bl9 = bl2 || bl8 || string3.equals(string5);
            if (bl10) {
                d4 = toC.lineSize / ((double)Data.getBPA((String)toCR.getFormat()) * toCR.getRate());
            }
            bl9 = d < 0.0 ? (bl9 &= (double)i >= -d - 1.0 && (double)i < -d - 1.0 - d2) : (bl9 &= d3 + d4 >= d && d3 <= d + d2);
            if (!bl9) continue;
            if (bl2) {
                toCR.setEvent(string3);
            }
            if (bl6) {
                toCR.setStatus(bl10 ? "OPENED/S" : "SAVED");
            }
            if (bl7) {
                toCR.setStatus("CLOSED");
            }
            if (bl2 || bl6 || bl7) {
                toC.write(toCR, i);
            }
            ++n;
        }
        toC.close();
        return n;
    }

    public static String getFileAt(Object object, String string, double d, double d2, int n) {
        int n2 = 1;
        DataFile dataFile = new DataFile(object, (Object)(string + "_toc"));
        if (!dataFile.find(-1)) {
            return string;
        }
        ToC toC = new ToC(object, string + "_toc", -1, -1.0, n2);
        if (d > 0.0) {
            toC.setTop(d);
        }
        if (d2 > 0.0) {
            toC.setDur(d2);
        }
        int n3 = Data.getBPA((String)toC.tocr.getFormat());
        long l = toC.topIndex / (long)n3;
        long l2 = toC.topLength / (long)n3;
        l = Math.max(0L, l / (long)n) * (long)n;
        String string2 = string + "_" + toC.tocr.getKey();
        if (d > 0.0 && d2 > 0.0) {
            string2 = string2 + "(" + l + ":+" + l2 + ")";
        }
        return string2;
    }

    public class PSD {
        DataFile df;
        int nfft;
        int nout;
        int nrot;
        int pass;
        int itot;
        int iper;
        int spa;
        int bpe;
        String format;
        boolean cx;
        boolean isOutput;
        byte dtype;
        Fft fft;
        float[] wind;
        float[] fbuf;
        float[] fout;
        byte[] bbuf;

        public PSD(DataFile dataFile, String string, int n, int n2) {
            double d;
            this.format = dataFile.getFormat();
            this.nfft = n;
            this.spa = dataFile.getSPA();
            this.dtype = dataFile.getFormatType();
            this.bpe = (int)dataFile.getBPE();
            this.cx = this.spa == 2;
            double d2 = dataFile.getXDelta();
            double d3 = d2 * (double)n;
            double d4 = 1.0 / ((double)n * d2);
            this.iper = (int)(1.0 / d2 / (double)Archiver.this.navg * (double)this.bpe);
            int n3 = 8;
            if (this.cx) {
                this.nout = n;
                n3 |= 2;
                d = 1.0 / (double)n;
                this.nrot = n / 2 - 1;
            } else {
                this.nout = n / 2;
                n3 |= 0x21;
                d = 0.5 / (double)n;
                this.nrot = 0;
            }
            this.fft = new Fft(n, n3);
            this.wind = Window.get((String)"HANN", (int)n, (double)d);
            this.fbuf = new float[this.nout * 2];
            this.fout = new float[this.nout * 2];
            this.bbuf = new byte[this.nout * 8];
            this.isOutput = ((n2 &= 0xB) & 2) != 0;
            this.df = new DataFile((MidasReference)dataFile.M, (Object)string, "2000", "CF", n2);
            this.df.setSubsize(this.nout);
            this.df.setXStart((double)(-this.nrot) * d4);
            this.df.setXDelta(d4);
            this.df.setXUnits(3);
            this.df.setYUnits(1);
            this.df.setYStart(0.0);
            this.df.setYDelta(1.0 / Archiver.this.psdr);
            this.df.open();
        }

        public void proc(long l, byte[] byArray, int n, int n2) {
            int n3;
            this.itot += n2;
            if (this.itot < this.iper) {
                return;
            }
            this.itot = 0;
            int n4 = n2 / this.bpe;
            if (n4 > this.nfft) {
                n4 = this.nfft;
            }
            if (l != 0L) {
                byArray = this.bbuf;
                n = 0;
                n3 = Math.min(n2, this.nout * 8);
                Native.p2ja((long)l, (int)0, (Object)byArray, (int)n, (int)n3);
            }
            Convert.bb2ja((byte[])byArray, (int)n, (byte)this.dtype, (Object)this.fbuf, (int)0, (byte)70, (int)(n4 * this.spa));
            for (n3 = n4 * this.spa; n3 < this.nout * 2; ++n3) {
                this.fbuf[n3] = 0.0f;
            }
            if (this.cx) {
                Multiply.CSC((float[])this.fbuf, (float[])this.wind, (float[])this.fbuf, (int)this.nfft);
            } else {
                Multiply.SSS((float[])this.fbuf, (float[])this.wind, (float[])this.fbuf, (int)this.nfft);
            }
            this.fft.work((Object)this.fbuf);
            if (this.cx) {
                this.fft.rotateCF(this.fbuf);
            }
            if (this.pass == 0) {
                Noop.CC((float[])this.fbuf, (float[])this.fout, (int)this.nout);
            } else {
                Add.CCC((float[])this.fbuf, (float[])this.fout, (float[])this.fout, (int)this.nout);
            }
            ++this.pass;
            if (Archiver.this.multi == 0 && this.pass >= Archiver.this.navg) {
                this.write();
            }
        }

        public void write(int n) {
            this.df.seek((double)n);
            this.write();
            this.df.update();
        }

        public void write() {
            Convert.ja2bb((Object)this.fout, (int)0, (byte)70, (byte[])this.bbuf, (int)0, (byte)70, (int)(this.nout * 2));
            this.df.write(this.bbuf, 0, this.nout * 8);
            this.zero();
        }

        public void zero() {
            this.pass = 0;
            this.itot = 0;
        }

        public void flush() {
            if (this.isOutput) {
                this.df.flush();
            }
        }

        public void close() {
            if (this.df.isOpen()) {
                this.df.close();
            }
        }

        public boolean isOpen() {
            return this.df.isOpen();
        }
    }

    public static class ToCR {
        Data dtoc;

        public ToCR(DataFile dataFile) {
            this.dtoc = dataFile.getDataBuffer(1);
        }

        public void setEvent(String string) {
            this.dtoc.packS(0, 8, string);
        }

        public void setStatus(String string) {
            this.dtoc.packS(8, 8, string);
        }

        public void setKey(short s) {
            this.dtoc.packI(16, s);
        }

        public void setPort(short s) {
            this.dtoc.packI(18, s);
        }

        public void setAddress(int n) {
            this.dtoc.packL(20, n);
        }

        public void setFormat(String string) {
            this.dtoc.packS(24, 8, string);
        }

        public void setRate(double d) {
            this.dtoc.packD(32, d);
        }

        public void setFreq(double d) {
            this.dtoc.packD(40, d);
        }

        public void setTime(double d) {
            this.dtoc.packD(48, d);
        }

        public void setLength(double d) {
            this.dtoc.packD(56, d);
        }

        public void setTime(Time time) {
            if (time != null) {
                this.setTime(time.getSec());
            }
        }

        public String getEvent() {
            return this.dtoc.unpackS(0, 8);
        }

        public String getStatus() {
            return this.dtoc.unpackS(8, 8);
        }

        public short getKey() {
            return this.dtoc.unpackI(16);
        }

        public short getPort() {
            return this.dtoc.unpackI(18);
        }

        public int getAddress() {
            return this.dtoc.unpackL(20);
        }

        public String getFormat() {
            return this.dtoc.unpackS(24, 8);
        }

        public double getRate() {
            return this.dtoc.unpackD(32);
        }

        public double getFreq() {
            return this.dtoc.unpackD(40);
        }

        public double getTime() {
            return this.dtoc.unpackD(48);
        }

        public double getLength() {
            return this.dtoc.unpackD(56);
        }
    }

    public static class ToC {
        int offset;
        int topOffset;
        DataFile df;
        ToCR tocr;
        int isf;
        int nsf;
        int size;
        boolean isInput = ((n2 &= 0xB) & 1) != 0;
        boolean isOutput;
        long topIndex;
        long topLength;
        long clen;
        double lineSize;
        double topTime;

        public ToC(Object object, String string, int n, double d, int n2) {
            this.isOutput = (n2 & 2) != 0;
            this.df = new DataFile();
            this.df.init(object, (Object)string, "3000", "NH", n2);
            this.df.setSubRecords("EVNT|1A,STAT|1A,KEY|SI,PORT|SI,ADDR|4B,FORM|1A,RATE|SD,FREQ|SD,TIME|SD,LEN|SD");
            if (this.isOutput & !this.isInput) {
                this.df.keywords.put("LINES", Convert.l2o((int)n));
                this.df.keywords.put("LINESIZE", Convert.d2o((double)d));
                this.df.keywords.put("CUROFFSET", Convert.d2o((double)0.0));
            }
            this.df.open();
            this.nsf = this.df.keywords.getL("LINES", n);
            d = this.df.keywords.getD("LINESIZE", d);
            this.offset = this.df.keywords.getL("CUROFFSET", 0);
            this.size = (int)this.df.getSize();
            this.lineSize = d;
            this.tocr = new ToCR(this.df);
        }

        public void write(ToCR toCR, int n) {
            this.df.write(toCR.dtoc, (double)n, 1);
            this.df.update();
            if (n >= this.size) {
                this.size = n + 1;
                this.df.setSize((double)this.size);
            }
        }

        public void nextOffset(int n) {
            this.offset = n;
        }

        public int nextOffset() {
            ++this.offset;
            if (this.nsf > 0) {
                if (this.offset >= this.nsf) {
                    this.offset = 0;
                }
                while (this.offset < this.size) {
                    this.read(this.tocr, this.offset);
                    if (!this.tocr.getStatus().startsWith("SAVE")) break;
                    ++this.offset;
                    if (this.offset < this.nsf) continue;
                    this.offset = 0;
                }
            }
            this.df.keywords.put("CUROFFSET", Convert.l2o((int)this.offset));
            if (this.isOutput) {
                this.df.flush();
            }
            return this.offset;
        }

        public long readOffset(long l) {
            int n;
            long l2 = l + this.topIndex;
            long l3 = (long)this.lineSize;
            int n2 = (int)(l2 / l3);
            long l4 = l2 - (long)n2 * l3;
            this.isf = n = (this.topOffset + n2) % Math.max(1, this.size);
            return l4;
        }

        public void read(int n) {
            this.read(this.tocr, n);
        }

        public void read(ToCR toCR, int n) {
            this.df.read(toCR.dtoc, (double)n, 1);
        }

        public void flush() {
            if (this.isOutput && this.df.isOpen()) {
                this.df.flush();
            }
        }

        public void close() {
            if (this.df.isOpen()) {
                this.df.close();
            }
        }

        public boolean isOpen() {
            return this.df.isOpen();
        }

        public int size() {
            return this.size;
        }

        public double getLength() {
            double d = 0.0;
            for (int i = 0; i < this.size; ++i) {
                this.read(this.tocr, i);
                d += this.tocr.getLength();
            }
            return d;
        }

        public void setTop(double d) {
            int n = 0;
            double d2 = 0.0;
            double d3 = 1.0;
            for (n = 0; n < this.size; ++n) {
                this.read(n);
                d2 = this.tocr.getTime();
                d3 = this.tocr.getLength();
                if (d2 <= d && d < d2 + d3) break;
            }
            if (n >= this.size) {
                System.out.println("Top time=" + d + " not found. Starting at 1st record.");
                n = 0;
                this.read(n);
                d = d2 = this.tocr.getTime();
            }
            this.topOffset = n;
            this.topIndex = (long)((d - d2) * this.tocr.getRate()) * (long)Data.getBPA((String)this.tocr.getFormat());
            this.topIndex = Math.max(0L, this.topIndex);
            this.topTime = d;
            this.nextOffset(n);
            this.clen = 0L;
        }

        public void setDur(double d) {
            this.topLength = (long)(d * this.tocr.getRate() * (double)Data.getBPA((String)this.tocr.getFormat()));
            this.topLength = Math.max(1L, this.topLength / 0x100000L) * 0x100000L;
        }

        public double getSavedSpace() {
            double d = 0.0;
            for (int i = 0; i < this.size; ++i) {
                this.read(this.tocr, i);
                if (!this.tocr.getStatus().equals("SAVED")) continue;
                d += this.lineSize;
            }
            return d;
        }

        public double getTotalSpace() {
            return this.lineSize * (double)this.size;
        }
    }

    public class Channel {
        short port;
        int addr;
        int offset;
        double bytes;
        boolean isOpen;
        boolean hasNewData;
        byte[] buf;
        int inbuf = 0;
        long lbuf;
        DataFile df;
        Time time = new Time();
        FileName mfn;
        ToCR tocr;
        String quals;

        public Channel(DataFile dataFile, int n) {
            this.df = dataFile;
            this.tocr = new ToCR(((Archiver)Archiver.this).toc.df);
            this.tocr.setEvent(Archiver.this.getEvent());
            this.tocr.setStatus("");
            this.tocr.setKey((short)(n + 1));
            this.tocr.setPort((short)0);
            this.tocr.setAddress(0);
            this.tocr.setFormat(Archiver.this.getChannelFormat());
            this.tocr.setFreq(0.0);
            this.tocr.setTime(0.0);
            if (Archiver.this.func == 2) {
                this.buf = new byte[0x110000];
            }
            this.quals = Archiver.this.fn.getQualifiers();
            if (this.quals.indexOf("+APPEND") > 0) {
                this.quals = this.quals.replace("+APPEND", "|");
            } else if (this.quals.indexOf("APPEND") > 0) {
                this.quals = this.quals.replace("APPEND", "|");
            }
        }

        public Channel(DataFile dataFile, String string, int n) {
            this(dataFile, n);
            String string2 = String.format("%s_ch_%04d", string, n);
            this.mfn = new FileName(string2);
            this.mfn.setExt("tmp");
            this.lbuf = FileIO.malloc(131072L);
            this.inbuf = 0;
            this.buf = null;
        }

        public boolean open(int n) {
            if (this.isOpen) {
                this.close();
            }
            if (n < 0) {
                n = ((Archiver)Archiver.this).toc.offset;
            }
            this.tocr.setStatus("OPENED");
            this.bytes = 0.0;
            boolean bl = true;
            if (Archiver.this.multi != 0) {
                int n2 = n + 1;
                this.tocr.setKey((short)n2);
                String string = Archiver.this.fn.getRoot() + "_%d";
                String string2 = String.format(string, n2);
                Command command = Archiver.this.cmd;
                if (command == null) {
                    command = Archiver.this.M;
                }
                if (Archiver.this.isInput) {
                    this.df = new DataFile((Object)command, (Object)(string2 + this.quals), "1000", "", Archiver.this.flags & 0xFFFFFFF7);
                }
                if (Archiver.this.isOutput) {
                    this.df = new DataFile((Object)command, (Object)(string2 + this.quals), Archiver.this.dfSuper, Archiver.this.flags & 0xFFFFFFF7);
                }
                int n3 = n;
                if (Archiver.this.naux == 1) {
                    this.df.setAux(Archiver.this.aaux);
                } else if (Archiver.this.naux > 1) {
                    this.df.setAux(Archiver.this.auxes.get(n3 % Archiver.this.naux + 1));
                }
                if (this.time != null) {
                    Archiver.this.setTimeNicely(this.df, this.time);
                }
                bl = this.df.open();
            } else if (Archiver.this.func == 4) {
                Command command = Archiver.this.cmd;
                if (command == null) {
                    command = Archiver.this.M;
                }
                this.df = new DataFile((Object)command, (Object)this.mfn, "1000", Archiver.this.getFormat(), 0);
                this.df.setDetached(1);
                bl = this.df.open(130);
                this.df.setDataStart(0.0);
                this.df.setXUnits(1);
                this.df.setXDelta(Archiver.this.dfSuper.getXDelta() * (double)Archiver.this.nchan);
            }
            if (((Archiver)Archiver.this).dfSuper.isOutput) {
                this.tocr.setRate(1.0 / this.df.getXDelta());
                this.tocr.setLength(0.0);
                Archiver.this.toc.write(this.tocr, n);
            }
            this.offset = n;
            this.isOpen = bl;
            return bl;
        }

        public void flush() {
            if (!((Archiver)Archiver.this).dfSuper.isOutput || !this.isOpen) {
                return;
            }
            if (this.inbuf > 0) {
                if (Archiver.this.func == 4) {
                    this.df.write(this.lbuf, 0, this.inbuf, false);
                } else {
                    this.df.write(this.buf, 0, this.inbuf);
                }
                this.inbuf = 0;
            }
            if (Archiver.this.multi != 0) {
                this.df.flush();
            }
            double d = this.bytes;
            if (Archiver.this.func == 2) {
                d = this.bytes * 1024.0 / 1088.0;
            }
            this.tocr.setLength(d / this.df.dbpe * this.df.getDelta());
        }

        public void close() {
            if (!this.isOpen) {
                return;
            }
            this.tocr.setStatus("CLOSED");
            this.tocr.setFreq(Archiver.this.getChannelFreq());
            this.updateKeys(this.df);
            this.flush();
            if (Archiver.this.multi != 0 && this.df != Archiver.this.dfSuper) {
                this.df.close();
            } else if (Archiver.this.func == 4) {
                this.df.close();
                FileIO.mfree(this.lbuf);
            }
            if (((Archiver)Archiver.this).dfSuper.isOutput) {
                if (this.offset < ((Archiver)Archiver.this).toc.size) {
                    Archiver.this.toc.read(this.offset);
                    this.tocr.setEvent(((Archiver)Archiver.this).toc.tocr.getEvent());
                    if (((Archiver)Archiver.this).toc.tocr.getStatus().equals("OPENED/S")) {
                        this.tocr.setStatus("SAVED");
                    }
                }
                Archiver.this.toc.write(this.tocr, this.offset);
                if (Archiver.this.multi != 0 && Archiver.this.psd != null) {
                    Archiver.this.psd.write(this.offset);
                }
            }
            if (Archiver.this.multi <= 0) {
                Archiver.this.toc.nextOffset();
            }
            this.isOpen = false;
        }

        public void updateKeys(DataFile dataFile) {
            Table table;
            if (!Archiver.this.isOutput) {
                return;
            }
            if (Archiver.this.sp == null) {
                return;
            }
            dataFile.keywords.put("PORT", (Object)Archiver.this.sp.getPort());
            if (Archiver.this.sp.getRfFreq() > 0.0) {
                dataFile.keywords.put("RFFREQ", (Object)Archiver.this.sp.getRfFreq());
                dataFile.keywords.put("RFGAIN", (Object)Archiver.this.sp.getRfGain());
            }
            if (Archiver.this.sp.isTuner()) {
                dataFile.keywords.put("FREQ", (Object)Archiver.this.sp.getFreq());
                dataFile.keywords.put("GAIN", (Object)Archiver.this.sp.getGain());
            }
            if ((table = Archiver.this.sp.getArchKW()) != null) {
                dataFile.keywords.putAll((Map)table);
            }
        }
    }
}

