/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.dsp.prim.firkais;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class WBR
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int ONP = 1;
    public static final int NP = 2;
    public static final int BW = 64;
    public static final int IKR = 8;
    public static final int OTAP = 6;
    public static final int RTAP = 64;
    public static final int OFILT = 5;
    public static final int FILT = 32;

    public static class CORE
    extends Core {
        float fwf;
        double p;
        double dp;
        double dpinc;
        int ntap;
        int nrpt;
        float fscl;
        float lfp;
        float mfp;
        float dpi;
        float[] dpia;
        boolean updn;
        boolean bypass;
        int gain;
        CoreComponent.CxTapBuf vd;
        CoreComponent.RomF2Di rft;
        CoreCommon.CxFloat[] vi;
        CoreCommon.CxFloat[] vs;
        CoreCommon.CxFloat[] vo;

        public void setRatio(double d) {
            this.dp = 1.0 / d;
            this.ntap = 64 - 2 * CORE.d2i(CORE.ceil(2.0 * this.dp));
            this.updn = d > 1.0;
            this.bypass = this.dp == 1.0;
            this.dpinc = this.updn ? this.dp : d;
            this.putVars("dpinc");
        }

        public void setGain(double d) {
            double d2 = CORE.pow(2.0, d / 6.0);
            this.fscl = CORE.d2f(d2);
            if ((double)this.gain == d) {
                return;
            }
            this.gain = (byte)d;
            this.putVars("gain,fscl");
        }

        public void genFilt() {
            int n = this.nrpt * this.ntap;
            int n2 = 64 - this.ntap;
            double d = this.updn ? (double)this.fwf : (double)this.fwf / this.dp;
            float[] fArray = new float[n * 2];
            firkais.generate((int)1, (double)(d / (double)this.nrpt), (double)0.0, (double)(0.05 / (double)this.nrpt), (double)90.0, (float[])fArray, (int)n, (boolean)false);
            int n3 = 0;
            for (int i = 0; i < this.ntap; ++i) {
                int n4 = 0;
                while (n4 < this.nrpt) {
                    this.rft.set(n4, i + n2, fArray[n3] * (float)this.nrpt);
                    ++n4;
                    n3 += 2;
                }
            }
        }

        @Override
        public int init() {
            this.fwf = 0.9f;
            this.dp = 1.0;
            this.fscl = 1.0f;
            this.ntap = 64;
            this.nrpt = 32;
            return 0;
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "D:RATIO")) {
                this.setRatio(value.toD());
            } else if (this.isMatch(string, "L:NTAP")) {
                this.ntap = value.toL();
            } else if (this.isMatch(string, "F:FWF")) {
                this.fwf = value.toF();
            } else if (this.isMatch(string, "D:GAIN")) {
                this.setGain(value.toD());
            } else {
                return super.set(string, value);
            }
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "L:GAIN")) {
                value.fromL(this.gain);
            } else if (this.isMatch(string, "L:NTAP")) {
                value.fromL(this.ntap);
            } else if (this.isMatch(string, "D:RATIO")) {
                value.fromD(1.0 / this.dp);
            } else if (this.isMatch(string, "D:XDIO")) {
                value.fromD(this.dp);
            } else {
                return super.get(string, value);
            }
            return 0;
        }

        @Override
        public int open() {
            int n;
            this.rft = new CoreComponent.RomF2Di(5, 6, 64);
            this.vd = new CoreComponent.CxTapBuf(6, 1, 64, -1);
            this.vi = new CoreCommon.CxFloat[2];
            for (n = 0; n < 2; ++n) {
                this.vi[n] = new CoreCommon.CxFloat();
            }
            this.vo = new CoreCommon.CxFloat[2];
            for (n = 0; n < 2; ++n) {
                this.vo[n] = new CoreCommon.CxFloat();
            }
            this.vs = new CoreCommon.CxFloat[2];
            for (n = 0; n < 2; ++n) {
                this.vs[n] = new CoreCommon.CxFloat();
            }
            if (this.ntap > 64) {
                System.out.printf("Number taps=%d limited to max taps=%d for this buid\n", this.ntap, 64);
                this.ntap = 64;
            }
            this.genFilt();
            this.dpi = CORE.d2f(this.dp);
            this.p = 0.0;
            this.lfp = 0.0f;
            this.mfp = 1.0f - this.lfp;
            this.dpia = new float[2];
            for (n = 0; n < 2; ++n) {
                this.dpia[n] = this.dpi * (float)n;
            }
            this.dpi = CORE.d2f(this.dp * 0.999);
            System.out.printf("WBR dp=%f ntap=%d nrpt=%d spc=%d byp=%d\n", this.dp, this.ntap, this.nrpt, 2, this.bypass ? 1 : 0);
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream stream, CoreComponent.Stream stream2) {
            CoreCommon.CxFloat cxFloat = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat2 = CoreCommon.CxFloat.stk();
            while (stream.rok && stream2.wok) {
                float f;
                boolean bl;
                boolean bl2;
                float f2 = CORE.d2f(this.p);
                if (this.updn) {
                    bl2 = f2 < this.lfp;
                    bl = true;
                    f = f2;
                } else {
                    bl2 = true;
                    bl = f2 <= this.lfp;
                    f = this.mfp * this.dpi;
                }
                this.lfp = f2;
                this.mfp = 1.0f - f2;
                this.p = CORE.frac(this.p + this.dpinc);
                if (bl2) {
                    stream.rdCIFA(this.vi, 2);
                    for (int i = 0; i < 2; ++i) {
                        CORE.mulfc(this.fscl, this.vi[i], this.vs[i]);
                    }
                    this.vd.loadA(this.vs, 2);
                }
                if (!bl) continue;
                for (int i = 0; i < 2; ++i) {
                    float f3 = CORE.mulfp2(f, 1) + this.dpia[i];
                    CoreCommon.CxFloat cxFloat3 = CoreCommon.CxFloat.stk();
                    cxFloat3.x = 0.0f;
                    cxFloat3.y = 0.0f;
                    for (int j = 0; j < 64; ++j) {
                        float f4;
                        CoreCommon.CxFloat cxFloat4 = CoreCommon.CxFloat.stk();
                        CoreCommon.CxFloat cxFloat5 = CoreCommon.CxFloat.stk();
                        CoreCommon.CxFloat cxFloat6 = CoreCommon.CxFloat.stk();
                        float f5 = f4 = this.rft.getrN(f3, j);
                        this.vd.get(j, cxFloat5);
                        cxFloat4 = cxFloat5;
                        cxFloat3.x += f5 * cxFloat4.x;
                        cxFloat3.y += f5 * cxFloat4.y;
                    }
                    this.vo[i] = cxFloat3;
                }
                stream2.wrCFIA(this.vo, 2);
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

