/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class PKT2DAT
extends CoreFactory {

    public static class CORE
    extends Core {
        public static final int FLOW = 4;
        public static final int SELFPACE = 1;
        public static final int PIPE = 0;
        public static final String pktList = "Auto,None,Eth,UDP,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD";
        public static final int PT_AUTO = -1;
        public static final int PT_NONE = 0;
        public static final int PT_ETH = 1;
        public static final int PT_UDP = 2;
        public static final int PT_ICE = 3;
        public static final int PT_SDDS = 4;
        public static final int PT_VRT = 5;
        public static final int PT_VRTL = 6;
        public static final int PT_VRTW = 7;
        public static final int PT_VRTX = 8;
        public static final int PT_VRTD = 9;
        public static final String flgList = "Asis,Gate,Clip,AllEth,AnyMC,AnySID,AnyIP,Other,Pack,Test";
        public static final int BW = 32;
        public static final int PIBW = 32;
        public static final int POBW = 32;
        public static final int RW = 15;
        public static final int CW = 2;
        public static final int NC = 4;
        public static final int IP = 8;
        public static final int ARP = 1544;
        public static final int ICMP = 1;
        public static final int IGMP = 2;
        public static final int TCP = 6;
        public static final int UDP = 17;
        public static final int SOP = 54613;
        public static final int OUID = 1068407;
        public static final int DIFI = 6971934;
        public static final int GATE = 485425152;
        public static final int IGMP_BA = -536870911;
        public static final int RES_IPKT = 1;
        public static final int RES_OPKT = 2;
        public static final int RES_ARP = 3;
        public static final int RES_ICMP = 4;
        public static final int RES_IGMP = 5;
        public static final int RES_OTHER = 6;
        int pkty;
        int myip;
        int mcip;
        int mcid;
        int flags;
        int osel;
        int ipkt;
        int opkt;
        int ic;
        int nc;
        int[] mcips;
        int[] mcids;
        int[] osels;
        int counts;
        int nseq;
        int ouid;
        int debug;
        CoreComponent.Dma dma;

        @Override
        public int init() {
            this.ic = 0;
            this.nc = 0;
            this.pkty = -1;
            this.ouid = 0;
            return 0;
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "S:PT")) {
                this.pkty = value.toItem(pktList);
            } else if (this.isMatch(string, "L:PKTY")) {
                this.pkty = value.toL();
            } else if (this.isMatch(string, "L:MYIP")) {
                this.myip = value.toL();
            } else if (this.isMatch(string, "L:CHAN")) {
                this.ic = value.toL();
            } else if (this.isMatch(string, "L:MCIP")) {
                this.mcip = value.toL();
            } else if (this.isMatch(string, "L:MCID")) {
                this.mcid = value.toL() & 0xFFFF;
            } else if (this.isMatch(string, "L:OSEL")) {
                this.osel = value.toL();
            } else if (this.isMatch(string, "L:OUID")) {
                this.ouid = value.toL();
            } else if (this.isMatch(string, "S:FLAGS")) {
                this.flags = value.toMask(flgList);
            } else if (this.isMatch(string, "L:FLAGS")) {
                this.flags = value.toL();
            } else {
                return super.set(string, value);
            }
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "L:PKTY")) {
                value.fromL(this.pkty);
            } else if (this.isMatch(string, "L:MYIP")) {
                value.fromL(this.myip);
            } else if (this.isMatch(string, "L:MCIP")) {
                value.fromL(this.mcip);
            } else if (this.isMatch(string, "L:MCID")) {
                value.fromL(this.mcid);
            } else if (this.isMatch(string, "L:FLAGS")) {
                value.fromL(this.flags);
            } else {
                return super.get(string, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.dma = new CoreComponent.Dma(15, 32);
            this.mcips = new int[4];
            this.mcids = new int[4];
            this.osels = new int[4];
            for (int i = 0; i < 4; ++i) {
                this.mcips[i] = -1;
                this.mcids[i] = 65535;
                this.osels[i] = 0;
            }
            this.mcips[this.ic] = this.mcip;
            this.mcids[this.ic] = this.mcid;
            this.osels[this.ic] = this.osel;
            if (this.pkty == 2) {
                this.flags |= 1;
            }
            if (this.pkty == 1) {
                this.flags |= 8;
            }
            if (this.mcip == -1) {
                this.flags |= 0x10;
            }
            if (this.mcid == 65535) {
                this.flags |= 0x20;
            }
            if (this.ouid < 0) {
                this.flags |= 0x400;
            }
            if (this.ouid <= 0) {
                this.ouid = this.pkty == 9 ? 6971934 : 1068407;
            }
            this.ipkt = 0;
            this.opkt = 0;
            this.nseq = 0;
            this.counts = 0;
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("PKT2DAT pkt=%d flg=%04x\n", this.pkty, this.flags);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Buffer buffer, CoreComponent.Stream stream, CoreComponent.Stream stream2, CoreComponent.Stream stream3) {
            boolean bl;
            boolean bl2 = CORE.getBit(this.flags, 0);
            boolean bl3 = CORE.getBit(this.flags, 1);
            boolean bl4 = CORE.getBit(this.flags, 2);
            boolean bl5 = CORE.getBit(this.flags, 3) || this.pkty == 1;
            boolean bl6 = CORE.getBit(this.flags, 4);
            boolean bl7 = CORE.getBit(this.flags, 5);
            boolean bl8 = CORE.getBit(this.flags, 6);
            boolean bl9 = CORE.getBit(this.flags, 7);
            boolean bl10 = CORE.getBit(this.flags, 8);
            boolean bl11 = CORE.getBit(this.flags, 9);
            int n = CORE.getBits(this.flags, 15, 12);
            boolean bl12 = false;
            boolean bl13 = this.pkty == 0 && !CORE.getBit(this.flags, 1);
            boolean bl14 = this.pkty == 2;
            boolean bl15 = this.pkty == -1 || this.pkty == 3;
            boolean bl16 = this.pkty == -1 || this.pkty == 4;
            boolean bl17 = bl = this.pkty == -1 || this.pkty >= 5;
            if (bl3 && !stream.rok && stream2.wok && !bl13) {
                stream2.wrL(485425152);
            }
            while (stream.rok) {
                boolean bl18;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = this.nseq;
                ++this.ipkt;
                this.counts = CORE.setBits(this.counts, 11, 0, this.ipkt);
                int n10 = stream.rdL();
                int n11 = buffer.getL(0);
                int n12 = buffer.getL(12);
                boolean bl19 = CORE.getBits(n12, 31, 16) == 1544;
                boolean bl20 = CORE.getBits(n12, 31, 16) == 8;
                n12 = buffer.getL(24);
                boolean bl21 = bl20 && CORE.getBits(n12, 15, 8) == 17;
                boolean bl22 = bl20 && CORE.getBits(n12, 15, 8) == 1;
                boolean bl23 = bl20 && CORE.getBits(n12, 15, 8) == 2;
                boolean bl24 = false;
                n12 = buffer.getL(32);
                int n13 = CORE.bswap4(n12);
                boolean bl25 = n13 == this.myip;
                boolean bl26 = n13 == this.mcip;
                boolean bl27 = bl18 = n13 == -536870911;
                if (CORE.getBits(n10, 17, 16) != 1 || CORE.getBits(n11, 15, 0) != 54613) {
                    bl12 = true;
                    this.counts = CORE.setBit(this.counts, 31, true);
                    this.counts = CORE.setBits(this.counts, 30, 28, CORE.getBits(this.counts, 30, 28) + 1);
                    return 1;
                }
                if (bl21 && (bl6 || bl26) && !bl5) {
                    n12 = buffer.getL(40);
                    short s = CORE.bswap2(CORE.getBits(n12, 15, 0));
                    int n14 = 8;
                    n6 = 44;
                    boolean bl28 = true;
                    n12 = buffer.getL(n6);
                    n11 = buffer.getL(n6 + 4);
                    int n15 = buffer.getL(n6 + 8);
                    int n16 = buffer.getL(n6 + 12);
                    boolean bl29 = CORE.getBit(this.flags, 10) || !CORE.getBit(n12, 3);
                    boolean bl30 = CORE.getBit(n12, 3);
                    boolean bl31 = CORE.getBits(n12, 6, 5) > 1 ? true : CORE.getBit(n12, 4);
                    int n17 = CORE.bswap2(bl31 ? CORE.getBits(n11, 31, 16) : CORE.getBits(n15, 15, 0));
                    boolean bl32 = n17 == this.mcid;
                    boolean bl33 = this.ouid == CORE.bswap4(bl31 ? n15 : n11);
                    boolean bl34 = CORE.getBits(n12, 7, 0) == 28;
                    boolean bl35 = CORE.getBits(n12, 7, 0) == 8;
                    boolean bl36 = CORE.getBits(n12, 7, 0) == 20 && this.pkty == 8;
                    boolean bl37 = CORE.getBits(n12, 7, 0) == 24;
                    boolean bl38 = CORE.getBits(n12, 7, 0) == 73 || CORE.getBits(n12, 7, 0) == 65;
                    boolean bl39 = bl15 && n12 == 0x676665;
                    boolean bl40 = bl16 && s == 1088;
                    boolean bl41 = !(!bl || !bl34 && !bl35 && !bl36 && !bl37 || !bl32 && !bl7 || !bl33 && !bl29);
                    boolean bl42 = bl24 = !(!bl || !bl38 || !bl32 && !bl7 || !bl33 && !bl29);
                    if (bl14) {
                        n7 = 0;
                    } else if (bl39) {
                        n7 = 64;
                        n9 = CORE.getBits(n11, 7, 0);
                        n17 = CORE.getBits(n16, 31, 16);
                    } else if (bl40) {
                        n7 = 56;
                        n9 = CORE.getBits(n12, 31, 24);
                        boolean bl43 = CORE.getBits(n12, 13, 8) > 8;
                        n16 = buffer.getL(n6 + 52);
                        n17 = CORE.getBits(n16, 31, 16);
                        n2 = CORE.setBit(n2, 0, bl43);
                    } else if (bl41) {
                        boolean bl44;
                        if (CORE.getBit(n12, 2) && !bl2) {
                            n14 = 12;
                        }
                        n9 = CORE.getBits(n12, 11, 8);
                        this.nseq &= 0xF;
                        int n18 = !bl30 ? 20 : (n7 = !bl31 ? 24 : 28);
                        boolean bl45 = bl34 ? CORE.getBit(n16, 22) : (bl44 = bl35 ? CORE.getBit(n15, 22) : true);
                        int n19 = bl34 ? CORE.getBits(n16, 27, 24) : (bl35 ? CORE.getBits(n15, 27, 24) : 15);
                        n2 = CORE.setBit(n2, 0, n19 == 15 && bl44);
                        n2 = CORE.setBit(n2, 1, n19 > 7 && bl44);
                        n2 = CORE.setBit(n2, 2, n19 == 11 && bl44);
                        if (bl11) {
                            n12 = buffer.getL(n6 + 16);
                            bl28 = CORE.getBits(n12, 31, 28) < n;
                        }
                    } else {
                        boolean bl46 = bl28 = bl24 ? bl2 : false;
                    }
                    if (bl2) {
                        n7 = 0;
                        n2 = 0;
                    }
                    int n20 = s - n7 - n14;
                    boolean bl47 = bl32 = n17 == this.mcid;
                    if (bl28 && (bl32 || bl7)) {
                        n8 = n20;
                    }
                } else if (bl22 && bl25 | bl8) {
                    n5 = 4;
                    this.counts = CORE.setBits(this.counts, 19, 16, CORE.getBits(this.counts, 19, 16) + 1);
                    bl5 |= !bl3;
                } else if (bl23 && bl25 | bl8 | bl26 | bl18) {
                    n5 = 5;
                    this.counts = CORE.setBits(this.counts, 23, 20, CORE.getBits(this.counts, 23, 20) + 1);
                } else if (bl19) {
                    n12 = buffer.getL(40);
                    n13 = CORE.bswap4(n12);
                    boolean bl48 = bl25 = n13 == this.myip;
                    if (bl25) {
                        n5 = 3;
                        this.counts = CORE.setBits(this.counts, 27, 24, CORE.getBits(this.counts, 27, 24) + 1);
                        bl5 |= !bl3;
                    }
                } else if (bl9 && !bl21) {
                    n5 = 6;
                    this.counts = CORE.setBits(this.counts, 30, 28, CORE.getBits(this.counts, 30, 28) + 1);
                }
                if (bl5) {
                    while (!stream.rok) {
                    }
                    n3 = stream.rdL();
                    n8 = n3 &= 0xFFFF;
                    if (bl3) {
                        stream2.wrL(0x1CEF0000 | n3);
                    }
                }
                if (n8 > 0 && !bl13) {
                    if (this.nc > 0) {
                        this.osel = this.osels[this.ic];
                    }
                    stream2.setC(this.osel);
                    this.dma.setFlags(n2);
                    this.dma.b2s(buffer, n6 + n7, stream2, 0, n8);
                    ++this.opkt;
                    if (bl21 && !bl24) {
                        if (n9 != this.nseq) {
                            this.counts = CORE.setBits(this.counts, 15, 12, CORE.getBits(this.counts, 15, 12) + 1);
                        }
                        this.nseq = n9 + 1;
                    }
                    CORE cORE = this;
                    cORE.dma.sync();
                }
                if (!bl5) {
                    while (!stream.rok) {
                    }
                    n3 = stream.rdL();
                    n3 &= 0xFFFF;
                }
                if (n5 > 0 && stream3.wok) {
                    this.dma.setFlags(0);
                    n4 = n3;
                    n10 = CORE.setBits(n10, 31, 20, 462);
                    n10 = CORE.setBits(n10, 19, 16, n5);
                    n10 = CORE.setBits(n10, 15, 0, n4);
                    stream3.wrL(n10);
                    n10 = CORE.bswap4(this.myip);
                    stream3.wrL(n10);
                    this.dma.b2s(buffer, 0, stream3, 0, n4);
                    System.out.printf("Got restyp=%d reslen=%d\n", n5, n4);
                    CORE cORE = this;
                    cORE.dma.sync();
                }
                buffer.rnxt(n3);
            }
            this.opkt = this.opkt;
            this.counts = this.counts;
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(4);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(4);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(4);
        }
    }
}

