/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Modefs;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreLibrary;

public class Modems
extends CoreLibrary
implements Modefs {
    public static final byte[] mapTCM = new byte[]{0, 2, 3, 1, 4, 6, 7, 5};

    public static int getModID(String string) {
        int n = Modems.findListItem("NONE,CW,AM,FM,FSK,4FSK,BPSK,QPSK,OQPSK,1P4QPSK,3P4QPSK,1P4DQPSK,8PSK,16PSK,16APSK,32APSK,64APSK,128APSK,256APSK,16CQAM,64CQAM,128CQAM,256CQAM,8QAM,16QAM,32QAM,64QAM,128QAM,256QAM,512QAM,1024QAM", string, -2);
        if (n < 0) {
            System.out.printf("Unknown MOD type=%s\n", string);
        }
        return n;
    }

    public static int getFecID(String string) {
        int n = Modems.findListItem("NONE,REP1,REP2,REP3,HAM74,HAM84,HAM128,GLY2412,SD2216,SD3932,SD7264,V27,V27P12,V27P23,V27P34,V27P45,V27P56,V27P67,V27P78,V29,V29P12,V29P23,V29P34,V29P45,V29P56,V29P67,V29P78,V39,V615,TCM,TCM23,DTCM23", string, -2);
        if (n < 0) {
            System.out.printf("Unknown FEC type=%s\n", string);
        }
        return n;
    }

    public static int getMapID(String string) {
        int n = Modems.findListItem("LINEAR,BRGC,BRGCIB,BRGCIX,BRGCIY,BRGCIXY,BRGCNT,BRGCBE", string, -2);
        if (n < 0) {
            System.out.printf("Unknown MAP type=%s\n", string);
        }
        return n;
    }

    public static int getBitsPerSym(int n) {
        int n2;
        switch (n) {
            case 30: {
                n2 = 10;
                break;
            }
            case 29: {
                n2 = 9;
                break;
            }
            case 18: 
            case 22: 
            case 28: {
                n2 = 8;
                break;
            }
            case 17: 
            case 21: 
            case 27: {
                n2 = 7;
                break;
            }
            case 16: 
            case 20: 
            case 26: {
                n2 = 6;
                break;
            }
            case 15: 
            case 25: {
                n2 = 5;
                break;
            }
            case 13: 
            case 14: 
            case 19: 
            case 24: {
                n2 = 4;
                break;
            }
            case 12: {
                n2 = 3;
                break;
            }
            case 23: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 1;
                break;
            }
            default: {
                n2 = 2;
            }
        }
        return n2;
    }

    public static int getGridSF(int n) {
        int n2 = Modems.getBitsPerSym(n);
        double d = Modems.sqrt(Modems.pow(2.0, Modems.i2d(n2)));
        return Modems.d2i(Modems.round(d / 2.0));
    }

    public static float getMinSNR(int n) {
        float f;
        switch (n) {
            case 30: {
                f = 40.0f;
                break;
            }
            case 29: {
                f = 36.0f;
                break;
            }
            case 18: 
            case 22: 
            case 28: {
                f = 30.0f;
                break;
            }
            case 17: 
            case 21: 
            case 27: {
                f = 20.0f;
                break;
            }
            case 16: 
            case 20: 
            case 26: {
                f = 15.0f;
                break;
            }
            case 15: 
            case 25: {
                f = 12.0f;
                break;
            }
            case 14: 
            case 19: 
            case 24: {
                f = 9.0f;
                break;
            }
            case 12: {
                f = 9.0f;
                break;
            }
            case 23: {
                f = 9.0f;
                break;
            }
            case 6: {
                f = 6.0f;
                break;
            }
            default: {
                f = 6.0f;
            }
        }
        return f;
    }

    public static float getMinCV(int n) {
        float f;
        switch (n) {
            case 4: {
                f = -9.0f;
                break;
            }
            case 5: {
                f = -12.0f;
                break;
            }
            case 12: {
                f = -10.0f;
                break;
            }
            case 2: {
                f = -9.0f;
                break;
            }
            case 3: {
                f = -9.0f;
                break;
            }
            case 8: {
                f = -6.0f;
                break;
            }
            case 7: {
                f = -9.0f;
                break;
            }
            default: {
                f = -20.0f;
            }
        }
        return f;
    }

    public static float getCFact(int n) {
        float f;
        switch (n) {
            case 22: {
                f = 0.001f;
                break;
            }
            case 27: {
                f = 0.002f;
                break;
            }
            case 16: {
                f = 0.05f;
                break;
            }
            case 25: {
                f = 0.001f;
                break;
            }
            case 6: {
                f = 0.1f;
                break;
            }
            default: {
                f = 0.01f;
            }
        }
        return f;
    }

    public static int bitRev(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if ((n2 >> i & 1) == 0) continue;
            n3 |= 1 << n - 1 - i;
        }
        return n3;
    }

    public static int getMap(int n, int n2, int n3) {
        int n4 = 1 << n2;
        int n5 = n4 / 2;
        int n6 = n3;
        if (n == 3 && n3 >= n5) {
            n3 = n4 - 1 - n3 + n5;
        }
        if (n >= 2) {
            n6 = n3 ^ n3 >> 1;
        }
        if (n == 7) {
            n6 = mapTCM[n3];
        }
        if (n == 8) {
            n6 = Modems.bitRev(n2, n6);
        }
        return n6;
    }

    public static int getMapXY(int n, int n2, int n3, int n4, int n5) {
        int n6 = n2 / 2;
        int n7 = 1 << n6;
        if (n == 4 || n == 6) {
            n3 = n7 - 1 - n3;
        }
        if (n == 5 || n == 6) {
            n4 = n7 - 1 - n4;
        }
        int n8 = n >= 2 ? n3 ^ n3 >> 1 : n3;
        int n9 = n >= 2 ? n4 ^ n4 >> 1 : n4;
        int n10 = n8 << n6 | n9;
        if ((n2 & 1) != 0) {
            n10 = n5;
        }
        if (n == 8) {
            n10 = Modems.bitRev(n2, n10);
        }
        return n10;
    }

    public static void fixCQ(int n, float f, int n2, int n3, int n4, float[] fArray, float[] fArray2) {
        float f2 = fArray[n4];
        float f3 = fArray2[n4];
        float f4 = Modems.sqrtf(f2 * f2 + f3 * f3);
        n2 = n2 < n ? n - 1 - n2 : n2 - n;
        n3 = n3 < n ? n - 1 - n3 : n3 - n;
        int n5 = Modems.imax(n2, n3);
        float f5 = n5 == 0 ? 0.8f : f * ((float)n5 + 0.5f) / f4;
        fArray[n4] = f2 * f5;
        fArray2[n4] = f3 * f5;
    }

    public static int getSymbolMap(int n, int n2, double d, double d2, int n3, float[] fArray, float[] fArray2) {
        float f = (float)d;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (n2 < 0) {
            n2 = 2;
        }
        if (n == 0) {
            n6 = 0;
        } else if (n <= 3) {
            n6 = n == 1 ? 10 : 1;
            float f2 = f * 0.707f;
            for (int i = 0; i < 1024; ++i) {
                double d3 = ((double)i + 0.5) / 1024.0;
                fArray[i] = f2 * Modems.coscf(d3);
                fArray2[i] = f2 * Modems.sincf(d3);
            }
        } else if (n == 4) {
            int n7;
            double d4;
            int n8;
            n6 = 1;
            float f3 = f * 0.707f;
            for (n8 = 0; n8 < n3 * 2; ++n8) {
                d4 = 0.5 * d2 * (double)n8 / (double)n3;
                n7 = 0 + (n8 << 4);
                fArray[n7] = f3 * Modems.coscf(d4);
                fArray2[n7] = f3 * Modems.sincf(d4);
            }
            for (n8 = 0; n8 < n3 * 2; ++n8) {
                d4 = -0.5 * d2 * (double)n8 / (double)n3;
                n7 = 1 + (n8 << 4);
                fArray[n7] = f3 * Modems.coscf(d4);
                fArray2[n7] = f3 * Modems.sincf(d4);
            }
        } else if (n == 5) {
            int n9;
            double d5;
            int n10;
            n6 = 2;
            float f4 = f * 0.707f;
            for (n10 = 0; n10 < n3 * 2; ++n10) {
                d5 = 0.5 * d2 * (double)n10 / (double)n3;
                n9 = 0 + (n10 << 4);
                fArray[n9] = f4 * Modems.coscf(d5);
                fArray2[n9] = f4 * Modems.sincf(d5);
            }
            for (n10 = 0; n10 < n3 * 2; ++n10) {
                d5 = -0.5 * d2 * (double)n10 / (double)n3;
                n9 = 1 + (n10 << 4);
                fArray[n9] = f4 * Modems.coscf(d5);
                fArray2[n9] = f4 * Modems.sincf(d5);
            }
            for (n10 = 0; n10 < n3 * 2; ++n10) {
                d5 = 1.5 * d2 * (double)n10 / (double)n3;
                n9 = 2 + (n10 << 4);
                fArray[n9] = f4 * Modems.coscf(d5);
                fArray2[n9] = f4 * Modems.sincf(d5);
            }
            for (n10 = 0; n10 < n3 * 2; ++n10) {
                d5 = -1.5 * d2 * (double)n10 / (double)n3;
                n9 = 3 + (n10 << 4);
                fArray[n9] = f4 * Modems.coscf(d5);
                fArray2[n9] = f4 * Modems.sincf(d5);
            }
        } else if (n == 6) {
            n6 = 1;
            float f5 = f * 0.707f;
            for (int i = 0; i < 2; ++i) {
                double d6 = ((double)i + 0.25) / 2.0;
                int n11 = Modems.getMap(n2, n6, i);
                fArray[n11] = f5 * Modems.coscf(d6);
                fArray2[n11] = f5 * Modems.sincf(d6);
            }
        } else if (n >= 7 && n <= 11) {
            n6 = 2;
            float f6 = f * 0.707f;
            for (int i = 0; i < 4; ++i) {
                double d7 = ((double)i + 0.5) / 4.0;
                int n12 = Modems.getMap(n2, n6, i);
                fArray[n12] = f6 * Modems.coscf(d7);
                fArray2[n12] = f6 * Modems.sincf(d7);
            }
        } else if (n == 12) {
            n6 = 3;
            float f7 = f * 0.707f;
            for (int i = 0; i < 8; ++i) {
                double d8 = ((double)i + 0.5) / 8.0;
                int n13 = Modems.getMap(n2, n6, i);
                fArray[n13] = f7 * Modems.coscf(d8);
                fArray2[n13] = f7 * Modems.sincf(d8);
            }
        } else if (n == 13) {
            n6 = 4;
            float f8 = f * 0.707f;
            for (int i = 0; i < 16; ++i) {
                double d9 = ((double)i + 0.5) / 16.0;
                int n14 = Modems.getMap(n2, n6, i);
                fArray[n14] = f8 * Modems.coscf(d9);
                fArray2[n14] = f8 * Modems.sincf(d9);
            }
        } else if (n == 14) {
            int n15;
            double d10;
            int n16;
            n6 = 4;
            float f9 = f * 0.75f;
            float f10 = f9 * 0.38910508f;
            for (n16 = 0; n16 < 4; ++n16) {
                d10 = ((double)n16 + 0.5) / 4.0;
                n15 = Modems.getMap(n2, n6, n16);
                fArray[n15] = f10 * Modems.coscf(d10);
                fArray2[n15] = f10 * Modems.sincf(d10);
            }
            for (n16 = 4; n16 < 16; ++n16) {
                d10 = ((double)n16 - 3.5) / 12.0;
                n15 = Modems.getMap(n2, n6, n16);
                fArray[n15] = f9 * Modems.coscf(d10);
                fArray2[n15] = f9 * Modems.sincf(d10);
            }
        } else if (n == 15) {
            int n17;
            double d11;
            int n18;
            n6 = 5;
            float f11 = f * 0.8333333f;
            float f12 = f11 * 0.58837205f;
            float f13 = f11 * 0.23255813f;
            for (n18 = 0; n18 < 4; ++n18) {
                d11 = ((double)n18 + 0.5) / 4.0;
                n17 = Modems.getMap(n2, n6, n18);
                fArray[n17] = f13 * Modems.coscf(d11);
                fArray2[n17] = f13 * Modems.sincf(d11);
            }
            for (n18 = 4; n18 < 16; ++n18) {
                d11 = ((double)n18 - 3.5) / 12.0;
                n17 = Modems.getMap(n2, n6, n18);
                fArray[n17] = f12 * Modems.coscf(d11);
                fArray2[n17] = f12 * Modems.sincf(d11);
            }
            for (n18 = 16; n18 < 32; ++n18) {
                d11 = ((double)n18 - 15.0) / 16.0;
                n17 = Modems.getMap(n2, n6, n18);
                fArray[n17] = f11 * Modems.coscf(d11);
                fArray2[n17] = f11 * Modems.sincf(d11);
            }
        } else if (n == 16) {
            int n19;
            double d12;
            int n20;
            n6 = 6;
            float f14 = f * 0.875f;
            float f15 = f14 * 0.75471693f;
            float f16 = f14 * 0.47735846f;
            float f17 = f14 * 0.18867923f;
            for (n20 = 0; n20 < 4; ++n20) {
                d12 = ((double)n20 + 0.5) / 4.0;
                n19 = Modems.getMap(n2, n6, n20);
                fArray[n19] = f17 * Modems.coscf(d12);
                fArray2[n19] = f17 * Modems.sincf(d12);
            }
            for (n20 = 4; n20 < 16; ++n20) {
                d12 = ((double)n20 - 3.5) / 12.0;
                n19 = Modems.getMap(n2, n6, n20);
                fArray[n19] = f16 * Modems.coscf(d12);
                fArray2[n19] = f16 * Modems.sincf(d12);
            }
            for (n20 = 16; n20 < 36; ++n20) {
                d12 = ((double)n20 - 15.5) / 20.0;
                n19 = Modems.getMap(n2, n6, n20);
                fArray[n19] = f15 * Modems.coscf(d12);
                fArray2[n19] = f15 * Modems.sincf(d12);
            }
            for (n20 = 36; n20 < 64; ++n20) {
                d12 = ((double)n20 - 35.5) / 28.0;
                n19 = Modems.getMap(n2, n6, n20);
                fArray[n19] = f14 * Modems.coscf(d12);
                fArray2[n19] = f14 * Modems.sincf(d12);
            }
        } else if (n == 17) {
            int n21;
            double d13;
            int n22;
            n6 = 7;
            float f18 = f * 0.9f;
            float f19 = f * 0.7f;
            float f20 = f * 0.5f;
            float f21 = f * 0.3f;
            float f22 = f18 * 0.14f;
            for (n22 = 0; n22 < 4; ++n22) {
                d13 = ((double)n22 + 0.5) / 4.0;
                n21 = Modems.getMap(n2, n6, n22);
                fArray[n21] = f22 * Modems.coscf(d13);
                fArray2[n21] = f22 * Modems.sincf(d13);
            }
            for (n22 = 4; n22 < 16; ++n22) {
                d13 = ((double)n22 - 3.5) / 12.0;
                n21 = Modems.getMap(n2, n6, n22);
                fArray[n21] = f21 * Modems.coscf(d13);
                fArray2[n21] = f21 * Modems.sincf(d13);
            }
            for (n22 = 16; n22 < 36; ++n22) {
                d13 = ((double)n22 - 15.5) / 20.0;
                n21 = Modems.getMap(n2, n6, n22);
                fArray[n21] = f20 * Modems.coscf(d13);
                fArray2[n21] = f20 * Modems.sincf(d13);
            }
            for (n22 = 36; n22 < 64; ++n22) {
                d13 = ((double)n22 - 35.5) / 28.0;
                n21 = Modems.getMap(n2, n6, n22);
                fArray[n21] = f19 * Modems.coscf(d13);
                fArray2[n21] = f19 * Modems.sincf(d13);
            }
            for (n22 = 64; n22 < 128; ++n22) {
                d13 = ((double)n22 - 63.5) / 64.0;
                n21 = Modems.getMap(n2, n6, n22);
                fArray[n21] = f18 * Modems.coscf(d13);
                fArray2[n21] = f18 * Modems.sincf(d13);
            }
        } else if (n == 23) {
            int n23;
            double d14;
            int n24;
            n6 = 3;
            float f23 = f * 0.7392f;
            float f24 = 0.3072f;
            for (n24 = 0; n24 < 4; ++n24) {
                d14 = ((double)n24 + 0.5) / 4.0;
                n23 = Modems.getMap(n2, n6, n24);
                fArray[n23] = f24 * Modems.coscf(d14);
                fArray2[n23] = f24 * Modems.sincf(d14);
            }
            for (n24 = 4; n24 < 8; ++n24) {
                d14 = ((double)n24 - 3.5) / 4.0;
                n23 = Modems.getMap(n2, n6, n24);
                fArray[n23] = f23 * Modems.coscf(d14);
                fArray2[n23] = f23 * Modems.sincf(d14);
            }
        } else {
            int n25 = 0;
            switch (n) {
                case 24: {
                    n6 = 4;
                    n5 = 4;
                    break;
                }
                case 19: {
                    n6 = 4;
                    n5 = 4;
                    n25 = 2;
                    break;
                }
                case 25: {
                    n6 = 5;
                    n5 = 6;
                    break;
                }
                case 26: {
                    n6 = 6;
                    n5 = 8;
                    break;
                }
                case 20: {
                    n6 = 6;
                    n5 = 8;
                    n25 = 4;
                    break;
                }
                case 27: {
                    n6 = 7;
                    n5 = 12;
                    break;
                }
                case 28: {
                    n6 = 8;
                    n5 = 16;
                    break;
                }
                case 22: {
                    n6 = 8;
                    n5 = 16;
                    n25 = 8;
                    break;
                }
                case 29: {
                    n6 = 9;
                    n5 = 24;
                    break;
                }
                case 30: {
                    n6 = 10;
                    n5 = 32;
                }
            }
            float f25 = 2.0f * f / (float)n5;
            float f26 = -f + f25 / 2.0f;
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n5; ++j) {
                    if (!((n != 25 || i >= 1 && i <= 4 || j >= 1 && j <= 4) && (n != 27 || i >= 2 && i <= 9 || j >= 2 && j <= 9) && (n != 29 || i >= 4 && i <= 19 || j >= 4 && j <= 19))) continue;
                    int n26 = Modems.getMapXY(n2, n6, i, j, n4);
                    fArray[n26] = f26 + (float)i * f25;
                    fArray2[n26] = f26 + (float)j * f25;
                    if (n25 > 0) {
                        Modems.fixCQ(n25, f25, i, j, n26, fArray, fArray2);
                    }
                    ++n4;
                }
            }
        }
        return 1 << n6;
    }

    public static int getRings(int n, int n2, float[] fArray, float[] fArray2, float[] fArray3) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4;
            float f = Modems.sqrtf(fArray[i] * fArray[i] + fArray2[i] * fArray2[i]);
            for (n4 = 0; n4 < n3 && !((double)Modems.fabsf(f - fArray3[n4]) < 0.001); ++n4) {
            }
            if (n4 != n3) continue;
            for (int j = n3; j > 0 && !(f > fArray3[j - 1]); --j) {
                fArray3[j] = fArray3[j - 1];
            }
            fArray3[j] = f;
            ++n3;
        }
        if (n == 22) {
            for (n3 = 0; n3 < 5; ++n3) {
                fArray3[n3] = fArray3[n3 + 3];
            }
        }
        return n3;
    }

    public static float getAMDes(int n, int n2, float[] fArray, float[] fArray2) {
        float f = 0.0f;
        for (int i = 0; i < n2; ++i) {
            f += fArray[i] * fArray[i] + fArray2[i] * fArray2[i];
        }
        float f2 = Modems.sqrtf(f / (float)n2) * 0.9f;
        return f2;
    }

    public static int diff(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            int n5 = n3;
            n3 = n2 >> i & 1;
            int n6 = n5 ^ n3;
            n4 |= n6 << i;
        }
        return n4;
    }

    public static int genLUT(int n, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int[] nArray, int[] nArray2) {
        int n8;
        int n9;
        int n10 = 9;
        boolean bl2 = n7 == 7;
        int n11 = n == 0 ? 1 << n4 : 1 << n;
        int n12 = n == 1 ? 0 : n11 - 1;
        int n13 = n6 - 1;
        if (n13 < 0) {
            n13 = 0;
        }
        if (nArray != null) {
            for (int i = 0; i < n11; ++i) {
                int n14 = bl ? Modems.diff(n, i) : i;
                int n15 = Modems.ones(n14 & n2, n) & 1;
                int n16 = Modems.ones(n14 & n3, n) & 1;
                int n17 = i % 2 == 1 ? (1 << n5) - 1 : 0;
                int n18 = 0x100 | n15;
                int n19 = 0x100 | n16;
                int n20 = n16 << 1 | n15;
                int n21 = n15 << 1 | n16;
                if (bl2) {
                    for (n9 = 0; n9 < 8; ++n9) {
                        n14 = n15 != 0 ? n9 & 5 : n9 & 3;
                        int n22 = Modems.ones(n14, 3) & 1;
                        nArray[n9 << n10 | i] = n22 << 2 | n15 << 1 | n16;
                    }
                    continue;
                }
                for (n9 = 0; n9 < n6; ++n9) {
                    n8 = n7 >> 4 * n9 & 0xF;
                    nArray[n9 << n10 | i] = (short)(n == 0 ? i & n12 : (n8 == 0 ? n17 : (n8 == 1 ? n18 : (n8 == 2 ? n19 : (n8 == 3 ? n20 : (n8 == 4 ? n21 : n17))))));
                }
            }
        }
        if (nArray2 != null) {
            for (n9 = 0; n9 < n6; ++n9) {
                n8 = n7 >> 4 * n9 & 0xF;
                nArray2[n9] = n8 == 2 ? 9 : (n8 == 1 ? 10 : 0);
            }
        }
        return n13 << 28 | n12 << 16 | n5 << 8 | n4;
    }

    public static int getFECLUT(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = 0;
        boolean bl = n2 != 0;
        switch (n) {
            case 0: {
                n3 = Modems.genLUT(0, 0, 0, false, 1, 1, 1, bl ? n2 : 0, nArray, nArray2);
                break;
            }
            case 1: {
                n3 = Modems.genLUT(1, 1, 0, false, 1, 1, 1, bl ? n2 : 0, nArray, nArray2);
                break;
            }
            case 2: {
                n3 = Modems.genLUT(1, 1, 0, false, 1, 2, 1, bl ? n2 : 0, nArray, nArray2);
                break;
            }
            case 3: {
                n3 = Modems.genLUT(1, 1, 0, false, 1, 3, 1, bl ? n2 : 0, nArray, nArray2);
                break;
            }
            case 11: 
            case 12: {
                n3 = Modems.genLUT(7, 109, 79, false, 1, 2, 1, bl ? n2 : 3, nArray, nArray2);
                break;
            }
            case 13: {
                n3 = Modems.genLUT(7, 109, 79, false, 1, 2, 2, bl ? n2 : 19, nArray, nArray2);
                break;
            }
            case 14: {
                n3 = Modems.genLUT(7, 109, 79, false, 1, 2, 3, bl ? n2 : 531, nArray, nArray2);
                break;
            }
            case 15: {
                n3 = Modems.genLUT(7, 109, 79, false, 1, 2, 4, bl ? n2 : 4371, nArray, nArray2);
                break;
            }
            case 16: {
                n3 = Modems.genLUT(7, 109, 79, false, 1, 2, 5, bl ? n2 : 135699, nArray, nArray2);
                break;
            }
            case 17: {
                n3 = Modems.genLUT(7, 109, 79, false, 1, 2, 6, bl ? n2 : 0x212113, nArray, nArray2);
                break;
            }
            case 18: {
                n3 = Modems.genLUT(7, 109, 79, false, 1, 2, 7, bl ? n2 : 0x2121113, nArray, nArray2);
                break;
            }
            case 19: 
            case 20: {
                n3 = Modems.genLUT(9, 431, 285, false, 1, 2, 1, bl ? n2 : 3, nArray, nArray2);
                break;
            }
            case 21: {
                n3 = Modems.genLUT(9, 431, 285, false, 1, 2, 2, bl ? n2 : 19, nArray, nArray2);
                break;
            }
            case 22: {
                n3 = Modems.genLUT(9, 431, 285, false, 1, 2, 3, bl ? n2 : 275, nArray, nArray2);
                break;
            }
            case 23: {
                n3 = Modems.genLUT(9, 431, 285, false, 1, 2, 4, bl ? n2 : 4627, nArray, nArray2);
                break;
            }
            case 24: {
                n3 = Modems.genLUT(9, 431, 285, false, 1, 2, 5, bl ? n2 : 135459, nArray, nArray2);
                break;
            }
            case 25: {
                n3 = Modems.genLUT(9, 431, 285, false, 1, 2, 6, bl ? n2 : 0x211213, nArray, nArray2);
                break;
            }
            case 26: {
                n3 = Modems.genLUT(9, 431, 285, false, 1, 2, 7, bl ? n2 : 0x1121213, nArray, nArray2);
                break;
            }
            case 29: 
            case 30: {
                n3 = Modems.genLUT(7, 109, 79, false, 2, 3, 1, bl ? n2 : 7, nArray, nArray2);
                break;
            }
            case 31: {
                n3 = Modems.genLUT(7, 109, 79, true, 2, 3, 1, bl ? n2 : 7, nArray, nArray2);
                break;
            }
            default: {
                n3 = Modems.genLUT(0, 0, 0, false, 1, 1, 1, bl ? n2 : 0, nArray, nArray2);
                System.out.printf("Unhandled FEC algorithm index=%d \n", n);
            }
        }
        return n3;
    }

    public static int getFrameSize(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8 = Modems.getBitsPerSym(n);
        int n9 = Modems.getFECLUT(n2, 0, null, null);
        int n10 = n9 >> 0 & 0xFF;
        int n11 = n9 >> 8 & 0xFF;
        int n12 = n9 >> 16 & 0xFFF;
        int n13 = n9 >> 28 & 0xF;
        int n14 = n10 * ++n13;
        int n15 = n11 + (n13 - 1) * (n11 - 1);
        for (n7 = n4; n7 > 30 && ((n6 = n7 * n8) % n15 != 0 || (n5 = n6 / n15 * n14) % n3 != 0); --n7) {
        }
        if (n7 != n4) {
            System.out.printf("RFP Frame: ask=%d use=%d\n", n4, n7);
        }
        if (n7 < 32) {
            System.out.printf("Problem finding frame size for bps=%d word=%d feci=%d feco=%d punc=%d\n", n8, n3, n10, n11, n13);
        }
        return n11 << 28 | n10 << 24 | n13 << 20 | n8 << 16 | n7;
    }

    public static int getFrameFor(String string, String string2, int n, int n2) {
        return Modems.getFrameSize(Modems.getModID(string), Modems.getFecID(string2), n, n2);
    }

    public static int getFrameAWG(int n) {
        int n2 = n >> 0 & 0xFFFF;
        return n2;
    }

    public static double getFECratio(int n) {
        int n2 = Modems.getFECLUT(n, 0, null, null);
        int n3 = n2 >> 0 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 >> 16 & 0xFFF;
        int n6 = n2 >> 28 & 0xF;
        int n7 = n3 * ++n6;
        int n8 = n4 + (n6 - 1) * (n4 - 1);
        return Modems.i2d(n8 * n3) / (double)n7;
    }

    public static int getFrameFEC(int n) {
        int n2 = n >> 0 & 0xFFFF;
        int n3 = n >> 16 & 0xF;
        int n4 = n >> 20 & 0xF;
        int n5 = n >> 24 & 0xF;
        int n6 = n >> 28 & 0xF;
        int n7 = n5 * n4;
        int n8 = n6 + (n4 - 1) * (n6 - 1);
        return n2 * n3 / n8 * n7 / n5;
    }

    public static class IFEC
    extends CoreComponent {
        int MO;
        int MP;
        int OLUT;
        int NLUT;
        public int alg;
        public int upp;
        public double ratio;
        int ilen;
        int olen;
        int ibit;
        int slen;
        int obit;
        int serr;
        int ipunc;
        int jpunc;
        int mpunc;
        int mask;
        int shft;
        int rluts;
        int vluts;
        int[] rlut;
        int[] pflgs;
        int vflg;
        int sdb;
        long ivec;
        int ovec;
        boolean iby3;
        boolean oby2;
        boolean frm1;
        boolean frm2;
        int uv;
        CoreComponent.Viterbi vit;
        public static final String handleAuto = "sets,process=iix1,processReframe=x1,processRepunc=x0";
        public static final String handleMethod_process = "$process_ena=T,$hsym=%1,$hbits=%2,x=1,%0=$process_ret";
        public static final String handleMethod_processReframe = "$processReframe_ena=T,x=1";
        public static final String handleMethod_processRepunc = "$processRepunc_ena=T,x=0";
        public static final String handleArgs = "sets,i:process_ena,i:uint32:hsym,i:uint5:hbits,o:uint32:process_ret,i:processReframe_ena,i:processRepunc_ena";

        public IFEC(int n) {
            this.MO = n;
            this.MP = this.MO + 3;
            this.OLUT = this.MP + 2;
            this.NLUT = 1 << this.OLUT;
            this.pflgs = new int[8];
            this.rlut = new int[this.NLUT];
            this.vit = new CoreComponent.Viterbi();
        }

        public void formLUT() {
            int[] nArray = new int[this.NLUT];
            int n = Modems.getFECLUT(this.alg, this.upp, nArray, this.pflgs);
            this.olen = n >> 0 & 0xFF;
            this.ilen = n >> 8 & 0xFF;
            this.mask = n >> 16 & 0xFFF;
            this.mpunc = n >> 28 & 0xF;
            if (!IFEC.getBit(this.vflg, 7)) {
                this.rlut = new int[8];
                return;
            }
            int n2 = this.ilen >= 3 ? 8 : (this.ilen == 2 ? 4 : 2);
            for (int i = 0; i < 1 << this.MO; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n3;
                    int n4 = (j ^ nArray[i << 1 & this.mask | 0]) & 3;
                    int n5 = (j ^ nArray[i << 1 & this.mask | 1]) & 3;
                    int n6 = 0;
                    if (this.alg >= 29) {
                        int n7;
                        int n8 = n7 = n5 < n4 ? 1 : 0;
                        if (n4 != 0 && n5 != 0) {
                            ++n6;
                        }
                        int n9 = (j & 2) != 0 ? 1 : 0;
                        int n10 = (j & 4) != 0 ? 1 : 0;
                        for (int k = 0; k < 4; ++k) {
                            int n11 = (k & 1) != 0 ? 1 : 0;
                            int n12 = (k & 2) != 0 ? 1 : 0;
                            n3 = n7 << 1 | (n9 != 0 ? n10 ^ n12 : n10 ^ n11);
                            this.rlut[k << this.MP | j << this.MO | i] = n6 << 3 | n9 << 2 | n3;
                        }
                        continue;
                    }
                    int n13 = n3 = n5 < n4 ? 1 : 0;
                    if (n4 != 0 && n5 != 0) {
                        ++n6;
                    }
                    if (n4 == 0) {
                        this.rlut[1 << this.MP | (j >> 1 & 1) << this.MO | i] = n3;
                    }
                    if (n5 == 0) {
                        this.rlut[1 << this.MP | (j >> 1 & 1) << this.MO | i] = n3;
                    }
                    if (n4 == 0) {
                        this.rlut[2 << this.MP | (j >> 0 & 1) << this.MO | i] = n3;
                    }
                    if (n5 == 0) {
                        this.rlut[2 << this.MP | (j >> 0 & 1) << this.MO | i] = n3;
                    }
                    this.rlut[0 << this.MP | j << this.MO | i] = n6 << 3 | n3;
                }
            }
        }

        public void open(int n, int n2, int n3) {
            this.alg = n;
            this.upp = n2;
            this.vflg = n3;
            this.formLUT();
            this.iby3 = this.ilen == 3;
            this.oby2 = this.olen == 2;
            this.ibit = 0;
            this.obit = 0;
            this.serr = 0;
            this.sdb = IFEC.getBit(this.vflg, 1) ? 4 : (IFEC.getBit(this.vflg, 0) ? 3 : 1);
            this.slen = this.ilen * this.sdb;
        }

        public double getRatio() {
            return Modems.getFECratio(this.alg);
        }

        public void processReframe() {
            if (IFEC.getBit(this.vflg, 5)) {
                this.frm1 = this.ibit == this.sdb;
                boolean bl = this.frm2 = !this.frm1;
            }
            if (this.frm2) {
                this.shft = 0;
            }
        }

        public void processRepunc() {
            this.ipunc = this.ipunc >= this.mpunc ? 0 : this.ipunc + 1;
            int n = this.jpunc = this.jpunc >= this.mpunc ? 0 : this.jpunc + 1;
            if (this.jpunc == 0 && !IFEC.getBit(this.vflg, 2)) {
                ++this.ibit;
            }
        }

        public int process(int n, int n2) {
            boolean bl = IFEC.getBit(this.vflg, 0);
            boolean bl2 = IFEC.getBit(this.vflg, 1);
            boolean bl3 = IFEC.getBit(this.vflg, 2);
            boolean bl4 = IFEC.getBit(this.vflg, 3);
            boolean bl5 = IFEC.getBit(this.vflg, 4);
            boolean bl6 = IFEC.getBit(this.vflg, 5);
            boolean bl7 = IFEC.getBit(this.vflg, 6);
            boolean bl8 = IFEC.getBit(this.vflg, 7);
            this.ivec = n << this.ibit | IFEC.getBits(this.ivec, 7, 0);
            this.ibit += n2;
            this.obit = 0;
            boolean bl9 = true;
            while (this.ibit >= this.slen) {
                int n3;
                int n4;
                int n5 = this.pflgs[this.ipunc];
                int n6 = n4 = bl3 ? this.uv : IFEC.getBits(n5, 1, 0);
                int n7 = this.iby3 ? (bl2 ? 12 : (bl ? 9 : 3)) : (IFEC.getBit(n5, 3) ? (bl2 ? 4 : (bl ? 3 : 1)) : (bl2 ? 8 : (bl ? 6 : 2)));
                int n8 = this.ipunc = this.ipunc >= this.mpunc ? 0 : this.ipunc + 1;
                int n9 = this.iby3 ? IFEC.getBits(this.ivec, 2, 0) : (n3 = !IFEC.getBit(n5, 3) ? IFEC.getBits(this.ivec, 1, 0) : IFEC.getBits(this.ivec, 0, 0));
                if (bl7) {
                    this.vluts = this.vit.process(IFEC.getBits(this.ivec, 11, 0), n5, this.vflg);
                } else {
                    boolean bl10;
                    boolean bl11 = bl10 = bl5 && IFEC.getBit(this.rluts, 3);
                    int n10 = bl10 ? 0 : (this.frm2 ? 0 : (bl3 ? IFEC.getBits(this.rluts, 1, 1) : IFEC.getBits(this.rluts, 0, 0))) | this.shft << 1;
                    int n11 = n4 << this.MP | n3 << this.MO | n10 & this.mask;
                    this.rluts = this.rlut[n11];
                    this.shft = this.frm1 ? 0 : n10;
                    this.uv = IFEC.getBit(this.rluts, 2) ? this.uv & 1 | IFEC.getBits(this.rluts, 0, 0) << 1 : this.uv & 2 | IFEC.getBits(this.rluts, 0, 0);
                }
                int n12 = bl7 ? this.vluts : this.rluts;
                boolean bl12 = bl7 ? IFEC.getBit(this.vluts, 2) : true;
                int n13 = bl12 ? IFEC.getBits(n12, 1, 0) : 0;
                int n14 = bl12 ? IFEC.getBits(n12, 3, 3) : 0;
                int n15 = bl12 ? this.olen : 0;
                this.serr = bl9 ? n14 : this.serr + n14;
                this.ovec = bl9 ? n13 : this.ovec | n13 << this.obit;
                this.obit = bl9 ? n15 : this.obit + n15;
                this.ivec >>= n7;
                this.ibit -= n7;
                bl9 = false;
                this.frm2 = this.frm1;
                this.frm1 = false;
            }
            return this.serr << 24 | this.obit << 16 | this.ovec;
        }
    }
}

