/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class MFPP
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int BW = 32;
    public static final int OHIT = 8;
    public static final int MHIT = 256;
    public static final int OTOP = 8;
    public static final int MTOP = 256;
    public static final int OWIN = 6;
    public static final int MWIN = 64;
    public static final int OFFT = 14;
    public static final int MFFT = 16384;
    public static final int PIPE = 1;

    public static class CORE
    extends Core {
        public static final String flgList = "Bypass,Strip,Tag,Log,Peak,Sort,Diff,HiThresh";
        public static final int F_BYPASS = 0;
        public static final int F_STRIP = 1;
        public static final int F_TAG = 2;
        public static final int F_LOG = 3;
        public static final int F_PEAK = 4;
        public static final int F_SORT = 5;
        public static final int F_DIFF = 6;
        public static final int F_HITHRESH = 7;
        float thresh;
        int frame;
        float vthresh;
        int mframe;
        int nwin;
        int ntop;
        float tmin;
        int flags;
        int itop;
        int count;
        boolean cntovr;
        boolean isUp;
        int iup;
        float vtot;
        float vhit;
        float vnf;
        CoreComponent.StatBuf sbuf;
        int[] hiti;
        float[] hitv;
        int edgeL;
        int edgeR;

        public int addToSort(int n, float f, int n2) {
            for (int i = n; i >= 0; --i) {
                boolean bl;
                boolean bl2 = i == n || f > this.hitv[i];
                boolean bl3 = bl = i > 0 && f > this.hitv[i - 1];
                if (bl) {
                    this.hiti[i] = this.hiti[i - 1];
                    this.hitv[i] = this.hitv[i - 1];
                    continue;
                }
                if (!bl2) continue;
                this.hiti[i] = n2;
                this.hitv[i] = f;
            }
            if (n < this.ntop) {
                ++n;
            }
            return n;
        }

        @Override
        public int init() {
            this.thresh = 2.0f;
            this.frame = 256;
            this.ntop = 64;
            this.tmin = 0.0f;
            return 0;
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "L:FRAME")) {
                this.frame = value.toL();
            } else if (this.isMatch(string, "L:WIDTH")) {
                this.nwin = value.toL();
            } else if (this.isMatch(string, "L:NTOP")) {
                this.ntop = value.toL();
            } else if (this.isMatch(string, "F:THRESH")) {
                this.thresh = value.toF();
            } else if (this.isMatch(string, "F:TMIN")) {
                this.tmin = value.toF();
            } else if (this.isMatch(string, "S:FLAGS")) {
                this.flags = value.toMask(flgList);
            } else {
                return super.set(string, value);
            }
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "L:FRAME")) {
                value.fromL(this.frame);
            } else if (this.isMatch(string, "L:WIDTH")) {
                value.fromL(this.nwin);
            } else {
                return super.get(string, value);
            }
            return 0;
        }

        @Override
        public int open() {
            if (this.nwin > 64) {
                System.out.printf("Sliding window width=%d limited to max=%d\n", this.nwin, 64);
                this.nwin = 64;
            }
            if (this.ntop > 256) {
                System.out.printf("Number peaks=%d limited to max=%d\n", this.ntop, 256);
                this.ntop = 256;
            }
            this.sbuf = new CoreComponent.StatBuf(6);
            this.sbuf.setLength(this.nwin);
            this.hiti = new int[256];
            this.hitv = new float[256];
            this.cntovr = false;
            if (this.ntop == 0) {
                this.flags |= 0;
            }
            this.vthresh = 1.0f / this.thresh;
            this.count = 0;
            this.mframe = this.frame - 1;
            this.itop = 0;
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("MFPP frame=%d ntop=%d flags=%x\n", this.frame, this.ntop, this.flags);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream stream, CoreComponent.Stream stream2) {
            boolean bl = CORE.getBit(this.flags, 0);
            boolean bl2 = CORE.getBit(this.flags, 1);
            boolean bl3 = CORE.getBit(this.flags, 2);
            boolean bl4 = CORE.getBit(this.flags, 3);
            boolean bl5 = CORE.getBit(this.flags, 4);
            boolean bl6 = CORE.getBit(this.flags, 5);
            boolean bl7 = CORE.getBit(this.flags, 6);
            boolean bl8 = CORE.getBit(this.flags, 7);
            while (stream.rok && stream2.wok && !this.cntovr) {
                boolean bl9;
                boolean bl10 = this.count >= this.nwin && this.edgeR == 0;
                this.cntovr = this.count >= this.mframe;
                int n = this.count - (this.nwin >> 1);
                this.count = bl || this.count >= this.mframe ? 0 : this.count + 1;
                float f = stream.rdF();
                if (!bl2) {
                    stream2.wrL(CORE.fp2i(f));
                }
                this.sbuf.load(f);
                float f2 = this.sbuf.getMid();
                float f3 = this.sbuf.getMinM(bl5 ? 0 : -1);
                float f4 = this.sbuf.getMaxM(1);
                float f5 = bl7 ? f2 - f3 : f2 - this.vnf;
                float f6 = CORE.mulff(f2, this.vthresh);
                float f7 = bl4 ? f2 - this.thresh : f6;
                boolean bl11 = bl10 && f7 > f3;
                boolean bl12 = this.cntovr || f2 < this.vhit;
                boolean bl13 = bl9 = bl8 && f4 - f2 > this.thresh;
                if (this.isUp && bl12) {
                    this.edgeR = this.sbuf.getMinI(1);
                    int n2 = CORE.imin(this.edgeL, this.edgeR);
                    int n3 = n + n2 << 16 | this.iup - n2;
                    if (!(this.vtot < this.tmin)) {
                        if (bl6) {
                            this.itop = this.addToSort(this.itop, this.vtot, n3);
                        } else if (this.itop < this.ntop) {
                            this.hiti[this.itop] = n3;
                            this.hitv[this.itop] = this.vtot;
                            ++this.itop;
                        }
                    }
                    this.isUp = false;
                    this.vtot = 0.0f;
                    continue;
                }
                if (this.isUp ? bl9 : bl11) {
                    this.iup = n;
                    this.vtot = f5;
                    this.vhit = f2;
                    if (!this.isUp) {
                        this.vnf = f3;
                    }
                    this.edgeL = this.sbuf.getMinI(-1);
                    this.isUp = true;
                    continue;
                }
                if (this.isUp) {
                    if (!bl5) {
                        this.vtot += f5;
                        continue;
                    }
                    if (!(f5 > this.vtot)) continue;
                    this.vtot = f5;
                    continue;
                }
                if (this.edgeR <= 0) continue;
                --this.edgeR;
            }
            while (stream2.wok && this.cntovr) {
                this.cntovr = this.count < this.ntop;
                boolean bl14 = this.count < this.itop;
                boolean bl15 = this.count == this.ntop;
                int n = this.hiti[this.count];
                float f = this.hitv[this.count];
                int n4 = this.count = this.count >= this.ntop ? 0 : this.count + 1;
                if (!bl15 || bl3) {
                    int n5;
                    int n6 = bl15 ? this.itop : (n5 = bl14 ? n : 0);
                    float f8 = bl15 ? this.vtot : (bl14 ? f : 0.0f);
                    stream2.wrL(n5);
                    stream2.wrL(CORE.fp2i(f8));
                    this.vtot += f;
                }
                if (!bl15) continue;
                this.itop = 0;
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

