/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;

public class timelinetester
extends Primitive {
    private DataFile inFile;
    private DataFile outFile;
    private Data data;
    private boolean rt;
    private int wrap;
    private double tdelta;
    private Time tcurrent;
    private Time tnext;
    private double jitter;
    private int count;
    private int timeFreq;

    @Override
    public int open() {
        this.inFile = this.MA.getDataFile("IN");
        this.inFile.open();
        this.outFile = this.MA.getDataFile("OUT", this.inFile, 0);
        this.outFile.setDefaultQualifier("TYPE", this.inFile.getType());
        this.outFile.open();
        this.xfer = this.outFile.getType() % 1000 == 1 ? Math.max(1, (int)((double)this.bufSize / this.inFile.dbpe)) : 1;
        this.xfer = this.MA.getL("/TL", this.xfer);
        this.data = this.inFile.getDataBuffer(this.xfer);
        this.wrap = this.MA.getL("/WRAP", 0);
        this.rt = this.MA.getState("/RT");
        this.tcurrent = new Time(this.MA.getD("TSTART", this.outFile.getStart()));
        this.tdelta = this.MA.getD("TDELTA", this.outFile.getDelta());
        this.jitter = this.MA.getD("JITTER", 0.0);
        this.count = this.timeFreq = this.MA.getL("TFREQ", 1);
        this.tnext = new Time();
        if (!this.MA.isPresent("/TLT") && this.outFile.getTimeLineTolerance() > 0.09) {
            this.outFile.setTimeLineTolerance(1.0E-6);
        }
        return 0;
    }

    @Override
    public int process() {
        int status = 0;
        Time time = Time.currentTime();
        if (this.rt && this.tnext.diff(time) > 0.0) {
            status = -1;
        } else {
            int n = this.inFile.read(this.data);
            if (n > 0) {
                if (this.count == this.timeFreq) {
                    this.data.setHeader(new Time(this.tcurrent));
                    this.count = 0;
                }
                ++this.count;
                this.outFile.write(this.data, n);
                double dt = this.tdelta;
                if (this.jitter != 0.0) {
                    dt = this.tdelta + (Math.random() * 2.0 - 1.0) * this.jitter;
                }
                this.tcurrent.addSec(dt * (double)this.xfer);
                this.tnext = Time.add(time, dt * (double)this.xfer);
            } else if (n == 0) {
                status = -1;
            } else if (this.wrap > 0 && (this.inFile.isFile() || this.inFile.isJarFile())) {
                this.inFile.seek(0.0);
                --this.wrap;
            } else {
                status = 9;
            }
        }
        return status;
    }

    @Override
    public int close() {
        if (this.inFile != null) {
            this.inFile.close();
        }
        if (this.outFile != null) {
            this.outFile.close();
        }
        return 0;
    }
}

