/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Position;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Vector3D;

@InternalUseOnly
public class Orbit {
    private Orbit() {
    }

    @InternalUseOnly
    public static void create5000Orbit(String fileName, Data viewer, Data target, Data rotateAbout, double angle, int numberPositions) {
        Position viewerPos = Position.fromAltLatLon(new double[]{viewer.getD(0), viewer.getD(1), viewer.getD(2)});
        Position targetPos = Position.fromAltLatLon(new double[]{target.getD(0), target.getD(1), target.getD(2)});
        Position rotateAboutPos = Position.fromAltLatLon(new double[]{rotateAbout.getD(0), rotateAbout.getD(1), rotateAbout.getD(2)});
        Orbit.create5000Orbit(fileName, viewerPos, targetPos, rotateAboutPos, angle, numberPositions);
    }

    @InternalUseOnly
    public static void create5000Orbit(String fileName, double[] viewer, double[] target, double[] rotateAbout, double angle, int numberPositions) {
        Position viewerPos = Position.fromAltLatLon(viewer);
        Position targetPos = Position.fromAltLatLon(target);
        Position rotateAboutPos = Position.fromAltLatLon(rotateAbout);
        Orbit.create5000Orbit(fileName, viewerPos, targetPos, rotateAboutPos, angle, numberPositions);
    }

    @InternalUseOnly
    public static void create5000Orbit(String fileName, Position viewer, Position target, Position rotateAbout, double angle, int numberPositions) {
        DataFile df = new DataFile(Shell.getSharedMidasContext(), (Object)fileName, "5000", "NH", 0);
        df.setComponents("POS/VD/6/5,POSP/VD/6/5,CONE/VD/6/5,LABEL/1A/0/0");
        df.setSize(numberPositions);
        df.setReferenceFrame("ECR");
        df.open(2);
        Position[] orbitPos = Orbit.getOrbit(viewer, rotateAbout, numberPositions);
        Position[] targetPos = Orbit.getOrbit(target, rotateAbout, numberPositions);
        Data thisCone = new Data(angle, angle, angle);
        for (int i = 0; i < numberPositions; ++i) {
            Data thisPos = new Data(viewer.getAlt(), orbitPos[i].getLat(), orbitPos[i].getLon());
            df.setData((double)i, "POS", (Object)thisPos);
            Data thisTarget = new Data(target.getAlt(), targetPos[i].getLat(), targetPos[i].getLon());
            df.setData((double)i, "POSP", (Object)thisTarget);
            df.setData((double)i, "CONE", (Object)thisCone);
            df.setData((double)i, "LABEL", (Object)("" + i));
        }
        df.close();
    }

    static Position[] getOrbit(Position viewer, Position rotateAbout, int numberPositions) {
        double[] viewerXYZ = new double[]{viewer.getX(), viewer.getY(), viewer.getZ()};
        double[] rotateAboutXYZ = new double[]{rotateAbout.getX(), rotateAbout.getY(), rotateAbout.getZ()};
        double magRotateAbout = Vector3D.mag(rotateAboutXYZ);
        double[] perpRotateAbout = Vector3D.multByScalar(Vector3D.crossProduct(viewerXYZ, rotateAboutXYZ), 1.0 / magRotateAbout);
        double angleShift = 360.0 / (double)numberPositions;
        Position[] newViewerPos = new Position[numberPositions];
        newViewerPos[0] = viewer;
        for (int i = 1; i < numberPositions; ++i) {
            double radiansShift = Math.toRadians(angleShift * (double)i);
            double[] nextViewerXYZ = Vector3D.add(Vector3D.multByScalar(viewerXYZ, Math.cos(radiansShift)), Vector3D.multByScalar(perpRotateAbout, Math.sin(radiansShift)));
            newViewerPos[i] = new Position();
            newViewerPos[i].setCar(nextViewerXYZ[0], nextViewerXYZ[1], nextViewerXYZ[2]);
        }
        return newViewerPos;
    }

    @InternalUseOnly
    public static void main(String[] args) {
        Position viewer = Position.fromAltLatLon(new double[]{1000000.0, 45.0, 90.0});
        Position target = Position.fromAltLatLon(new double[]{0.0, 45.0, 90.0});
        Position rotateAbout = Position.fromAltLatLon(new double[]{1000000.0, -45.0, 0.0});
        Orbit.create5000Orbit("myorbitfile.tmp", viewer, target, rotateAbout, 10.0, 20);
    }
}

