/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataFileHeader;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Shell;
import nxm.sys.test.DatLocator;

@InternalUseOnly
public class DataUnsignedUtility {
    private static String AUX_1_PATH = "/midas/data1/" + System.getProperty("user.name");
    private static String KEYWORDS_FILE = AUX_1_PATH + "/unsigned_keywords.tmp";
    private static String RECORD_BASED_FILE = AUX_1_PATH + "/unsigned_values_3000.tmp";
    private String optionsSave;
    private Midas M = Shell.getMidasContext();
    private static String datDir = DatLocator.getDatDirLocation();

    private DataUnsignedUtility() {
    }

    private void setUp() {
        this.optionsSave = Shell.getMidasContext().io.getOptions();
        Shell.getMidasContext().io.setOptions("+MINIMALSUPPORTFORUNSUPPORTEDDATATYPES");
        Shell.runCommand(this.M, "WAVEFORM " + KEYWORDS_FILE + " ELEM=128");
    }

    private void tearDown() {
        Shell.getMidasContext().io.setOptions(this.optionsSave);
    }

    private void addViaDataFileHeader() {
        DataFile df = new DataFile(this.M, (Object)KEYWORDS_FILE);
        DataFileHeader dfh = new DataFileHeader(df);
        dfh.addToFile('V', Integer.MIN_VALUE, "VADDEDFROMDFH");
        dfh.addToFile('U', (short)Short.MIN_VALUE, "UADDEDFROMDFH");
    }

    private void create3000File() {
        DataFile in = new DataFile(this.M, (Object)(datDir + ".test3000.prm"));
        in.open();
        DataFile out = new DataFile(this.M, (Object)RECORD_BASED_FILE, in, 2);
        out.open();
        Keywords kw = out.getKeywordsObject();
        kw.setKey("S:6000key", "6000 test value");
        byte[] value1 = new byte[4];
        byte[] value2 = new byte[4];
        Convert.packL(value1, 0, Integer.parseUnsignedInt("4294967295"));
        Convert.packL(value2, 0, Integer.parseUnsignedInt("1024"));
        byte[] values = new byte[value1.length + value2.length];
        System.arraycopy(value1, 0, values, 0, value1.length);
        System.arraycopy(value2, 0, values, value1.length, value2.length);
        kw.set("V:CVKEY", (byte)86, values, values.length, 0);
        out.setSubRecords("(SR2A|2A,SRSL|SL,SRSU|SU,SRSV|SV,SRCV|CV)");
        out.setData(0.0, "SR2A", (Object)"FIRST");
        out.setData(0.0, "SRSL", (Object)65536);
        DataUnsignedUtility.writeOneElement(out, 0.0, "SRSU", 0, 65535, this.M, 'I');
        DataUnsignedUtility.writeOneElement(out, 0.0, "SRSV", 0, 0xFFFFFFFFL, this.M, 'L');
        DataUnsignedUtility.writeOneElement(out, 0.0, "SRCV", 0, 0xFFFFFFFFL, this.M, 'L');
        DataUnsignedUtility.writeOneElement(out, 0.0, "SRCV", 1, 5, this.M, 'L');
        out.setData(1.0, "SR2A", (Object)"SECOND");
        out.setData(1.0, "SRSL", (Object)32769);
        out.setData(1.0, "SRSU", (Object)32768);
        out.setData(1.0, "SRSV", (Object)0x80000000L);
        DataUnsignedUtility.writeOneElement(out, 1.0, "SRCV", 0, 0x80000000L, this.M, 'L');
        DataUnsignedUtility.writeOneElement(out, 1.0, "SRCV", 1, 4, this.M, 'L');
        out.close();
        in.close();
        out.close();
        DataFile df = new DataFile(this.M, (Object)RECORD_BASED_FILE);
        DataFileHeader dfh = new DataFileHeader(df);
        dfh.addToFile('V', (int)Integer.toUnsignedLong(-1), "V:UINT");
        dfh.addToFile('U', (short)Short.toUnsignedInt((short)-1), "U:USHORT");
    }

    private static void writeOneElement(DataFile df, double offset, String fieldName, int elem, Number num, Midas M, char type) {
        int fieldOffset = df.findRecOffset(fieldName);
        double dbpe = df.getBPE();
        offset += (double)fieldOffset / dbpe;
        int offThisElem = Data.getBPS(type);
        if ((offset += (double)(offThisElem * elem) / dbpe) != df.getOffset()) {
            df.seek(offset);
        }
        String fieldFormat = "S" + type;
        Data data = new Data(fieldFormat, 1, num);
        df.write(data.buf, 0, data.buf.length);
    }

    private void manuallyAddKeysToFile() {
        byte[] buf;
        File file = new File(KEYWORDS_FILE);
        File file2 = new File(KEYWORDS_FILE);
        try {
            FileInputStream fis = new FileInputStream(file);
            buf = new byte[(int)file.length()];
            fis.read(buf);
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        buf = this.addToFile('U', (short)-1, "testUDataType".toUpperCase(), buf);
        buf = this.addToFile('V', -1, "testVDataType".toUpperCase(), buf);
        try (FileOutputStream fos = new FileOutputStream(file2);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            bos.write(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private byte[] addToFile(char type, Object val, String name, byte[] buf) {
        int extStart = Convert.unpackL(buf, 24);
        int extSize = Convert.unpackL(buf, 28);
        double dataStart = Convert.unpackD(buf, 32);
        double dataSize = Convert.unpackD(buf, 40);
        byte[] data = this.packTestDataToBuffer(type, val);
        int off = extStart * 512 + extSize;
        if (off == 0) {
            off = (int)(dataStart + dataSize);
        }
        int ltag = name.length();
        int len = data.length;
        int length = (len + ltag + 15) / 8 * 8;
        short lext = (short)(length - len);
        if (buf.length < length + off) {
            int size = buf.length;
            byte[] bufo = buf;
            buf = new byte[length + off];
            System.arraycopy(bufo, 0, buf, 0, size);
        }
        Convert.packL(buf, off + 0, length);
        Convert.packI(buf, off + 4, lext);
        buf[off + 6] = ltag;
        buf[off + 7] = (byte)type;
        System.arraycopy(data, 0, buf, off + 8, len);
        int i = 0;
        int j = off + 8 + len;
        while (i < ltag) {
            buf[j++] = (byte)name.charAt(i++);
        }
        Convert.packL(buf, 28, extSize + length);
        Convert.packL(buf, 24, off / 512);
        return buf;
    }

    private byte[] packTestDataToBuffer(char type, Object val) {
        byte[] res = new byte[type == 'U' ? 2 : 4];
        if (type == 'U') {
            Convert.packI(res, 0, (Short)val);
        } else {
            Convert.packL(res, 0, (Integer)val);
        }
        return res;
    }

    public static void main(String[] args) {
        DataUnsignedUtility dut = new DataUnsignedUtility();
        dut.setUp();
        dut.create3000File();
        dut.tearDown();
    }
}

