/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;

public class thin
extends Primitive {
    Data dbi;
    Data dbo;
    DataFile hi;
    DataFile ho;
    double dstart;
    double dend;
    double dinc;
    double fdstr;
    double fdend;
    double fdinc;
    int inc;
    int bpe;
    int stride;
    int finc;
    int fbpe;
    int fstride;
    int foff;
    int nsub;
    int off;
    int curoff = 0;
    int addressingMode;
    boolean xsub;
    boolean enablerestart = true;

    @Override
    public int open() {
        this.hi = this.MA.getDataFile("IN");
        this.hi.open();
        if (this.state != 7) {
            this.addressingMode = this.MA.getAddressing();
            String startStr = this.MA.getU("START");
            String endStr = this.MA.getU("END");
            String incStr = this.MA.getU("INC");
            this.dstart = this.hi.getIndex(startStr, 1, this.addressingMode);
            this.dend = this.hi.getIndex(endStr, 2, this.dstart, this.addressingMode);
            this.dinc = this.hi.getIndex(incStr, 4, this.addressingMode);
            if (endStr.equals("-1")) {
                this.M.warning("Setting END to -1 addresses EOF-1 not EOF. Use -0 for EOF.");
            }
            if (this.hi.getUnits() == 1 && !this.MA.hasAddressing() && (this.dstart > 1.0E8 && startStr.startsWith("~") || this.dend > 1.0E8 && endStr.startsWith("~"))) {
                this.M.warning("Behavior change since 2.9.1 for abscissa addressing using tilde.");
                this.M.warning("You may need to add /ADDRESSING=timecode or /ABSC switch to get desired result.");
            }
        }
        if (this.dend > this.hi.getSize()) {
            this.dend = this.hi.getSize();
        }
        this.inc = (int)this.dinc;
        if (this.dinc < -1.0) {
            this.dinc = -1.0 / this.dinc;
        } else if (this.dinc <= 0.0) {
            this.dinc = 1.0;
            this.inc = 1;
        } else if (this.dinc < 1.0) {
            this.inc = -((int)(1.0 / this.dinc + 0.1));
        }
        this.bpe = (int)this.hi.getBPE();
        this.stride = this.inc < 0 ? -this.inc * this.bpe : this.inc * this.bpe;
        if (this.hi.typeClass == 2) {
            if (this.state != 7) {
                this.fdstr = this.hi.getIndex(this.MA.getU("FSTART"), 5, 0.0, this.addressingMode);
                this.fdend = this.hi.getIndex(this.MA.getU("FEND"), 6, this.fdstr, this.addressingMode);
                this.fdinc = this.hi.getIndex(this.MA.getU("FINC"), 7, 0.0, this.addressingMode);
            }
            this.finc = Math.max(0, (int)(this.fdinc + 0.5));
            this.xsub = this.fdstr != 0.0 || this.fdend != (double)this.hi.getSubSize() || this.finc != 1;
            this.nsub = (int)Math.round((this.fdend - this.fdstr) / this.fdinc);
            this.fbpe = this.hi.getBPA();
            this.foff = Math.max(0, (int)this.fdstr) * this.fbpe;
            this.fstride = this.fbpe * this.finc;
        }
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        this.ho.setStart(this.hi.getStart() + this.hi.getDelta() * this.dstart);
        this.ho.setDelta(this.hi.getDelta() * this.dinc);
        this.ho.setSize(Math.ceil((this.dend - this.dstart) / this.dinc + 0.1));
        if (this.xsub) {
            this.ho.setXStart(this.hi.getXStart() + this.hi.getXDelta() * this.fdstr);
        }
        if (this.xsub) {
            this.ho.setXDelta(this.hi.getXDelta() * this.fdinc);
        }
        if (this.xsub) {
            this.ho.setSubSize(this.nsub);
        }
        this.ho.open();
        this.xfer = Math.max(1, this.bufSize / this.stride);
        if (this.xsub || this.stride > 1024) {
            this.xfer = 1;
        }
        this.xfer = this.MA.getL("/TL", this.xfer);
        this.setupDataBuffers();
        this.off = this.MA.getL("/OFFSET", 0);
        this.enablerestart = this.MA.getState("/RESTART", true);
        this.hi.seek(this.dstart);
        this.hi.setSize(this.dend);
        return 0;
    }

    private void setupDataBuffers() {
        if (this.xfer == 1) {
            this.dbo = this.dbi = this.hi.getDataBuffer(1);
            if (this.xsub) {
                this.dbo = this.ho.getDataBuffer(1);
            }
        } else if (this.inc < 0) {
            this.dbi = this.hi.getDataBuffer(this.xfer);
            this.dbo = this.ho.getDataBuffer(-this.inc * this.xfer);
        } else {
            this.dbo = this.dbi = this.hi.getDataBuffer(this.xfer * this.inc);
        }
    }

    @Override
    public int process() {
        int n = this.hi.read(this.dbi);
        if (n == 0) {
            return -1;
        }
        if (n < 0) {
            return 9;
        }
        if (this.xfer == 1) {
            int newoff = this.off;
            if (this.inc > 1) {
                this.hi.skip(newoff - this.curoff + this.inc - 1);
            }
            this.curoff = newoff;
            if (this.xsub) {
                Convert.move(this.dbi.buf, this.foff, this.fstride, this.dbo.buf, 0, this.fbpe, this.fbpe, this.nsub);
            }
        } else if (this.inc > 1) {
            n = (n + this.inc - 1) / this.inc;
            Convert.move(this.dbi.buf, this.off * this.bpe, this.stride, this.dbo.buf, 0, this.bpe, this.bpe, n);
        } else if (this.inc < 0) {
            Convert.move(this.dbi.buf, 0, this.bpe, this.dbo.buf, 0, this.stride, this.bpe, n);
            n = -this.inc * n;
        }
        this.ho.write(this.dbo, n);
        return 0;
    }

    @Override
    public int close() {
        this.hi.close();
        this.ho.close();
        return 0;
    }

    public void setOffset(int off) {
        this.off = off % this.inc;
    }

    public int getOffset() {
        return this.off;
    }

    public void setInc(String dinc) {
        this.dinc = this.hi.getIndex(dinc, 4, 0.0, this.addressingMode);
        if (this.enablerestart) {
            this.setState(7);
        }
    }

    public int getInc() {
        return this.inc;
    }

    public void setStart(String start) {
        this.dstart = this.hi.getIndex(start, 1, 0.0, this.addressingMode);
        if (this.enablerestart) {
            this.setState(7);
        }
    }

    public double getStart() {
        return this.dstart;
    }

    public void setEnd(String end) {
        this.dend = this.hi.getIndex(end, 2, this.dstart, this.addressingMode);
        if (this.enablerestart) {
            this.setState(7);
        }
    }

    public double getEnd() {
        return this.dend;
    }

    public void setFVals(String fstart, String fend, String finc) {
        if (this.hi.typeClass != 2) {
            return;
        }
        this.setFInc(finc);
        this.setFStart(fstart);
        this.setFEnd(fend);
    }

    public void setFVals(Table fvals) {
        if (this.hi.typeClass != 2 || fvals == null) {
            return;
        }
        this.setFVals(fvals.getS("FSTART", ""), fvals.getS("FEND", ""), fvals.getS("FINC", ""));
    }

    public void setFInc(String sval) {
        if (this.hi.typeClass != 2) {
            return;
        }
        if (sval != null && !sval.equals("")) {
            this.fdinc = this.hi.getIndex(sval, 7, this.addressingMode);
        }
    }

    public int getFInc() {
        return this.finc;
    }

    public void setFStart(String sval) {
        if (this.hi.typeClass != 2) {
            return;
        }
        if (sval != null && !sval.equals("")) {
            this.fdstr = this.hi.getIndex(sval, 5, this.addressingMode);
        }
    }

    public double getFStart() {
        return this.fdstr;
    }

    public void setFEnd(String sval) {
        if (this.hi.typeClass != 2) {
            return;
        }
        if (sval != null && !sval.equals("")) {
            this.fdend = this.hi.getIndex(sval, 6, this.addressingMode);
        }
        if (this.enablerestart) {
            this.setState(7);
        }
    }

    public double getFEnd() {
        return this.fdend;
    }
}

