/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Convert;
import nxm.sys.lib.Message;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.libm.Tolerance;

public class testxmmsg
extends Primitive {
    private int numTests = 0;
    private int numFails = 0;
    private String xmid = "";
    private String nmid = "";
    private static final String longstr12 = "abcdefghijkl";
    private static final String longstr32 = "abcdefghijklmnopqrstuzwxyz012345";
    private static final String longstr36 = "abcdefghijklmnopqrstuzwxyz0123456789";

    @Override
    public int open() {
        this.pollTime = this.args.getD("/POLL", 0.1);
        this.xmid = this.MA.get("/MSGID");
        this.nmid = "XM." + this.getID();
        return 0;
    }

    @Override
    public int processMessage(Message msg) {
        int status = -1;
        if (msg.name.equals("TEST1")) {
            Table tbl = Convert.o2t(msg.data);
            this.doAssert("TEST1 message fid=" + this.xmid, this.xmid.equals(msg.getFromID()));
            this.doAssert("TEST1 message to=" + this.nmid, this.nmid.equals(msg.getToID()));
            this.doAssert("TEST1 message info=99", msg.info == 99);
            this.doAssert("TEST1 message data.getsize=0", tbl.size() == 0);
        } else if (msg.name.equals("TEST2")) {
            Table tbl = Convert.o2t(msg.data);
            this.doAssert("TEST2 message fid=" + this.xmid, this.xmid.equals(msg.getFromID()));
            this.doAssert("TEST2 message to=" + this.nmid, this.nmid.equals(msg.getToID()));
            this.doAssert("TEST2 message info=7", msg.info == 7);
            this.doAssert("TEST2 message data.getsize=3", tbl.size() == 3);
            this.doAssert("TEST2 message val1=1", tbl.getD("VAL1") == 1.0);
            this.doAssert("TEST2 message val2=Two", tbl.getS("VAL2").equals("Two"));
            this.doAssert("TEST2 message val3=3", tbl.getD("VAL3") == 3.0);
        } else if (msg.name.equals("TEST3")) {
            Table tbl = Convert.o2t(msg.data);
            this.doAssert("TEST3 message fid=" + this.xmid, this.xmid.equals(msg.getFromID()));
            this.doAssert("TEST3 message to=" + this.nmid, this.nmid.equals(msg.getToID()));
            this.doAssert("TEST3 message info=0", msg.info == 0);
            this.doAssert("TEST3 message data.getsize=4", tbl.size() == 4);
            this.doAssert("TEST3 message val1=1", tbl.getD("VAL1") == 1.0);
            this.doAssert("TEST3 message val2=longstr12", longstr12.equals(tbl.getS("VAL2")));
            this.doAssert("TEST3 message val3=longstr32", longstr32.equals(tbl.getS("VAL3")));
            this.doAssert("TEST3 message val4=2", tbl.getD("VAL4") == 2.0);
        } else if (msg.name.equals("TEST4")) {
            Table tbl = Convert.o2t(msg.data);
            this.doAssert("TEST4 message fid=" + this.xmid, this.xmid.equals(msg.getFromID()));
            this.doAssert("TEST4 message to=" + this.nmid, this.nmid.equals(msg.getToID()));
            this.doAssert("TEST4 message info=0", msg.info == 0);
            this.doAssert("TEST4 message data.getsize=6", tbl.size() == 6);
            this.doAssert("TEST4 message val1=1", tbl.getD("VAL1") == 1.0);
            this.doAssert("TEST4 message val2=2", tbl.getD("VAL2") == 2.0);
            this.doAssert("TEST4 message val3=3.3", this.eqt(tbl.getD("VAL3"), 3.3));
            this.doAssert("TEST4 message val4=4.4", this.eqt(tbl.getD("VAL4"), 4.4));
            this.doAssert("TEST4 message val5=5.5", this.eqt(tbl.getD("VAL5"), 5.5));
            this.doAssert("TEST4 message val6=6.6", this.eqt(tbl.getD("VAL6"), 6.6));
        } else if (msg.name.equals("SETL")) {
            Table tbl = Convert.o2t(msg.data);
            this.doAssert("SETL message fid=" + this.xmid, this.xmid.equals(msg.getFromID()));
            this.doAssert("SETL message to=" + this.nmid, this.nmid.equals(msg.getToID()));
            this.doAssert("SETL message info=42", msg.info == 42);
            this.doAssert("SETL message data.getsize=3", tbl.size() == 3);
            this.doAssert("SETL message object=MyObj", tbl.getS("OBJECT").equals("MyObj"));
            this.doAssert("SETL message value=1", tbl.getD("VALUE") == 1.0);
            this.doAssert("SETL message value2=2", tbl.getD("VALUE2") == 2.0);
            String passFail = this.numFails == 0 ? "PASS" : "FAIL";
            this.MR.getRoot().put("XM.STATUS_" + this.getID(), (Object)passFail);
            Table data2 = new Table("{ARGS=3,TYPE=\"DAD\",VAL1=10.0,VAL2=\"Twenty\",VAL3=30.0}");
            Table data3 = new Table("{ARGS=4,TYPE=\"LS[12]S[32]L\",VAL1=1,VAL2=\"abcdefghijkl\",VAL3=\"abcdefghijklmnopqrstuzwxyz0123456789\",VAL4=2}");
            Table datas = new Table("{OBJECT=\"NmObj\",VALUE2=30,VALUE=20}");
            Table data4 = new Table("{ARGS=6,TYPE=\"2L2DFF\",VAL1=1,VAL2=2,VAL3=3.3,VAL4=4.4,VAL5=5.5,VAL6=6.6}");
            this.MQ.put(new Message("TESTN0", 0, null, Message.XmMsgType.AUTO), "XM.3");
            this.MQ.put(new Message("TESTN1", 10, null, Message.XmMsgType.UNCONFIGURED), "XM.1");
            this.MQ.put(new Message("TESTN2", 20, (Object)data2, Message.XmMsgType.AUTO), "XM.1");
            this.sendMessage(new Message("TESTN3", 0, (Object)data3, Message.XmMsgType.UNCONFIGURED));
            this.sendMessage(new Message("TESTN4", 0, (Object)data4, Message.XmMsgType.UNCONFIGURED));
            this.sendMessage(new Message("SETL", 30, (Object)datas, Message.XmMsgType.CONFIGURED));
            Table rerrdata = new Table("{TEXT=\"MYTEXT\",ADDR=\"MYADDR\",FUNC=\"MYFUNC\",DATA=\"MYDATA\"}");
            this.MQ.put(new Message("RERR", 0, (Object)rerrdata, Message.XmMsgType.CONFIGURED), "XM.3");
            status = 9;
        } else {
            this.doAssert("Got unknown message name=" + msg.name, false);
        }
        return status;
    }

    private void doAssert(String msg, boolean status) {
        msg = StringUtil.padRight(msg, 69, '.');
        ++this.numTests;
        if (status) {
            this.M.info(msg + "PASS");
        } else {
            ++this.numFails;
            this.M.warning(msg + "FAIL <--");
        }
    }

    private final boolean eqt(double d1, double d2) {
        return Tolerance.equalsWithTolerance(d1, d2);
    }
}

