/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Message;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Terminal;
import nxm.sys.libg.GPrimitive;
import nxm.sys.libg.GTerminal;
import nxm.sys.libg.MWText;

public class shellgui
extends GPrimitive {
    public static final String exitList = "COMMAND,MENU,MESSAGE,WINDOW";
    public static final int EXIT_COMMAND = 1;
    public static final int EXIT_MENU = 2;
    public static final int EXIT_MESSAGE = 4;
    public static final int EXIT_WINDOW = 8;
    public static final int EXIT_ALL = 15;
    public Shell shell;
    public GTerminal terminal;
    private Terminal saveterm;
    private boolean attach;
    private int exit;
    private boolean exiting;
    private MWText mwtext;

    @Override
    public int open() {
        int lines = this.MA.getL("/LINES", 2000);
        int rows = this.MA.getL("/ROWS", 30);
        int cols = this.MA.getL("/COLS", 100);
        int fontsz = this.MA.getL("/FONTSZ", 12);
        int flags = 18370;
        boolean addPlus = this.MA.getState("/ADDPLUS", true);
        if (addPlus) {
            flags |= 0x1000;
        }
        this.attach = this.MA.getState("/ATTACH", false);
        if (this.M.terminal != null && this.M.macro != null && this.M.terminal.getShell() != this.M.macro.MT.getShell() && this.attach) {
            Shell.runCommand(this.M, "POPUP,,OK,ERROR:Not_allowed_to_have_two_attached_SHELLGUIs,ERR");
            return 10;
        }
        this.mwtext = new MWText("GShell", lines, rows, cols, fontsz, flags, this);
        this.MW = this.mwtext;
        this.MW.open();
        this.terminal = new GTerminal(this.M, this.mwtext);
        this.saveterm = this.M.terminal;
        this.attach = this.MA.getState("/ATTACH", false);
        this.shell = new Shell(this.M, this.attach);
        this.terminal.setShell(this.shell);
        if (this.attach) {
            if (this.M.macro == null) {
                this.saveterm.leach = this.terminal;
            }
        } else {
            this.shell.M.detach();
        }
        this.exit = this.M.pipeMode == 1 ? 0 : 15;
        this.exit = this.MA.getOptionMask("/EXIT", exitList, this.exit);
        this.MW.addTo(this);
        this.shell.M.terminal = this.terminal;
        if (this.verbose) {
            this.terminal.writeln("Welcome to NeXtMidas 4.1.4 ...");
        }
        return 0;
    }

    @Override
    public int process() {
        this.shell.process();
        if (this.exit(1)) {
            return 9;
        }
        return 0;
    }

    @Override
    public int processMessage(Message msg) {
        int status = 0;
        if (msg.name.equals("EXIT")) {
            this.exit(4);
        } else if (msg.name.equals("MENUEXIT")) {
            this.exit(2);
        } else if (msg.name.equals("WINDOW") && msg.info == 0) {
            this.exit(8);
        } else if (msg.name.equals("RESIZE")) {
            this.MW.resize(0);
        } else if (msg.name.equals("CLEAR")) {
            this.clear();
        } else {
            status = this.MW.processMessage(msg);
        }
        return status;
    }

    private boolean exit(int flag) {
        if ((flag & this.exit) != 0) {
            this.exiting = true;
        }
        if (this.exiting && flag != 1) {
            this.terminal.setTextInput("EXIT");
        }
        return this.exiting;
    }

    @Override
    public int close() {
        if (this.attach) {
            this.M.terminal = this.saveterm;
            this.saveterm.leach = null;
        }
        this.MW.close();
        return 0;
    }

    public void clear() {
        this.mwtext.mtext.removeAll();
    }
}

