/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

public class polyeval
extends Primitive {
    DataFile outFile;
    Data coefs;
    Data outData;
    double[] coefficients;
    double[] outArray;
    int ndata;

    @Override
    public int open() {
        String format = this.MA.getS("FORMAT", "SD");
        double start = this.MA.getD("START", 0.0);
        double delta = this.MA.getD("DELTA", 1.0);
        int units = this.MA.getL("UNITS", 0);
        this.ndata = this.MA.getL("NDATA", 1024);
        this.coefs = this.MA.getData("COEF");
        this.MA.testFormat(this.coefs.getFormat(), "S#");
        this.outFile = this.MA.getDataFile("OUT", "1000", format, 2);
        this.outFile.setStart(start);
        this.outFile.setDelta(delta);
        this.outFile.setUnits(units);
        this.outFile.open();
        this.outData = this.outFile.getDataBuffer(this.ndata);
        return 0;
    }

    @Override
    public int process() {
        this.coefficients = this.coefs.castD(true);
        this.outArray = this.outData.castD(false);
        this.evaluate(this.coefficients, this.outArray, 0, this.ndata);
        this.coefs.uncast(this.coefficients, false);
        this.outData.uncast(this.outArray, true);
        this.outFile.write(this.outData);
        return 9;
    }

    protected void evaluate(double[] coefficients, double[] outArray, int start, int end) {
        int order = coefficients.length - 1;
        for (int i = start; i < end; ++i) {
            double sum = 0.0;
            double xpow = 1.0;
            for (int j = 0; j <= order; ++j) {
                sum += coefficients[j] * xpow;
                xpow *= (double)i;
            }
            outArray[i] = sum;
        }
    }

    @Override
    public int close() {
        this.outFile.close();
        return 0;
    }
}

