/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;

public class noop
extends Primitive {
    public static final String throttleList = "RealTime,Full,Block";
    private static final int REALTIME = 1;
    private static final int FULL = 2;
    private static final int BLOCK = 3;
    private DataFile hi;
    private DataFile ho;
    private Data data;
    private boolean wrap = false;
    private int throttle;
    private double tdelta;
    private double tstart;
    private double offs;
    private double size;
    private double tcur;
    private double flush;
    private double tflush;
    private double rateWindow;
    private double rateWindowOffset = 0.0;
    private static double RW_DEF = 1.0;
    private static double RW_MIN = 0.01;
    private boolean noPropagationOfTimelineKeywords;

    @Override
    public int open() {
        this.hi = this.MA.getDataFile("IN");
        this.hi.open();
        this.size = this.MA.getD("/SIZE");
        this.offs = this.MA.getD("/START", 0.0);
        this.noPropagationOfTimelineKeywords = this.MA.getState("/NOPROPAGATIONOFTIMELINEKEYWORDS");
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        if (this.noPropagationOfTimelineKeywords) {
            this.ho.deleteTimeLineKeywords();
        }
        if (this.size > 0.0) {
            this.ho.setSize(this.size);
        }
        this.ho.open();
        this.setProgressFeed(this.hi, "NOOP " + this.hi.getURL() + " to " + this.ho.getURL());
        if (this.MA.find("/PACKET")) {
            FileName pfn = this.MA.getFileName("/PACKET");
            this.ho.getPacketHandler().setFileName(this.ho, pfn);
        }
        this.xfer = Math.max(1, (int)((double)this.bufSize / this.hi.dbpe));
        this.xfer = this.MA.getL("/TL", this.xfer);
        this.data = this.hi.getDataBuffer(this.xfer);
        this.wrap = this.MA.getState("/WRAP");
        this.tstart = 0.0;
        this.setRate(this.MA.getD("/RATE"));
        this.setRateWindow(this.MA.getD("/RATEWINDOW", RW_DEF));
        this.throttle = this.MA.getState("/RT") ? 1 : 2;
        this.throttle = this.MA.getChoice("/THROTTLE", throttleList, this.throttle);
        this.flush = this.MA.getD("/FLUSH");
        if (this.offs > 0.0) {
            this.hi.seek(this.offs);
        }
        if (this.hi.getFormatMode() != this.ho.getFormatMode()) {
            this.M.error("Mixed mode reformats are not supported: " + this.hi.getFormat() + " -> " + this.ho.getFormat());
        }
        return 0;
    }

    @Override
    public int process() {
        double tcur;
        double d = tcur = this.flush > 0.0 || this.throttle == 1 ? Time.current() : 0.0;
        if (this.state == 12) {
            this.resetWindow();
        }
        if (this.throttle == 1) {
            if (this.tstart == 0.0 && this.hi.avail() < (double)this.xfer) {
                return -1;
            }
            if (this.tstart == 0.0) {
                this.tstart = tcur;
            }
            if (tcur < this.tstart + (this.ho.seek() - this.rateWindowOffset) * this.tdelta) {
                return -1;
            }
            if (tcur > this.tstart + this.rateWindow) {
                this.resetWindow();
            }
        } else if (this.throttle == 3) {
            return -1;
        }
        if (this.size > 0.0 && this.ho.seek() >= this.size) {
            return 9;
        }
        int n = this.hi.read(this.data);
        if (this.size > 0.0 && (double)n + this.ho.seek() > this.size) {
            n = (int)(this.size - this.ho.seek());
        }
        if (n > 0) {
            this.ho.write(this.data, n);
        } else {
            if (n == 0) {
                return -1;
            }
            if (this.wrap && (this.hi.isFile() || this.hi.isJarFile())) {
                this.hi.seek(0.0);
            } else {
                return 9;
            }
        }
        if (this.flush > 0.0 && tcur - this.tflush > this.flush) {
            this.ho.flush();
            this.tflush = tcur;
        }
        return 0;
    }

    @Override
    public int close() {
        this.hi.close();
        this.ho.close();
        return 0;
    }

    public void setTDelta(double value) {
        this.tdelta = value;
    }

    public void setRate(double value) {
        this.tdelta = value <= 0.0 ? this.hi.getDelta() : this.hi.dbpe / value;
    }

    public void setThrottle(String value) {
        this.throttle = Parser.find(throttleList, value, this.throttle, 0, 1);
    }

    public String getThrottle() {
        return Parser.get(throttleList, this.throttle);
    }

    public void setRateWindow(double value) {
        if (value < RW_MIN) {
            this.M.warning("Rate window reset to minimum value of " + RW_MIN + " seconds.");
            this.rateWindow = RW_MIN;
        } else {
            this.rateWindow = value;
        }
    }

    private void resetWindow() {
        this.tstart = Time.current();
        this.rateWindowOffset = this.ho.seek();
    }
}

