/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import nxm.sys.lib.Message;
import nxm.sys.lib.Table;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrimitive;
import nxm.sys.libg.MWText;
import nxm.sys.prim.panel;

public class msglog
extends GPrimitive
implements ActionListener {
    MWText MWT;
    String lastmsg;
    int info;
    int warn;
    int err;
    int other;
    int banner;
    public static final String bannerList = "None,Top,Pane";

    @Override
    public int open() {
        int lines = this.MA.getL("/LINES", 200);
        int rows = this.MA.getL("/ROWS", 24);
        int cols = this.MA.getL("/COLS", 80);
        int fontsz = this.MA.getL("/FONTSZ", 12);
        int flags = 9218;
        if (this.MA.getState("/WRAP")) {
            flags |= 0x200;
        }
        this.banner = this.MA.getChoice("/BANNER", bannerList, 2);
        if (this.banner == 2) {
            flags |= 0x800;
        }
        this.MWT = new MWText("MsgLog", lines, rows, cols, fontsz, flags, this);
        if (this.MWT.mtext != null) {
            this.MWT.mtext.addActionListener(this);
        }
        this.setBanner();
        this.MW = this.MWT;
        this.MW.open();
        this.MW.addTo(this);
        this.M.msglog = this.getID();
        return 0;
    }

    @Override
    public int process() {
        return -1;
    }

    @Override
    public int processMessage(Message msg) {
        int status = 0;
        if (msg.name.equals("EXIT")) {
            this.setState(9);
        } else if (msg.name.equals("RESIZE")) {
            this.MW.resize(0);
            if (this.MWT.mtext != null) {
                this.MWT.mtext.setScroll(-1);
            }
        } else if (msg.name.equals("LOG")) {
            String head = "";
            switch (msg.info) {
                case 0: {
                    head = "INFO: ";
                    ++this.info;
                    break;
                }
                case 1: {
                    head = "WARN: ";
                    ++this.warn;
                    break;
                }
                case 2: {
                    head = "ERROR: ";
                    ++this.err;
                    break;
                }
                default: {
                    head = "";
                    ++this.other;
                }
            }
            this.setBanner();
            this.lastmsg = head + msg.data;
            if (this.MWT.mtext != null) {
                this.MWT.mtext.add(this.lastmsg);
            }
        } else if (msg.name.equals("MSGLOG")) {
            String text = msg.getS();
            if (text.equals("CLEAR")) {
                this.clear();
            }
            if (text.equals("CONFIGURE")) {
                this.configure();
            }
            if (text.equals("EXIT")) {
                this.setState(9);
            }
        } else {
            status = this.MW.processMessage(msg);
        }
        return status;
    }

    @Override
    public int close() {
        this.MW.close();
        this.M.msglog = null;
        return 0;
    }

    private void clear() {
        this.MWT.mtext.removeAll();
        this.other = 0;
        this.err = 0;
        this.warn = 0;
        this.info = 0;
        this.setBanner();
    }

    private void configure() {
    }

    private void setBanner() {
        String text = "MsgLog: Info=" + this.info + " Warn=" + this.warn + " Err=" + this.err + " Other=" + this.other;
        if (this.banner == 2) {
            this.MWT.mtext.setBanner(text);
        } else if (this.banner == 3 && this.MWT.parent instanceof panel.Pane) {
            ((panel.Pane)this.MWT.parent).setTitle(text);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int button;
        String action = e.getActionCommand();
        if (action.equals("POP")) {
            if (this.MW.status != -3) {
                this.MW.pop(-1);
            }
        } else if (action.equals("BANNER")) {
            if (this.MW.status != -3) {
                this.MW.pop(-1);
            }
        } else if (action.equals("BUTTON") && (button = e.getModifiers()) == 2) {
            new GMenu(this.MW, "MSGLOG", "Clear,Configure,Exit", 0, 0, this);
        }
    }

    public Table getStats() {
        Table t = new Table();
        t.put("INFO", this.info);
        t.put("WARN", this.warn);
        t.put("ERR", this.err);
        t.put("OTHER", this.other);
        return t;
    }

    public String getLast() {
        return this.lastmsg;
    }
}

