/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.inc.DataTypes;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.libm.ArgStack;
import nxm.sys.libm.Argument;
import nxm.sys.libm.Operator;
import nxm.sys.libm.Operators;

public class fcalculator
extends Primitive
implements DataTypes {
    private ArgStack calc;
    private int xfero;
    private char type;
    private DataFile[] dfs;
    private int ndf = 0;
    private int idf = -1;
    private boolean hasInput;
    private boolean propHeader = true;

    @Override
    public int open() {
        int i;
        int narg = this.MA.numberOf();
        boolean var = this.MA.getState("/MON", false);
        this.type = this.MA.getU("/TYPE", "F").charAt(0);
        this.xfer = this.MA.getL("/TL", 1024);
        this.calc = new ArgStack(narg, narg, this.type, this.xfer, 0);
        this.dfs = new DataFile[narg];
        this.propHeader = this.MA.getState("/PROPHEADER", this.propHeader);
        boolean useLabel = true;
        for (i = 1; i <= narg; ++i) {
            if (!this.MA.getU(i).startsWith(">")) continue;
            useLabel = false;
        }
        for (i = 1; i <= narg; ++i) {
            if (useLabel && i == 1) continue;
            String s = this.MA.getU(i);
            Operator op = Operators.get(s);
            if (op != null) {
                this.calc.parseOperator(s, op);
                continue;
            }
            if (s.equals("PUSH")) {
                this.calc.parsePush();
                continue;
            }
            if (s.equals("POP")) {
                this.calc.parsePop();
                continue;
            }
            if (s.equals("<>")) {
                this.calc.parseSwap();
                continue;
            }
            if (s.startsWith("<")) {
                this.parseFileIn(this.MA.getCS(i).substring(1));
                continue;
            }
            if (s.startsWith(">")) {
                this.parseFileOut(this.MA.getCS(i).substring(1));
                continue;
            }
            if (this.calc.parseConstant(s, this, true, var)) continue;
            this.parseFileIn(this.MA.getCS(i));
        }
        if (useLabel) {
            this.parseFileOut(this.MA.getU(1));
        }
        this.calc.parseDone();
        if (!this.hasInput) {
            this.calc.badArg("Need at least one input file");
        }
        return 0;
    }

    @Override
    public int process() {
        this.xfero = this.xfer;
        int eofs = 0;
        block5: for (int i = 0; i < this.calc.nArgs; ++i) {
            Argument arg = this.calc.args[i];
            if (arg.kind == 11) {
                eofs += this.dataIn(arg);
                continue;
            }
            if (arg.kind == 12) {
                this.dataOut(arg);
                continue;
            }
            if (arg.kind == 3) {
                this.updateVariable(arg);
                continue;
            }
            if (eofs > 0) {
                arg.size = this.xfer;
            }
            switch (this.calc.type) {
                case 'F': {
                    arg.op.process(arg.fv, arg.size, arg.mode);
                    continue block5;
                }
                case 'D': {
                    arg.op.process(arg.dv, arg.size, arg.mode);
                    continue block5;
                }
                case 'L': {
                    arg.op.process(arg.lv, arg.size, arg.mode);
                }
            }
        }
        return eofs > 0 ? 9 : 0;
    }

    @Override
    public int close() {
        for (int i = 0; i < this.ndf; ++i) {
            this.dfs[i].close();
        }
        this.ndf = 0;
        return 0;
    }

    private void parseFileIn(String name) {
        DataFile df = new DataFile();
        df.init(this, (Object)name, "1000,2000", "S#,C#,V#", 0);
        df.open(1);
        this.addProgressFeed(df);
        int nxfer = this.xfer;
        if (df.typeClass == 1) {
            double numElem = df.getSize();
            if (numElem > 0.0) {
                nxfer = (int)Math.ceil(Math.min((double)nxfer, numElem));
            }
            this.xfer = nxfer;
        }
        if (df.typeClass == 2) {
            nxfer = df.getSubSize();
            this.xfer = 1;
        }
        df.buffer = df.getDataBuffer(this.xfer, (byte)this.type);
        Argument arg = this.calc.parseStackIn(name, df.buffer, nxfer);
        if (this.xfer > 1 || df.typeClass == 2 || this.idf < 0) {
            this.idf = this.ndf;
        }
        arg.info = this.ndf;
        this.dfs[this.ndf++] = df;
        this.hasInput = true;
    }

    private void parseFileOut(String name) {
        DataFile df = new DataFile();
        if (this.idf >= 0) {
            df.init(this, (Object)name, this.dfs[this.idf], 0);
        } else {
            df.init(this, (Object)name, "1000", "SF", 0);
        }
        df.setFormat(this.calc.getFormat());
        df.open(2);
        df.buffer = df.getDataBuffer(this.xfer, (byte)this.type);
        Argument arg = this.calc.parseStackOut(name);
        arg.info = this.ndf;
        this.dfs[this.ndf++] = df;
    }

    private int dataIn(Argument arg) {
        boolean reachedEnd = false;
        DataFile df = this.dfs[arg.info];
        int ngot = df.read(df.buffer);
        if (ngot < 0) {
            this.xfero = 0;
            return 1;
        }
        if (ngot < this.xfero) {
            this.xfero = this.xfer = ngot;
            reachedEnd = true;
        }
        if (this.type == 'F') {
            df.buffer.toArray(arg.fv[0]);
        } else if (this.type == 'D') {
            df.buffer.toArray(arg.dv[0]);
        } else if (this.type == 'L') {
            df.buffer.toArray(arg.lv[0]);
        }
        return reachedEnd ? 1 : 0;
    }

    private void updateVariable(Argument arg) {
        Data data = (Data)Convert.s2o(arg.name, this.type, (Object)this);
        if (this.type == 'F') {
            data.toArray(arg.fv[0]);
        } else if (this.type == 'D') {
            data.toArray(arg.dv[0]);
        } else if (this.type == 'L') {
            data.toArray(arg.lv[0]);
        }
    }

    private void dataOut(Argument arg) {
        DataFile df = this.dfs[arg.info];
        if (this.idf >= 0 && this.propHeader) {
            df.buffer.setHeader(this.dfs[this.idf].buffer.getHeader());
        }
        if (this.type == 'F') {
            df.buffer.fromArray(arg.fv[0]);
        } else if (this.type == 'D') {
            df.buffer.fromArray(arg.dv[0]);
        } else if (this.type == 'L') {
            df.buffer.fromArray(arg.lv[0]);
        }
        df.write(df.buffer, this.xfero);
    }
}

