/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.net;

import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.zip.Deflater;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Data;
import nxm.sys.lib.ICEPacket;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Time;

@Deprecated
public class dgnetsend {
    private boolean verbose = false;
    private boolean packetDebug = false;
    private boolean multicast = true;
    private boolean keepopen = false;
    private Deflater compressor = null;
    private Cipher cipher = null;
    private Key cipherkey = null;
    private PBEKeySpec pbeKeySpec = null;
    private AlgorithmParameterSpec pbeParamSpec = null;
    private String ciphertype = "PBEWithSHA1AndDESede";
    private Mac mac = null;
    private byte[] signature = new byte[20];
    private static final byte[] fakesignature = "00000000000000000000".getBytes();
    private int ITERATIONS = 1000;
    private SecretKeySpec signingkey = null;
    private String hmactype = "HmacSHA1";
    private String host = new String("238.0.0.1");
    private int port = 18800;
    private int ttl = 1;
    private int rtphdrlen = 0;
    private int icehdrlen = 0;
    private int ssrc = 0;
    private int csrc0 = 0;
    private short payload = 0;
    private static final int MAXPKTBUF = 65536;
    private static final int RTP_HEADER_SIZE = 12;
    private static final int RTP_CSRC_SIZE = 4;
    private static final int RTP_XHDR_HEADER_SIZE = 4;
    private InetAddress addr = null;
    private DatagramSocket dsock = null;
    private MulticastSocket msock = null;
    private String osname = System.getProperty("os.name").toUpperCase();
    private boolean windows = this.osname.startsWith("WINDOWS");
    private DatagramPacket dpacki = null;
    ICEPacket icePacket = new ICEPacket("SB", 64, 0);
    static final int MAX_UNSIGNED_INT_2 = 65535;
    static final long MAX_UNSIGNED_INT_4 = 0x100000000L;
    static final int MAX_INT_4 = Integer.MAX_VALUE;
    public static final int MAXPKT = 32768;
    private byte[] rtpbuf = new byte[32768];
    private int timestamp = 0;
    private int compsize = 0;
    int seqnum = 0;
    int count = 0;

    public dgnetsend() {
    }

    public dgnetsend(String phost, int pport) {
        this.host = phost;
        this.port = pport;
    }

    public int getNextSeqNum() {
        if (this.seqnum >= 65535) {
            return 0;
        }
        return this.seqnum + 1;
    }

    public int getSeqNum() {
        return this.seqnum;
    }

    public void setSeqNum(int parm) {
        this.seqnum = parm;
    }

    public int getTTL() {
        return this.ttl;
    }

    public void setTTL(int pittl) {
        try {
            this.ttl = pittl;
            if (this.msock == null) {
                return;
            }
            if (this.multicast) {
                this.msock.setTimeToLive(this.ttl);
            }
            if (this.verbose) {
                System.out.println("dgnetsend: setting ttl " + this.ttl);
            }
        }
        catch (Exception e) {
            System.err.println("dgnetsend: Invalid ttl=" + pittl + ". TTL Must be >=0 and <=255");
            e.printStackTrace();
        }
    }

    @Deprecated
    public int getTimeOut() {
        return 0;
    }

    @Deprecated
    public void setTimeOut(int pTimeOut) {
        System.out.println("dgnetsend: setTimeOut() deprecated: did nothing");
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean pVerbose) {
        this.verbose = pVerbose;
        if (this.verbose) {
            System.out.println("dgnetsend: setting Verbose " + pVerbose);
        }
    }

    public boolean getPacketDebug() {
        return this.packetDebug;
    }

    public void setPacketDebug(boolean pPacketDebug) {
        this.packetDebug = pPacketDebug;
        if (this.verbose) {
            System.out.println("dgnetsend: setting PacketDebug " + pPacketDebug);
        }
    }

    public void setHost(String phost) {
        this.host = phost;
        if (this.verbose) {
            System.out.println("dgnetsend: setting host " + phost);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int pport) {
        this.port = pport;
        if (this.verbose) {
            System.out.println("dgnetsend: setting port " + pport);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setKeepOpen(boolean pkeepopen) {
        this.keepopen = pkeepopen;
        if (this.verbose) {
            System.out.println("dgnetsend: setting keepopen " + pkeepopen);
        }
    }

    public short getPayload() {
        return this.payload;
    }

    public void setPayload(short ppayload) {
        this.payload = ppayload;
        if (this.verbose) {
            System.out.println("dgnetsend: setting payload " + this.payload);
        }
    }

    public int getSSRC() {
        return this.ssrc;
    }

    public void setSSRC(int pssrc) {
        this.ssrc = pssrc;
        if (this.verbose) {
            System.out.println("dgnetsend: setting ssrc " + this.ssrc);
        }
    }

    public int getCSRC() {
        return this.csrc0;
    }

    public void setCSRC(int csrc0id) {
        this.csrc0 = csrc0id;
        if (this.verbose) {
            System.out.println("dgnetsend: setting csrc(0) " + this.csrc0);
        }
    }

    public boolean getCompress() {
        return this.compressor != null;
    }

    public void setCompress(boolean pcompress) {
        this.compressor = pcompress ? new Deflater(9) : null;
        if (this.verbose) {
            System.out.println("dgnetsend: setting compress " + pcompress);
        }
    }

    public boolean getMac() {
        return this.mac != null;
    }

    public void setMac(int dpmac, String key) {
        if (dpmac == 1) {
            this.setMac(false, key);
        } else {
            this.setMac(true, key);
        }
    }

    public void setMac(boolean pmac, String key) {
        if (this.verbose) {
            System.out.println("dgnetsend: setting Mac " + pmac);
        }
        if (!pmac) {
            this.mac = null;
            return;
        }
        try {
            this.mac = Mac.getInstance(this.hmactype);
            this.signingkey = new SecretKeySpec(key.getBytes(), this.hmactype);
            this.mac.init(this.signingkey);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mac = null;
        }
    }

    public boolean getEncrypt() {
        return this.cipher != null;
    }

    public void setEncrypt(int dpcipher, String key, String salt) {
        if (dpcipher == 1) {
            this.setEncrypt(false, key, salt);
        } else {
            this.setEncrypt(true, key, salt);
        }
    }

    public void setEncrypt(boolean pcipher, String key, String salt) {
        if (this.verbose) {
            System.out.println("dgnetsend: setting Encrypt " + pcipher);
        }
        if (!pcipher) {
            this.cipher = null;
            return;
        }
        try {
            if (this.verbose) {
                System.out.println("dgnetsend: setEncrypt with " + key + " and " + salt);
            }
            this.pbeParamSpec = new PBEParameterSpec(salt.getBytes(), this.ITERATIONS);
            this.pbeKeySpec = new PBEKeySpec(key.toCharArray());
            this.cipherkey = SecretKeyFactory.getInstance(this.ciphertype).generateSecret(this.pbeKeySpec);
            this.cipher = Cipher.getInstance(this.cipherkey.getAlgorithm());
            this.cipher.init(1, this.cipherkey, this.pbeParamSpec);
            if (this.verbose) {
                System.out.println("Done setEncrypt");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cipher = null;
        }
    }

    public void setLoopbackMode(boolean disable) {
        if (this.verbose) {
            System.out.println("dgnetsend: setting LookbackMode " + disable);
        }
        if (this.msock == null) {
            return;
        }
        try {
            this.msock.setLoopbackMode(disable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getLoopbackMode() {
        if (this.msock == null) {
            return false;
        }
        try {
            return this.msock.getLoopbackMode();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public MulticastSocket getMulticastSocket() {
        if (this.multicast) {
            return this.msock;
        }
        return null;
    }

    public DatagramSocket getDatagramSocket() {
        if (!this.multicast) {
            return this.dsock;
        }
        return null;
    }

    public boolean open(String phost, int pport, short pptype, int pssrc, int csrc0id) {
        this.host = phost;
        this.port = pport;
        this.payload = pptype;
        this.ssrc = pssrc;
        this.csrc0 = csrc0id;
        this.keepopen = true;
        return this.open();
    }

    public boolean open(String phost, int pport) {
        this.host = phost;
        this.port = pport;
        this.keepopen = true;
        return this.open();
    }

    public boolean open(short pptype, int pssrc, int csrc0id) {
        this.payload = pptype;
        this.ssrc = pssrc;
        this.csrc0 = csrc0id;
        this.keepopen = true;
        return this.open();
    }

    public boolean open() {
        try {
            this.close();
            if (!this.keepopen) {
                this.msock = new MulticastSocket();
                this.msock.setTimeToLive(this.ttl);
                this.dsock = new DatagramSocket();
            } else {
                if (this.host == null) {
                    System.err.println("dgnetsend: No Host to open");
                    return false;
                }
                InetSocketAddress isa = new InetSocketAddress(this.host, this.port);
                this.addr = InetAddress.getByName(this.host);
                this.multicast = this.addr.isMulticastAddress();
                if (this.verbose && this.multicast) {
                    System.out.println("dgnetsend: Set Multicast on for " + isa);
                }
                if (this.multicast) {
                    this.msock = new MulticastSocket(this.port);
                    this.msock.joinGroup(this.addr);
                    this.msock.setTimeToLive(this.ttl);
                } else {
                    this.dsock = new DatagramSocket();
                }
                if (this.verbose) {
                    System.out.println("dgnetsend: Connected to Socket. Host:" + this.host + ". Port:" + this.port);
                }
            }
            if (this.verbose) {
                System.out.println("dgnetsend: Done open. dsock=" + this.dsock + " msock=" + this.msock);
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("dgnetsend: Open Error:" + e + ". For IP=" + this.host + ". Port=" + this.port);
            if (e instanceof BindException && "Cannot assign requested address".equals(e.getMessage())) {
                System.err.println("dgnetsend: On RHEL4+ (system with dual IPv4 and IPv6 stacks), try defining\n           java.net.preferIPv4Stack=true system property to use IPv4 stack.");
            }
            e.printStackTrace();
            return false;
        }
    }

    public void close() {
        if (this.verbose) {
            System.out.println("dgnetsend: Closing");
        }
        try {
            if (this.dsock != null) {
                this.dsock.close();
                this.dsock = null;
            }
            if (this.msock != null) {
                this.msock.leaveGroup(this.addr);
                this.msock.close();
                this.msock = null;
            }
        }
        catch (Exception e) {
            System.err.println("dgnetsend: Exception: " + e);
            e.printStackTrace();
        }
    }

    public boolean writeRTP(String sbuf) {
        if (sbuf == null || sbuf.length() < 1) {
            System.err.println("dgnetsend: writeRTP Null Input");
            return false;
        }
        try {
            byte[] buf = sbuf.getBytes();
            if (buf == null) {
                System.err.println("dgnetsend: writeRTP Null Input");
                return false;
            }
            return this.writeRTPICE(sbuf);
        }
        catch (Exception e) {
            System.err.println("dgnetsend: writeRTP Exception: " + e);
            e.printStackTrace();
            return false;
        }
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4")
    public boolean writeRTP_T1(String sbuf) {
        byte[] buf = sbuf.getBytes();
        return this.writeRTP(buf, buf.length);
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4")
    public boolean writeRTP_T2(String sbuf) {
        byte[] buf = sbuf.getBytes();
        return this.writeRTP(buf, buf.length - 1, 1);
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4")
    public boolean writeRTP_T3(String sbuf) {
        byte[] buf = sbuf.getBytes();
        return this.writeRTP(buf, buf.length, (short)15, 1234);
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4")
    public boolean writeRTP_T4(String sbuf) {
        byte[] buf = sbuf.getBytes();
        return this.writeRTP(buf, buf.length - 2, (short)16, 1236, 2);
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4")
    public boolean writeRTP_T5(String sbuf) {
        byte[] buf = sbuf.getBytes();
        return this.writeRTP(buf, buf.length - 3, (short)17, 1237, 3, 2345);
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4")
    public boolean writeRTPICE_T1(String sbuf) {
        byte[] buf = sbuf.getBytes();
        return this.writeRTPICE(buf, buf.length, (short)18, 1238);
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4")
    public boolean writeRTPICE_T2(String sbuf) {
        byte[] buf = sbuf.getBytes();
        return this.writeRTPICE(buf, buf.length, 1234567.0, 11.0, 12.0);
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4")
    public boolean writeRTPICE_T3(String sbuf) {
        byte[] buf = sbuf.getBytes();
        return this.writeRTPICE(buf, buf.length - 1, 1234568.0, 13.0, 14.0, 1);
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4")
    public boolean writeRTPICE_T4(String sbuf) {
        byte[] buf = sbuf.getBytes();
        return this.writeRTPICE(buf, buf.length - 1, 1234568.0, 15.0, 16.0, (short)19, 1239, 1);
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4")
    public boolean writeRTPICE_T5(String sbuf) {
        byte[] buf = sbuf.getBytes();
        return this.writeRTPICE(buf, buf.length - 1, 1234569.0, 17.0f, 18.0f, 19.0f, 20.0f, (short)20, 1240, 1, 100);
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4")
    public boolean writeRTPICE_T6(String sbuf) {
        byte[] buf = sbuf.getBytes();
        return this.writeRTPICE(buf, buf.length - 2, 1234570.0, 21.0, 22.0, (short)21, 1241, 2, 101);
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4")
    public boolean writeRTPICE_T7(String sbuf) {
        byte[] buf = sbuf.getBytes();
        return this.writeRTPICE(buf, buf.length - 3, "SB", 1234571.0, 23.0, 24.0, (short)22, 1242, 3, 1000);
    }

    public boolean writeRTP(String sbuf, short ptype, int ssrcid) {
        if (sbuf == null || sbuf.length() < 1) {
            System.err.println("dgnetsend: writeRTP Null Input");
            return false;
        }
        try {
            byte[] buf = sbuf.getBytes();
            if (buf == null) {
                System.err.println("dgnetsend: writeRTP Null Input");
                return false;
            }
            return this.writeRTPCommon(buf, buf.length, null, 0, ptype, ssrcid, 0, this.csrc0);
        }
        catch (Exception e) {
            System.err.println("dgnetsend: writeRTP Exception: " + e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean writeRTP(byte[] dbuf, int size) {
        return this.writeRTPCommon(dbuf, size, null, 0, this.payload, this.ssrc, 0, this.csrc0);
    }

    public boolean writeRTP(byte[] dbuf, int size, int offset) {
        return this.writeRTPCommon(dbuf, size, null, 0, this.payload, this.ssrc, offset, this.csrc0);
    }

    public boolean writeRTP(byte[] dbuf, int size, short ptype, int ssrcid) {
        return this.writeRTPCommon(dbuf, size, null, 0, ptype, ssrcid, 0, this.csrc0);
    }

    public boolean writeRTP(byte[] dbuf, int size, short ptype, int ssrcid, int offset) {
        return this.writeRTPCommon(dbuf, size, null, 0, ptype, ssrcid, offset, this.csrc0);
    }

    public boolean writeRTP(byte[] dbuf, int size, short ptype, int ssrcid, int offset, int csrc0id) {
        return this.writeRTPCommon(dbuf, size, null, 0, ptype, ssrcid, offset, csrc0id);
    }

    public boolean writeRTPICE(byte[] dbuf, int size, short ptype) {
        System.arraycopy(dbuf, 0, this.icePacket.buf, 0, 64);
        return this.writeRTPCommon(dbuf, size - 64, this.icePacket.buf, 64, ptype, this.ssrc, 64, this.csrc0);
    }

    public boolean writeRTPICE(byte[] dbuf, int size, short ptype, int ssrcid, int csrc0id) {
        System.arraycopy(dbuf, 0, this.icePacket.buf, 0, 64);
        return this.writeRTPCommon(dbuf, size - 64, this.icePacket.buf, 64, ptype, ssrcid, 64, csrc0id);
    }

    public boolean writeRTPICE(byte[] dbuf, byte[] icebuf, int size, short ptype, int ssrcid, int csrc0id, int offset) {
        return this.writeRTPCommon(dbuf, size, icebuf, icebuf.length, ptype, ssrcid, offset, csrc0id);
    }

    public boolean writeRTPICE(byte[] dbuf, byte[] icebuf, int size, short ptype, int ssrcid, int csrc0id) {
        return this.writeRTPCommon(dbuf, size, icebuf, icebuf.length, ptype, ssrcid, 0, csrc0id);
    }

    @InternalUseOnly(value="since initial version in NeXtMidas 3.5.4")
    public boolean writeRTPICE(String sbuf) {
        if (sbuf == null) {
            System.err.println("dgnetsend: writeRTPICE Null Input");
            return false;
        }
        byte[] buf = sbuf.getBytes();
        if (buf == null) {
            System.err.println("dgnetsend: writeRTPICE Null Input");
            return false;
        }
        return this.writeRTPICE(buf, buf.length, Time.current(), 3.0, 5.0);
    }

    public boolean writeRTPICE(byte[] dbuf, int size, short ptype, int ssrcid) {
        return this.writeRTPICE(dbuf, size, Time.current(), 0.0, 0.0, ptype, ssrcid, 0, this.csrc0);
    }

    public boolean writeRTPICE(byte[] dbuf, int size, double jtime, double p1, double p2) {
        return this.writeRTPICE(dbuf, size, jtime, p1, p2, this.payload, this.ssrc, 0, this.csrc0);
    }

    public boolean writeRTPICE(byte[] dbuf, int size, double jtime, double p1, double p2, int offset) {
        return this.writeRTPICE(dbuf, size, jtime, p1, p2, this.payload, this.ssrc, offset, this.csrc0);
    }

    public boolean writeRTPICE(byte[] dbuf, int size, double jtime, double p1, double p2, short ptype, int ssrcid) {
        return this.writeRTPICE(dbuf, size, jtime, p1, p2, ptype, ssrcid, 0, this.csrc0);
    }

    public boolean writeRTPICE(byte[] dbuf, int size, double jtime, double p1, double p2, short ptype, int ssrcid, int offset) {
        return this.writeRTPICE(dbuf, size, jtime, p1, p2, ptype, ssrcid, offset, this.csrc0);
    }

    public boolean writeRTPICE(byte[] dbuf, int size, double jtime, float p1, float p2, float p3, float p4, short ptype, int ssrcid, int offset, int csrc0id) {
        this.icehdrlen = this.defICE(this.icePacket.buf, this.count, size, jtime, p1, p2, p3, p4, 0);
        return this.writeRTPCommon(dbuf, size, this.icePacket.buf, this.icehdrlen, ptype, ssrcid, offset, csrc0id);
    }

    public boolean writeRTPICE(byte[] dbuf, int size, double jtime, double p1, double p2, short ptype, int ssrcid, int offset, int csrc0id) {
        this.count = this.count >= Integer.MAX_VALUE ? 0 : ++this.count;
        this.icehdrlen = this.defICE(this.icePacket.buf, this.count, size, "SB", jtime, p1, p2, 0);
        return this.writeRTPCommon(dbuf, size, this.icePacket.buf, this.icehdrlen, ptype, ssrcid, offset, csrc0id);
    }

    public boolean writeRTPICE(byte[] dbuf, int size, String format, double jtime, double p1, double p2, short ptype, int ssrcid, int offset, int csrc0id) {
        this.count = this.count >= Integer.MAX_VALUE ? 0 : ++this.count;
        this.icehdrlen = this.defICE(this.icePacket.buf, this.count, size, format, jtime, p1, p2, 0);
        return this.writeRTPCommon(dbuf, size, this.icePacket.buf, this.icehdrlen, ptype, ssrcid, offset, csrc0id);
    }

    private boolean writeRTPCommon(byte[] databuf, int size, byte[] icebuf, int icehdrlen, short ptype, int ssrcid, int offset, int csrc0id) {
        try {
            this.timestamp += size;
            this.seqnum = this.seqnum >= 65535 ? 0 : ++this.seqnum;
            this.rtphdrlen = this.mac != null ? this.setRTPHeader(this.rtpbuf, fakesignature, fakesignature.length, (byte)18, icebuf, icehdrlen, (byte)16, ptype, ssrcid, this.seqnum, this.timestamp, csrc0id) : this.setRTPHeader(this.rtpbuf, icebuf, icehdrlen, (byte)16, null, 0, (byte)18, ptype, ssrcid, this.seqnum, this.timestamp, csrc0id);
            if (this.compressor != null) {
                this.compressor.setInput(databuf, offset, size);
                this.compressor.finish();
                if (size < 65546) {
                    this.compsize = this.compressor.deflate(this.rtpbuf, this.rtphdrlen, size + 10);
                }
                if (this.compsize > size) {
                    System.arraycopy(databuf, offset, this.rtpbuf, this.rtphdrlen, size);
                } else {
                    size = this.compsize;
                }
                this.compressor.reset();
                if (this.cipher != null) {
                    size = this.cipher.doFinal(this.rtpbuf, this.rtphdrlen, size, databuf, offset);
                    System.arraycopy(databuf, offset, this.rtpbuf, this.rtphdrlen, size);
                }
            } else if (this.cipher != null) {
                size = this.cipher.doFinal(databuf, offset, size, this.rtpbuf, this.rtphdrlen);
            } else {
                System.arraycopy(databuf, offset, this.rtpbuf, this.rtphdrlen, size);
            }
            if (this.mac != null) {
                this.mac.update(this.rtpbuf, 0, size + this.rtphdrlen);
                int pos = 12;
                if (csrc0id != 0) {
                    pos += 4;
                }
                if (icebuf != null) {
                    pos += 4;
                }
                this.mac.doFinal(this.rtpbuf, pos += 4);
            }
            try {
                if (this.dsock == null && this.msock == null) {
                    System.err.println("dgnetsend: writeRTPICE Null Socket/buffer");
                    return false;
                }
                this.dpacki = new DatagramPacket(this.rtpbuf, size + this.rtphdrlen, this.addr, this.port);
                if (this.multicast) {
                    this.msock.send(this.dpacki);
                } else {
                    this.dsock.send(this.dpacki);
                }
                if (this.packetDebug) {
                    System.out.println("dgnetsend: Packet size " + (size + this.rtphdrlen) + "-" + new String(this.rtpbuf) + ":::" + this.dpacki);
                    for (int i = 0; i < size + this.rtphdrlen; ++i) {
                        System.out.println("BUF[" + i + "]=" + this.rtpbuf[i]);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("dgnetsend writeRTPICE socket: Exception: " + e);
                e.printStackTrace();
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("dgnetsend: writeRTPICE Exception: " + e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean write(String sbuf) {
        boolean ret = false;
        try {
            byte[] buf = sbuf.getBytes();
            if (buf == null) {
                System.err.println("dgnetsend: Null Input");
                return ret;
            }
            ret = this.write(buf);
        }
        catch (Exception e) {
            System.err.println("dgnetsend: write Exception: " + e);
            e.printStackTrace();
        }
        return ret;
    }

    public boolean write(byte[] buf) {
        if (buf == null || buf.length < 1) {
            System.err.println("dgnetsend: Null data input");
            return false;
        }
        if (!this.keepopen) {
            System.out.println("dgnetsend: Must use write(host,port,buf) if not using keepopen");
            return false;
        }
        try {
            try {
                if (this.dsock == null && this.msock == null) {
                    System.err.println("dgnetsend: Null Socket/buffer");
                    return false;
                }
                this.dpacki = new DatagramPacket(buf, buf.length, this.addr, this.port);
                if (this.multicast) {
                    this.msock.send(this.dpacki);
                } else {
                    this.dsock.send(this.dpacki);
                }
                if (this.packetDebug) {
                    System.out.println("dgnetsend: Packet size " + buf.length + "-" + new String(buf) + ":::" + this.dpacki);
                }
                return true;
            }
            catch (SocketTimeoutException ste) {
                if (this.verbose) {
                    System.out.println("dgnetsend: SocketTimeOutException" + ste);
                }
            }
        }
        catch (InterruptedIOException e) {
            if (this.verbose) {
                System.out.println("dgnetsend: Interrupted:" + e);
            }
        }
        catch (SocketException e) {
            if (this.verbose) {
                System.out.println("dgnetsend: Socket Closed:" + e);
            }
        }
        catch (Exception e) {
            System.err.println("dgnetsend: write Exception: " + e);
            e.printStackTrace();
        }
        return false;
    }

    public boolean write(String phost, int pport, String sbuf) {
        boolean ret = false;
        try {
            byte[] buf = sbuf.getBytes();
            ret = this.write(phost, pport, buf);
        }
        catch (Exception e) {
            System.err.println("dgnetsend: write Exception: " + e);
            e.printStackTrace();
        }
        return ret;
    }

    public boolean write(String phost, int pport, byte[] buf) {
        boolean ret = false;
        if (phost == null) {
            System.err.println("dgnetsend: No Host for write ");
            return ret;
        }
        try {
            boolean tmulticast = false;
            int iprefix = Integer.parseInt(phost.substring(0, 3));
            if (iprefix >= 224 && iprefix <= 239) {
                tmulticast = true;
            }
            if (this.verbose && tmulticast) {
                System.out.println("dgnetsend: Multicast:" + iprefix);
            }
            try {
                this.dpacki = new DatagramPacket(buf, buf.length, InetAddress.getByName(phost), this.port);
                if (tmulticast) {
                    this.msock.send(this.dpacki);
                } else {
                    this.dsock.send(this.dpacki);
                }
                ret = true;
            }
            catch (SocketTimeoutException ste) {
                if (this.verbose) {
                    System.out.println("dgnetsend: SocketTimeOutException" + ste);
                }
            }
            catch (InterruptedIOException e) {
                if (this.verbose) {
                    System.out.println("dgnetsend: Interrupted:" + e);
                }
            }
            catch (SocketException e) {
                if (this.verbose) {
                    System.out.println("dgnetsend: Socket Closed:" + e);
                }
            }
            catch (Exception e) {
                System.err.println("dgnetsend: write Exception: " + e);
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            System.err.println("dgnetsend: Problem with stream address:" + phost + ":" + pport + " ->" + e);
            e.printStackTrace();
        }
        return ret;
    }

    public int defICE(byte[] buf, int count, int size, String format, double jtime, double p1, double p2, int boffset) {
        double wsec = Math.floor(jtime += 5.0E-7);
        double fsec = 1.0E-6 * Math.floor(1000000.0 * (jtime - wsec));
        return this.setICEPacket((byte)0, count, size, (short)0, (short)1, (byte)0, (byte)0, Shell.rep, format, (byte)0, (byte)0, 0.0, wsec, fsec, p1, p2);
    }

    public int defICE(byte[] buf, int count, int size, double jtime, double p1, double p2, int boffset) {
        return this.defICE(buf, count, size, "SB", jtime, p1, p2, boffset);
    }

    public int setICEPacket(byte type, int count, int size, short user, short channel, byte id1, byte id2, byte rep, String format, byte mode, byte status, double offset, double wsec, double fsec, double p1, double p2) {
        int ilen = this.setICEPacket(type, count, size, user, channel, id1, id2, rep, format, mode, status, offset, wsec, fsec);
        this.icePacket.setUserData(p1, 0);
        this.icePacket.setUserData(p2, 1);
        return ilen;
    }

    public int setICEPacket(byte type, int count, int size, short user, short channel, byte id1, byte id2, byte rep, String format, byte mode, byte status, double offset, double wsec, double fsec) {
        this.icePacket.setUserKey(type);
        this.icePacket.setCount(count);
        int bpa = Data.getBPA(format);
        int nsize = size;
        if (bpa > 0) {
            nsize /= bpa;
        }
        this.icePacket.setSize(nsize);
        this.icePacket.setUser(user);
        this.icePacket.setChannel(channel);
        this.icePacket.setID(id1, id2);
        this.icePacket.setRep(rep);
        this.icePacket.setFormat(format);
        this.icePacket.setTC(mode, status, offset, wsec, fsec);
        return 64;
    }

    public int defICE(byte[] buf, int count, int size, int boffset) {
        return this.setICEPacket((byte)0, count, size, (short)0, (short)1, (byte)0, (byte)0, Shell.rep, "SB", (byte)0, (byte)0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public int defICE(byte[] buf, int count, int size, double jtime, float p1, float p2, float p3, float p4, int boffset) {
        double wsec = Math.floor(jtime += 5.0E-7);
        double fsec = 1.0E-6 * Math.floor(1000000.0 * (jtime - wsec));
        return this.setICEPacket((byte)0, count, size, (short)0, (short)1, (byte)0, (byte)0, Shell.rep, "SI", (byte)0, (byte)0, 0.0, wsec, fsec, p1, p2, p3, p4);
    }

    public int setICEPacket(byte type, int count, int size, short user, short channel, byte id1, byte id2, byte rep, String format, byte mode, byte status, double offset, double wsec, double fsec, float p1, float p2, float p3, float p4) {
        int ilen = this.setICEPacket(type, count, size, user, channel, id1, id2, rep, format, mode, status, offset, wsec, fsec);
        this.icePacket.setUserData(p1, 0);
        this.icePacket.setUserData(p2, 1);
        this.icePacket.setUserData(p3, 2);
        this.icePacket.setUserData(p4, 3);
        return ilen;
    }

    public int setRTPHeader(byte[] buf, byte[] xhdr, int xlen, byte xtype, byte[] xhdr2, int xlen2, byte xtype2, short ptype, int ssrcid, int snum, int tstamp, int csrc0id) {
        int boffset = 0;
        int pos = 12;
        buf[boffset] = xhdr != null && xlen > 0 ? -112 : -128;
        if (csrc0id != 0) {
            int n = boffset;
            buf[n] = (byte)(buf[n] | 1);
            pos += 4;
        }
        buf[boffset + 1] = (byte)ptype;
        int n = boffset + 1;
        buf[n] = (byte)(buf[n] & 0x7F);
        dgnetsend.netpackI2S(buf, boffset + 2, snum);
        dgnetsend.netpackL(buf, boffset + 4, tstamp);
        dgnetsend.netpackL(buf, boffset + 8, ssrcid);
        if (csrc0id != 0) {
            dgnetsend.netpackL(buf, boffset + 12, csrc0id);
        }
        if (xhdr == null || xlen <= 0 || xlen > 65000) {
            return pos;
        }
        int xlen4 = xlen >> 2;
        buf[boffset + pos] = 0;
        if (xlen2 > 0) {
            buf[boffset + pos + 1] = -1;
            xlen4 += (xlen2 >> 2) + 2;
        } else {
            buf[boffset + pos + 1] = xtype;
        }
        dgnetsend.netpackI2S(buf, boffset + pos + 2, xlen4);
        if (xhdr2 == null || xlen2 <= 0 || xlen2 > 32000) {
            System.arraycopy(xhdr, 0, buf, pos + 4, xlen);
            return pos + 4 + xlen;
        }
        buf[boffset + (pos += 4)] = 0;
        buf[boffset + pos + 1] = xtype;
        xlen4 = xlen >> 2;
        dgnetsend.netpackI2S(buf, boffset + pos + 2, xlen4);
        System.arraycopy(xhdr, 0, buf, pos + 4, xlen);
        buf[boffset + (pos += 4 + xlen)] = 0;
        buf[boffset + pos + 1] = xtype2;
        xlen4 = xlen2 >> 2;
        dgnetsend.netpackI2S(buf, boffset + pos + 2, xlen4);
        System.arraycopy(xhdr2, 0, buf, pos + 4, xlen2);
        return pos += 4 + xlen2;
    }

    public void modRTPHeaderForMac(byte[] buf, byte[] signature, int csrc0id, boolean compound) {
        int pos = 12;
        if (csrc0id != 0) {
            pos += 4;
        }
        if (compound) {
            pos += 4;
        }
        System.arraycopy(signature, 0, buf, pos += 4, signature.length);
    }

    public static void netpackI2S(byte[] buf, int off, int val) {
        buf[off + 1] = (byte)(val & 0xFF);
        buf[off + 0] = (byte)(val >> 8 & 0xFF);
    }

    public static void netpackL(byte[] buf, int off, int val) {
        buf[off + 3] = (byte)(val & 0xFF);
        buf[off + 2] = (byte)(val >> 8 & 0xFF);
        buf[off + 1] = (byte)(val >> 16 & 0xFF);
        buf[off + 0] = (byte)(val >> 24 & 0xFF);
    }
}

