/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.net;

import nxm.sys.lib.Table;
import nxm.sys.net.HPage;
import nxm.sys.net.HServer;

public class HSource {
    public String name;
    public HServer server;

    public HSource() {
    }

    public HSource(String name) {
        this.name = name.startsWith("/") ? name.substring(1) : name;
    }

    public String getName() {
        return "/" + this.name;
    }

    public boolean canHandleRequest(String uri) {
        String rname = this.getName();
        if (!uri.startsWith(rname)) {
            return false;
        }
        int lr = rname.length();
        int lu = uri.length();
        if (rname.charAt(lr - 1) == '/') {
            return true;
        }
        return lu <= lr || uri.charAt(lr) == '/' || uri.charAt(lr) == '?';
    }

    public void handleRequest(String uri, HPage hp) {
        hp.open();
        hp.close();
    }

    protected static final Table getParameters(String uri) {
        return HSource.getParameters(uri, null);
    }

    static final Table getParameters(String uri, Table tbl) {
        if (tbl == null) {
            tbl = new Table();
        }
        if (uri == null) {
            return tbl;
        }
        int start = uri.indexOf(63);
        if (start < 0) {
            return tbl;
        }
        String[] params = uri.substring(start + 1).split("[&]");
        for (int i = 0; i < params.length; ++i) {
            String[] param = params[i].split("[=]");
            String name = param[0].toUpperCase();
            if (param.length <= 1) continue;
            String value = param[1].replace('+', ' ').replaceAll("[%]20", " ");
            tbl.setKey(name, value);
        }
        return tbl;
    }

    public void setServer(HServer server) {
        this.server = server;
    }
}

