/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

import nxm.sys.inc.Constants;
import nxm.sys.libm.Operator;

public final class LogarithmBounded
extends Operator
implements Constants {
    public LogarithmBounded() {
    }

    public LogarithmBounded(int flags) {
        super(flags);
    }

    public LogarithmBounded(double scale) {
        super(scale);
    }

    public LogarithmBounded(int flags, double scale) {
        super(flags, scale);
    }

    @Override
    public final int validate(char type, int n, int mode) {
        switch (mode) {
            case 17: {
                return n;
            }
            case 18: {
                return n;
            }
            case 19: {
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(double[][] v, int n, int mode) {
        switch (mode) {
            case 17: {
                LogarithmBounded.SS(v[0], v[1], n, this.scale);
                return n;
            }
            case 18: {
                LogarithmBounded.CS(v[0], v[1], n, this.scale);
                return n;
            }
            case 19: {
                LogarithmBounded.VS(v[0], v[1], n, this.scale);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(double[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 17: {
                LogarithmBounded.SS(v[0], v[1], n, scale);
                return n;
            }
            case 18: {
                LogarithmBounded.CS(v[0], v[1], n, scale);
                return n;
            }
            case 19: {
                LogarithmBounded.VS(v[0], v[1], n, scale);
                return n;
            }
        }
        return -1;
    }

    public static final void SS(double[] a, double[] b, int n, double scale) {
        for (int i = 0; i < n; ++i) {
            b[i] = scale * Math.log(Math.max(1.0E-12, Math.abs(a[i])));
        }
    }

    public static final void CS(double[] a, double[] b, int n, double scale) {
        int i = 0;
        int j = 0;
        while (i < n) {
            b[i] = scale * Math.log(Math.max(1.0E-12, a[j] * a[j] + a[j + 1] * a[j + 1]));
            ++i;
            j += 2;
        }
    }

    public static final void VS(double[] a, double[] b, int n, double scale) {
        int i = 0;
        int k = 0;
        while (i < n) {
            b[i] = scale * Math.log(Math.max(1.0E-12, a[k] * a[k] + a[k + 1] * a[k + 1] + a[k + 2] * a[k + 2]));
            ++i;
            k += 3;
        }
    }

    @Override
    public final int process(float[][] v, int n, int mode) {
        switch (mode) {
            case 17: {
                LogarithmBounded.SS(v[0], v[1], n, this.scale);
                return n;
            }
            case 18: {
                LogarithmBounded.CS(v[0], v[1], n, this.scale);
                return n;
            }
            case 19: {
                LogarithmBounded.VS(v[0], v[1], n, this.scale);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(float[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 17: {
                LogarithmBounded.SS(v[0], v[1], n, scale);
                return n;
            }
            case 18: {
                LogarithmBounded.CS(v[0], v[1], n, scale);
                return n;
            }
            case 19: {
                LogarithmBounded.VS(v[0], v[1], n, scale);
                return n;
            }
        }
        return -1;
    }

    public static final void SS(float[] a, float[] b, int n, double scale) {
        for (int i = 0; i < n; ++i) {
            double aa = a[i];
            if (aa < 0.0) {
                aa = -aa;
            }
            if (aa < 1.0E-12) {
                aa = 1.0E-12;
            }
            b[i] = (float)(scale * Math.log(aa));
        }
    }

    public static final void CS(float[] a, float[] b, int n, double scale) {
        int i = 0;
        int j = 0;
        while (i < n) {
            b[i] = (float)(scale * Math.log(Math.max(1.0E-12, (double)(a[j] * a[j] + a[j + 1] * a[j + 1]))));
            ++i;
            j += 2;
        }
    }

    public static final void VS(float[] a, float[] b, int n, double scale) {
        int i = 0;
        int k = 0;
        while (i < n) {
            b[i] = (float)(scale * Math.log(Math.max(1.0E-12, (double)(a[k] * a[k] + a[k + 1] * a[k + 1] + a[k + 2] * a[k + 2]))));
            ++i;
            k += 3;
        }
    }

    @Override
    public final int process(int[][] v, int n, int mode) {
        switch (mode) {
            case 17: {
                LogarithmBounded.SS(v[0], v[1], n, this.scale);
                return n;
            }
            case 18: {
                LogarithmBounded.CS(v[0], v[1], n, this.scale);
                return n;
            }
            case 19: {
                LogarithmBounded.VS(v[0], v[1], n, this.scale);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(int[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 17: {
                LogarithmBounded.SS(v[0], v[1], n, scale);
                return n;
            }
            case 18: {
                LogarithmBounded.CS(v[0], v[1], n, scale);
                return n;
            }
            case 19: {
                LogarithmBounded.VS(v[0], v[1], n, scale);
                return n;
            }
        }
        return -1;
    }

    public static final void SS(int[] a, int[] b, int n, double scale) {
        for (int i = 0; i < n; ++i) {
            b[i] = (int)(scale * Math.log(Math.max(1.0E-12, (double)Math.abs(a[i]))));
        }
    }

    public static final void CS(int[] a, int[] b, int n, double scale) {
        int i = 0;
        int j = 0;
        while (i < n) {
            b[i] = (int)(scale * Math.log(Math.max(1.0E-12, (double)(a[j] * a[j] + a[j + 1] * a[j + 1]))));
            ++i;
            j += 2;
        }
    }

    public static final void VS(int[] a, int[] b, int n, double scale) {
        int i = 0;
        int k = 0;
        while (i < n) {
            b[i] = (int)(scale * Math.log(Math.max(1.0E-12, (double)(a[k] * a[k] + a[k + 1] * a[k + 1] + a[k + 2] * a[k + 2]))));
            ++i;
            k += 3;
        }
    }

    @Override
    public int getInputs() {
        return 1;
    }

    @Override
    public int getOutputs() {
        return 1;
    }
}

