/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

import nxm.sys.inc.Constants;
import nxm.sys.libm.Operator;

public final class Logarithm
extends Operator
implements Constants {
    static final double eps$double = Double.MIN_VALUE;
    static final double eps$float = (double)1.4E-45f;
    static final double eps$int = (double)1.4E-45f;

    public Logarithm() {
    }

    public Logarithm(int flags) {
        super(flags);
    }

    public Logarithm(double scale) {
        super(scale);
    }

    public Logarithm(int flags, double scale) {
        super(flags, scale);
    }

    @Override
    public final int validate(char type, int n, int mode) {
        switch (mode) {
            case 17: {
                return n;
            }
            case 18: {
                return n;
            }
            case 19: {
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(double[][] v, int n, int mode) {
        switch (mode) {
            case 17: {
                this.SS(v[0], v[1], n, this.scale);
                return n;
            }
            case 18: {
                this.CS(v[0], v[1], n, this.scale);
                return n;
            }
            case 19: {
                this.VS(v[0], v[1], n, this.scale);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(double[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 17: {
                this.SS(v[0], v[1], n, scale);
                return n;
            }
            case 18: {
                this.CS(v[0], v[1], n, scale);
                return n;
            }
            case 19: {
                this.VS(v[0], v[1], n, scale);
                return n;
            }
        }
        return -1;
    }

    public final void SS(double[] a, double[] b, int n, double scale) {
        for (int i = 0; i < n; ++i) {
            b[i] = scale * Math.log(Math.abs(a[i]) + Double.MIN_VALUE);
        }
    }

    public final void CS(double[] a, double[] b, int n, double scale) {
        int i = 0;
        int j = 0;
        while (i < n) {
            b[i] = scale * Math.log(a[j] * a[j] + a[j + 1] * a[j + 1] + Double.MIN_VALUE);
            ++i;
            j += 2;
        }
    }

    public final void VS(double[] a, double[] b, int n, double scale) {
        int i = 0;
        int k = 0;
        while (i < n) {
            b[i] = scale * Math.log(a[k] * a[k] + a[k + 1] * a[k + 1] + a[k + 2] * a[k + 2] + Double.MIN_VALUE);
            ++i;
            k += 3;
        }
    }

    @Override
    public final int process(float[][] v, int n, int mode) {
        switch (mode) {
            case 17: {
                this.SS(v[0], v[1], n, this.scale);
                return n;
            }
            case 18: {
                this.CS(v[0], v[1], n, this.scale);
                return n;
            }
            case 19: {
                this.VS(v[0], v[1], n, this.scale);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(float[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 17: {
                this.SS(v[0], v[1], n, scale);
                return n;
            }
            case 18: {
                this.CS(v[0], v[1], n, scale);
                return n;
            }
            case 19: {
                this.VS(v[0], v[1], n, scale);
                return n;
            }
        }
        return -1;
    }

    public final void SS(float[] a, float[] b, int n, double scale) {
        for (int i = 0; i < n; ++i) {
            b[i] = (float)(scale * Math.log((double)Math.abs(a[i]) + (double)1.4E-45f));
        }
    }

    public final void CS(float[] a, float[] b, int n, double scale) {
        int i = 0;
        int j = 0;
        while (i < n) {
            b[i] = (float)(scale * Math.log((double)(a[j] * a[j] + a[j + 1] * a[j + 1]) + (double)1.4E-45f));
            ++i;
            j += 2;
        }
    }

    public final void VS(float[] a, float[] b, int n, double scale) {
        int i = 0;
        int k = 0;
        while (i < n) {
            b[i] = (float)(scale * Math.log((double)(a[k] * a[k] + a[k + 1] * a[k + 1] + a[k + 2] * a[k + 2]) + (double)1.4E-45f));
            ++i;
            k += 3;
        }
    }

    @Override
    public final int process(int[][] v, int n, int mode) {
        switch (mode) {
            case 17: {
                this.SS(v[0], v[1], n, this.scale);
                return n;
            }
            case 18: {
                this.CS(v[0], v[1], n, this.scale);
                return n;
            }
            case 19: {
                this.VS(v[0], v[1], n, this.scale);
                return n;
            }
        }
        return -1;
    }

    @Override
    public final int process(int[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 17: {
                this.SS(v[0], v[1], n, scale);
                return n;
            }
            case 18: {
                this.CS(v[0], v[1], n, scale);
                return n;
            }
            case 19: {
                this.VS(v[0], v[1], n, scale);
                return n;
            }
        }
        return -1;
    }

    public final void SS(int[] a, int[] b, int n, double scale) {
        for (int i = 0; i < n; ++i) {
            b[i] = (int)(scale * Math.log((double)Math.abs(a[i]) + (double)1.4E-45f));
        }
    }

    public final void CS(int[] a, int[] b, int n, double scale) {
        int i = 0;
        int j = 0;
        while (i < n) {
            b[i] = (int)(scale * Math.log((double)(a[j] * a[j] + a[j + 1] * a[j + 1]) + (double)1.4E-45f));
            ++i;
            j += 2;
        }
    }

    public final void VS(int[] a, int[] b, int n, double scale) {
        int i = 0;
        int k = 0;
        while (i < n) {
            b[i] = (int)(scale * Math.log((double)(a[k] * a[k] + a[k + 1] * a[k + 1] + a[k + 2] * a[k + 2]) + (double)1.4E-45f));
            ++i;
            k += 3;
        }
    }

    @Override
    public int getInputs() {
        return 1;
    }

    @Override
    public int getOutputs() {
        return 1;
    }
}

